/*
 * Decompiled with CFR 0.152.
 */
package vcpmaint;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import vcpmaint.GridBagLayout2;
import vcpmaint.MVCPGlobals;
import vcpmaint.Messenger;
import vcpmaint.SocketMgr;

public class DvbControl
extends Panel
implements MVCPGlobals,
ActionListener,
Runnable {
    private Messenger messenger;
    private TextField tfHost;
    private TextField tfBegRecAt;
    private TextField tfEndRecAt;
    private TextField tfPauseTime;
    private TextField tfPBDelay;
    private TextField tfTimeCodePlay;
    private TextField tfTimeCodeRec;
    private TextField tfTCDelay;
    private Button bBegRecAtSubmit;
    private Button bEndRecAtSubmit;
    private Button bPBNow;
    private Button bStoPBNow;
    private Button bBegRecNow;
    private Button bEndRecNow;
    private Button bPBDelaySubmit;
    private Button bPauseSubmit;
    private Button bTCDelaySubmit;
    private Button bPausePB20;
    private Button bPausePB30;
    private Button bPausePBPause2;
    private Button bPausePB90;
    private Button bPausePB10;
    private Button bPausePBPause1;
    private static final String strHost = "VCP Recorder Host Name";
    static final Font veryLargeFont = new Font("Helvetica", 0, 25);
    private String p1;
    private String p2;
    private SocketMgr dvbSocket;
    private SocketMgr dvbMon;
    private Thread runThread;
    private boolean keepRunning;
    private static int port = -1;
    private static String recUnit;
    private static String playUnit;
    private String delayValue;
    int minFrames;
    int maxFrames = 20000000;

    public DvbControl(Messenger messenger) {
        this.messenger = messenger;
        this.dvbSocket = new SocketMgr(5250, this.messenger);
        if (!this.dvbSocket.openSocket(2000)) {
            this.error("Error while opening socket");
        }
        this.dvbSocket.setDebug(true);
        this.delayValue = "";
        this.dvbSocket.readSocketLine();
        this.dvbSocket.writeWithRNToSocket("PLS");
        String string = this.dvbSocket.readSocketLine();
        string = this.dvbSocket.readSocketLine();
        this.error(string);
        this.dvbSocket.readSocketLine();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\"");
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        stringTokenizer = new StringTokenizer(string2);
        string2 = stringTokenizer.nextToken();
        string2 = stringTokenizer.nextToken();
        string2 = stringTokenizer.nextToken();
        string2 = stringTokenizer.nextToken();
        port = Integer.valueOf(string2);
        this.error("Using port " + port);
        this.dvbSocket.writeWithRNToSocket("UADD dvb-asi");
        this.dvbSocket.readSocketLine();
        recUnit = this.dvbSocket.readSocketLine();
        this.error("Rec unit is " + recUnit);
        this.dvbSocket.writeWithRNToSocket("SET " + recUnit + " MED vtr.media.dvb-asi.port \"" + port + "\"");
        this.dvbSocket.readSocketLine();
        this.dvbSocket.writeWithRNToSocket("SET " + recUnit + " MED vtr.media.dvb-asi.port.total_bitrate 45000000");
        this.dvbSocket.readSocketLine();
        this.dvbSocket.writeWithRNToSocket("UADD dvb-asi");
        this.dvbSocket.readSocketLine();
        playUnit = this.dvbSocket.readSocketLine();
        this.error("Play unit is " + playUnit);
        this.dvbSocket.writeWithRNToSocket("SET " + playUnit + " MED vtr.media.dvb-asi.port \"" + port + "\"");
        this.dvbSocket.readSocketLine();
        this.dvbSocket.writeWithRNToSocket("SET " + playUnit + " MED vtr.media.dvb-asi.port.total_bitrate 45000000");
        this.dvbSocket.readSocketLine();
        ((Component)this).setFont(MVCPGlobals.baseFont);
        GridBagLayout2 gridBagLayout2 = new GridBagLayout2();
        this.setLayout(gridBagLayout2);
        gridBagLayout2.setDefaultMargins(2, 2, 2, 2);
        Label label = new Label("Begin Recording At");
        label.setFont(veryLargeFont);
        this.tfBegRecAt = new TextField(35);
        Label label2 = new Label("End Recording At");
        label2.setFont(veryLargeFont);
        this.tfEndRecAt = new TextField(35);
        this.bBegRecAtSubmit = new Button("Submit");
        this.bBegRecAtSubmit.setFont(MVCPGlobals.buttonFont);
        this.bBegRecAtSubmit.addActionListener(this);
        this.bEndRecAtSubmit = new Button("Submit");
        this.bEndRecAtSubmit.setFont(MVCPGlobals.buttonFont);
        this.bEndRecAtSubmit.addActionListener(this);
        Label label3 = new Label("Begin Recording");
        label3.setFont(veryLargeFont);
        this.bBegRecNow = new Button("NOW");
        this.bBegRecNow.setFont(MVCPGlobals.buttonFont);
        this.bBegRecNow.addActionListener(this);
        Label label4 = new Label("End Recording");
        label4.setFont(veryLargeFont);
        this.bEndRecNow = new Button("NOW");
        this.bEndRecNow.setFont(MVCPGlobals.buttonFont);
        this.bEndRecNow.addActionListener(this);
        Label label5 = new Label("Set Playback TC to");
        label5.setFont(veryLargeFont);
        this.tfPBDelay = new TextField(35);
        this.bPBDelaySubmit = new Button("Submit");
        this.bPBDelaySubmit.setFont(MVCPGlobals.buttonFont);
        this.bPBDelaySubmit.addActionListener(this);
        Label label6 = new Label("Begin PlayBack at a TC of");
        label6.setFont(veryLargeFont);
        this.tfTCDelay = new TextField(35);
        this.bTCDelaySubmit = new Button("Submit");
        this.bTCDelaySubmit.setFont(MVCPGlobals.buttonFont);
        this.bTCDelaySubmit.addActionListener(this);
        Label label7 = new Label("Begin Playback");
        label7.setFont(veryLargeFont);
        this.bPBNow = new Button("NOW");
        this.bPBNow.setFont(MVCPGlobals.buttonFont);
        this.bPBNow.addActionListener(this);
        Label label8 = new Label("Stop Playback");
        label8.setFont(veryLargeFont);
        this.bStoPBNow = new Button("NOW");
        this.bStoPBNow.setFont(MVCPGlobals.buttonFont);
        this.bStoPBNow.addActionListener(this);
        Label label9 = new Label("Pause Playback For (secs)");
        label9.setFont(veryLargeFont);
        this.bPausePB10 = new Button(" 10 secs ");
        this.bPausePB10.setFont(veryLargeFont);
        this.bPausePB10.setForeground(Color.black);
        this.bPausePB10.setBackground(Color.red);
        this.bPausePB10.addActionListener(this);
        this.p1 = new String(String.valueOf(this.messenger.getPause1()) + " secs");
        this.bPausePBPause1 = new Button(this.p1);
        this.bPausePBPause1.setFont(veryLargeFont);
        this.bPausePBPause1.setForeground(Color.black);
        this.bPausePBPause1.setBackground(Color.red);
        this.bPausePBPause1.addActionListener(this);
        this.bPausePB30 = new Button(" 30 secs ");
        this.bPausePB30.setFont(veryLargeFont);
        this.bPausePB30.setForeground(Color.black);
        this.bPausePB30.setBackground(Color.red);
        this.bPausePB30.addActionListener(this);
        this.p2 = new String(String.valueOf(this.messenger.getPause2()) + " secs");
        this.bPausePBPause2 = new Button(this.p2);
        this.bPausePBPause2.setFont(veryLargeFont);
        this.bPausePBPause2.setForeground(Color.black);
        this.bPausePBPause2.setBackground(Color.red);
        this.bPausePBPause2.addActionListener(this);
        this.tfPauseTime = new TextField(4);
        ((TextComponent)this.tfPauseTime).setText("30");
        new Label("seconds");
        this.bPauseSubmit = new Button("Submit");
        this.bPauseSubmit.setFont(MVCPGlobals.boldFont);
        Label label10 = new Label("Play Timecode");
        label10.setFont(veryLargeFont);
        this.tfTimeCodePlay = new TextField(35);
        ((TextComponent)this.tfTimeCodePlay).setText("00:00:00.00");
        Label label11 = new Label("Rec Timecode");
        label11.setFont(veryLargeFont);
        this.tfTimeCodeRec = new TextField(35);
        ((TextComponent)this.tfTimeCodeRec).setText("00:00:00.00");
        int n = 0;
        int n2 = 0;
        Panel panel = new Panel();
        panel.setLayout(gridBagLayout2);
        gridBagLayout2.northeast(panel, label, n, ++n2, 10, 10, 10, 0);
        gridBagLayout2.northwest(panel, this.tfBegRecAt, n + 1, n2, 10, 0, 10, 10);
        gridBagLayout2.northeast(panel, this.bBegRecAtSubmit, n + 2, n2, 10, 10, 10, 0);
        gridBagLayout2.northeast(panel, label2, n, ++n2, 10, 10, 10, 0);
        gridBagLayout2.northwest(panel, this.tfEndRecAt, n + 1, n2, 10, 0, 10, 10);
        gridBagLayout2.northeast(panel, this.bEndRecAtSubmit, n + 2, n2, 10, 10, 10, 0);
        ++n2;
        gridBagLayout2.northeast(panel, label3, n, ++n2, 10, 10, 10, 0);
        gridBagLayout2.northwest(panel, this.bBegRecNow, n + 1, n2, 10, 0, 10, 10);
        gridBagLayout2.northeast(panel, label4, n, ++n2, 10, 10, 10, 0);
        gridBagLayout2.northwest(panel, this.bEndRecNow, n + 1, n2, 10, 0, 10, 10);
        gridBagLayout2.northeast(panel, label5, n, ++n2, 10, 10, 10, 0);
        gridBagLayout2.northwest(panel, this.tfPBDelay, n + 1, n2, 10, 0, 10, 10);
        gridBagLayout2.northwest(panel, this.bPBDelaySubmit, n + 2, n2, 10, 0, 10, 10);
        gridBagLayout2.northeast(panel, label6, n, ++n2, 10, 10, 10, 0);
        gridBagLayout2.northwest(panel, this.tfTCDelay, n + 1, n2, 10, 0, 10, 10);
        gridBagLayout2.northwest(panel, this.bTCDelaySubmit, n + 2, n2, 10, 0, 10, 10);
        gridBagLayout2.northeast(panel, label7, n, ++n2, 10, 10, 10, 0);
        gridBagLayout2.northwest(panel, this.bPBNow, n + 1, n2, 10, 0, 10, 10);
        gridBagLayout2.northeast(panel, label8, n, ++n2, 10, 10, 10, 0);
        gridBagLayout2.northwest(panel, this.bStoPBNow, n + 1, n2, 10, 0, 10, 10);
        gridBagLayout2.northeast(panel, label9, n, ++n2, 10, 10, 10, 0);
        gridBagLayout2.centered(panel, this.tfPauseTime, n + 1, n2, 10, 0, 5, 5);
        gridBagLayout2.northwest(panel, this.bPauseSubmit, n + 2, n2, 10, 0, 5, 5);
        gridBagLayout2.northwest_gr(panel, this.bPausePB10, n, ++n2, 1, 4, 5, 5, 5, 5);
        gridBagLayout2.northwest_gr(panel, this.bPausePBPause1, n + 1, n2, 1, 4, 5, 5, 5, 5);
        gridBagLayout2.northwest_gr(panel, this.bPausePB30, n, n2 += 5, 1, 4, 5, 5, 5, 5);
        gridBagLayout2.northwest_gr(panel, this.bPausePBPause2, n + 1, n2, 1, 4, 5, 5, 5, 5);
        gridBagLayout2.northeast(panel, label10, n, n2 += 4, 10, 0, 10, 10);
        gridBagLayout2.northwest(panel, this.tfTimeCodePlay, n + 1, n2, 10, 0, 10, 10);
        gridBagLayout2.northeast(panel, label11, n, ++n2, 10, 0, 10, 10);
        gridBagLayout2.northwest(panel, this.tfTimeCodeRec, n + 1, n2, 10, 0, 10, 10);
        gridBagLayout2.centered(this, panel, 0, 0);
        gridBagLayout2.centered_gr(this, new Panel(), 0, 1);
    }

    public void tellInfoToMessenger() {
    }

    public void start() {
        if (!this.dvbSocket.isOpen()) {
            this.error("Error - socket not open.");
        }
        this.setFields();
        this.runThread = new Thread(this);
        try {
            this.runThread.start();
            return;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            System.out.println("DvbControl.start, caught IllegalThreadStateException");
            return;
        }
    }

    public void run() {
        this.dvbMon = new SocketMgr(5250, this.messenger);
        if (!this.dvbMon.openSocket(2000)) {
            return;
        }
        this.dvbMon.readSocketLine();
        this.dvbMon.writeWithRNToSocket("MON");
        String string = this.dvbMon.readSocketLine();
        this.keepRunning = true;
        while (this.keepRunning) {
            int n;
            StringTokenizer stringTokenizer;
            String string2;
            if (!this.dvbMon.isOpen()) {
                return;
            }
            string = this.dvbMon.readSocketLine();
            if (string == null || string.equals("TIMEDOUT") || !(string2 = (stringTokenizer = new StringTokenizer(string, " ")).nextToken()).equals("UCHG")) continue;
            String string3 = stringTokenizer.nextToken();
            if (playUnit.equals(string3)) {
                n = 0;
                while (n < 3) {
                    stringTokenizer.nextToken();
                    ++n;
                }
                ((TextComponent)this.tfTimeCodePlay).setText(stringTokenizer.nextToken());
                continue;
            }
            if (!recUnit.equals(string3)) continue;
            n = 0;
            while (n < 3) {
                stringTokenizer.nextToken();
                ++n;
            }
            ((TextComponent)this.tfTimeCodeRec).setText(stringTokenizer.nextToken());
        }
        this.dvbMon.closeSocket();
        this.runThread = null;
    }

    public void exit() {
        this.tellInfoToMessenger();
    }

    public void setFields() {
        this.p1 = new String(" " + this.messenger.getPause1() + " secs ");
        this.bPausePBPause1.setLabel(this.p1);
        this.p2 = new String(" " + this.messenger.getPause2() + " secs ");
        this.bPausePBPause2.setLabel(this.p2);
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        if (!this.dvbSocket.isOpen()) {
            this.error("Socket not open?");
            return;
        }
        if (actionEvent.getSource() == this.bBegRecAtSubmit) {
            String string = this.tfBegRecAt.getText();
            this.dvbSocket.writeWithRNToSocket("LOAD " + recUnit + " " + this.messenger.getClipName() + " BOTH CRTE");
            this.dvbSocket.readSocketLine();
            this.dvbSocket.readSocketLine();
            TimeCode timeCode = new TimeCode(string);
            string = this.checkTC(timeCode);
            ((TextComponent)this.tfBegRecAt).setText(string);
            this.dvbSocket.writeWithRNToSocket("/SEQA CUER " + recUnit + " " + string);
            this.dvbSocket.readSocketLine();
            this.dvbSocket.readSocketLine();
            this.dvbSocket.writeWithRNToSocket("/SEQA @" + string + " REC " + recUnit);
            this.dvbSocket.readSocketLine();
            return;
        }
        if (actionEvent.getSource() == this.bEndRecAtSubmit) {
            String string = this.tfEndRecAt.getText();
            TimeCode timeCode = new TimeCode(string);
            string = this.checkTC(timeCode);
            ((TextComponent)this.tfEndRecAt).setText(string);
            this.dvbSocket.writeWithRNToSocket("@" + string + " STOP " + recUnit);
            this.dvbSocket.readSocketLine();
            return;
        }
        if (actionEvent.getSource() == this.bBegRecNow) {
            this.dvbSocket.writeWithRNToSocket("LOAD " + recUnit + " " + this.messenger.getClipName() + " BOTH CRTE");
            this.dvbSocket.readSocketLine();
            this.dvbSocket.readSocketLine();
            this.dvbSocket.writeWithRNToSocket("GTOD");
            String string = this.dvbSocket.readSocketLine();
            string = this.dvbSocket.readSocketLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            String string2 = stringTokenizer.nextToken();
            this.dvbSocket.writeWithRNToSocket("/SEQA CUER " + recUnit + " " + string2);
            this.dvbSocket.readSocketLine();
            this.dvbSocket.readSocketLine();
            this.dvbSocket.writeWithRNToSocket("REC " + recUnit);
            this.dvbSocket.readSocketLine();
            return;
        }
        if (actionEvent.getSource() == this.bEndRecNow) {
            this.dvbSocket.writeWithRNToSocket("STOP " + recUnit);
            this.dvbSocket.readSocketLine();
            return;
        }
        if (actionEvent.getSource() == this.bPBDelaySubmit) {
            this.delayValue = this.tfPBDelay.getText();
            TimeCode timeCode = new TimeCode(this.delayValue);
            this.delayValue = this.checkTC(timeCode);
            ((TextComponent)this.tfBegRecAt).setText(this.delayValue);
            return;
        }
        if (actionEvent.getSource() == this.bTCDelaySubmit) {
            this.dvbSocket.writeWithRNToSocket("LOAD " + playUnit + " " + this.messenger.getClipName() + " OUT");
            this.dvbSocket.readSocketLine();
            this.dvbSocket.readSocketLine();
            String string = this.tfTCDelay.getText();
            TimeCode timeCode = new TimeCode(string);
            string = this.checkTC(timeCode);
            ((TextComponent)this.tfTCDelay).setText(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            String string6 = stringTokenizer.nextToken();
            int n = Integer.parseInt(string5);
            int n2 = Integer.parseInt(string4);
            int n3 = Integer.parseInt(string3);
            if (n >= 2) {
                string5 = new String(this.formatTCField(n -= 2));
            } else if (n2 >= 1) {
                string4 = new String(this.formatTCField(--n2));
            } else {
                n3 = n3 > 0 ? --n3 : 23;
                n2 = 59;
                string4 = new String(this.formatTCField(n2));
                string3 = new String(this.formatTCField(n3));
            }
            timeCode.setTC(string3, string4, string5, string6);
            String string7 = this.checkTC(timeCode);
            this.dvbSocket.writeWithRNToSocket("/SEQA @" + string7 + " CUE " + playUnit + " " + this.delayValue);
            this.dvbSocket.readSocketLine();
            this.dvbSocket.readSocketLine();
            this.dvbSocket.writeWithRNToSocket("@" + string + " PLAY " + playUnit);
            this.dvbSocket.readSocketLine();
            return;
        }
        if (actionEvent.getSource() == this.bPBNow) {
            this.dvbSocket.writeWithRNToSocket("LOAD " + playUnit + " " + this.messenger.getClipName() + " OUT");
            this.dvbSocket.readSocketLine();
            this.dvbSocket.readSocketLine();
            this.dvbSocket.writeWithRNToSocket("/SEQA CUE " + playUnit);
            this.dvbSocket.readSocketLine();
            this.dvbSocket.readSocketLine();
            this.dvbSocket.writeWithRNToSocket("/SEQA PLAY " + playUnit);
            this.dvbSocket.readSocketLine();
            return;
        }
        if (actionEvent.getSource() == this.bStoPBNow) {
            this.dvbSocket.writeWithRNToSocket("STOP " + playUnit);
            this.dvbSocket.readSocketLine();
            return;
        }
        if (actionEvent.getSource() == this.bPausePB10 || actionEvent.getSource() == this.bPauseSubmit || actionEvent.getSource() == this.bPausePBPause1 || actionEvent.getSource() == this.bPausePB30 || actionEvent.getSource() == this.bPausePBPause2) {
            int n = 0;
            if (actionEvent.getSource() == this.bPauseSubmit) {
                n = Integer.valueOf(this.tfPauseTime.getText());
            } else if (actionEvent.getSource() == this.bPausePBPause1) {
                n = Integer.valueOf(this.messenger.getPause1());
            } else if (actionEvent.getSource() == this.bPausePBPause2) {
                n = Integer.valueOf(this.messenger.getPause2());
            } else if (actionEvent.getSource() == this.bPausePB10) {
                n = 10;
            } else if (actionEvent.getSource() == this.bPausePB30) {
                n = 30;
            }
            this.callPause(n);
            return;
        }
    }

    public synchronized void callPause(int n) {
        this.dvbSocket.writeWithRNToSocket("ULOC " + playUnit);
        this.dvbSocket.readSocketLine();
        String string = this.dvbSocket.readSocketLine();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string2 = stringTokenizer.nextToken();
        this.dvbSocket.writeWithRNToSocket("GTOD");
        this.dvbSocket.readSocketLine();
        string = this.dvbSocket.readSocketLine();
        stringTokenizer = new StringTokenizer(string, " ");
        String string3 = stringTokenizer.nextToken();
        stringTokenizer = new StringTokenizer(string3, ".");
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        stringTokenizer = new StringTokenizer(string4, ":");
        String string6 = stringTokenizer.nextToken();
        String string7 = stringTokenizer.nextToken();
        String string8 = stringTokenizer.nextToken();
        int n2 = Integer.valueOf(string8);
        int n3 = Integer.valueOf(string7);
        int n4 = Integer.valueOf(string6);
        if ((n2 += n) >= 60) {
            int n5 = n2 / 60;
            n2 %= 60;
            if ((n3 += n5) >= 60) {
                n5 = n3 / 60;
                n4 += n5;
            }
        }
        this.dvbSocket.writeWithRNToSocket("STOP " + playUnit);
        this.dvbSocket.readSocketLine();
        this.dvbSocket.writeWithRNToSocket("/SEQA CUE " + playUnit + " " + string2);
        this.dvbSocket.readSocketLine();
        this.dvbSocket.writeWithRNToSocket("@" + Integer.toString(n4) + ":" + Integer.toString(n3) + ":" + Integer.toString(n2) + "." + string5 + " PLAY " + playUnit);
        this.dvbSocket.readSocketLine();
    }

    public void error(String string) {
        this.messenger.errorMessage(string);
    }

    public int tcToFrames(int n, int n2, int n3, int n4) {
        int n5 = n4 + n3 * 30 + n2 * 30 * 60 + n * 30 * 60 * 60;
        if (n5 < this.minFrames) {
            n5 = this.minFrames;
        }
        if (n5 > this.maxFrames) {
            n5 = this.maxFrames;
        }
        return n5;
    }

    public String formatTCField(int n) {
        String string = n < 10 ? "0" + Integer.toString(n) : Integer.toString(n);
        return string;
    }

    public String checkTC(TimeCode timeCode) {
        String string = timeCode.getTC();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        int n = Integer.parseInt(string5, 10);
        int n2 = Integer.parseInt(string4, 10);
        int n3 = Integer.parseInt(string3, 10);
        int n4 = Integer.parseInt(string2, 10);
        if (this.checkDF(n4, n3, n2, n)) {
            n = 2;
        }
        n = Math.abs(n);
        n2 = Math.abs(n2);
        n3 = Math.abs(n3);
        n4 = Math.abs(n4);
        n = this.tcToFrames(n4, n3, n2, n);
        n2 = (int)Math.floor(n / 30);
        n3 = (int)Math.floor(n2 / 60);
        n4 = (int)Math.floor(n3 / 60);
        string5 = new String(this.formatTCField(n %= 30));
        string4 = new String(this.formatTCField(n2 %= 60));
        string3 = new String(this.formatTCField(n3 %= 60));
        string2 = new String(this.formatTCField(n4));
        timeCode.setTC(string2, string3, string4, string5);
        return timeCode.getTC();
    }

    public boolean checkDF(int n, int n2, int n3, int n4) {
        return (n4 == 0 || n4 == 1) && n3 == 0 && n2 != 0 && n2 % 10 != 0;
    }

    public class TimeCode {
        String TC;

        TimeCode(String string) {
            DvbControl.this = DvbControl.this;
            this.TC = string;
        }

        public String getTC() {
            return this.TC;
        }

        public void setTC(String string, String string2, String string3, String string4) {
            this.TC = String.valueOf(string) + ":" + string2 + ":" + string3 + ":" + string4;
        }
    }
}

