/*
 * Decompiled with CFR 0.152.
 */
package vcpmaint;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;
import vcpmaint.MVCPGlobals;
import vcpmaint.ScrollCanvas;

public class FileSysCanvas
extends ScrollCanvas
implements MVCPGlobals {
    String title;
    String nameTitle;
    String usedTitle;
    String availTitle;
    String totalTitle;
    String percentTitle;
    protected Vector fileSysInfo = new Vector(5);
    private static final Color nameColor = MVCPGlobals.mcpDkPurple;
    private static final Color nameRTColor = MVCPGlobals.mcpDkBlue;
    private static final Color usedColor = MVCPGlobals.mcpLtRed;
    private static final Color availColor = MVCPGlobals.mcpDkGreen;
    private static final Color totalColor = Color.black;

    FileSysCanvas() {
    }

    public void addFileSys(String string, int n, int n2, int n3, int n4, boolean bl) {
        this.fileSysInfo.addElement(new FileSysInfo(string, n / 1000, n2 / 1000, n3 / 1000, n4, bl));
        int n5 = this.fileSysInfo.size();
        int n6 = n5 > 2 ? n5 / 2 : n5;
        this.setSize(830, 60 + n6 * 120);
    }

    public void start() {
        this.fileSysInfo = new Vector(5);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.offGraphics == null || dimension.width != this.offDimension.width || dimension.height != this.offDimension.height) {
            this.offDimension = dimension;
            this.offImage = this.createImage(dimension.width, dimension.height);
            this.offGraphics = this.offImage.getGraphics();
        }
        this.offGraphics.setColor(this.getBackground());
        this.offGraphics.fillRect(0, 0, dimension.width, dimension.height);
        this.offGraphics.setFont(MVCPGlobals.largeFont);
        this.offGraphics.setColor(Color.black);
        this.offGraphics.drawString(this.title, 20, 30);
        this.offGraphics.setFont(MVCPGlobals.textFont);
        int n = 0;
        while (n < this.fileSysInfo.size()) {
            String string;
            int n2;
            int n3;
            FileSysInfo fileSysInfo = (FileSysInfo)this.fileSysInfo.elementAt(n);
            if (this.fileSysInfo.size() > 2) {
                n3 = (n & 1) == 1 ? 1 : 0;
                n2 = 120 * (n / 2);
            } else {
                n3 = 0;
                n2 = 120 * n;
            }
            int n4 = 440;
            int n5 = 45 + n2;
            int n6 = 290 + n4 * n3;
            int n7 = 60 + n2;
            int n8 = 20 + n4 * n3;
            int n9 = 150 + n4 * n3;
            int n10 = n7;
            this.myDraw3dRect(this.offGraphics, new Rectangle(n6 - 5, n5 - 5, 110, 110));
            if (fileSysInfo.isRealTime) {
                string = String.valueOf(fileSysInfo.name) + " (RT)";
                this.offGraphics.setColor(nameRTColor);
            } else {
                string = fileSysInfo.name;
                this.offGraphics.setColor(nameColor);
            }
            this.offGraphics.drawString(this.nameTitle, n8, n10);
            this.offGraphics.drawString(" " + string, n9, n10);
            this.offGraphics.setColor(usedColor);
            this.offGraphics.drawString(this.percentTitle, n8, n10 += 20);
            this.offGraphics.drawString(" " + fileSysInfo.percent + "%", n9, n10);
            this.offGraphics.setColor(usedColor);
            int n11 = fileSysInfo.used * 360 / fileSysInfo.total;
            this.offGraphics.fillArc(n6, n5, 100, 100, 0, n11);
            this.offGraphics.drawString(this.usedTitle, n8, n10 += 20);
            this.offGraphics.drawString(" " + fileSysInfo.used + " MB", n9, n10);
            this.offGraphics.setColor(availColor);
            int n12 = 360 - n11;
            this.offGraphics.fillArc(n6, n5, 100, 100, n11, n12);
            n11 += n12;
            this.offGraphics.drawString(this.availTitle, n8, n10 += 20);
            this.offGraphics.drawString(" " + fileSysInfo.avail + " MB", n9, n10);
            this.offGraphics.setColor(totalColor);
            this.offGraphics.drawString(this.totalTitle, n8, n10 += 20);
            this.offGraphics.drawString(" " + fileSysInfo.total + " MB", n9, n10);
            ++n;
        }
        graphics.drawImage(this.offImage, 0, 0, null);
    }

    private class FileSysInfo {
        public String name;
        public int used;
        public int avail;
        public int total;
        public int percent;
        public boolean isRealTime;

        FileSysInfo(String string, int n, int n2, int n3, int n4, boolean bl) {
            FileSysCanvas.this = FileSysCanvas.this;
            this.name = string;
            this.used = n;
            this.avail = n2;
            this.total = n3;
            this.percent = n4;
            this.isRealTime = bl;
        }
    }
}

