/*
 * Decompiled with CFR 0.152.
 */
package vcpmaint;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.StringTokenizer;
import vcpmaint.FileSysCanvas;
import vcpmaint.GridBagLayout2;
import vcpmaint.MVCPGlobals;
import vcpmaint.Messenger;
import vcpmaint.ScrollCanvas;
import vcpmaint.SocketMgr;

public class FileSysData
extends Panel
implements MVCPGlobals,
ActionListener {
    Messenger messenger;
    SocketMgr serverSocket;
    String serverString;
    private FileSysCanvas drawingCanvas;
    private ScrollPane scrollPane;
    private boolean doneLayout;
    Button bRefresh;
    static final int canvasHeight = 220;

    public FileSysData(Messenger messenger) {
        this.messenger = messenger;
        this.doneLayout = false;
        this.serverSocket = new SocketMgr(5025, messenger);
        this.drawingCanvas = new FileSysCanvas();
        this.drawingCanvas.title = "File Systems";
        this.drawingCanvas.nameTitle = "File System:";
        this.drawingCanvas.usedTitle = "Used:";
        this.drawingCanvas.availTitle = "Available:";
        this.drawingCanvas.totalTitle = "Total:";
        this.drawingCanvas.percentTitle = "Percent Used:";
        this.bRefresh = new Button(" Refresh ");
        this.bRefresh.setFont(MVCPGlobals.buttonFont);
        this.bRefresh.addActionListener(this);
    }

    public void layoutAndShow(ScrollCanvas scrollCanvas) {
        this.removeAll();
        GridBagLayout2 gridBagLayout2 = new GridBagLayout2();
        Panel panel = new Panel();
        panel.setLayout(gridBagLayout2);
        gridBagLayout2.northeast(panel, this.bRefresh, 0, 0, 10, 10, 10, 10);
        gridBagLayout2.centered_gr(panel, new Panel(), 1, 0);
        this.scrollPane = new ScrollPane(0);
        this.scrollPane.add(this.drawingCanvas);
        this.setLayout(new BorderLayout(0, 0));
        this.add("North", panel);
        this.add("Center", this.scrollPane);
    }

    public boolean contactServer() {
        if (!this.serverSocket.openSocket(60000)) {
            return false;
        }
        this.drawingCanvas.title = "File Systems on " + this.messenger.getHost();
        try {
            this.serverSocket.sendRequestToSocket(3, 0);
        }
        catch (IOException iOException) {
            this.error("Unexpected exception caught in contactServer: ", iOException);
            return false;
        }
        if (!this.doneLayout) {
            this.layoutAndShow(this.drawingCanvas);
            this.doneLayout = true;
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.bRefresh) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.start();
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void parseAndSend(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        int n4 = Integer.parseInt(stringTokenizer.nextToken());
        String string2 = stringTokenizer.nextToken();
        int n5 = Integer.parseInt(stringTokenizer.nextToken());
        this.drawingCanvas.addFileSys(string2, n2, n3, n, n4, n5 == 1);
    }

    public void start() {
        if (!this.contactServer()) {
            return;
        }
        this.drawingCanvas.start();
        this.myRun();
    }

    public void exit() {
    }

    public void socketClose() {
        if (this.serverSocket.isOpen()) {
            this.serverSocket.writeToSocket("stop");
            this.serverSocket.closeSocket();
        }
    }

    public void myRun() {
        try {
            String string = new String("ack");
            while ((this.serverString = this.serverSocket.readSocketLine()) != null) {
                if (this.serverString.equalsIgnoreCase("GROSServer-Bye")) break;
                this.serverSocket.writeToSocket(string);
                this.parseAndSend(this.serverString);
            }
            this.drawingCanvas.repaint();
            this.serverSocket.closeSocket();
            return;
        }
        catch (Exception exception) {
            this.error("Exception: ", exception);
            return;
        }
    }

    public void update(Graphics graphics) {
        this.drawingCanvas.repaint();
    }

    public void error(String string, Exception exception) {
        this.messenger.errorMessage(String.valueOf(string) + exception);
        System.out.println(string);
        exception.printStackTrace();
    }
}

