/*
 * Decompiled with CFR 0.152.
 */
package vcpmaint;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import vcpmaint.MVCPGlobals;
import vcpmaint.ScrollCanvas;

public class GROSMemCanvas
extends ScrollCanvas
implements MVCPGlobals {
    double memKernel;
    double memFsctl;
    double memFsdirty;
    double memFsclean;
    double memFree;
    double memUser;
    double memTot;
    double memFs;
    double mdrawKernel;
    double mdrawFsctl;
    double mdrawFsdirty;
    double mdrawFsclean;
    double mdrawFs;
    double mdrawUser;
    double mdrawFree;
    double mdrawTot;
    String title;
    String os_title;
    String fs_title;
    String usr_title;
    String free_title;
    String total_title;
    String status_str;
    String stillimage_str;
    Color statusColor;
    private static final double warningValue = 0.05;
    private static String warningStart = "WARNING: Running low on free memory; only ";
    int pageSize;

    public GROSMemCanvas() {
        this.messageY = 195;
        this.warnY = this.messageY + 20;
        this.statusColor = Color.black;
    }

    public void setPageSize(int n) {
        this.pageSize = n;
    }

    private double roundTo2Digits(double d) {
        long l = Math.round(d * 100.0);
        return (double)l / 100.0;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.offGraphics == null || dimension.width != this.offDimension.width || dimension.height != this.offDimension.height) {
            this.offDimension = dimension;
            this.offImage = this.createImage(dimension.width, dimension.height);
            this.offGraphics = this.offImage.getGraphics();
        }
        this.offGraphics.setColor(this.getBackground());
        this.offGraphics.fillRect(0, 0, dimension.width, dimension.height);
        this.offGraphics.setColor(Color.black);
        this.offGraphics.setFont(MVCPGlobals.textFont);
        this.offGraphics.setColor(Color.black);
        this.memFs = this.memFsctl + this.memFsdirty + this.memFsclean;
        this.mdrawKernel = this.memKernel * (double)this.pageSize / 1048576.0;
        this.mdrawFsctl = this.memFsctl * (double)this.pageSize / 1048576.0;
        this.mdrawFsdirty = this.memFsdirty * (double)this.pageSize / 1048576.0;
        this.mdrawFsclean = this.memFsclean * (double)this.pageSize / 1048576.0;
        this.mdrawFs = this.memFs * (double)this.pageSize / 1048576.0;
        this.mdrawUser = this.memUser * (double)this.pageSize / 1048576.0;
        this.mdrawFree = this.memFree * (double)this.pageSize / 1048576.0;
        this.mdrawTot = this.memTot * (double)this.pageSize / 1048576.0;
        this.myDraw3dRect(this.offGraphics, new Rectangle(285, 40, 110, 110));
        this.offGraphics.setFont(MVCPGlobals.largeFont);
        this.offGraphics.setColor(Color.black);
        this.offGraphics.drawString(this.title, 20, 30);
        int n = 0;
        this.offGraphics.setFont(MVCPGlobals.textFont);
        this.offGraphics.setColor(MVCPGlobals.mcpDkBlue);
        int n2 = (int)(this.mdrawKernel * 360.0 / this.mdrawTot);
        this.offGraphics.fillArc(290, 45, 100, 100, 0, n2);
        this.offGraphics.drawString(this.os_title, 20, 60);
        this.offGraphics.drawString(" " + this.roundTo2Digits(this.mdrawKernel) + " MB", 150, 60);
        n = 80;
        this.offGraphics.setColor(MVCPGlobals.mcpLtRed);
        int n3 = (int)(this.mdrawFs * 360.0 / this.mdrawTot);
        this.offGraphics.fillArc(290, 45, 100, 100, n2, n3);
        n2 += n3;
        this.offGraphics.drawString(this.fs_title, 20, n);
        this.offGraphics.drawString(" " + this.roundTo2Digits(this.mdrawFs) + " MB", 150, n);
        this.offGraphics.setColor(MVCPGlobals.mcpDkYellow);
        n3 = (int)(this.mdrawUser * 360.0 / this.mdrawTot);
        this.offGraphics.fillArc(290, 45, 100, 100, n2, n3);
        n2 += n3;
        this.offGraphics.drawString(this.usr_title, 20, n += 20);
        this.offGraphics.drawString(" " + this.roundTo2Digits(this.mdrawUser) + " MB", 150, n);
        this.offGraphics.setColor(MVCPGlobals.mcpDkGreen);
        n3 = 360 - n2;
        this.offGraphics.fillArc(290, 45, 100, 100, n2, n3);
        n2 += n3;
        this.offGraphics.drawString(this.free_title, 20, n += 20);
        this.offGraphics.drawString(" " + this.roundTo2Digits(this.mdrawFree) + " MB", 150, n);
        this.offGraphics.setColor(Color.black);
        this.offGraphics.drawString(this.total_title, 20, n += 20);
        this.offGraphics.drawString(" " + this.roundTo2Digits(this.mdrawTot) + " MB", 150, n);
        n += 20;
        boolean bl = false;
        if (this.memTot > 0.0 && this.memFree / this.memTot < 0.05) {
            bl = true;
        }
        if (bl) {
            this.offGraphics.setColor(MVCPGlobals.warningColor);
            String string = String.valueOf(warningStart) + this.roundTo2Digits(this.memFree * 100.0 / this.memTot) + "% free.";
            this.offGraphics.drawString(string, 20, this.warnY);
        }
        this.offGraphics.setFont(MVCPGlobals.textFont);
        if (this.freezeState) {
            this.offGraphics.setColor(MVCPGlobals.mcpDkYellow);
            this.offGraphics.drawString(this.stillimage_str, 20, this.messageY);
        } else {
            this.offGraphics.setColor(this.statusColor);
            this.offGraphics.drawString(this.status_str, 20, this.messageY);
        }
        graphics.drawImage(this.offImage, 0, 0, this);
    }
}

