/*
 * Decompiled with CFR 0.152.
 */
package vcpmaint;

import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;
import java.util.Date;
import vcpmaint.DataPanel;
import vcpmaint.GROSMemCanvas;
import vcpmaint.MVCPGlobals;
import vcpmaint.Messenger;
import vcpmaint.SocketMgr;

public class GROSMemData
extends DataPanel
implements MVCPGlobals,
Runnable {
    GROSMemCanvas drawingCanvas;
    int pageSize;
    String serverString;

    public GROSMemData(Messenger messenger) {
        super(messenger);
        this.serverSocket = new SocketMgr(5025, messenger);
        this.drawingCanvas = new GROSMemCanvas();
        this.drawingCanvas.title = "Memory Usage";
        this.drawingCanvas.os_title = "OS/Drivers:";
        this.drawingCanvas.fs_title = "File System Pages:";
        this.drawingCanvas.usr_title = "Running Procs:";
        this.drawingCanvas.free_title = "Free:";
        this.drawingCanvas.total_title = "Total:";
        this.drawingCanvas.status_str = "Monitoring Physical Memory Usage.";
        this.drawingCanvas.statusColor = Color.black;
        this.drawingCanvas.stillimage_str = "Automatic updating has stopped; press 'Resume Auto Update' to restart";
        super.layoutAndShow(this.drawingCanvas);
    }

    public boolean contactServer() {
        if (!this.serverSocket.openSocket()) {
            return false;
        }
        this.drawingCanvas.title = "Memory Usage on " + this.messenger.getHost();
        try {
            int n;
            String string;
            this.serverSocket.sendRequestToSocket(2, 2);
            if (this.serverSocket.moreToRead() && (string = this.serverSocket.readSocketLine()).startsWith("pagesize") && (n = string.indexOf(61)) > 0) {
                this.pageSize = Integer.parseInt(string.substring(n + 1));
            }
        }
        catch (IOException iOException) {
            this.error("Unexpected exception caught in contactServer: ", iOException);
            return false;
        }
        this.drawingCanvas.setPageSize(this.pageSize);
        this.serverString = this.serverSocket.readSocketLine();
        this.serverSocket.writeToSocket("ack");
        this.socketClose();
        return true;
    }

    public void run() {
        if (this.serverSocket.isOpen()) {
            return;
        }
        long l = this.now();
        Thread.currentThread().setPriority(1);
        this.keepRunning = true;
        try {
            while (this.keepRunning) {
                double d;
                double d2;
                double d3;
                double d4;
                double d5;
                double d6;
                if (!this.contactServer()) {
                    this.stop(false);
                    continue;
                }
                if (this.serverString.length() < 1 || this.serverString.charAt(0) != '=') continue;
                this.setUpdateTime(new Date());
                int n = 0;
                int n2 = 0;
                double d7 = 0.0;
                n = 5;
                n2 = this.serverString.indexOf(32, n);
                String string = this.serverString.substring(n, n2);
                this.drawingCanvas.memKernel = d6 = Double.valueOf(string).doubleValue();
                d7 += d6;
                n = n2 + 1;
                n2 = this.serverString.indexOf(32, n);
                string = this.serverString.substring(n, n2);
                this.drawingCanvas.memFsctl = d5 = Double.valueOf(string).doubleValue();
                d7 += d5;
                n = n2 + 1;
                n2 = this.serverString.indexOf(32, n);
                string = this.serverString.substring(n, n2);
                this.drawingCanvas.memFsdirty = d4 = Double.valueOf(string).doubleValue();
                d7 += d4;
                n = n2 + 1;
                n2 = this.serverString.indexOf(32, n);
                string = this.serverString.substring(n, n2);
                this.drawingCanvas.memFsclean = d3 = Double.valueOf(string).doubleValue();
                d7 += d3;
                n = n2 + 1;
                n2 = this.serverString.indexOf(32, n);
                string = this.serverString.substring(n, n2);
                this.drawingCanvas.memFree = d2 = Double.valueOf(string).doubleValue();
                d7 += d2;
                n = n2 + 1;
                n2 = this.serverString.length();
                string = this.serverString.substring(n, n2);
                this.drawingCanvas.memUser = d = Double.valueOf(string).doubleValue();
                this.drawingCanvas.memTot = d7 += d;
                this.drawingCanvas.repaint();
                this.sleepFor((long)(this.timeUpdateChoice * 1000) - (this.now() - l));
                l = this.now();
            }
            return;
        }
        catch (Exception exception) {
            this.error("Exception: ", exception);
            return;
        }
    }

    public void update(Graphics graphics) {
        this.drawingCanvas.repaint();
    }

    public void error(String string, Exception exception) {
        this.messenger.errorMessage(String.valueOf(string) + exception);
        System.out.println(string);
        exception.printStackTrace();
    }
}

