/*
 * Decompiled with CFR 0.152.
 */
package vcpmaint;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentListener;
import vcpmaint.MVCPGlobals;
import vcpmaint.ScrollCanvas;

public class GROSProcCanvas
extends ScrollCanvas
implements MVCPGlobals {
    int numProcs;
    double[] cpuUser;
    double[] cpuSys;
    double[] cpuIntr;
    double[] cpuGraph1;
    double[] cpuGraph2;
    double[] cpuIdle;
    String title;
    String usr_title;
    String os_title;
    String intr_title;
    String gr_title;
    String idle_title;
    String status_str;
    String stillimage_str;
    Color statusColor = Color.black;
    static final double warningValue = 0.02;
    private static final String warningStart = new String("WARNING: High Usage of Processor ");
    private static final Color userColor = MVCPGlobals.mcpLtRed;
    private static final Color osColor = MVCPGlobals.mcpDkPurple;
    private static final Color interruptColor = MVCPGlobals.mcpDkYellow;
    private static final Color graphicsColor = MVCPGlobals.mcpDkBlue;
    private static final Color idleColor = MVCPGlobals.mcpDkGreen;

    GROSProcCanvas() {
    }

    public void setNumProcs(int n, AdjustmentListener adjustmentListener) {
        if (this.numProcs == n) {
            return;
        }
        this.numProcs = n;
        this.scrollColumns = n;
        this.cpuUser = new double[this.numProcs];
        this.cpuSys = new double[this.numProcs];
        this.cpuIntr = new double[this.numProcs];
        this.cpuGraph1 = new double[this.numProcs];
        this.cpuGraph2 = new double[this.numProcs];
        this.cpuIdle = new double[this.numProcs];
        if (this.numProcs < 2) {
            this.hbar = null;
            this.messageY = 195;
            this.warnY = this.messageY + 20;
        } else {
            this.visibleCols = (this.getSize().width - 145) / 50;
            if (this.visibleCols >= this.numProcs) {
                this.hbar = null;
            } else {
                this.hbar = new Scrollbar(0);
                this.hbar.addAdjustmentListener(adjustmentListener);
            }
            this.messageY = 250;
            this.warnY = this.messageY + 20;
        }
        this.offset_x = 0;
    }

    public void paint(Graphics graphics) {
        if (this.numProcs < 1) {
            return;
        }
        String string = "";
        boolean bl = false;
        Dimension dimension = this.getSize();
        if (this.offGraphics == null || dimension.width != this.offDimension.width || dimension.height != this.offDimension.height) {
            this.offDimension = dimension;
            this.offImage = this.createImage(dimension.width, dimension.height);
            this.offGraphics = this.offImage.getGraphics();
        }
        this.offGraphics.setColor(this.getBackground());
        this.offGraphics.fillRect(0, 0, dimension.width, dimension.height);
        this.offGraphics.setFont(MVCPGlobals.largeFont);
        this.offGraphics.setColor(Color.black);
        this.offGraphics.drawString(this.title, 20, 30);
        int n = 0;
        this.offGraphics.setFont(MVCPGlobals.textFont);
        this.offGraphics.setColor(userColor);
        n = 60;
        if (this.numProcs > 1) {
            n += 20;
        }
        this.offGraphics.drawString(this.usr_title, 20, n);
        this.offGraphics.setColor(osColor);
        this.offGraphics.drawString(this.os_title, 20, n += 20);
        this.offGraphics.setColor(interruptColor);
        this.offGraphics.drawString(this.intr_title, 20, n += 20);
        this.offGraphics.setColor(graphicsColor);
        this.offGraphics.drawString(this.gr_title, 20, n += 20);
        this.offGraphics.setColor(idleColor);
        this.offGraphics.drawString(this.idle_title, 20, n += 20);
        n = 0;
        if (this.numProcs <= 1) {
            bl = this.cpuIdle[0] < 0.02 && this.cpuUser[0] + this.cpuSys[0] > 0.1;
            this.myDraw3dRect(this.offGraphics, new Rectangle(285, 40, 110, 110));
            this.offGraphics.setColor(userColor);
            int n2 = (int)(this.cpuUser[0] * 360.0);
            this.offGraphics.fillArc(290, 45, 100, 100, 0, n2);
            this.offGraphics.drawString(" " + (int)(this.cpuUser[0] * 100.0) + "%", 150, 60);
            n = 80;
            this.offGraphics.setColor(osColor);
            int n3 = (int)(this.cpuSys[0] * 360.0);
            this.offGraphics.fillArc(290, 45, 100, 100, n2, n3);
            n2 += n3;
            this.offGraphics.drawString(" " + (int)(this.cpuSys[0] * 100.0) + "%", 150, n);
            this.offGraphics.setColor(interruptColor);
            n3 = (int)(this.cpuIntr[0] * 360.0);
            this.offGraphics.fillArc(290, 45, 100, 100, n2, n3);
            n2 += n3;
            this.offGraphics.drawString(" " + (int)(this.cpuIntr[0] * 100.0) + "%", 150, n += 20);
            this.offGraphics.setColor(graphicsColor);
            n3 = (int)((this.cpuGraph1[0] + this.cpuGraph2[0]) * 360.0);
            this.offGraphics.fillArc(290, 45, 100, 100, n2, n3);
            n2 += n3;
            this.offGraphics.drawString(" " + (int)((this.cpuGraph1[0] + this.cpuGraph2[0]) * 100.0) + "%", 150, n += 20);
            this.offGraphics.setColor(idleColor);
            n3 = 360 - n2;
            this.offGraphics.fillArc(290, 45, 100, 100, n2, n3);
            this.offGraphics.drawString(" " + (int)(this.cpuIdle[0] * 100.0) + "%", 150, n += 20);
        } else {
            if (this.hbar != null) {
                this.offset_x = Math.max(this.offset_x, this.hbar.getMinimum());
                this.offset_x = Math.min(this.offset_x, this.hbar.getMaximum());
            }
            int n4 = 145;
            int n5 = 150;
            int n6 = 0;
            while (n6 < Math.min(this.numProcs, this.visibleCols)) {
                String string2;
                boolean bl2;
                int n7 = n6 + this.offset_x;
                boolean bl3 = bl2 = this.cpuIdle[n7] < 0.02 && this.cpuUser[n7] + this.cpuSys[n7] > 0.1;
                if (bl2) {
                    string2 = bl ? ", " : " ";
                    string = String.valueOf(string) + string2 + (n7 + 1);
                    bl = true;
                }
                n = 60;
                this.offGraphics.setColor(Color.black);
                string2 = n7 < 9 ? "  " : " ";
                this.offGraphics.drawString(String.valueOf(string2) + (n7 + 1), n5, n);
                n += 20;
                this.offGraphics.setColor(userColor);
                int n8 = (int)(this.cpuUser[n7] * 360.0);
                this.offGraphics.fillArc(n4, 170, 40, 40, 0, n8);
                if (bl2) {
                    this.offGraphics.setColor(MVCPGlobals.warningColor);
                }
                this.offGraphics.drawString(" " + (int)(this.cpuUser[n7] * 100.0) + "%", n5, n);
                n += 20;
                this.offGraphics.setColor(osColor);
                int n9 = (int)(this.cpuSys[n7] * 360.0);
                this.offGraphics.fillArc(n4, 170, 40, 40, n8, n9);
                n8 += n9;
                if (bl2) {
                    this.offGraphics.setColor(MVCPGlobals.warningColor);
                }
                this.offGraphics.drawString(" " + (int)(this.cpuSys[n7] * 100.0) + "%", n5, n);
                this.offGraphics.setColor(interruptColor);
                n9 = (int)(this.cpuIntr[n7] * 360.0);
                this.offGraphics.fillArc(n4, 170, 40, 40, n8, n9);
                n8 += n9;
                this.offGraphics.drawString(" " + (int)(this.cpuIntr[n7] * 100.0) + "%", n5, n += 20);
                this.offGraphics.setColor(graphicsColor);
                n9 = (int)((this.cpuGraph1[n7] + this.cpuGraph2[n7]) * 360.0);
                this.offGraphics.fillArc(n4, 170, 40, 40, n8, n9);
                n8 += n9;
                this.offGraphics.drawString(" " + (int)((this.cpuGraph1[n7] + this.cpuGraph2[n7]) * 100.0) + "%", n5, n += 20);
                this.offGraphics.setColor(idleColor);
                n9 = 360 - n8;
                this.offGraphics.fillArc(n4, 170, 40, 40, n8, n9);
                this.offGraphics.drawString(" " + (int)(this.cpuIdle[n7] * 100.0) + "%", n5, n += 20);
                n4 += 50;
                n5 += 50;
                ++n6;
            }
        }
        if (bl) {
            this.offGraphics.setColor(MVCPGlobals.warningColor);
            this.offGraphics.drawString(String.valueOf(warningStart) + string, 20, this.warnY);
        }
        this.offGraphics.setFont(MVCPGlobals.textFont);
        if (this.freezeState) {
            this.offGraphics.setColor(MVCPGlobals.mcpDkYellow);
            this.offGraphics.drawString(this.stillimage_str, 20, this.messageY);
        } else {
            this.offGraphics.setColor(this.statusColor);
            this.offGraphics.drawString(this.status_str, 20, this.messageY);
        }
        graphics.drawImage(this.offImage, 0, 0, null);
    }
}

