/*
 * Decompiled with CFR 0.152.
 */
package vcpmaint;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.Date;
import vcpmaint.DataPanel;
import vcpmaint.GROSProcCanvas;
import vcpmaint.MVCPGlobals;
import vcpmaint.Messenger;
import vcpmaint.SocketMgr;

public class GROSProcData
extends DataPanel
implements MVCPGlobals,
AdjustmentListener {
    GROSProcCanvas drawingCanvas;
    int numProcs;
    String[] infoStrs;

    public GROSProcData(Messenger messenger) {
        super(messenger);
        this.serverSocket = new SocketMgr(5025, messenger);
        this.drawingCanvas = new GROSProcCanvas();
        this.drawingCanvas.title = "CPU Usage";
        this.drawingCanvas.usr_title = "User:";
        this.drawingCanvas.os_title = "OS:";
        this.drawingCanvas.intr_title = "Interrupt:";
        this.drawingCanvas.gr_title = "Graphics:";
        this.drawingCanvas.idle_title = "Idle:";
        this.drawingCanvas.status_str = "Monitoring Processor Statistics.";
        this.drawingCanvas.statusColor = Color.black;
        this.drawingCanvas.stillimage_str = "Automatic updating has stopped; press 'Resume Auto Update' to restart";
        super.layoutAndShow(this.drawingCanvas);
    }

    public boolean contactServer() {
        if (!this.serverSocket.openSocket()) {
            return false;
        }
        this.drawingCanvas.title = "CPU Usage on " + this.messenger.getHost();
        try {
            this.serverSocket.sendRequestToSocket(1, 2);
            if (this.serverSocket.moreToRead()) {
                int n;
                String string = this.serverSocket.readSocketLine();
                if (string == null) {
                    return false;
                }
                if (string.startsWith("numprocs") && (n = string.indexOf(61)) > 0) {
                    this.numProcs = Integer.parseInt(string.substring(n + 1));
                }
            }
            this.drawingCanvas.setNumProcs(this.numProcs, this);
            this.infoStrs = new String[this.numProcs];
            int n = 0;
            while (n < this.numProcs) {
                this.infoStrs[n] = this.serverSocket.readSocketLine();
                this.serverSocket.writeToSocket("ack");
                ++n;
            }
        }
        catch (Exception exception) {
            this.error("Unexpected exception caught in contactServer: ", exception);
            return false;
        }
        this.socketClose();
        return true;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getAdjustable() == this.drawingCanvas.hbar) {
            this.drawingCanvas.offset_x = adjustmentEvent.getValue();
            this.drawingCanvas.repaint();
        }
    }

    public void run() {
        if (this.serverSocket.isOpen()) {
            return;
        }
        long l = this.now();
        Thread.currentThread().setPriority(1);
        this.keepRunning = true;
        try {
            while (this.keepRunning) {
                if (!this.contactServer()) {
                    this.stop(false);
                    continue;
                }
                this.setUpdateTime(new Date());
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                while (n4 < this.numProcs) {
                    String string = this.infoStrs[n4];
                    if (string.length() >= 1 && string.charAt(0) == '=') {
                        double d;
                        double d2;
                        double d3;
                        double d4;
                        double d5;
                        n = 3;
                        n2 = string.indexOf(32, n);
                        n3 = string.indexOf(32, n2 + 1);
                        String string2 = string.substring(n2 + 1, n3);
                        this.drawingCanvas.cpuUser[n4] = d5 = Double.valueOf(string2).doubleValue();
                        n = n3 + 1;
                        n2 = string.indexOf(32, n);
                        string2 = string.substring(n, n2);
                        this.drawingCanvas.cpuSys[n4] = d4 = Double.valueOf(string2).doubleValue();
                        n = n2 + 1;
                        n2 = string.indexOf(32, n);
                        string2 = string.substring(n, n2);
                        this.drawingCanvas.cpuIntr[n4] = d3 = Double.valueOf(string2).doubleValue();
                        n = n2 + 1;
                        n2 = string.indexOf(32, n);
                        string2 = string.substring(n, n2);
                        this.drawingCanvas.cpuGraph1[n4] = d2 = Double.valueOf(string2).doubleValue();
                        n = n2 + 1;
                        n2 = string.indexOf(32, n);
                        string2 = string.substring(n, n2);
                        this.drawingCanvas.cpuGraph2[n4] = d = Double.valueOf(string2).doubleValue();
                        n = n2 + 1;
                        string2 = string.substring(n, n2 = string.length());
                        double d6 = Double.valueOf(string2);
                        if (d6 > 1.0) {
                            d6 = 1.0;
                        }
                        this.drawingCanvas.cpuIdle[n4] = d6;
                    }
                    ++n4;
                }
                this.drawingCanvas.repaint();
                this.sleepFor((long)(this.timeUpdateChoice * 1000) - (this.now() - l));
                l = this.now();
            }
            if (this.keepRunning) {
                this.stop(false);
                return;
            }
        }
        catch (Exception exception) {
            this.error("Exception: ", exception);
        }
    }

    public void update(Graphics graphics) {
        this.drawingCanvas.repaint();
    }

    public void error(String string, Exception exception) {
        this.messenger.errorMessage(String.valueOf(string) + exception);
        System.out.println(string);
        exception.printStackTrace();
    }
}

