/*
 * Decompiled with CFR 0.152.
 */
package vcpmaint;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.ImageObserver;

public class ImageCanvas
extends Canvas
implements ImageObserver {
    private Image theImage;
    private Dimension prefSize;
    private int imageHPos;
    private int imageVPos;

    public ImageCanvas(Image image) {
        this.theImage = image;
        this.prefSize = new Dimension(this.theImage.getWidth(this), this.theImage.getHeight(this));
        this.imageHPos = 0;
        this.imageVPos = 0;
    }

    public ImageCanvas(int n, int n2) {
        this.prefSize = new Dimension(n, n2);
    }

    public void clearImage() {
        this.theImage = null;
        Graphics graphics = this.getGraphics();
        graphics.clearRect(0, 0, this.prefSize.width, this.prefSize.height);
    }

    public Dimension getMinimumSize() {
        return this.prefSize;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x20) != 0) {
            this.repaint();
            return false;
        }
        if ((n & 1) != 0 || (n & 2) != 0) {
            this.prefSize = new Dimension(n4, n5);
        }
        return true;
    }

    public void paint(Graphics graphics) {
        if (this.theImage != null) {
            graphics.clearRect(0, 0, this.prefSize.width, this.prefSize.height);
            graphics.drawImage(this.theImage, this.imageHPos, this.imageVPos, null);
        }
    }

    public Dimension getPreferredSize() {
        if (this.prefSize == null || this.prefSize.width < 0 || this.prefSize.height < 0) {
            this.prefSize = !this.waitForImage() ? new Dimension(100, 100) : new Dimension(this.theImage.getWidth(null), this.theImage.getHeight(null));
        }
        return this.prefSize;
    }

    public void setImage(Image image) {
        this.theImage = image;
        this.setPosition();
        this.repaint();
    }

    public void setPosition() {
        this.imageHPos = 0;
        int n = this.theImage.getWidth(null);
        if (n < this.prefSize.width) {
            this.imageHPos = (this.prefSize.width - n) / 2;
        }
        this.imageVPos = 0;
        int n2 = this.theImage.getHeight(null);
        if (n2 < this.prefSize.height) {
            this.imageVPos = (this.prefSize.height - n2) / 2;
        }
    }

    private boolean waitForImage() {
        MediaTracker mediaTracker = new MediaTracker(this);
        if (this.theImage != null) {
            mediaTracker.addImage(this.theImage, 1);
        }
        try {
            mediaTracker.waitForID(1);
        }
        catch (InterruptedException interruptedException) {}
        if (mediaTracker.isErrorID(1)) {
            mediaTracker = null;
            return false;
        }
        mediaTracker = null;
        return true;
    }
}

