/*
 * Decompiled with CFR 0.152.
 */
package vcpmaint;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.util.Hashtable;
import vcpmaint.AppletFrame;
import vcpmaint.ImageCanvas;
import vcpmaint.MVCPGlobals;
import vcpmaint.MVCPMaint;

public class MVCPApp
extends Applet
implements MVCPGlobals {
    private static MVCPApp theApp;
    private ImageCanvas logoCanvas;
    private static Frame logoFrame;
    private MVCPMaint mvcp;
    private String hostName;
    private Hashtable imagesLoaded = new Hashtable(10);
    private static boolean we_re_an_application;
    private static final String frameTitle = "VCP Recorder Monitor";
    private static final String logoFile = "DNALOGO1.gif";
    static String tmphost;

    public static void main(String[] stringArray) {
        we_re_an_application = true;
        if (stringArray.length != 0) {
            tmphost = stringArray[0];
        }
        theApp = new MVCPApp();
        new AppletFrame(theApp, 900, 750, frameTitle);
    }

    public void init() {
        Image image = this.loadImageNoWait(logoFile);
        this.logoCanvas = new ImageCanvas(image);
        this.logoCanvas.setName(logoFile);
        if (!we_re_an_application) {
            this.hostName = this.getParameter("hostName");
            if (this.hostName == null || this.hostName.length() == 0) {
                this.hostName = super.getCodeBase().getHost();
            }
        }
        if (we_re_an_application && tmphost.length() > 0) {
            this.hostName = tmphost;
        }
        this.mvcp = new MVCPMaint(this, this.logoCanvas, this.hostName, we_re_an_application);
        this.setLayout(new BorderLayout());
        this.add("Center", this.mvcp);
        this.setVisible(true);
        if (logoFrame != null) {
            logoFrame.dispose();
        }
    }

    public void start() {
        super.start();
        this.mvcp.start();
    }

    public void stop() {
        super.stop();
        this.mvcp.stop();
    }

    private void putUpSplashScreen() {
        Dimension dimension = this.getParent().getSize();
        logoFrame = new Frame();
        logoFrame.setTitle(frameTitle);
        logoFrame.setLayout(new BorderLayout());
        logoFrame.add("Center", this.logoCanvas);
        logoFrame.pack();
        Dimension dimension2 = logoFrame.getSize();
        ((Component)logoFrame).setLocation(dimension.width / 2 - dimension2.width / 2, dimension.height / 2 - dimension2.height / 2);
        logoFrame.show();
        ((Component)logoFrame).setCursor(Cursor.getPredefinedCursor(3));
    }

    private Image startLoadImage(String string) {
        Image image = null;
        image = we_re_an_application ? Toolkit.getDefaultToolkit().getImage(string) : this.getImage(this.getCodeBase(), string);
        return image;
    }

    public Image loadImageNoWait(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (this.imagesLoaded.containsKey(string)) {
            return (Image)this.imagesLoaded.get(string);
        }
        return this.startLoadImage(string);
    }

    public Image loadImage(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (this.imagesLoaded.containsKey(string)) {
            return (Image)this.imagesLoaded.get(string);
        }
        Image image = this.startLoadImage(string);
        if (image == null) {
            this.errorMessage("Internal error: image is null");
            return null;
        }
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 1);
        try {
            mediaTracker.waitForID(1);
        }
        catch (InterruptedException interruptedException) {}
        if (mediaTracker.isErrorID(1)) {
            this.errorMessage("File '" + string + "' does not exist or does not contain a valid JPEG or GIF image");
            return null;
        }
        this.imagesLoaded.put(string, image);
        return image;
    }

    private void errorMessage(String string) {
        if (this.mvcp != null) {
            this.mvcp.errorMessage(string);
            return;
        }
        System.out.println(string);
    }

    private void sleep(long l) {
        try {
            Thread.sleep(l);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    static {
        tmphost = "";
    }
}

