/*
 * Decompiled with CFR 0.152.
 */
package vcpmaint;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Date;
import vcpmaint.DvbConfigure;
import vcpmaint.DvbControl;
import vcpmaint.FileSysData;
import vcpmaint.GROSMemData;
import vcpmaint.GROSProcData;
import vcpmaint.GridBagLayout2;
import vcpmaint.MVCPApp;
import vcpmaint.MVCPGlobals;
import vcpmaint.MVCPSetup;
import vcpmaint.MVCPStatus;
import vcpmaint.Messenger;
import vcpmaint.TabbedPane;
import vcpmaint.UPGraphInfo;
import vcpmaint.UPStat;

public class MVCPMaint
extends Panel
implements MVCPGlobals,
Messenger,
WindowListener,
ItemListener {
    public static boolean isIRIX;
    public static Color backgroundGray;
    private TextArea taMessages;
    private MVCPSetup setupPanel;
    private MVCPMaint maint;
    private MVCPStatus statusPanel;
    private UPGraphInfo graphicInfoPanel;
    private UPStat statPanel;
    private GROSProcData procPanel;
    private GROSMemData memPanel;
    private FileSysData fileSysPanel;
    private DvbControl dvbPanel;
    private DvbConfigure dvbConfig;
    private String mainHost;
    private String clipName;
    private String pause1;
    private String pause2;
    private TabbedPane tabbedPane;
    private Component currentPane;
    private Image portIcon;
    private Image unitIcon;
    private MVCPApp ourparent;
    private boolean we_re_an_application = false;
    private static final String portIconFile = "porticon.gif";
    private static final String unitIconFile = "uniticon.gif";

    public MVCPMaint(MVCPApp mVCPApp, Canvas canvas, String string, boolean bl) {
        this.ourparent = mVCPApp;
        this.mainHost = string;
        this.pause1 = this.pause2 = new String("<unset>");
        this.we_re_an_application = bl;
        isIRIX = System.getProperty("os.name").toUpperCase().startsWith("IRIX");
        backgroundGray = isIRIX ? MVCPGlobals.mcpMdGray : MVCPGlobals.mcpLtGray;
        this.portIcon = this.ourparent.loadImage(portIconFile);
        this.unitIcon = this.ourparent.loadImage(unitIconFile);
        if (this.we_re_an_application) {
            this.setupPanel = new MVCPSetup(this);
        }
        this.setBackground(backgroundGray);
        this.statusPanel = new MVCPStatus(this, canvas);
        this.graphicInfoPanel = new UPGraphInfo(this, this.portIcon, this.unitIcon);
        this.statPanel = new UPStat(this);
        this.procPanel = new GROSProcData(this);
        this.memPanel = new GROSMemData(this);
        this.fileSysPanel = new FileSysData(this);
        this.dvbPanel = new DvbControl(this);
        this.dvbConfig = new DvbConfigure(this);
        this.taMessages = new TextArea(4, 80);
        this.taMessages.setEditable(false);
        ((Component)this.taMessages).setBackground(MVCPGlobals.mcpLtYellow);
        this.taMessages.setFont(MVCPGlobals.baseFont);
        String string2 = this.mainHost == null ? "Not specified" : this.mainHost;
        this.tabbedPane = new TabbedPane("Host: " + string2);
        this.tabbedPane.setFont(MVCPGlobals.tabFont);
        this.tabbedPane.addItemListener(this);
        this.tabbedPane.setForeground(Color.black);
        this.tabbedPane.setBackground(backgroundGray);
        int n = 0;
        this.tabbedPane.addTab("Status", null, this.statusPanel, "Overall Status of VCPR");
        if (this.we_re_an_application) {
            this.tabbedPane.addTab("Host", null, this.setupPanel, "Specify the MVCP Host");
            ++n;
        }
        this.tabbedPane.addTab("Ports & Units", null, this.graphicInfoPanel, "Ports and Units Information");
        ++n;
        this.tabbedPane.addTab("Statistics", null, this.statPanel, "Statistical Information");
        ++n;
        this.tabbedPane.addTab("CPU", null, this.procPanel, "Displays CPU information");
        ++n;
        this.tabbedPane.addTab("Memory", null, this.memPanel, "Displays memory information");
        ++n;
        this.tabbedPane.addTab("File Systems", null, this.fileSysPanel, "Displays file system information");
        ++n;
        this.tabbedPane.addTab("DVB Control", null, this.dvbPanel, "DVB control and status");
        ++n;
        this.tabbedPane.addTab("DVB Configure", null, this.dvbConfig, "DVB pause config");
        this.tabbedPane.setSelectedIndex(++n);
        GridBagLayout2 gridBagLayout2 = new GridBagLayout2();
        gridBagLayout2.setDefaultMargins(10, 10, 10, 10);
        this.setLayout(gridBagLayout2);
        gridBagLayout2.centered_gr(this, this.tabbedPane, 0, 0, 0, 10, 0, 10);
        gridBagLayout2.centered_gr_h(this, this.taMessages, 0, 1, 10, 10, 10, 10);
        this.findOurWindow();
    }

    private void findOurWindow() {
        Container container = this.ourparent;
        while (container != null && !(container instanceof Window)) {
            container = container.getParent();
        }
        if (container != null) {
            ((Window)container).addWindowListener(this);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        if (this.currentPane == this.graphicInfoPanel) {
            this.graphicInfoPanel.unPause();
            return;
        }
        if (this.currentPane == this.procPanel) {
            this.procPanel.unPause();
            return;
        }
        if (this.currentPane == this.memPanel) {
            this.memPanel.unPause();
        }
    }

    public void windowIconified(WindowEvent windowEvent) {
        if (this.currentPane == this.graphicInfoPanel) {
            this.graphicInfoPanel.pause();
            return;
        }
        if (this.currentPane == this.procPanel) {
            this.procPanel.pause();
            return;
        }
        if (this.currentPane == this.memPanel) {
            this.memPanel.pause();
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void setHost(String string) {
        this.mainHost = string;
        this.tabbedPane.setHeader("Host: " + this.mainHost);
        if (this.setupPanel != null) {
            this.setupPanel.setFields();
        }
    }

    public String getHost() {
        return this.mainHost;
    }

    public void setPausetime1(String string) {
        this.pause1 = string;
    }

    public void setPausetime2(String string) {
        this.pause2 = string;
    }

    public void setClipName(String string) {
        this.clipName = string;
    }

    public String getPause1() {
        return this.pause1;
    }

    public String getPause2() {
        return this.pause2;
    }

    public String getClipName() {
        return this.clipName;
    }

    public void start() {
        this.startPane(this.tabbedPane.getSelectedComponent());
    }

    public void stop() {
    }

    private void exitCurrentPane() {
        if (this.currentPane != null) {
            if (this.currentPane == this.statusPanel) {
                this.statusPanel.exit();
                return;
            }
            if (this.currentPane == this.setupPanel) {
                this.setupPanel.exit();
                return;
            }
            if (this.currentPane == this.graphicInfoPanel) {
                this.graphicInfoPanel.exit();
                return;
            }
            if (this.currentPane == this.procPanel) {
                this.procPanel.exit();
                return;
            }
            if (this.currentPane == this.memPanel) {
                this.memPanel.exit();
                return;
            }
            if (this.currentPane == this.fileSysPanel) {
                this.fileSysPanel.exit();
                return;
            }
            if (this.currentPane == this.dvbPanel) {
                this.dvbPanel.exit();
                return;
            }
            if (this.currentPane == this.dvbConfig) {
                this.dvbConfig.exit();
            }
        }
    }

    private void startPane(Component component) {
        if (this.currentPane != component) {
            if (component == this.statusPanel) {
                this.statusPanel.start();
            } else if (component == this.setupPanel) {
                this.setupPanel.start();
            } else if (component == this.graphicInfoPanel) {
                this.graphicInfoPanel.start();
            } else if (component == this.statPanel) {
                this.statPanel.start();
            } else if (component == this.procPanel) {
                this.procPanel.start();
            } else if (component == this.memPanel) {
                this.memPanel.start();
            } else if (component == this.fileSysPanel) {
                this.fileSysPanel.start();
            } else if (component == this.dvbPanel) {
                this.dvbPanel.start();
            } else if (component == this.dvbConfig) {
                this.dvbConfig.start();
            }
            this.currentPane = component;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.exitCurrentPane();
        this.startPane(this.tabbedPane.getSelectedComponent());
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void errorMessage(String string) {
        Date date = new Date();
        if (this.taMessages != null) {
            this.taMessages.append("\n" + date + ": " + string);
            return;
        }
        System.out.println(String.valueOf(date) + ": " + string);
    }
}

