/*
 * Decompiled with CFR 0.152.
 */
package vcpmaint;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Label;
import java.awt.Panel;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import vcpmaint.GridBagLayout2;
import vcpmaint.MVCPGlobals;
import vcpmaint.Messenger;
import vcpmaint.SocketMgr;

public final class MVCPStatus
extends Panel
implements MVCPGlobals,
Runnable {
    Messenger messenger;
    SocketMgr mvpSocket;
    Thread runThread;
    boolean keepRunning;
    int serverState;
    int curUnitErrors;
    String msgStr;
    Label lOverallStatus;
    Label lServerTime;
    Label lUnitErrors;
    private static final int serverContacting = 0;
    private static final int serverUp = 1;
    private static final int serverDown = 2;
    private static final int serverNoHost = 3;
    private static final String msgContacting = "Contacting server...";
    private static final String msgUp = "VCP Recorder is UP";
    private static final String msgDown = "VCP Recorder is NOT RESPONDING";
    private static final String msgNoHost = "VCP Recorder host not specified";
    private static final String msgServerTime = "Server time is ";
    private static final String msgUnitErrors = " units have errors";
    private static final String msgUnitError = "one unit has an error";
    private static final String statusErr = "ERR";
    private static final Color backgroundColor = Color.white;

    public MVCPStatus(Messenger messenger, Canvas canvas) {
        this.mvpSocket = new SocketMgr(5250, messenger);
        this.setBackground(backgroundColor);
        GridBagLayout2 gridBagLayout2 = new GridBagLayout2();
        this.setLayout(gridBagLayout2);
        this.lOverallStatus = new Label(msgContacting, 1);
        this.lOverallStatus.setFont(MVCPGlobals.largeFont);
        this.lOverallStatus.setForeground(MVCPGlobals.mcpDkYellow);
        this.lOverallStatus.setBackground(backgroundColor);
        this.serverState = 0;
        this.lServerTime = new Label("Server time is 00:00:00", 0);
        this.lServerTime.setFont(MVCPGlobals.largeFont);
        this.lServerTime.setForeground(MVCPGlobals.mcpDkGreen);
        this.lServerTime.setBackground(backgroundColor);
        this.lUnitErrors = new Label("0 units have errors", 2);
        this.lUnitErrors.setFont(MVCPGlobals.largeFont);
        this.lUnitErrors.setForeground(MVCPGlobals.mcpDkGreen);
        this.lUnitErrors.setBackground(backgroundColor);
        this.curUnitErrors = 0;
        Panel panel = new Panel();
        panel.setLayout(gridBagLayout2);
        gridBagLayout2.setDefaultMargins(2, 20, 2, 20);
        gridBagLayout2.centered_gr(panel, this.lOverallStatus, 0, 0, 2, 1);
        gridBagLayout2.northwest_gr_h(panel, this.lServerTime, 0, 1);
        gridBagLayout2.northeast_gr_h(panel, this.lUnitErrors, 1, 1);
        gridBagLayout2.setDefaultMargins(2, 2, 2, 2);
        gridBagLayout2.centered(panel, canvas, 0, 2, 2, 1);
        gridBagLayout2.centered(this, panel, 0, 0);
        this.doLayout();
    }

    private void setContacting() {
        if (this.serverState != 0) {
            this.serverState = 0;
            this.setLabelVisibles(false);
            this.lOverallStatus.setForeground(MVCPGlobals.mcpDkYellow);
            this.lOverallStatus.setBackground(backgroundColor);
            this.lOverallStatus.setText(msgContacting);
        }
    }

    private void setServerIsUp() {
        if (this.serverState != 1) {
            this.serverState = 1;
            this.setLabelVisibles(true);
            this.lOverallStatus.setForeground(MVCPGlobals.mcpDkGreen);
            this.lOverallStatus.setBackground(backgroundColor);
            this.lOverallStatus.setText(msgUp);
        }
    }

    private void setServerIsDown() {
        if (this.serverState != 2) {
            this.serverState = 2;
            this.setLabelVisibles(false);
            this.lOverallStatus.setForeground(MVCPGlobals.mcpDkRed);
            this.lOverallStatus.setText(msgDown);
        }
    }

    private void setNoHost() {
        if (this.serverState != 3) {
            this.serverState = 3;
            this.setLabelVisibles(false);
            this.lOverallStatus.setForeground(MVCPGlobals.mcpDkYellow);
            this.lOverallStatus.setBackground(backgroundColor);
            this.lOverallStatus.setText(msgNoHost);
        }
    }

    private void setLabelVisibles(boolean bl) {
        if (bl) {
            this.lServerTime.setForeground(MVCPGlobals.mcpDkGreen);
            if (this.curUnitErrors > 0) {
                this.lUnitErrors.setForeground(MVCPGlobals.mcpDkRed);
                return;
            }
            this.lUnitErrors.setForeground(MVCPGlobals.mcpDkGreen);
            return;
        }
        this.lServerTime.setForeground(backgroundColor);
        this.lUnitErrors.setForeground(backgroundColor);
    }

    private void setUnitErrors(int n) {
        if (this.curUnitErrors == n) {
            return;
        }
        if (n > 0) {
            this.lUnitErrors.setForeground(MVCPGlobals.mcpDkRed);
        } else {
            this.lUnitErrors.setForeground(MVCPGlobals.mcpDkGreen);
        }
        if (n == 1) {
            this.lUnitErrors.setText(msgUnitError);
            return;
        }
        this.lUnitErrors.setText(n + msgUnitErrors);
    }

    private boolean readAndCheckForUp() {
        this.msgStr = null;
        while (this.msgStr == null) {
            this.msgStr = this.mvpSocket.readSocketLine();
        }
        if (this.msgStr.equals("TIMEDOUT")) {
            this.setServerIsDown();
            return false;
        }
        this.setServerIsUp();
        return true;
    }

    public void start() {
        if (this.mvpSocket.getHost() == null || this.mvpSocket.getHost().length() == 0) {
            this.setNoHost();
            return;
        }
        this.setContacting();
        SocketMgr socketMgr = this.mvpSocket;
        synchronized (socketMgr) {
            if (this.runThread != null) {
                Object var2_2 = null;
                return;
            }
            this.runThread = new Thread(this);
            try {
                this.runThread.start();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                System.out.println("MVCPStatus.start, caught IllegalThreadStateException");
            }
            return;
        }
    }

    private void stop() {
        SocketMgr socketMgr = this.mvpSocket;
        synchronized (socketMgr) {
            this.keepRunning = false;
            this.mvpSocket.closeSocket();
            this.runThread = null;
            return;
        }
    }

    public void pause() {
        this.stop();
    }

    public void unPause() {
        this.start();
    }

    public void exit() {
        this.stop();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (!this.mvpSocket.openSocket(10000)) {
            this.setServerIsDown();
            return;
        }
        long l = this.now();
        if (!this.readAndCheckForUp()) {
            this.stop();
            return;
        }
        this.keepRunning = true;
        int n = 0;
        while (this.keepRunning) {
            SocketMgr socketMgr = this.mvpSocket;
            synchronized (socketMgr) {
                Object object;
                if (!this.mvpSocket.isOpen()) {
                    return;
                }
                this.mvpSocket.writeWithRNToSocket("GTOD");
                if (!this.readAndCheckForUp()) {
                    this.stop();
                    return;
                }
                if (!this.readAndCheckForUp()) {
                    this.stop();
                    return;
                }
                if (this.msgStr != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(this.msgStr, ".");
                    object = stringTokenizer.nextToken();
                    this.lServerTime.setText(msgServerTime + (String)object);
                }
                if (++n == 10) {
                    n = 0;
                    int n2 = 0;
                    object = this.mvpSocket.execMVCPCommand("ULS", true);
                    int n3 = 0;
                    while (true) {
                        if (n3 >= ((Vector)object).size()) {
                            this.setUnitErrors(n2);
                            break;
                        }
                        if (this.isUnitError((String)((Vector)object).elementAt(n3))) {
                            ++n2;
                        }
                        ++n3;
                    }
                }
            }
            this.sleepFor(Math.max(0L, 1000L - (this.now() - l)));
        }
        return;
    }

    private boolean isUnitError(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            String string2 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            return string2.equals(statusErr);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private long now() {
        return new Date().getTime();
    }

    private final void sleepFor(long l) {
        try {
            Thread.sleep(l);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

