/*
 * Decompiled with CFR 0.152.
 */
package vcpmaint;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Rectangle;
import vcpmaint.MVCPGlobals;
import vcpmaint.PortComponent;
import vcpmaint.UnitComponent;

public class PortsPanel
extends Panel
implements MVCPGlobals {
    protected boolean showBorder = true;
    protected String title;
    protected int titleHeight;
    protected int titleWidth;
    protected int numUnits;
    protected int portHeight;
    protected int portRight;
    protected int curUnitY;
    protected Color portColor;
    protected Dimension ourSize;
    private static final int portOffsetX = 2;
    private static final int portOffsetY = 10;
    private static final int unitSpacingY = 5;
    private static final int margin = 20;
    private static final Font ourFont = MVCPGlobals.baseFont;

    public PortsPanel(PortComponent portComponent) {
        this(portComponent, null);
    }

    public PortsPanel(PortComponent portComponent, String string) {
        this.title = string;
        this.titleWidth = 0;
        this.titleHeight = 0;
        this.numUnits = 0;
        this.setLayout(null);
        this.add(portComponent);
        portComponent.setLocation(2, 10);
        this.portHeight = portComponent.getHeight();
        this.portRight = portComponent.getRight();
        this.portColor = portComponent.getColor();
        this.curUnitY = 10;
        this.ourSize = new Dimension(portComponent.getRight() + 20, this.curUnitY + portComponent.getHeight() + 20);
    }

    public void addNotify() {
        super.addNotify();
        if (this.title != null) {
            FontMetrics fontMetrics = this.getFontMetrics(ourFont);
            this.titleHeight = fontMetrics.getHeight();
            this.titleWidth = fontMetrics.stringWidth(this.title);
        }
    }

    public void addUnit(UnitComponent unitComponent) {
        this.add(unitComponent);
        unitComponent.setLocation(this.portRight + 1, this.curUnitY);
        ++this.numUnits;
        int n = this.numUnits == 1 ? Math.max(this.portHeight, unitComponent.getHeight()) : unitComponent.getHeight();
        this.curUnitY = this.curUnitY + n + 5;
        this.ourSize = new Dimension(unitComponent.getRight() + 20, this.curUnitY + 5);
    }

    public Dimension getPreferredSize() {
        return this.ourSize;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void paint(Graphics graphics) {
        if (this.showBorder) {
            Rectangle rectangle = this.getBounds();
            int n = rectangle.width;
            int n2 = rectangle.height;
            int n3 = 0;
            if (this.titleHeight > 0) {
                n3 = this.titleHeight / 2;
            }
            graphics.setFont(ourFont);
            graphics.setColor(Color.darkGray);
            graphics.drawRect(0, n3, n - 2, n2 - n3 - 2);
            graphics.setColor(Color.white);
            graphics.drawLine(1, n3 + 1, n - 3, n3 + 1);
            graphics.drawLine(1, n3 + 1, 1, n2 - 3);
            graphics.drawLine(1, n2 - 1, n - 1, n2 - 1);
            graphics.drawLine(n - 1, n3 + 1, n - 1, n2);
            if (this.titleHeight > 0) {
                int n4 = 30;
                int n5 = this.titleHeight - this.titleHeight / 4;
                graphics.clearRect(n4 - 10, 0, n4 + this.titleWidth - 10, this.titleHeight);
                graphics.setColor(Color.white);
                graphics.drawString(this.title, n4 + 1, n5 + 1);
                graphics.setColor(Color.black);
                graphics.drawString(this.title, n4, n5);
            }
        }
        if (this.numUnits > 1) {
            graphics.setColor(this.portColor);
            graphics.drawLine(this.portRight, 10, this.portRight, this.curUnitY - 5);
        }
    }

    public void setShowBorder(boolean bl) {
        this.showBorder = bl;
    }

    public void setTitle(String string) {
        this.title = string;
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(ourFont);
            this.titleHeight = fontMetrics.getHeight();
            this.titleWidth = fontMetrics.stringWidth(this.title);
            this.repaint();
        }
    }
}

