/*
 * Decompiled with CFR 0.152.
 */
package vcpmaint;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.URL;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import vcpmaint.Messenger;

public class SocketMgr {
    private Messenger messenger;
    private Socket socket;
    private String fileName;
    private OutputStreamWriter writer;
    private BufferedReader reader;
    private URL mainURL;
    private String mainHost;
    private int mainPort;
    private boolean debug_set = false;
    public static final String TIMEDOUT = "TIMEDOUT";

    public SocketMgr(int n, Messenger messenger) {
        this.messenger = messenger;
        this.mainHost = this.messenger.getHost();
        this.mainPort = n;
    }

    public SocketMgr(String string, Messenger messenger) {
        this.messenger = messenger;
        String string2 = this.messenger.getHost();
        try {
            this.mainURL = new URL("http", string2, "/" + string);
            this.fileName = string;
            this.mainHost = string2;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public SocketMgr(Messenger messenger) {
        this.messenger = messenger;
    }

    public void setHost(String string) {
        this.mainHost = string;
    }

    public void setHostPort(String string, int n) {
        this.mainHost = string;
        this.mainPort = n;
        this.mainURL = null;
    }

    public String getHost() {
        this.mainHost = this.messenger.getHost();
        return this.mainHost;
    }

    public int getPort() {
        return this.mainPort;
    }

    public boolean isOpen() {
        return this.socket != null;
    }

    public synchronized void setDebug(boolean bl) {
        this.debug_set = bl;
    }

    public boolean openSocket() {
        return this.openSocket(30000);
    }

    public boolean openSocket(int n) {
        if (this.socket != null) {
            return true;
        }
        if (this.mainURL != null) {
            return this.openURL();
        }
        this.mainHost = this.messenger.getHost();
        if (this.mainHost == null || this.mainHost.length() == 0) {
            this.error("Error in openSocket: Host name has not been specified", null);
            return false;
        }
        try {
            this.socket = new Socket(this.mainHost, this.mainPort);
            this.socket.setSoTimeout(n);
            this.writer = new OutputStreamWriter(this.socket.getOutputStream());
            this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        }
        catch (Exception exception) {
            this.error("Exception when opening Socket to " + this.mainHost, exception);
            return false;
        }
        return true;
    }

    private boolean openURL() {
        this.debugMsg("openURL to " + this.mainURL);
        try {
            this.reader = new BufferedReader(new InputStreamReader(this.mainURL.openStream()));
        }
        catch (Exception exception) {
            this.error("Exception when opening URL to " + this.mainURL, exception);
            return false;
        }
        return true;
    }

    public synchronized void closeSocket() {
        this.debugMsg("closing socket");
        if (this.socket == null) {
            return;
        }
        try {
            if (this.writer != null) {
                this.writer.close();
            }
            if (this.reader != null) {
                this.reader.close();
            }
            this.socket.close();
        }
        catch (Exception exception) {
            this.error("Exception when closing Socket to " + this.mainHost, exception);
        }
        this.socket = null;
    }

    public boolean moreToRead() {
        try {
            return this.reader.ready();
        }
        catch (Exception exception) {
            this.error("Exception on call to reader.ready()", exception);
            return false;
        }
    }

    public synchronized String readSocketLine() {
        if (this.socket == null || this.reader == null) {
            return null;
        }
        String string = null;
        try {
            string = this.reader.readLine();
            this.debugMsg("read line:" + string);
        }
        catch (Exception exception) {
            if (exception instanceof InterruptedIOException) {
                return TIMEDOUT;
            }
            this.error("Exception when reading from socket to " + this.mainHost, exception);
        }
        this.debugMsg("readSocketLine returning " + string);
        return string;
    }

    public void writeWithRNToSocket(String string) {
        this.writeToSocket(String.valueOf(string) + "\r\n");
    }

    public synchronized void writeToSocket(String string) {
        if (this.writer == null) {
            this.error("Error in writeToSocket: writer is null", null);
            return;
        }
        try {
            this.debugMsg("Issuing " + string);
            this.writer.write(string);
            this.writer.flush();
        }
        catch (Exception exception) {
            this.error("Exception when sending to socket to " + this.mainHost, exception);
        }
        this.sleep(500L);
    }

    public synchronized void sendRequestToSocket(int n, int n2) throws IOException {
        if (this.writer == null) {
            return;
        }
        this.debugMsg("sendRequestToSocket, reqType=" + n + ", timeInterval=" + n2);
        this.writer.write(0);
        this.writer.write(0);
        this.writer.write(0);
        this.writer.write(n);
        this.writer.write(0);
        this.writer.write(0);
        this.writer.write(0);
        this.writer.write(n2);
        this.writer.flush();
        this.sleep(500L);
    }

    public synchronized void flushSocket() {
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.flush();
            return;
        }
        catch (Exception exception) {
            this.error("Exception when flushing socket to " + this.mainHost, exception);
            return;
        }
    }

    public Vector execMVCPCommand(String string) {
        return this.execMVCPCommand(string, false);
    }

    public Vector execMVCPCommand(String string, boolean bl) {
        Vector<String> vector = new Vector<String>();
        try {
            boolean bl2 = true;
            if (!bl) {
                bl2 = this.openSocket();
            }
            if (bl2) {
                if (!bl) {
                    this.readSocketLine();
                }
                this.debugMsg("Issuing " + string);
                this.writeWithRNToSocket(string);
                String string2 = this.readSocketLine();
                while (this.moreToRead()) {
                    string2 = this.readSocketLine();
                    if (string2 == null || string2.length() <= 0) continue;
                    vector.addElement(this.parseLine(string2));
                }
                if (!bl) {
                    this.closeSocket();
                }
            }
        }
        catch (Exception exception) {
            this.error("Exception caught in execMVCPCommand", exception);
        }
        return vector;
    }

    private String parseLine(String string) {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.charAt(0) == '\"') {
                String string4 = string3.substring(1);
                while (!string3.endsWith("\"") && stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    string4 = String.valueOf(string4) + " " + string3;
                }
                string3 = string4.substring(0, string4.length() - 1);
            }
            string2 = String.valueOf(string2) + "\t" + string3;
        }
        return string2.substring(1);
    }

    public void debugMsg(String string) {
        if (this.debug_set) {
            if (this.mainURL == null) {
                System.out.println(String.valueOf(new Date().getTime()) + "[" + this.mainHost + ", " + this.mainPort + "] " + string);
                return;
            }
            System.out.println("[" + this.mainURL + "] " + string);
        }
    }

    public void debugTrace(String string) {
        if (this.mainURL == null) {
            System.out.println("[" + this.mainHost + ", " + this.mainPort + "] " + string);
        } else {
            System.out.println("[" + this.mainURL + "] " + string);
        }
        new Throwable().printStackTrace();
    }

    public void error(String string, Exception exception) {
        if (this.messenger != null) {
            if (exception == null) {
                this.messenger.errorMessage(string);
            } else {
                this.messenger.errorMessage(String.valueOf(string) + ": " + exception);
            }
        }
        System.out.println(string);
        if (exception != null) {
            exception.printStackTrace();
        }
    }

    private void sleep(long l) {
        try {
            Thread.sleep(l);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

