/*
 * Decompiled with CFR 0.152.
 */
package vcpmaint;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import vcpmaint.MVCPGlobals;

public class TabButtonNew
extends Panel
implements MVCPGlobals,
ActionListener {
    protected String title;
    protected int titleWidth;
    protected int titleHeight;
    protected Dimension ourSize;
    protected boolean isActive = false;
    protected Font activeFont;
    protected Font inactiveFont;
    private static final int MARGIN = 10;

    public TabButtonNew(String string) {
        this.title = string;
    }

    public void setLabel(String string) {
        this.title = string;
    }

    private void setOurSize() {
        Font font = this.activeFont != null ? this.activeFont : this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.titleWidth = fontMetrics.stringWidth(this.title);
        this.titleHeight = fontMetrics.getMaxAscent();
        this.ourSize = new Dimension(this.titleWidth + 20, this.titleHeight + 8);
    }

    public Dimension getPreferredSize() {
        if (this.ourSize == null) {
            this.setOurSize();
        }
        return this.ourSize;
    }

    public void setPreferredSize(int n) {
        if (this.ourSize == null) {
            this.setOurSize();
        }
        this.ourSize.height *= n;
        this.ourSize.width *= n;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setActive(boolean bl) {
        this.isActive = bl;
        this.repaint();
    }

    public void setFonts(Font font, Font font2) {
        this.activeFont = font;
        this.inactiveFont = font2;
    }

    public void paint(Graphics graphics) {
        int n;
        if (this.isActive) {
            n = 0;
            graphics.setFont(this.activeFont);
        } else {
            n = 3;
            graphics.setFont(this.inactiveFont);
        }
        graphics.setColor(Color.black);
        graphics.drawRect(0, n, this.ourSize.width - 2, this.ourSize.height * 2);
        graphics.setColor(Color.red);
        graphics.fillRect(0, n, this.ourSize.width - 2, this.ourSize.height * 2);
        graphics.setColor(Color.black);
        graphics.drawString(this.title, 10, this.titleHeight + 4);
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
    }
}

