/*
 * Decompiled with CFR 0.152.
 */
package vcpmaint;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import vcpmaint.MVCPGlobals;
import vcpmaint.TabButton;

public class TabbedPane
extends Panel
implements MVCPGlobals,
MouseListener {
    protected Panel cardPanel;
    protected CardLayout cardLayout;
    protected TabPanel tabPanel;
    protected Vector tabs;
    protected Vector tabTitles;
    protected Vector components;
    protected Vector listeners;
    protected TabButton activeTab;
    protected String activeTitle;
    protected Component activeComp;
    protected Font activeFont;
    protected String theHeader;

    public TabbedPane() {
        this((String)null);
    }

    public TabbedPane(String string) {
        this.theHeader = string;
        this.cardPanel = new Panel();
        this.cardLayout = new CardLayout();
        this.cardPanel.setLayout(this.cardLayout);
        this.tabPanel = new TabPanel();
        this.tabs = new Vector(5);
        this.tabTitles = new Vector(5);
        this.components = new Vector(5);
        this.listeners = new Vector(5);
        this.setLayout(new BorderLayout());
        this.add("North", this.tabPanel);
        this.add("Center", this.cardPanel);
    }

    public void addTab(String string, Image image, Component component, String string2) {
        if (this.activeFont == null) {
            this.activeFont = this.getFont();
        }
        this.tabTitles.addElement(string);
        this.components.addElement(component);
        this.cardPanel.add(string, component);
        TabButton tabButton = new TabButton(string);
        tabButton.setActive(false);
        tabButton.setFonts(this.activeFont, this.getFont());
        if (this.activeTab == null) {
            this.activeTab = tabButton;
            this.activeTab.setActive(true);
        }
        tabButton.addMouseListener(this);
        this.tabs.addElement(tabButton);
        this.tabPanel.add(tabButton);
    }

    public void addItemListener(ItemListener itemListener) {
        this.listeners.addElement(itemListener);
    }

    public Component getSelectedComponent() {
        return this.activeComp;
    }

    public void setHeader(String string) {
        this.theHeader = string;
    }

    public void setSelectedIndex(int n) {
        if (n < 0 || n > this.tabs.size()) {
            return;
        }
        this.activeTab.setActive(false);
        this.activeTab = (TabButton)this.tabs.elementAt(n);
        this.activeTab.setActive(true);
        this.activeTitle = (String)this.tabTitles.elementAt(n);
        this.activeComp = (Component)this.components.elementAt(n);
        this.tabPanel.repaint();
        this.tellListeners();
        this.cardLayout.show(this.cardPanel, this.activeTitle);
    }

    public synchronized void setFont(Font font) {
        super.setFont(font);
        this.activeFont = new Font(font.getName(), 1, font.getSize());
        int n = 0;
        while (n < this.tabs.size()) {
            ((TabButton)this.tabs.elementAt(n)).setFonts(this.activeFont, this.getFont());
            ++n;
        }
    }

    private void tellListeners() {
        int n = 0;
        while (n < this.listeners.size()) {
            ((ItemListener)this.listeners.elementAt(n)).itemStateChanged(null);
            ++n;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        TabButton tabButton = (TabButton)mouseEvent.getComponent();
        int n = 0;
        while (n < this.tabs.size()) {
            if (tabButton == this.tabs.elementAt(n)) {
                this.setSelectedIndex(n);
                return;
            }
            ++n;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private class TabPanel
    extends Panel {
        TabPanel() {
            TabbedPane.this = TabbedPane.this;
            this.setLayout(new FlowLayout(0));
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            Rectangle rectangle = TabbedPane.this.activeTab.getBounds();
            graphics.clearRect(0, 0, dimension.width, dimension.height);
            int n = 0;
            int n2 = rectangle.x;
            int n3 = rectangle.x + rectangle.width;
            int n4 = dimension.width - 1;
            int n5 = dimension.height - 5;
            graphics.setColor(MVCPGlobals.reallyLtGray);
            graphics.drawLine(n, n5, n2, n5);
            graphics.drawLine(n3, n5, n4, n5);
            if (TabbedPane.this.theHeader != null) {
                graphics.setColor(Color.black);
                graphics.setFont(MVCPGlobals.baseFont);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n6 = fontMetrics.stringWidth(TabbedPane.this.theHeader);
                graphics.drawString(TabbedPane.this.theHeader, dimension.width - n6 - 10, dimension.height - 10);
            }
        }
    }
}

