/*
 * Decompiled with CFR 0.152.
 */
package vcpmaint;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import vcpmaint.CanvasCallback;
import vcpmaint.MVCPGlobals;
import vcpmaint.TableItem;
import vcpmaint.TableListSorter;

public class TableList
extends Panel
implements AdjustmentListener,
MouseListener,
MouseMotionListener,
MVCPGlobals {
    public static final Font baseFont = new Font("Helvetica", 0, 14);
    public static final Font colHdrFont = new Font("Helvetica", 1, 14);
    public static final Color reallyDarkGray = new Color(48, 48, 48);
    protected CanvasCallback canvas;
    protected CanvasCallback headerCanvas;
    protected TableListSorter sorter;
    protected Scrollbar hbar;
    protected Scrollbar vbar;
    protected int offset_x;
    protected int offset_y;
    protected int canvas_y;
    protected int iconWidth;
    protected int iconHeight;
    protected int fontHeight;
    protected int minimumColumnWidth;
    protected FontMetrics canvasFM;
    protected FontMetrics headerFM;
    protected Vector items;
    protected int curItem;
    protected int requestedRows;
    protected int lineHeight;
    protected int sortCol;
    protected int hiliteLine;
    protected int[] originalTabs;
    protected int[] tabStops;
    protected int lastColumnWidth;
    protected int fitStringMargin;
    protected int draggingColumn;
    protected int oldXLine;
    protected int maxSortCol;
    protected String header;
    protected String iconHeader;
    protected boolean showIcons;
    protected boolean showColumnLines;
    protected boolean showVbar;
    protected boolean beenReshaped;
    protected boolean allowSelections;
    protected Color columnLineColor;
    private Image offscreen;
    private Graphics goff;
    protected static final int maxIconSize = 60;
    protected static final int largestSortCol = 500;
    private static final int iconLeading = 2;

    public TableList(int n, String string, String string2, TableListSorter tableListSorter) {
        this.requestedRows = n;
        this.header = string;
        this.iconHeader = string2;
        this.sorter = tableListSorter;
        this.curItem = 0;
        this.maxSortCol = 500;
        this.sortCol = -1;
        this.offset_x = 0;
        this.offset_y = 0;
        this.canvas_y = 0;
        this.hiliteLine = -1;
        this.draggingColumn = -1;
        this.allowSelections = true;
        this.showIcons = false;
        this.showColumnLines = true;
        this.showVbar = false;
        this.columnLineColor = Color.gray;
        this.fitStringMargin = 2;
        this.lastColumnWidth = 200;
        this.minimumColumnWidth = 60;
        this.iconWidth = this.minimumColumnWidth + 2;
        this.iconHeight = 0;
        ((Component)this).setFont(baseFont);
        this.headerCanvas = new CanvasCallback(this);
        this.canvas = new CanvasCallback(this);
        this.canvas.setBackground(Color.white);
        this.hbar = new Scrollbar(0);
        this.vbar = new Scrollbar(1);
        this.hbar.addAdjustmentListener(this);
        this.vbar.addAdjustmentListener(this);
        this.addMouseListener(this);
        this.canvas.addMouseListener(this);
        this.canvas.addMouseMotionListener(this);
        this.headerCanvas.addMouseListener(this);
        this.setLayout(new BorderLayout(0, 0));
        this.add("North", this.headerCanvas);
        this.add("Center", this.canvas);
        this.add("South", this.hbar);
        this.hbar.setVisible(false);
        this.add("East", this.vbar);
        this.items = new Vector(20, 10);
    }

    public TableList(int n, String string) {
        this(n, string, null, null);
    }

    public TableList(int n, String string, TableListSorter tableListSorter) {
        this(n, string, null, tableListSorter);
    }

    public void addItemNoDraw(String string, Image image, String string2, Color color) {
        if (this.tabStops == null) {
            this.setTabStops(string);
        }
        if (image != null) {
            if (this.minimumColumnWidth > 0) {
                this.showIcons = true;
            }
            int n = image.getHeight(null);
            int n2 = image.getWidth(null);
            if (n > this.iconHeight && n <= 60) {
                this.iconHeight = n + 2;
                if (this.showIcons) {
                    this.lineHeight = this.iconHeight;
                }
            }
            if (n2 > this.iconWidth) {
                if (n2 <= 60) {
                    this.iconWidth = n2 + 2;
                }
                this.fixTabStops();
            }
        }
        this.items.addElement(new TableItem(string, image, string2, color, this.curItem++));
        this.setScrollBars();
    }

    public void addItem(String string, Image image, String string2, Color color) {
        this.addItemNoDraw(string, image, string2, color);
        this.drawStuff(false);
    }

    public void addItem(String string, Color color) {
        this.addItem(string, null, null, color);
    }

    public void addNotify() {
        super.addNotify();
        this.canvasFM = this.getFontMetrics(baseFont);
        this.fontHeight = this.canvasFM.getHeight() + 5;
        this.lineHeight = this.iconHeight == 0 ? this.fontHeight : this.iconHeight;
        this.headerCanvas.setFont(colHdrFont);
        this.headerFM = this.getFontMetrics(colHdrFont);
    }

    public void clear() {
        this.items.removeAllElements();
        this.curItem = 0;
        this.offset_x = 0;
        this.offset_y = 0;
        this.hiliteLine = -1;
        this.setScrollBars();
        this.drawStuff(true);
    }

    public void deselect() {
        this.hiliteLine = -1;
        this.repaint();
    }

    public void disableSelections() {
        this.allowSelections = false;
    }

    private void myDraw3DRect(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.darkGray);
        graphics.drawRect(0, 0, n - 2, n2 - 2);
        graphics.setColor(Color.white);
        graphics.drawLine(1, 1, n - 3, 1);
        graphics.drawLine(1, 1, 1, n2 - 3);
        graphics.drawLine(1, n2 - 1, n - 1, n2 - 1);
        graphics.drawLine(n - 1, 1, n - 1, n2);
        graphics.setColor(Color.black);
    }

    protected void drawStuff(boolean bl) {
        Object object;
        int n;
        int n2;
        Graphics graphics = this.canvas.getGraphics();
        if (graphics == null) {
            return;
        }
        if (this.beenReshaped) {
            this.beenReshaped = false;
            this.canvas_y = this.canvas.getLocation().y;
            this.setScrollBars();
        }
        Dimension dimension = this.canvas.getSize();
        Graphics graphics2 = this.headerCanvas.getGraphics();
        Dimension dimension2 = this.headerCanvas.getSize();
        if (this.offscreen == null || dimension.height != this.offscreen.getHeight(null) || dimension.width != this.offscreen.getWidth(null)) {
            if (dimension.width > 0 && dimension.height > 0) {
                this.offscreen = this.canvas.createImage(dimension.width, dimension.height);
                this.goff = null;
            } else {
                return;
            }
        }
        if (this.goff == null) {
            this.goff = this.offscreen.getGraphics();
            this.goff.setFont(baseFont);
            this.goff.setColor(Color.white);
        }
        if (bl) {
            this.goff.clearRect(0, 0, dimension.width, dimension.height);
            graphics2.clearRect(0, 0, dimension2.width, dimension2.height);
        }
        this.myDraw3DRect(graphics2, dimension2.width, dimension2.height);
        this.goff.draw3DRect(0, 0, dimension.width, dimension.height, false);
        if (this.iconHeader != null) {
            n2 = this.originalTabs[0];
            n = dimension2.height - 7;
            object = this.fitStringToWidth(this.iconHeader, this.tabStops[0], this.headerFM);
            graphics2.setColor(Color.white);
            graphics2.drawString((String)object, n2 + 1, n + 1);
            graphics2.setColor(reallyDarkGray);
            graphics2.drawString((String)object, n2, n);
            if (this.sortCol == 0) {
                int n3 = this.canvasFM.stringWidth((String)object);
                graphics2.drawLine(n2, n + 2, n2 + n3, n + 2);
            }
        }
        this.showString(this.header, graphics2, dimension2.height - 7, this.sortCol, true);
        this.vbar.setVisible(this.showVbar);
        n2 = 0;
        n = this.offset_y;
        while (n < this.items.size() && n2 < dimension.height) {
            int n4;
            int n5;
            int n6;
            object = (TableItem)this.items.elementAt(n);
            n2 = (n - this.offset_y + 1) * this.lineHeight;
            Color color = ((TableItem)object).color;
            if (this.hiliteLine == n) {
                Color color2 = ((TableItem)object).color;
                color = this.canvas.getBackground();
                this.goff.setColor(color2);
                n6 = n2 - this.lineHeight;
                n5 = this.lineHeight;
                if (this.showIcons) {
                    n5 -= 2;
                } else {
                    n6 += this.canvasFM.getDescent() + 2;
                }
                n4 = 0;
                if (this.showIcons && ((TableItem)object).icon != null) {
                    n4 = this.tabStops[0];
                }
                this.goff.fillRect(n4, n6, dimension.width, n5);
            }
            this.goff.setColor(color);
            int n7 = (this.iconHeight - 2 - (this.canvasFM.getHeight() - this.canvasFM.getDescent())) / 2 + 2;
            if (this.showIcons && ((TableItem)object).icon != null) {
                try {
                    n6 = 1;
                    n5 = ((TableItem)object).icon.getWidth(null);
                    if (n5 < this.iconWidth) {
                        n6 = (this.iconWidth - n5) / 2;
                    }
                    n4 = 0;
                    int n8 = ((TableItem)object).icon.getHeight(null);
                    if (n8 < this.iconHeight) {
                        n4 = (this.iconHeight - n8) / 2;
                    }
                    this.goff.drawImage(((TableItem)object).icon, n6, n2 - this.iconHeight + n4, null);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            } else {
                if (!this.showIcons) {
                    n7 = 0;
                }
                String string = this.fitStringToWidth(((TableItem)object).iconName, this.iconWidth, this.canvasFM);
                this.goff.drawString(string, this.originalTabs[0], n2 - n7);
            }
            this.showString(((TableItem)object).string, this.goff, n2 - n7, -1);
            if (this.showColumnLines) {
                this.goff.setColor(this.columnLineColor);
                int n9 = 0;
                while (n9 < this.tabStops.length) {
                    if (this.iconWidth > 0 || n9 != 0) {
                        this.goff.drawLine(this.tabStops[n9], 0, this.tabStops[n9], dimension.height);
                    }
                    ++n9;
                }
            }
            ++n;
        }
        graphics.drawImage(this.offscreen, 0, 0, dimension.width, dimension.height, null);
    }

    private String fitStringToWidth(String string, int n, FontMetrics fontMetrics) {
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        while (string2.length() > 0 && fontMetrics.stringWidth(string2) > n - this.fitStringMargin) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    private void fixTabStops() {
        this.setLineHeight();
        this.fitStringMargin = this.originalTabs[0];
        this.tabStops = new int[this.originalTabs.length];
        int n = 0;
        while (n < this.originalTabs.length) {
            this.tabStops[n] = this.originalTabs[n] + this.iconWidth;
            ++n;
        }
    }

    public int getScrollPos() {
        return this.offset_y;
    }

    public void setScrollPos(int n) {
        if (n >= this.vbar.getMinimum() && n <= this.vbar.getMaximum()) {
            this.offset_y = n;
            this.setScrollBars();
            this.repaint();
        }
    }

    public String getTableCellAt(int n, int n2) {
        if (n > this.items.size() || n2 > this.tabStops.length) {
            return null;
        }
        TableItem tableItem = (TableItem)this.items.elementAt(n);
        if (n2 == 0) {
            return tableItem.iconName;
        }
        int n3 = 0;
        int n4 = tableItem.string.indexOf("\t");
        int n5 = 1;
        while (n5 < n2) {
            n4 = tableItem.string.indexOf("\t", n3);
            n3 = n4 + 1;
            ++n5;
        }
        return tableItem.string.substring(n3, n4);
    }

    public Dimension getMinimumSize() {
        int n = this.tabStops == null ? 200 : this.tabStops[this.tabStops.length - 1] + this.lastColumnWidth;
        return new Dimension(n, 4 * this.lineHeight);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getAdjustable() == this.hbar) {
            this.offset_x = adjustmentEvent.getValue();
            this.repaint();
            return;
        }
        if (adjustmentEvent.getAdjustable() == this.vbar) {
            this.offset_y = adjustmentEvent.getValue();
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.getCursor().getType() == 3) {
            return;
        }
        this.setCursorByType(0);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.showColumnLines) {
            int n = mouseEvent.getX();
            mouseEvent.getY();
            int n2 = 0;
            while (n2 < this.tabStops.length) {
                int n3 = this.tabStops[n2];
                if (n > n3 - 2 && n < n3 + 2) {
                    this.draggingColumn = n2;
                    return;
                }
                ++n2;
            }
        }
        this.draggingColumn = -1;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.draggingColumn > -1) {
            if (this.draggingColumn == 0 && n < Math.max(this.iconWidth, this.minimumColumnWidth)) {
                n = this.iconWidth;
            } else if (this.draggingColumn > 0 && this.tabStops[this.draggingColumn - 1] + this.minimumColumnWidth > n) {
                n = this.tabStops[this.draggingColumn - 1] + this.minimumColumnWidth;
            } else if (this.draggingColumn < this.tabStops.length - 1 && this.tabStops[this.draggingColumn + 1] - this.minimumColumnWidth < n) {
                n = this.tabStops[this.draggingColumn + 1] - this.minimumColumnWidth;
            } else if (this.draggingColumn == this.tabStops.length - 1 && n > this.canvas.getSize().width - this.minimumColumnWidth) {
                n = this.canvas.getSize().width - this.minimumColumnWidth;
            }
            this.tabStops[this.draggingColumn] = n;
            this.draggingColumn = -1;
            this.repaint();
            return;
        }
        if (mouseEvent.getComponent() == this.headerCanvas) {
            int n3 = 0;
            while (n3 < this.tabStops.length) {
                if (n < this.tabStops[n3]) {
                    if (n3 == 0 && mouseEvent.isShiftDown()) {
                        this.showIcons = !this.showIcons;
                        this.offset_y = 0;
                        this.setLineHeight();
                        this.setScrollBars();
                        this.repaint();
                        return;
                    }
                    this.sortByColumn(n3);
                    return;
                }
                ++n3;
            }
            this.sortByColumn(this.tabStops.length);
            return;
        }
        if (mouseEvent.getComponent() == this.canvas) {
            if (!this.allowSelections) {
                return;
            }
            int n4 = this.offset_y + (n2 - 6) / this.lineHeight;
            if (n4 == this.hiliteLine || n4 >= this.items.size()) {
                this.deselect();
                if (this.sorter != null) {
                    this.sorter.listDeSelect(this);
                }
                return;
            }
            this.hiliteLine = n4;
            if (this.sorter != null) {
                this.sorter.listSelect(this.hiliteLine, this);
            }
            this.repaint();
            return;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.showColumnLines) {
            int n = mouseEvent.getX();
            mouseEvent.getY();
            if (this.getCursor().getType() == 3) {
                return;
            }
            int n2 = 0;
            while (n2 < this.tabStops.length) {
                int n3 = this.tabStops[n2];
                if (n > n3 - 2 && n < n3 + 2) {
                    this.setCursorByType(13);
                    return;
                }
                ++n2;
            }
            this.setCursorByType(0);
            return;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.draggingColumn < 0) {
            return;
        }
        int n = mouseEvent.getX();
        mouseEvent.getY();
        Graphics graphics = this.canvas.getGraphics();
        this.drawStuff(false);
        Dimension dimension = this.canvas.getSize();
        graphics.setColor(Color.green);
        graphics.drawLine(n, 0, n, dimension.height);
    }

    public void paint(Graphics graphics) {
        this.setCursorByType(3);
        this.drawStuff(true);
        this.setCursorByType(0);
    }

    public Dimension getPreferredSize() {
        int n = this.tabStops == null ? 200 : this.tabStops[this.tabStops.length - 1] + this.lastColumnWidth;
        return new Dimension(n, this.requestedRows * this.lineHeight);
    }

    public synchronized void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.beenReshaped = true;
        if (this.canvas != null && this.headerCanvas != null && this.headerFM != null) {
            Rectangle rectangle = this.canvas.getBounds();
            this.headerCanvas.setBounds(rectangle.x, rectangle.y, rectangle.width, this.headerFM.getHeight() + 6);
        }
    }

    public void setBackground(Color color) {
        this.canvas.setBackground(color);
    }

    public void setColumnLines(boolean bl) {
        this.showColumnLines = bl;
    }

    public void setColumnLineColor(Color color) {
        this.columnLineColor = color;
    }

    private void setCursorByType(int n) {
        this.setCursor(Cursor.getPredefinedCursor(n));
    }

    public void setHeaderColor(Color color) {
        this.headerCanvas.setForeground(color);
    }

    public void setHeader(String string) {
        this.header = string;
    }

    private void setLineHeight() {
        if (this.iconHeight == 0 || !this.showIcons) {
            this.lineHeight = this.fontHeight;
            return;
        }
        this.lineHeight = this.iconHeight;
    }

    public void setMaxSortColumn(int n) {
        this.maxSortCol = n;
    }

    private void setScrollBars() {
        int n;
        if (this.canvas.getSize().width <= 0) {
            return;
        }
        Dimension dimension = this.hbar.getSize();
        if (!this.hbar.isVisible()) {
            dimension = new Dimension(0, 0);
        }
        Dimension dimension2 = this.vbar.getSize();
        int n2 = this.canvas.getSize().width - dimension2.width;
        if (n2 <= 0) {
            return;
        }
        int n3 = (this.canvas.getSize().height - dimension.height) / this.lineHeight;
        if (n3 < 2) {
            n3 = 2;
        }
        if ((n = this.items.size()) <= 0) {
            n = 0;
            this.offset_y = 0;
        }
        this.hbar.setValues(this.offset_x, n2, 0, 1000 - n2);
        this.vbar.setValues(this.offset_y, n3, 0, n);
        this.hbar.setBlockIncrement(n2 / 2);
        this.vbar.setBlockIncrement(n3 - 1);
        this.showVbar = n3 < this.items.size() + 1;
    }

    public void setTabStops(int[] nArray, boolean bl) {
        this.originalTabs = nArray;
        if (bl) {
            this.iconWidth = 62;
        }
        this.fixTabStops();
    }

    public void setTabStops(int[] nArray) {
        this.setTabStops(nArray, false);
    }

    public void setTabStops(int[] nArray, int n) {
        this.setTabStops(nArray, false);
        this.lastColumnWidth = n;
        if (this.lastColumnWidth < this.minimumColumnWidth) {
            this.lastColumnWidth = this.minimumColumnWidth;
        }
    }

    public void setTabStops(String string) {
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf("\t", n2 + 1)) > 0) {
            ++n;
        }
        this.originalTabs = new int[n + 1];
        this.originalTabs[0] = 5;
        n2 = 0;
        int n3 = 1;
        int n4 = 0;
        while ((n2 = string.indexOf("\t", n2 + 1)) > 0) {
            this.originalTabs[n3] = this.originalTabs[n3 - 1] + this.canvasFM.stringWidth(String.valueOf(string.substring(n4, n2)) + "mmmm");
            n4 = n2 + 1;
            ++n3;
        }
        this.fixTabStops();
    }

    public void setSortColumn(int n) {
        if (n <= this.maxSortCol) {
            this.sortCol = n;
        }
    }

    public void setNeverShowIcons() {
        this.minimumColumnWidth = 0;
        this.iconWidth = 0;
        this.iconHeader = null;
        this.setShowIcons(false);
    }

    public void setShowIcons(boolean bl) {
        this.showIcons = bl;
        this.offset_y = 0;
        this.setLineHeight();
        this.setScrollBars();
        this.repaint();
    }

    protected void showString(String string, Graphics graphics, int n, int n2) {
        this.showString(string, graphics, n, n2, false);
    }

    protected void showString(String string, Graphics graphics, int n, int n2, boolean bl) {
        int n3 = 0;
        int n4 = this.showColumnLines ? 3 : 0;
        FontMetrics fontMetrics = this.getFontMetrics(graphics.getFont());
        int n5 = 0;
        while (n5 < this.tabStops.length && n3 < string.length()) {
            int n6 = string.indexOf("\t", n3);
            if (n6 < 0) {
                n6 = string.length();
            }
            String string2 = string.substring(n3, n6);
            if (n5 < this.tabStops.length - 1) {
                string2 = this.fitStringToWidth(string2, this.tabStops[n5 + 1] - this.tabStops[n5] - n4, fontMetrics);
            }
            if (bl) {
                Color color = graphics.getColor();
                graphics.setColor(Color.white);
                graphics.drawString(string2, this.tabStops[n5] + n4 + 1, n + 1);
                graphics.setColor(color);
            }
            graphics.drawString(string2, this.tabStops[n5] + n4, n);
            if (n2 - 1 == n5) {
                int n7 = fontMetrics.stringWidth(string2);
                int n8 = this.tabStops[n5] + n4;
                graphics.drawLine(n8, n + 2, n8 + n7, n + 2);
            }
            n3 = n6 + 1;
            ++n5;
        }
    }

    protected void sortByColumn(int n) {
        if (this.sorter != null && n <= this.maxSortCol && this.sorter.sortByColumn(n, this)) {
            this.sortCol = n;
            this.repaint();
        }
    }
}

