/*
 * Decompiled with CFR 0.152.
 */
package vcpmaint;

import java.awt.Button;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import vcpmaint.GridBagLayout2;
import vcpmaint.MVCPGlobals;
import vcpmaint.MVCPMaint;
import vcpmaint.Messenger;
import vcpmaint.PortComponent;
import vcpmaint.PortsPanel;
import vcpmaint.SocketMgr;
import vcpmaint.UnitComponent;

public class UPGraphInfo
extends Panel
implements MVCPGlobals,
ActionListener,
Runnable {
    private PortComponent[] ports;
    private Vector[] unitsOnPort;
    private Image portIcon;
    private Image unitIcon;
    private SocketMgr mvpSocket;
    private Thread runThread;
    private boolean keepRunning;
    private Panel mainPanel;
    private ScrollPane scrollPane;
    private boolean scrollPaneAdded = false;
    private Button bStartStop;
    private GridBagLayout2 gridbag = new GridBagLayout2();
    private static final int mainOffsetX = 20;
    private static final int infoY = 500;
    private static final int textHeight = 20;
    private static final String strStart = "Resume Auto Update";
    private static final String strStop = "    Stop Auto Update    ";

    public UPGraphInfo(Messenger messenger, Image image, Image image2) {
        this.mvpSocket = new SocketMgr(5250, messenger);
        this.portIcon = image;
        this.unitIcon = image2;
        this.setBackground(MVCPMaint.backgroundGray);
        this.bStartStop = new Button(strStop);
        this.bStartStop.setFont(MVCPGlobals.buttonFont);
        this.bStartStop.addActionListener(this);
        this.mainPanel = new Panel();
        this.mainPanel.setLayout(this.gridbag);
        this.scrollPane = new ScrollPane(0);
        this.scrollPane.add(this.mainPanel);
        this.setLayout(this.gridbag);
    }

    public void start() {
        this.createAndLayout();
        this.bStartStop.setLabel(strStop);
        this.runThread = new Thread(this);
        try {
            this.runThread.start();
            return;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            System.out.println("UPGraphInfo.start, caught IllegalThreadStateException");
            return;
        }
    }

    private void startAndReshow() {
        this.start();
        this.invalidate();
        this.validate();
        this.paint(this.getGraphics());
    }

    public void exit() {
        this.keepRunning = false;
        this.mvpSocket.closeSocket();
        this.bStartStop.setLabel(strStart);
    }

    public void pause() {
        this.exit();
    }

    public void unPause() {
        this.startAndReshow();
    }

    public void run() {
        boolean bl = false;
        if (!this.mvpSocket.openSocket(2000)) {
            return;
        }
        this.mvpSocket.readSocketLine();
        this.mvpSocket.writeWithRNToSocket("MON");
        String string = this.mvpSocket.readSocketLine();
        this.keepRunning = true;
        block0: while (this.keepRunning) {
            if (!this.mvpSocket.isOpen()) {
                return;
            }
            string = this.mvpSocket.readSocketLine();
            if (string == null || string.equals("TIMEDOUT")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("UCHG")) {
                String string3 = stringTokenizer.nextToken();
                int n = 0;
                while (n < this.unitsOnPort.length) {
                    int n2 = 0;
                    while (n2 < this.unitsOnPort[n].size()) {
                        UnitComponent unitComponent = (UnitComponent)this.unitsOnPort[n].elementAt(n2);
                        if (unitComponent.name.equals(string3)) {
                            unitComponent.changeInfo(string);
                            continue block0;
                        }
                        ++n2;
                    }
                    ++n;
                }
                continue;
            }
            if (string2.equals("UADD") || string2.equals("URM")) {
                this.keepRunning = false;
                bl = true;
                continue;
            }
            string2.equals("UCTL");
        }
        this.mvpSocket.closeSocket();
        this.runThread = null;
        if (bl) {
            this.startAndReshow();
        }
    }

    public void createAndLayout() {
        if (!this.scrollPaneAdded) {
            this.scrollPaneAdded = true;
            this.gridbag.setDefaultMargins(0, 0, 0, 0);
            this.gridbag.northwest(this, this.bStartStop, 0, 0, 10, 10, 10, 10);
            this.gridbag.centered_gr(this, this.scrollPane, 0, 1);
        }
        this.gridbag.setDefaultMargins(10, 10, 10, 10);
        this.mainPanel.removeAll();
        Vector vector = this.mvpSocket.execMVCPCommand("PLS");
        Vector vector2 = this.mvpSocket.execMVCPCommand("ULS");
        this.ports = new PortComponent[vector.size()];
        this.unitsOnPort = new Vector[vector.size()];
        UnitComponent[] unitComponentArray = new UnitComponent[vector2.size()];
        int n = 0;
        while (n < vector2.size()) {
            UnitComponent unitComponent;
            unitComponentArray[n] = unitComponent = new UnitComponent((String)vector2.elementAt(n), this.unitIcon);
            ++n;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < vector.size()) {
            PortComponent portComponent;
            this.ports[n4] = portComponent = new PortComponent((String)vector.elementAt(n4), this.portIcon);
            PortsPanel portsPanel = new PortsPanel(portComponent);
            this.unitsOnPort[n4] = new Vector();
            String string = portComponent.getPortName();
            int n5 = 0;
            while (n5 < unitComponentArray.length) {
                if (string.equals(unitComponentArray[n5].getUnitHost())) {
                    portsPanel.addUnit(unitComponentArray[n5]);
                    this.unitsOnPort[n4].addElement(unitComponentArray[n5]);
                }
                ++n5;
            }
            this.gridbag.northwest(this.mainPanel, portsPanel, n2, n3++);
            ++n4;
        }
        this.gridbag.centered_gr(this.mainPanel, new Panel(), n2, n3 + 1);
        this.paint(this.getGraphics());
    }

    private final void mySleep(long l) {
        try {
            Thread.sleep(l);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.bStartStop) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.keepRunning) {
                this.exit();
            } else {
                this.startAndReshow();
            }
            this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

