/*
 * Decompiled with CFR 0.152.
 */
package vcpmaint;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;
import java.util.Vector;
import vcpmaint.GridBagLayout2;
import vcpmaint.MVCPGlobals;
import vcpmaint.Messenger;
import vcpmaint.SocketMgr;
import vcpmaint.TableList;

public class UPStat
extends Panel
implements MVCPGlobals,
ActionListener,
ItemListener {
    private Button bUpdate;
    private Choice compChoice;
    private Label compLabel;
    private String statColHeads = "Component Name\tStatistic Name\tValue(s)";
    private String avgColHeads = "Number of Values\tNumber of Samples\tMinimum\tMaximum\tSum\tMean\tStd Dev";
    private Vector avgTableData;
    private Vector tableData;
    private Vector avgPatData;
    private Vector patData;
    private Vector uniqueComps;
    private TableList avgList;
    private TableList statList;
    private Panel controlsPanel;
    private static final int[] statTabStops = new int[]{5, 130, 305, 395, 485, 575, 665, 755};
    private static final int[] avgTabStops = new int[]{5, 130, 270, 370, 520, 620, 730};
    private Frame ourFrame;
    private SocketMgr mvpSocket;

    public UPStat(Messenger messenger) {
        this.mvpSocket = new SocketMgr(5250, messenger);
        this.controlsPanel = new Panel();
        this.bUpdate = new Button("Update");
        this.bUpdate.setFont(MVCPGlobals.buttonFont);
        this.bUpdate.addActionListener(this);
        this.compLabel = new Label("Choose Component Pattern:");
        this.compChoice = new Choice();
        this.compChoice.setFont(MVCPGlobals.buttonFont);
        this.compChoice.addItemListener(this);
        GridBagLayout2 gridBagLayout2 = new GridBagLayout2();
        this.controlsPanel.setLayout(gridBagLayout2);
        gridBagLayout2.northwest(this.controlsPanel, this.bUpdate, 0, 0, 5, 1, 5, 30);
        gridBagLayout2.northeast(this.controlsPanel, this.compLabel, 1, 0, 5, 30, 5, 1);
        gridBagLayout2.northwest(this.controlsPanel, this.compChoice, 2, 0, 5, 1, 5, 1);
        this.statList = new TableList(21, this.statColHeads);
        this.statList.setNeverShowIcons();
        this.statList.disableSelections();
        this.statList.setTabStops(statTabStops);
        this.avgList = new TableList(3, this.avgColHeads);
        this.avgList.setNeverShowIcons();
        this.avgList.disableSelections();
        this.avgList.setTabStops(avgTabStops);
        this.avgTableData = new Vector();
        this.tableData = new Vector();
        this.uniqueComps = new Vector();
        this.patData = new Vector();
        this.avgPatData = new Vector();
        this.setLayout(new BorderLayout(0, 0));
        this.add("North", this.controlsPanel);
        this.add("Center", this.statList);
        this.add("South", this.avgList);
    }

    public void start() {
        this.updateUPStat();
    }

    private void updateUPStat() {
        int n;
        this.avgTableData.removeAllElements();
        this.uniqueComps.removeAllElements();
        try {
            this.avgTableData.addElement(this.parseAvgTableData((String)this.mvpSocket.execMVCPCommand("STST").elementAt(0)));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        this.avgList.clear();
        int n2 = 0;
        while (n2 < this.avgTableData.size()) {
            this.avgList.addItemNoDraw((String)this.avgTableData.elementAt(n2), null, null, Color.black);
            ++n2;
        }
        this.avgList.repaint();
        this.tableData = this.mvpSocket.execMVCPCommand("STLS");
        this.statList.clear();
        int n3 = 0;
        while (n3 < this.tableData.size()) {
            this.statList.addItemNoDraw((String)this.tableData.elementAt(n3), null, null, Color.black);
            ++n3;
        }
        this.statList.repaint();
        this.uniqueComps.addElement("ALL");
        int n4 = 0;
        while (n4 < this.tableData.size()) {
            n = 0;
            String string = this.getCompToken((String)this.tableData.elementAt(n4));
            int n5 = 0;
            while (n5 < this.uniqueComps.size()) {
                if (((String)this.uniqueComps.elementAt(n5)).equals(string)) {
                    n = 1;
                }
                ++n5;
            }
            if (n == 0) {
                this.uniqueComps.addElement(string);
            }
            ++n4;
        }
        this.compChoice.removeAll();
        n = 0;
        while (n < this.uniqueComps.size()) {
            this.compChoice.add((String)this.uniqueComps.elementAt(n));
            ++n;
        }
        this.controlsPanel.repaint();
    }

    private String parseAvgTableData(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        String string2 = new String();
        while (stringTokenizer.hasMoreTokens()) {
            string2 = String.valueOf(string2) + "\t" + stringTokenizer.nextToken();
        }
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "\t");
        String string3 = new String();
        int n = 0;
        while (n < 14) {
            stringTokenizer2.nextToken();
            string3 = String.valueOf(string3) + "\t" + stringTokenizer2.nextToken();
            ++n;
            ++n;
        }
        return string3.substring(1);
    }

    private String getCompToken(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        return stringTokenizer.nextToken();
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.bUpdate) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.updateUPStat();
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        String string = this.compChoice.getSelectedItem();
        if (string.equals("ALL")) {
            this.patData = this.tableData;
            this.avgPatData = this.avgTableData;
        } else {
            this.patData = this.mvpSocket.execMVCPCommand("STLS " + string);
            this.avgPatData.removeAllElements();
            this.avgPatData.addElement(this.parseAvgTableData((String)this.mvpSocket.execMVCPCommand("STST " + string).elementAt(0)));
        }
        this.statList.clear();
        int n = 0;
        while (n < this.patData.size()) {
            this.statList.addItemNoDraw((String)this.patData.elementAt(n), null, null, Color.black);
            ++n;
        }
        this.statList.repaint();
        this.avgList.clear();
        int n2 = 0;
        while (n2 < this.avgPatData.size()) {
            this.avgList.addItemNoDraw((String)this.avgPatData.elementAt(n2), null, null, Color.black);
            ++n2;
        }
        this.avgList.repaint();
        this.setCursor(Cursor.getDefaultCursor());
    }
}

