/*
 * Decompiled with CFR 0.152.
 */
package vcpmaint;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import vcpmaint.ComponentCanvas;
import vcpmaint.MVCPGlobals;

public class UnitComponent
extends ComponentCanvas
implements MVCPGlobals {
    private String owner;
    private String port;
    private String clip;
    private String status;
    private String function;
    private String location;
    private String speed;
    private String frameRate;
    protected Image offImage;
    protected Graphics offGraphics;
    protected Dimension offDimension;
    private static final String statusBusy = "BUSY";
    private static final String statusRun = "RUN";
    private static final String statusDone = "DONE";
    private static final String statusErr = "ERR";

    public UnitComponent(String string, Image image) {
        super(image, Color.black, 500);
        this.setInfo(string);
        this.offGraphics = null;
    }

    public void setInfo(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            this.name = stringTokenizer.nextToken();
            this.owner = stringTokenizer.nextToken();
            this.port = stringTokenizer.nextToken();
            this.mode = stringTokenizer.nextToken();
            this.clip = stringTokenizer.nextToken();
            this.status = stringTokenizer.nextToken();
            this.function = stringTokenizer.nextToken();
            this.location = stringTokenizer.nextToken();
            this.speed = stringTokenizer.nextToken();
            this.frameRate = stringTokenizer.nextToken();
            this.setStatusColor();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void changeInfo(String string) {
        Graphics graphics = this.getGraphics();
        if (this.fm == null) {
            graphics.setFont(MVCPGlobals.textFont);
            this.fm = graphics.getFontMetrics();
            this.fontHeight = this.fm.getMaxAscent();
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            String string2 = stringTokenizer.nextToken();
            this.name = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            if (!string2.equals(this.clip)) {
                this.clip = string2;
                this.drawClip(graphics);
            }
            if (!(string2 = stringTokenizer.nextToken()).equals(this.status)) {
                this.status = string2;
                this.setStatusColor();
                this.repaint(10L);
            }
            if (!(string2 = stringTokenizer.nextToken()).equals(this.function)) {
                this.function = string2;
                this.drawFunction(graphics);
            }
            if (!(string2 = stringTokenizer.nextToken()).equals(this.location)) {
                this.location = string2;
                this.drawLocation(graphics);
            }
            if (!(string2 = stringTokenizer.nextToken()).equals(this.speed)) {
                this.speed = string2;
                this.drawSpeed(graphics);
            }
            this.frameRate = stringTokenizer.nextToken();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void setStatusColor() {
        if (this.status.equals(statusBusy)) {
            this.currentColor = MVCPGlobals.mcpDkYellow;
            this.textColor = Color.black;
            return;
        }
        if (this.status.equals(statusRun)) {
            this.currentColor = MVCPGlobals.mcpDkGreen;
            this.textColor = MVCPGlobals.mcpLtGray;
            return;
        }
        if (this.status.equals(statusDone)) {
            this.currentColor = MVCPGlobals.mcpDkPurple;
            this.textColor = MVCPGlobals.mcpLtGray;
            return;
        }
        if (this.status.equals(statusErr)) {
            this.currentColor = MVCPGlobals.mcpDkRed;
            this.textColor = MVCPGlobals.mcpLtGray;
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.offGraphics == null || dimension.width != this.offDimension.width || dimension.height != this.offDimension.height) {
            this.offDimension = dimension;
            this.offImage = this.createImage(dimension.width, dimension.height);
            this.offGraphics = this.offImage.getGraphics();
        }
        super.paint(this.offGraphics);
        this.drawOwner(this.offGraphics);
        this.drawClip(this.offGraphics);
        this.drawLocation(this.offGraphics);
        this.drawStatus(this.offGraphics);
        this.drawFunction(this.offGraphics);
        this.drawSpeed(this.offGraphics);
        graphics.drawImage(this.offImage, 0, 0, null);
    }

    private final void drawClip(Graphics graphics) {
        Rectangle rectangle = new Rectangle(82, 6, 200, 20);
        this.drawStringInBox(graphics, this.clip, rectangle);
    }

    private final void drawOwner(Graphics graphics) {
        Rectangle rectangle = new Rectangle(82, 26, 200, 20);
        this.drawStringInBox(graphics, this.owner, rectangle);
    }

    private final void drawStatus(Graphics graphics) {
        Rectangle rectangle = new Rectangle(282, 6, 100, 20);
        this.drawStringInBox(graphics, this.status, rectangle);
    }

    private final void drawFunction(Graphics graphics) {
        Rectangle rectangle = new Rectangle(282, 26, 100, 20);
        this.drawStringInBox(graphics, this.function, rectangle);
    }

    private final void drawLocation(Graphics graphics) {
        Rectangle rectangle = new Rectangle(382, 6, 100, 20);
        this.drawStringInBox(graphics, this.location, rectangle);
    }

    private final void drawSpeed(Graphics graphics) {
        Rectangle rectangle = new Rectangle(382, 26, 100, 20);
        this.drawStringInBox(graphics, this.speed, rectangle);
    }

    public String getUnitHost() {
        return this.port;
    }

    public String getCurrentInfo() {
        String string = "Unit " + this.name + ": Owner=" + this.owner + "; Port=" + this.port + "; Clip=" + this.clip + "; Status=" + this.status + "; Function=" + this.function + "; Location=" + this.location + "; Speed=" + this.speed + "; Frame Rate=" + this.frameRate;
        return string;
    }
}

