package Vtr;

require 5.002;
use Socket;
use FileHandle;
use English;

BEGIN
{
}

$PORT = 5250;
$socket = 'Socket';
$command_id = 'CommandId';
$sequence = 1;
$verbosity = 0;
$lastError = '';
$lastErrno = 0;

sub setVerbosity
{
    $verbosity = shift;
}

sub getLastErrno {
    $lastErrno;
}

sub getLastError {
    $lastError;
}

sub sendCommand
{
    my($vtr,$cmd) = @_;
    my $soc = $$vtr{$socket};
    if ($verbosity > 0) {
	print "<-- ".$cmd."\n";
    }
    print {$soc} $cmd."\r\n";
}

sub getResponseCode
{
    my $vtr = shift;
    my $soc = $$vtr{$socket};
    my $s;
    my $cid = 0;
    while (1) {
	my $s = <$soc>;
	if ($verbosity > 0) {
	    print " --> ".$s;
	}
	if ($s =~ /^(\d+)\s+(.*)\n/) {
	    if (($1 > 100) && ($1 < 200)) {
		if ($1 == 101) {
		    $s = <$soc>;
		    print " --> ".$s;
		    if ($s =~ /^(\d+)(.*)\n/) {
			$cid = $1;
		    }
		}
	    } else {
		$$vtr{$command_id} = $cid;
		return $1;
	    }
	}
    }
    print STDERR "MVCP server response missing or invalid\n";
    return 0;
}

sub getResponseOK
{
    return shift->getResponseCode() == 200;
}

sub getResponse
{
    my $vtr = shift;
    if ($vtr->getResponseCode() == 202) {
	my $soc = $$vtr{$socket};
	my $response = <$soc>;
	if ($verbosity > 0) {
	    print "   --> ".$response;
	}
	chop($response);
	chop($response);
	return $response;
    }
    return 0;
}

sub getResponseList
{
    my $vtr = shift;
    my @list;
    if ($vtr->getResponseCode() == 201) {
	my $soc = $$vtr{$socket};
      loop:
	for (;;) {
	    my $s = <$soc>;
	    if ($verbosity > 0) {
		print "   --> ".$s;
	    }
	    chop($s);
	    chop($s);
	    if (length($s) == 0) {
		last loop;
	    }
	    push(@list,$s);
	}
    }
    return @list;
}


sub connect
{
    my($destname) = @_;
    my $sockaddr_format = 'S n a4 x8';
    my($name,$aliases,$addrtype,$len,$destaddr) = gethostbyname($destname);
    if (!$name) {
	$lastError = "Host not found";
	$lastErrno = $OS_ERROR;
	return 0;
    }
    my $local = pack($sockaddr_format,AF_INET,0,"\0\0\0\0");
    my $dest = pack($sockaddr_format,AF_INET,$PORT,$destaddr);

    $sequence++;
    my $soc = 'VTRSOCKET'.$sequence;
    if (!socket($soc,PF_INET,SOCK_STREAM,0)) {
	$lastError = "Unable to create socket: $OS_ERROR";
	$lastErrno = $OS_ERROR;
	return 0;
    }
    if (!bind($soc,$local)) {
	$lastError = "Unable to bind socket: $OS_ERROR";
	$lastErrno = $OS_ERROR;
	return 0;	
    }
    if (!connect($soc,$dest)) {
	$lastError = "Unable to connect to $destname: $OS_ERROR";
	$lastErrno = $OS_ERROR;
	return 0;	
    }
    $soc->autoflush(1);
    my $vtr = {};
    bless $vtr,Vtr;
    $$vtr{$socket} = $soc;

    if ($vtr->getResponseCode() != 100) {
	close($soc);
	$lastError = "Incorrect response from $destname";
	$lastErrno = $OS_ERROR;
	return 0;
    }
    return $vtr;
}

sub disconnect
{
    my $vtr = shift;
    $vtr->sendCommand("BYE");
    my $soc = $$vtr{$socket};
    close($soc);
}

sub monitor
{
    my $vtr = shift;
    my $soc = $$vtr{$socket};
    print {$soc} "UMON";
    if ($vtr->getResponseCode() == 201) {
	return $vtr;
    }
    return '';
}

sub createUnit
{
    my($vtr,$port) = @_;
    $vtr->sendCommand("UADD $port * SHAR");
    my $unitName = getResponse($vtr);
    if ($unitName) {
	my $unit = new VtrUnit($vtr,$unitName);
	return $unit;
    }
    return 0;
}

sub openUnit
{
    my($vtr,$unitName) = @_;
    $vtr->sendCommand("UOPN $unitName");
    $unitName = getResponse($vtr);
    if ($unitName) {
	my $unit = new VtrUnit($vtr,$unitName);
	return $unit;
    }
    return 0;
}

sub getLine
{
    my $vtr = shift;
    my $soc = $$vtr{$socket};
    my $s = <$soc>;
    if ($s) {
	chop($s);
	chop($s);
    }
    $s;
}

sub getFd
{
    my $vtr = shift;
    $$vtr{$socket};
}

sub command
{
    my($this,$cmd) = @_;
    $this->sendCommand($cmd);
    return $this->getResponseOK();
}

sub commandResponse
{
    my($this,$cmd) = @_;
    $this->sendCommand($cmd);
    return $this->getResponse();
}

sub commandList
{
    my($this,$cmd) = @_;
    $this->sendCommand($cmd);
    return $this->getResponseList();
}


package VtrUnit;

$vtr = 'Vtr';
$unit_name = 'UnitName';
$command_id = 'CommandId';
$command_id_enabled = 'CommandIdEnabled';

sub new
{
    my($type,$soc,$unitName) = @_;
    my $unit = {};
    $$unit{$vtr} = $soc;
    $$unit{$unit_name} = $unitName;
    bless $unit,$type;
    return $unit;
}

sub name
{
    my $unit = shift;
    $$unit{$unit_name};
}


sub getVh
{
    my $unit = shift;
    return $$unit{$vtr};
}


sub enableCommandId
{
    my($unit,$enabled) = @_;
    $$unit{$command_id_enabled} = $enabled;
}

sub lastCommandId
{
    my $unit = shift;
    $$unit{$command_id};
}

sub sendCommand
{
    my($unit,$cmd,$args) = @_;
    my $vtr = $$unit{$vtr};
    my $name = $$unit{$unit_name};
    my $cid = $$unit{$command_id_enabled} ? "/CID " : "";
    my $c = "$cid$cmd $name";
    if ($args) {
	$c .= " $args";
    }
    $vtr->sendCommand($c);
}


sub command
{
    my($unit,$cmd,$args) = @_;
    $unit->sendCommand($cmd,$args);
    my $v = $$unit{$vtr};
    my $result = $v->getResponseOK();
    $$unit{$command_id} = $$v{$command_id};
    $result;
}

sub commandResponse
{
    my($unit,$cmd,$args) = @_;
    $unit->sendCommand($cmd,$args);
    my $v = $$unit{$vtr};
    my $result = $v->getResponse();
    $$unit{$command_id} = $$v{$command_id};
    $result;
}

sub commandList
{
    my($unit,$cmd,$args) = @_;
    $unit->sendCommand($cmd,$args);
    my $v = $$unit{$vtr};
    my $result = $v->getResponseList();
    $$unit{$command_id} = $$v{$command_id};
    $result;
}

1;
