/*
*  This file contains clip object methods and fields definitions.
*/

clips = new Array();

function clip (name, startHH, startMM, startSS, startFF, startAbsFr,
                     endHH,   endMM,   endSS,   endFF, endAbsFr,
                     size, format, speed, lowres)
{
  this.name = name
  this.startHH = startHH
  this.startMM = startMM
  this.startSS = startSS
  this.startFF = startFF
  this.startAbsFr = startAbsFr
  this.endHH = endHH
  this.endMM = endMM
  this.endSS = endSS
  this.endFF = endFF
  this.endAbsFr = endAbsFr
  this.size = size
  this.speed = speed
  this.format = format
  this.lowres = "Yes"
  }  

function loadClipFromForm (c, f)
{
  c.name = f.clipName.value
  c.startHH = f.tcSrcInHH.value
  c.startMM = f.tcSrcInMM.value
  c.startSS = f.tcSrcInSS.value
  c.startFF = f.tcSrcInFF.value
  var inff = parseInt (c.startFF,10)
  var inss = parseInt (c.startSS,10)
  var inmm = parseInt (c.startMM,10)
  var inhh = parseInt (c.startHH,10)
  c.startAbsFr = tcToFrames (inhh, inmm, inss, inff)
  c.endHH = f.tcSrcOutHH.value
  c.endMM = f.tcSrcOutMM.value
  c.endSS = f.tcSrcOutSS.value
  c.endFF = f.tcSrcOutFF.value
  var outff = parseInt (c.endFF,10)
  var outss = parseInt (c.endSS,10)
  var outmm = parseInt (c.endMM,10)
  var outhh = parseInt (c.endHH,10)
  c.endAbsFr = tcToFrames (outhh, outmm, outss, outff)
  c.size = -1
  c.speed = "Unknown"
  c.format = "Yes"
  }  

function checkClipName (clipNameInput) 
{
  i = clipFindIndex (clipNameInput.value)
  if (i >= 0) {
    selectClip (clips[i])
    }
  else {
    minFrames = 0
    maxFrames = 20000000
    }
  }

function clipExists (clipName)
{
  for (i = 0; i < clips.length; i++) {
    if (clips[i].name == clipName) return true
    }
  return false
  }

function clipFindIndex (clipName)
{
  for (i = 0; i < clips.length; i++) {
    if (clips[i].name == clipName) return i
    }
  return -1
  }


function selectClip(c) 
{
  minFrames = c.startAbsFr
  maxFrames = c.endAbsFr
  document.Cntls.clipName.value = c.name
  if (document.Cntls.tcSrcInHH) {
    document.Cntls.tcSrcInHH.value = c.startHH
    document.Cntls.tcSrcInMM.value = c.startMM
    document.Cntls.tcSrcInSS.value = c.startSS
    document.Cntls.tcSrcInFF.value = c.startFF
    document.Cntls.tcSrcOutHH.value = c.endHH
    document.Cntls.tcSrcOutMM.value = c.endMM
    document.Cntls.tcSrcOutSS.value = c.endSS
    document.Cntls.tcSrcOutFF.value = c.endFF
    if (document.Cntls.tcLenHH) {
      checkSrcOutTC()
      }
    }
  if (document.Cntls.clipLength) {
    document.Cntls.clipLength.value = 
      c.endHH + ":" + c.endMM + ":" + c.endSS +"." + c.endFF
    document.Cntls.clipSize.value = c.size
    document.Cntls.clipFormat.value = c.format
    document.Cntls.clipSpeed.value = c.speed
    }
  if (document.Cntls.clipLowRes) {
    document.Cntls.clipLowRes.value = c.lowres
    }
  }

function setupForLowRes ()
{
  if (parent.Player) {
    if (document.Cntls.reviewPlaybackLowRes.checked) {
      }
    else {
      }
    }
  }

function playLowResClip (mbserver, assetpath) {
  if (clipExists(document.Cntls.clipName.value)) {
    c = clipFindIndex(document.Cntls.clipName.value)
    if (c.lowres = "Yes") {
      if (parent.Player) {
        playLowResClipPlugin (mbserver, assetpath) 
        }
      else {
        document.location = "http://" + mbserver + "/mbase/asset/" + assetpath + 
          document.Cntls.clipName.value + "?autostart=true"
        }
      }
    }
  }

function playLowResClipPlugin (mbserver, assetpath) {
  parent.Player.document.open()
  parent.Player.document.writeln('<HTML><HEAD><TITLE>Mediabase Player Plugin</TITLE></HEAD>')
  parent.Player.document.writeln('<CENTER>')
  parent.Player.document.writeln('<TABLE BORDER=3 CELLPADDING="0" CELLSPACING="3"><TR><TD ALIGN="CENTER">')
  str = '<EMBED SRC="http://' + mbserver + '/mbase/asset/' + assetpath + document.Cntls.clipName.value +
                                   '?autostart=true&displaymethod=embed" WIDTH=155 HEIGHT=105>'
  parent.Player.document.writeln(str)
  parent.Player.document.writeln('</TD></TR></TABLE>')
  parent.Player.document.writeln('</CENTER>')
  parent.Player.document.writeln('</BODY></HTML>')
  parent.Player.document.close()
  }

function shipClip (c, image) {
  if (c.ship == true) {
    c.ship = false
    image.ship = false
    }
  else {
    c.ship = true
    image.ship = true
    }
  }

function gotoUrl (loc) {
  document.location = loc
  } 
