/*
*  This file contains timecode functions that operate on a form called
*  "Cntls"
*/

var minFrames = 0
var maxFrames = 20000000

// Over-the-fence routine for setting the timecode from the Status frame.
//   This routine must be moved into the .html to work however.  It is placed
//   only for cut and past.

function updateSrcTC (f)
{
  document.Cntls.tcSrc.value = f
  }

//  Calculate frames from timecode.

function tcToFrames (h, m, s, f)
{
  numf = f + s*30 + m*30*60 + h*30*60*60
  if (numf < minFrames) {
    numf = minFrames
    alert ('Timecode is below Minimum ... using Minimum')
    }
  if (numf > maxFrames) {
    numf = maxFrames
    alert ('Timecode is above Maximum ... using Maximum')
    }
  return numf
  }

//  Make sure timecode fields have 2 digits */

function formatTCField (f)
{
  var ff
  if (f < 10) {
    ff = "0" + f.toString()
    }
  else {
    ff = f.toString()
    }
  return ff
  }

//  Check Source In TC

function checkSrcInTC () 
{
  checkTC (
    document.Cntls.tcSrcInHH,
    document.Cntls.tcSrcInMM,
    document.Cntls.tcSrcInSS,
    document.Cntls.tcSrcInFF)
  var inff = parseInt (document.Cntls.tcSrcInFF.value,10)
  var inss = parseInt (document.Cntls.tcSrcInSS.value,10)
  var inmm = parseInt (document.Cntls.tcSrcInMM.value,10)
  var inhh = parseInt (document.Cntls.tcSrcInHH.value,10)
  if (checkDF (inhh, inmm, inss, inff)) {
    inff = 2
    document.Cntls.tcSrcInFF.value = formatTCField (inff)
    }

  var outff = parseInt (document.Cntls.tcSrcOutFF.value,10)
  var outss = parseInt (document.Cntls.tcSrcOutSS.value,10)
  var outmm = parseInt (document.Cntls.tcSrcOutMM.value,10)
  var outhh = parseInt (document.Cntls.tcSrcOutHH.value,10)
  var i = inff + inss*30 + inmm*30*60 + inhh*30*60*60
  var o = outff + outss*30 + outmm*30*60 + outhh*30*60*60
  if (o < i) {
    o = i
    outff = inff
    outss = inss
    outmm = inmm
    outhh = inhh
    document.Cntls.tcSrcOutFF.value = formatTCField (outff)
    document.Cntls.tcSrcOutSS.value = formatTCField (outss)
    document.Cntls.tcSrcOutMM.value = formatTCField (outmm)
    document.Cntls.tcSrcOutHH.value = formatTCField (outhh)
    }

/*  Update Length */

  var l = o - i
  var lenhh = Math.floor (l / (30*60*60))
  l = l - lenhh*30*60*60
  var lenmm = Math.floor (l / (30*60))
  l = l - lenmm*30*60
  var lenss = Math.floor (l / (30))
  l = l - lenss*30
  var lenff = l
  document.Cntls.tcLenFF.value = formatTCField (lenff)
  document.Cntls.tcLenSS.value = formatTCField (lenss)
  document.Cntls.tcLenMM.value = formatTCField (lenmm)
  document.Cntls.tcLenHH.value = formatTCField (lenhh)

/*  Update Source Out */

  checkLenTC ()
  }

// Check Source Out Timecode

function checkSrcOutTC () 
{
  checkTC (
    document.Cntls.tcSrcOutHH,
    document.Cntls.tcSrcOutMM,
    document.Cntls.tcSrcOutSS,
    document.Cntls.tcSrcOutFF)
  var outff = parseInt (document.Cntls.tcSrcOutFF.value,10)
  var outss = parseInt (document.Cntls.tcSrcOutSS.value,10)
  var outmm = parseInt (document.Cntls.tcSrcOutMM.value,10)
  var outhh = parseInt (document.Cntls.tcSrcOutHH.value,10)
  if (checkDF (outhh, outmm, outss, outff)) {
    outff = 2
    document.Cntls.tcSrcOutFF.value = formatTCField (outff)
    }
  var inff = parseInt (document.Cntls.tcSrcInFF.value,10)
  var inss = parseInt (document.Cntls.tcSrcInSS.value,10)
  var inmm = parseInt (document.Cntls.tcSrcInMM.value,10)
  var inhh = parseInt (document.Cntls.tcSrcInHH.value,10)
  var i = inff + inss*30 + inmm*30*60 + inhh*30*60*60
  var o = outff + outss*30 + outmm*30*60 + outhh*30*60*60
  if (o < i) {
    i = o
    inff = outff
    inss = outss
    inmm = outmm
    inhh = outhh
    document.Cntls.tcSrcInFF.value = formatTCField (inff)
    document.Cntls.tcSrcInSS.value = formatTCField (inss)
    document.Cntls.tcSrcInMM.value = formatTCField (inmm)
    document.Cntls.tcSrcInHH.value = formatTCField (inhh)
    }

/* Update length */

  var l = o - i
  var lenhh = Math.floor (l / (30*60*60))
  l = l - lenhh*30*60*60
  var lenmm = Math.floor (l / (30*60))
  l = l - lenmm*30*60
  var lenss = Math.floor (l / (30))
  l = l - lenss*30
  var lenff = l
  document.Cntls.tcLenFF.value = formatTCField (lenff)
  document.Cntls.tcLenSS.value = formatTCField (lenss)
  document.Cntls.tcLenMM.value = formatTCField (lenmm)
  document.Cntls.tcLenHH.value = formatTCField (lenhh)

/* Update Source Out */

  checkLenTC ()
  }

// Check Length timecode.

function checkLenTC ()
{
  checkTC (
    document.Cntls.tcLenHH,
    document.Cntls.tcLenMM,
    document.Cntls.tcLenSS,
    document.Cntls.tcLenFF)
  var lenff = parseInt (document.Cntls.tcLenFF.value,10)
  var lenss = parseInt (document.Cntls.tcLenSS.value,10)
  var lenmm = parseInt (document.Cntls.tcLenMM.value,10)
  var lenhh = parseInt (document.Cntls.tcLenHH.value,10)

/* Update Source Out */

  var inff = parseInt (document.Cntls.tcSrcInFF.value,10)
  var inss = parseInt (document.Cntls.tcSrcInSS.value,10)
  var inmm = parseInt (document.Cntls.tcSrcInMM.value,10)
  var inhh = parseInt (document.Cntls.tcSrcInHH.value,10)
  var i = inff + inss*30 + inmm*30*60 + inhh*30*60*60
  var l = lenff + lenss*30 + lenmm*30*60 + lenhh*30*60*60
  var o = i + l
  var outhh = Math.floor (o / (30*60*60))
  o = o - outhh*30*60*60
  var outmm = Math.floor (o / (30*60))
  o = o - outmm*30*60
  var outss = Math.floor (o / (30))
  o = o - outss*30
  var outff = o
  document.Cntls.tcSrcOutSS.value = formatTCField (outss)
  document.Cntls.tcSrcOutMM.value = formatTCField (outmm)
  document.Cntls.tcSrcOutHH.value = formatTCField (outhh)

// Take care of possible drop frame.

  if (checkDF (outhh, outmm, outss, outff)) {
    outff = 2
    document.Cntls.tcSrcOutFF.value = formatTCField (outff)
    checkSrcOutTC ()
    }
  else {
    document.Cntls.tcSrcOutFF.value = formatTCField (outff)
    } 
  }

//  Check the a time code for overflow of fields and illegal values

function checkTC (hh, mm, ss, ff) {
  var f = parseInt(ff.value,10)
  var s = parseInt(ss.value,10)
  var m = parseInt(mm.value,10)
  var h = parseInt(hh.value,10)
  if (isNaN(f)) f = 0
  if (isNaN(s)) s = 0
  if (isNaN(m)) m = 0
  if (isNaN(h)) h = 0
  f = Math.abs(f)
  s = Math.abs(s)
  m = Math.abs(m)
  h = Math.abs(h)
  f = tcToFrames (h, m, s, f)
  s = Math.floor (f / 30)
  m = Math.floor (s / 60)
  h = Math.floor (m / 60)
  f = f % 30
  s = s % 60
  m = m % 60
  ff.value = formatTCField (f)
  ss.value = formatTCField (s)
  mm.value = formatTCField (m)
  hh.value = formatTCField (h)
  }

// Check to see if frame should be dropped.

function checkDF (h, m, s, f) {
  if (f == 0 || f == 1) {
    if (s == 0 && m != 0) {
      if ((m % 10) != 0) {

// Time code is illegal in drop frame mode. Force legal time code.

        return true
        }
      }
    }
  return false
  }

