#include <stdio.h>
#include <signal.h>
#include <process.h>
#define MSDOS
#define	ASTYPE	1
#define	PGI	"c:\\usr\\pgi"

#ifdef MSDOS
#define	DIRCHAR		"\\"
#define	DIRCHARC	'\\'
#else
#define	DIRCHAR		"/"
#define	DIRCHARC	'/'
#endif

/* operating system where compiled code executes: */
#define OS_APX	1	/* hostlink */
#define	OS_UNIX	2	/* native unix */

/* assembly language output options */
#define AS_COFF	1	/* coff output */
#define AS_ELF	2

/* host for driver & compilers */
#define HOST_CROSS	1	/* cross compiler */
#define HOST_NATIVE	2	/* native compiler */

/* target machine options */
#define TARGET_I860	1	/* intel i860 */
#define TARGET_I386	2	/* intel i386 */

#include "config.h"

#define FUDGE 50
char *libdir = 0;

#ifdef PGC
char *toolname = "PGC";
char *fsuffix = ".c";
#endif
#ifdef PGFTN
char *toolname = "PGFTN";
char *fsuffix = ".f";
#endif

/*
#define OPTARG "vcpSEPgVfW:o:D:I:U:l:L:Y:O:M:K:"
*/
#define TAKES_ARG(c) (c == 'D' || c == 'I' || c == 'U' || \
		      c == 'l' || c == 'L' || c == 'W' || \
		      c == 'Y' || c == 'M' || c == 'K' || \
		      c == 'o')
#define TAKES_OPT_ARG(c) (c == 'O')



char *malloc();
char *calloc();

#define PATHLEN 1024
char compiler[PATHLEN+1];
char assembler[PATHLEN+1];
char linker[PATHLEN+1];




#define NARGS 200
char *ldfiles[NARGS+1];
char *cfiles[NARGS+1];
char *ldargs[NARGS+1];
char *cargs[NARGS+1];
char *asargs[NARGS+1];

char *as;
char *ld;
char *asdir;
char *lddir;

char **compopts;
char **asopts;
char **ldopts;

int ncargs;
int nasargs;
int nldfiles;
int nldargs;

char *suffix();
char *strchr();

int nufiles;
int onecfile;
char *ufilename;

#if 0
#define DBG(str) fprintf(stderr, str)
#define DBG2(str, arg) fprintf(stderr, str, arg)
#else
#define DBG(str)
#define DBG2(str, arg)
#endif




#define MAXFNAME 200
char fname[MAXFNAME+3];

#define RUN860_COMP 1
#define RUN860_AS 2
#define RUN860_LD 4

int nolink;
int asonly;
int profile;
int debug;
int eflag, pflag;
int version;
char *outfile;
int optlvl = -1;
int verbose;
int printprompt = -1;
int astype;
int nostdinc;
int nostdlib;
int nostartup;
int nostddef;
#ifdef MSDOS
int run860 = RUN860_COMP | RUN860_AS | RUN860_LD;
#else
int run860;
#endif
int ieee;
int linkmap;
int keepasm;
int status = 0;

char *strsave();
char *basename();
char *mkdirname();
char *tmpnam();

char *deflibdir;
char *startupdir;
char *compdir;
char *comp;
char *temp_name;
char *incdir;

#ifndef __STDC__
static int blocked = 0;
#else
static volatile int blocked = 0;
#endif

void
sighndlr()
{
    if (blocked == 0) return;
    unlink(temp_name);
    exit(127);
}

main(argc, argv)
int argc;
char **argv;
{
    int c;
    int i;
    int j;
    int compoffs;
    int asoffs;
    char buff[12];
    char *p;
    void (*signal())();
    int optind, optind1;
    char *optarg;

    temp_name = strsave(tmpnam((char *)0));
    if (signal(SIGINT, sighndlr) == SIG_IGN)
	signal(SIGINT, SIG_IGN);
#ifndef MSDOS
    if (signal(SIGHUP, sighndlr) == SIG_IGN)
	signal(SIGHUP, SIG_IGN);
#endif
    blocked = 1;
#if ASTYPE == AS_COFF
    deflibdir = mkdirname(COFF_LIBDIR);
#else
    deflibdir = mkdirname(ELF_LIBDIR);
#endif
    compdir = mkdirname(COMPDIR);
    comp = COMP;
    incdir = mkdirname(INCDIR);

    for (optind = 1; optind < argc; ++optind) {
	if (argv[optind][0] != '-') {
	    process_file(argv[optind]);
	}
	else {
	    for (optind1 = 1; argv[optind][optind1] != 0; ++optind1) {
		optarg = 0;
		c = argv[optind][optind1];
		if (TAKES_ARG(c)) {
		    if (argv[optind][optind1+1] != 0) {
			optarg = &argv[optind][optind1+1];
			optind1 = strlen(argv[optind])-1;
		    }
		    else if (optind < argc-1) {
			++optind;
			optarg = argv[optind];
			optind1 = strlen(argv[optind])-1;
		    }
		    else {
			fprintf(stderr, "%s: Missing argument for option -%c\n",
				toolname, c);
			exit(1);
		    }
		}
		else if (TAKES_OPT_ARG(c)) {
		    if (argv[optind][optind1+1] != 0) {
			optarg = &argv[optind][optind1+1];
			optind1 = strlen(argv[optind])-1;
		    }
		}
		switch (c) {
		case 'K':
		    if (strcmp(optarg, "pic") == 0) {
			fprintf(stderr, "%s: -K pic not yet supported\n", toolname);
		    }
		    else if (strcmp(optarg, "ieee") == 0) {
			ieee = 1;
		    }
		    else {
			fprintf(stderr, "%s: Illegal option to -K: %s\n", toolname,
			    optarg);
			exit(1);
		    }
		    break;
		case 'M':
		    process_mopt(optarg);
		    break;
		case 'v':
		    verbose = 1;
		    break;
		case 'O':
		    if (optarg == 0)
			optarg = "2";
		    switch (optarg[0]) {
		    case '0':
			optlvl = 0;
			break;
		    case '1':
			optlvl = 1;
			break;
		    case '2':
			optlvl = 2;
			break;
		    case '3':
			optlvl = 3;
			break;
		    case '4':
			optlvl = 4;
			break;
		    case '5':
			optlvl = 5;
			break;
		    default:
			fprintf(stderr, "%s: Illegal option to -O: %s\n", toolname,
			    optarg);
			exit(1);
		    }
		    break;
		case 'c':	/* compile only */
		    nolink = 1;
		    break;
		case 'p':	/* profile */
		    profile = 1;
		    break;
		case 'S':	/* assembly to file.s */
		    asonly = 1;
		    nolink = 1;
		    break;
		case 'E':	/* preprocessor only */
		    eflag = 1;
		    break;
		case 'P':	/* preprocessor only to file.i */
		    pflag = 1;
		    break;
		case 'g':	/* debug information */
		    debug = 1;
		    break;
		case 'V':	/* version information */
		    version = 1;
		    break;
		case 'r':
		case 's':
		    add_linkopt(c);
		    break;
		case 'm':
		    /*linkmap = 1;*/
		    fprintf(stderr, "%s: -m ignored\n", toolname);
		    break;
		case 'u':
		    /* add -u name to linker files */
		    fprintf(stderr, "%s: -u ignored\n", toolname);
		    break;
		case 'f':	/* floating point */
		    fprintf(stderr, "%s: -f ignored\n", toolname);
		    break;
		case 'W':	/* Alternate arguments */
		    process_wopt(optarg);
		    break;
		case 'o':	/* output file */
		    outfile = strsave(optarg);
		    break;
		case 'D':	/* define name */
		    process_def(optarg);
		    break;
		case 'I':	/* search for include */
		    process_idir(optarg);
		    break;
		case 'U':	/* undefine name */
		    process_undef(optarg);
		    break;
		case 'l':	/* linker library */
		    process_lib(optarg);
		    break;
		case 'L':	/* alternate linker path */
		    strcpy(fname, "-L");
		    strcat(fname, optarg);
		    add_arg(ldfiles, fname);
		    libdir = strsave(optarg);
		    break;
		case 'Y':	/* alternate directories */
		    process_yopt(optarg);
		    break;
		default:
		    fprintf(stderr,
			"%s: unknown option passed to linker: -%c\n",
			    toolname, c);
		    fname[0] = '-';
		    fname[1] = c;
		    fname[2] = 0;
		    add_linkopt(fname);
		    break;
		}
	    }
	}
    }
#ifdef PGC
    if (eflag && pflag) {
	fprintf(stderr,
		"%s: both -E and -P specified, using -E\n",
		toolname);
	pflag = 0;
    }
#endif
#ifdef PGFTN
    if (eflag || pflag) {
	fprintf(stderr,
		"%s: Fortran does not support eflag or pflag, ignored\n");
	exit(1);
    }
#endif
    if (astype == 0)
	astype = AS_DEFAULT;
    if (astype == AS_COFF) {
	as = COFF_AS;
	ld = COFF_LD;
	if (asdir == 0)
	    asdir = mkdirname(COFF_ASDIR);
	if (lddir == 0)
	    lddir = mkdirname(COFF_LDDIR);
	if (libdir == 0)
	    libdir = mkdirname(COFF_LIBDIR);
	if (startupdir == 0)
	    startupdir = mkdirname(COFF_CRTDIR);
    }
    else if (astype == AS_ELF) {
	as = ELF_AS;
	ld = ELF_LD;
	if (asdir == 0)
	    asdir = mkdirname(ELF_ASDIR);
	if (lddir == 0)
	    lddir = mkdirname(ELF_LDDIR);
	if (libdir == 0)
	    libdir = mkdirname(ELF_LIBDIR);
	if (startupdir == 0)
	    startupdir = mkdirname(ELF_CRTDIR);
    }
    else {
	fprintf(stderr, "%s: Only one of -M[coff|elf] allowed\n", toolname);
	exit(1);
    }
    if (optlvl == -1) {
	if (debug)
	    optlvl = 0;
	else
	    optlvl = 1;
    }

    DBG("Cfiles: ");
    for (j = 0; cfiles[j]; ++j)
	DBG2("%s ", cfiles[j]);
    DBG("\nLdfiles: ");
    for (j = 0; ldfiles[j]; ++j)
	DBG2("%s ", ldfiles[j]);
    nldfiles = j;
    DBG("\nldargs: ");
    for (j = 0; ldargs[j]; ++j)
	DBG2("%s ", ldargs[j]);
    nldargs = j;
    DBG("\ncargs: ");
    for (j = 0; cargs[j]; ++j)
	DBG2("%s ", cargs[j]);
    ncargs = j;
    DBG("\nasargs: ");
    for (j = 0; asargs[j]; ++j)
	DBG2("%s ", asargs[j]);
    nasargs = j;
    DBG("\n\n");

    /* build names for tools */
    strcpy(compiler, compdir);
    strcat(compiler, DIRCHAR);
    if (run860&RUN860_COMP) strcat(compiler, "apx");
    strcat(compiler, COMP);
    strcpy(assembler, asdir);
    strcat(assembler, DIRCHAR);
    if (run860&RUN860_AS) strcat(assembler, "apx");
    strcat(assembler, as);
    strcpy(linker, lddir);
    strcat(linker, DIRCHAR);
    if (run860&RUN860_LD) strcat(linker, "apx");
    strcat(linker, ld);
    /* build the compiler argument string */
    compopts = (char **)calloc(ncargs + FUDGE, sizeof(char *));
    if (compopts == 0) {
	fprintf(stderr, "%s: out of memory\n", toolname);
	exit(127);
    }
    if (!asonly && !eflag && !pflag) {
	asopts = (char **)calloc(nasargs + FUDGE, sizeof(char *));
	if (asopts == 0) {
	    fprintf(stderr, "%s: out of memory\n", toolname);
	    exit(127);
	}
    }
    if (!nolink && !eflag && !pflag && !asonly) {
	ldopts = (char **)calloc(nldargs + nldfiles + FUDGE, sizeof(char *));
	if (ldopts == 0) {
	    fprintf(stderr, "%s: out of memory\n", toolname);
	    exit(127);
	}
    }
    /* build the initial compiler string */
    if (!pflag && !eflag && !asonly) {
	if (run860 & RUN860_AS) {
	    asopts[0] = RUN860;
	    asopts[1] = assembler;
	    asoffs = 2;
	}
	else {
	    asoffs = 1;
	    asopts[0] = assembler;
	}
	for (i = 0; i < nasargs; ++i)
	    asopts[asoffs++] = asargs[i];
    }

    if (run860&RUN860_COMP) {
	compopts[0] = RUN860;
	compopts[1] = compiler;
	compoffs = 3;
    }
    else {
	compopts[0] = compiler;
	compoffs = 2;
    }

    if (pflag || eflag) {
	if (nostdinc)
	    compopts[compoffs++] = "-nostdinc";
	else {
	    compopts[compoffs++] = "-stdinc";
	    compopts[compoffs++] = incdir;
	}
	if (eflag) {
	    compopts[compoffs++] = "-pp";
	    compopts[compoffs++] = "-es";
	}
    }
    else if (!pflag) {
	if (!verbose) {
	    compopts[compoffs++] = "-inform";
	    compopts[compoffs++] = "warn";
	    compopts[compoffs++] = "-terse";
	}
	compopts[compoffs++] = "-astype";
	compopts[compoffs++] = (astype == AS_ELF) ? "0" :"1";
#ifdef PGC
	if (nostdinc)
	    compopts[compoffs++] = "-nostdinc";
	else {
	    compopts[compoffs++] = "-stdinc";
	    compopts[compoffs++] = incdir;
	}
	if (!nostddef) {
	    p = strsave(PREDEFS);
	    /* need -Mnostddef switch */
	    for (;;) {
		char *q, c;
		while (*p != '-' && *p != '\0')
		    ++p;
		if (*p == '\0')
		    break;
		if (p[1] != 'D')
		    break;
		q = p;
		while (*q != ' ' && *q)
		    ++q;
		c = *q;
		*q = 0;
		compopts[compoffs++] = "-def";
		compopts[compoffs++] = p+2;
		if (c == 0)
		    break;
		p = q+1;
	    }
	    /* similar code for PREPREDS; need accpp changes */
	}
#endif
	if (ieee) {
	    compopts[compoffs++] = "-ieee";
	    compopts[compoffs++] = "1";
	}
	if (debug) {
	    compopts[compoffs++] = "-debug";
	}
	if (profile)
	    compopts[compoffs++] = "-profile";
	sprintf(buff, "%d", optlvl);
	compopts[compoffs++] = "-opt";
	compopts[compoffs++] = strsave(buff);
    }

    for (i = 0; i < ncargs; ++i)
	compopts[compoffs++] = cargs[i];


    onecfile = 0;
    for (i = 0; cfiles[i]; ++i) {
	int j;

	if (run860&RUN860_COMP) j = 2;
	else j = 1;
	p = suffix(cfiles[i]);
	if (!p)
	    continue;
	if (strcmp(p, fsuffix) != 0 &&
	    strcmp(p, ".s") != 0)
	    continue;
	if (printprompt)
	    printf("%s:\n", cfiles[i]);
	if (strcmp(p, fsuffix) == 0) {
	    ++onecfile;
	    if (pflag) {
		compopts[compoffs] = "-es";
		mkname(basename(cfiles[i]), p+1, ".i");
		compopts[compoffs+1] = strsave(fname);
		compopts[j] = cfiles[i];
		compopts[compoffs+2] = 0;
		compile(asoffs, 0);
	    }
	    else if (asonly) {
		compopts[j] = cfiles[i];
		compopts[compoffs] = "-asm";
		compopts[compoffs+1] = 0;
		compile(asoffs, 0);
	    }
	    else {
		compopts[j] = cfiles[i];
		compopts[compoffs] = "-asm";
		compopts[compoffs+1] = temp_name;
		compopts[compoffs+2] = 0;
		compile(asoffs, temp_name);
	    }
	}
	else if (strcmp(p, ".s") == 0) {
	    if (pflag || eflag)
		continue;
	    if (asonly)
		continue;
	    asopts[asoffs] = "-o";
	    mkname(cfiles[i], p+1, ".o");
	    asopts[asoffs+1] = strsave(fname);
	    asopts[asoffs+2] = cfiles[i];
	    asopts[asoffs+3] = 0;
	    assemble();
	}
    }
    if (status == 0 && !nolink && !pflag && !eflag && !asonly && nldfiles) {
	printf("Linking:\n");
	dolink();
    }
    exit(status);
}

dolink()
{
    int i;
    int ldoffs;
    char *p;

    /* set up linker stuff */
    if (run860 & RUN860_LD) {
	ldopts[0] = RUN860;
	ldopts[1] = linker;
	ldoffs = 2;
    }
    else {
	ldopts[0] = linker;
	ldoffs = 1;
    }
    if (outfile) {
	ldopts[ldoffs++] = "-o";
	ldopts[ldoffs++] = outfile;
    }
    /* pick out startup options */
    if (!nostartup) {
	if (astype == AS_ELF) {
	    p = ELF_LD_STARTUP;
	}
	else {
	    p = COFF_LD_STARTUP;
	}
	while (*p != 0) {
	    char *beg;
	    char c;

	    beg = p;
	    while (*p != ' ' && *p != '\0')
		++p;
	    c = *p;
	    *p = 0;
	    strcpy(fname, startupdir);
	    strcat(fname, DIRCHAR);
	    strcat(fname, beg);
	    *p = c;
	    ldopts[ldoffs++] = strsave(fname);
	    if (c == 0)
		break;
	    while (*p == ' ') ++p;
	    if (*p == '\0') break;
	}
#ifdef PGFTN
	if (astype == AS_COFF)
	    strcpy(fname, mkdirname(COFF_PGI_LDIR));
	else
	    strcpy(fname, mkdirname(ELF_PGI_LDIR));
#ifdef MSDOS
	strcat(fname, "\\pgfmain.o");
#else
	strcat(fname, "/pgfmain.o");
#endif
	ldopts[ldoffs++] = strsave(fname);
#endif
	if (astype == AS_ELF) {
	    /* ATT Kludge */
	    strcpy(fname, startupdir);
	    strcat(fname, DIRCHAR);
	    strcat(fname, "values-Xa.");
	    ldopts[ldoffs++] = strsave(fname);
	}
    }

#ifdef COFF_PROF_LIB
    if (profile)
        ldopts[ldoffs++] = COFF_PROF_LIB;
#endif

    for (i = 0; i < nldargs; ++i)
	ldopts[ldoffs++] = ldargs[i];
    nufiles = 0;
    for (i = 0; i < nldfiles; ++i) {
	if (ldfiles[i][0] != '-') {
	    ldopts[ldoffs++] = ldfiles[i];
	    ++nufiles;
	    ufilename = ldfiles[i];
	}
	else if (ldfiles[i][1] == 'Y') {
	    if (astype == AS_COFF) {
#if COFF_LD_LOPT
		ldopts[ldoffs++] = ldfiles[i];
#endif
	    }
	    else {
#if ELF_LD_LOPT
		ldopts[ldoffs++] = ldfiles[i];
#endif
	    }
	}
	else if (ldfiles[i][1] == 'L') {
	    if (astype == AS_COFF) {
#if COFF_LD_LOPT
		ldopts[ldoffs++] = ldfiles[i];
#endif
	    }
	    else {
#if ELF_LD_LOPT
		ldopts[ldoffs++] = ldfiles[i];
#endif
	    }
	}
	else if (ldfiles[i][1] != 'l') {
	    ++nufiles;
	    ufilename = ldfiles[i];
	    ldopts[ldoffs++] = ldfiles[i];
	}
	else {
	    if (astype == AS_COFF) {
#if COFF_LD_LOPT
		ldopts[ldoffs++] = ldfiles[i];
#else
		if (libdir)
		    strcpy(fname, libdir);
		else
		    strcpy(fname, deflibdir);
#ifdef MSDOS
		strcat(fname, "\\lib");
#else
		strcat(fname, "/lib");
#endif
		fname[MAXFNAME] = 0;
		strncat(fname, ldfiles[i]+2, MAXFNAME);
		strcat(fname, ".a");
		ldopts[ldoffs++] = strsave(fname);
#endif
	    }
	    else {
#if ELF_LD_LOPT
		ldopts[ldoffs++] = ldfiles[i];
#else
		if (libdir)
		    strcpy(fname, libdir);
		else
		    strcpy(fname, deflibdir);
#ifdef MSDOS
		strcat(fname, "\\lib");
#else
		strcat(fname, "/lib");
#endif
		fname[MAXFNAME] = 0;
		strncat(fname, ldfiles[i]+2, MAXFNAME);
		strcat(fname, ".a");
		ldopts[ldoffs++] = strsave(fname);
#endif
	    }
	}
    }
    if (!nostdlib) {
#ifdef PGFTN
	if (astype == AS_COFF)
	    strcpy(fname, mkdirname(COFF_PGI_LDIR));
	else
	    strcpy(fname, mkdirname(ELF_PGI_LDIR));
#ifdef MSDOS
	strcat(fname, "\\pgftnrtl.a");
#else
	strcat(fname, "/pgftnrtl.a");
#endif
	ldopts[ldoffs++] = strsave(fname);
	if (astype == AS_ELF)
	    ldopts[ldoffs++] = "-lm";
	else {
#if COFF_LD_LOPT
	    ldopts[ldoffs++] = "-lm";
#else
	    strcpy(fname, libdir);
#ifdef MSDOS
	    strcat(fname, "\\libm.a");
#else
	    strcat(fname, "/libm.a");
#endif
	    ldopts[ldoffs++] = strsave(fname);
#endif
	}
#endif

	if (astype == AS_ELF) {
	    ldopts[ldoffs++] = "-lc";
	    strcpy(fname, mkdirname(ELF_PGI_LDIR));
	    strcat(fname, "/pgclib.a");
	    ldopts[ldoffs++] = strsave(fname);
	}
	else {
#if COFF_LD_LOPT
	    ldopts[ldoffs++] = "-lc";
#else
	    strcpy(fname, libdir);
#ifdef MSDOS
	    strcat(fname, "\\libc.a");
#else
	    strcat(fname, "/libc.a");
#endif
	    ldopts[ldoffs++] = strsave(fname);
#endif
	    strcpy(fname, mkdirname(COFF_PGI_LDIR));
#ifdef MSDOS
	    strcat(fname, "\\pgclib.a");
#else
	    strcat(fname, "/pgclib.a");
#endif
	    ldopts[ldoffs++] = strsave(fname);
	}
    }
    if (!nostartup) {
	if (astype == AS_ELF) {
	    p = ELF_LD_ENDUP;
	}
	else {
	    p = COFF_LD_ENDUP;
	}
	while (*p != 0) {
	    char *beg;
	    char c;

	    beg = p;
	    while (*p != ' ' && *p != '\0')
		++p;
	    c = *p;
	    *p = 0;
	    strcpy(fname, startupdir);
	    strcat(fname, DIRCHAR);
	    strcat(fname, beg);
	    *p = c;
	    ldopts[ldoffs++] = strsave(fname);
	    if (c == 0)
		break;
	    beg = p;
	    if (*beg == '\0') break;
	}
    }

    if (verbose) {
	for (i = 0; i < ldoffs; ++i)
	    printf("%s ", ldopts[i]);
	printf("\n");
    }
    if ((i = do_exec(ldopts)) != 0) {
	status = i;
	return;
    }
    /* if only 1 file linked then delete the object */
    if (nufiles == 1 && onecfile == 1) {
	if (verbose)
	    printf("Unlinking %s\n", ufilename);
	unlink(ufilename);
    }
}

compile(aso, asfile)
int aso;
char *asfile;
{
    int i;
    char *p, *q;
#ifdef MSDOS
    static char *movcmd[4] = {"RENAME"};
#else
    static char *movcmd[4] = {"/bin/mv"};
#endif

    if (verbose) {
	i = 0;
	while (compopts[i]) {
	    printf("%s ", compopts[i]);
	    ++i;
	}
	printf("\n");
    }
    i = do_exec(compopts);
    if (i != 0) status = i;
    if (pflag || eflag || asonly)
	return;
    if (i != 0) {
	/* delete asm file */
	if (verbose)
	    printf("Unlinking %s\n", temp_name);
	unlink(temp_name);
	return;
    }
    if (run860&RUN860_COMP)
	q = basename(compopts[2]);
    else
	q = basename(compopts[1]);
    p = suffix(q);
    mkname(q, p+1, ".o");
    asopts[aso] = "-o";
    asopts[aso+1] = fname;
    asopts[aso+2] = asfile;
    asopts[aso+3] = 0;
    assemble();
    if (keepasm) {
	movcmd[1] = asfile;
	mkname(q, p+1, ".s");
	movcmd[2] = fname;
	if (verbose) {
	    printf("%s %s %s\n", movcmd[0], movcmd[1], movcmd[2]);
	}
	do_exec(movcmd);
    }
    else {
	if (verbose)
	    printf("Unlinking %s\n", asfile);
	unlink(asfile);
    }
}

assemble()
{
    int i;

    if (verbose) {
	i = 0;
	while (asopts[i]) {
	    printf("%s ", asopts[i]);
	    ++i;
	}
	printf("\n");
    }
    i = do_exec(asopts);
    if (i != 0) status = i;
}


char *
suffix(s)
char *s;
{
    char *p;

    for (p = s + strlen(s); p > s; --p)
	if (*p == '.')
	    break;
    if (p == s) return 0;
    return p;
}

char *
strsave(s)
char *s;
{
    int i;
    char *p;

    i = strlen(s) + 1;
    if ((p = malloc(i)) == 0) {
	fprintf(stderr, "%s: out of memory\n", toolname);
	exit(127);
    }
    strcpy(p, s);
    return p;
}

add_arg(list, arg)
char **list;
char *arg;
{
    int i;

    for (i = 0; i < NARGS; ++i)
	if (list[i] == 0)
	    goto found;
    fprintf(stderr, "%s: too many files\n", toolname);
    exit(127);
found:
    list[i] = strsave(arg);
}

process_mopt(s)
char *s;
{
    char *p;
/*
 * PGI options:
 *	-Mcoff
 *	-Melf
 *	-Mnostdinc
 *	-Mnostdlib
 *	-Mnostddef
 *	-Mnostartup
 *	-Mvect=name[=value][,...]
 *	-Minline=n
 *	-Mrun860=[a|0|l|ALL]
 */
    if (strcmp(s, "coff") == 0)
	astype = AS_COFF;
    else if (strcmp(s, "elf") == 0)
	astype = AS_ELF;
    else if (strcmp(s, "nostdinc") == 0)
	nostdinc = 1;
    else if (strcmp(s, "nostdlib") == 0)
	nostdlib = 1;
    else if (strcmp(s, "nostddef") == 0)
	nostddef = 1;
    else if (strcmp(s, "nostartup") == 0)
	nostartup = 1;
    else if (strcmp(s, "keepasm") == 0)
	keepasm = 1;
    else if (strncmp(s, "run860", strlen("run860")) == 0) {
	p = strchr(s, '=');
	if (p == NULL) {
	usage:
	    fprintf(stderr, "%s: -Mrun860 usage: -Mrun860=[a|0|l]\n",
		toolname);
	    exit(1);
	}
	++p;
	switch (*p) {
	case 'A':
	    run860 |= RUN860_AS | RUN860_COMP | RUN860_LD;
	    fprintf(stderr, "%s: running all tools on i860\n", toolname);
	    break;
	case 'a':
	    run860 |= RUN860_AS;
	    fprintf(stderr, "%s: running assembler on i860\n", toolname);
	    break;
	case '0':
	    run860 |= RUN860_COMP;
	    fprintf(stderr, "%s: running compiler on i860\n", toolname);
	    break;
	case 'l':
	    run860 |= RUN860_LD;
	    fprintf(stderr, "%s: running linker on i860\n", toolname);
	    break;
	default:
	    goto usage;
	}
    }
    else if (strncmp(s, "vect", strlen("vect")) == 0) {
	printf("vect opt %s\n", s);
    }
    else if (strncmp(s, "inline", strlen("inline")) == 0) {
	printf("inline opt %s\n", s);
    }
    else {
	fprintf(stderr, "%s: Illegal option to -M: %s\n", toolname, s);
	exit(1);
    }
}

process_wopt(s)
char *s;
{
    char *p, *q, c;

    p = s;
    if (p[1] != ',' || p[2] == 0) {
	fprintf(stderr, "%s: Illegal option to -W: %s\n", toolname, s);
	exit(1);
    }
    p += 2;
    switch (s[0]) {
    case '0':
	while (*p) {
	    for (q = p; *q != ',' && *q; ++q)
		;
	    c = *q;
	    *q = 0;
	    if (*p == '-')
		switch (p[1]) {
		case 'f':
		case 'F':
		    fprintf(stderr,
			 "%s: Compiler option -%c ignored\n",
			 toolname,
			 p[1]);
		    break;
		case 'g':
		    debug = 1;
		    break;
		case 'p':
		    profile = 1;
		    break;
		default:
		    add_arg(cargs, p);
		    break;
		}
	    else {
		add_arg(cargs, p);
	    }
	    *q = c;
	    p = q;
	    if (c == ',') ++p;
	}
	break;
    case 'a':
	while (*p) {
	    for (q = p; *q != ',' && *q; ++q)
		;
	    c = *q;
	    *q = 0;
	    add_arg(asargs, p);
	    *q = c;
	    p = q;
	    if (c == ',') ++p;
	}
	break;
    case 'l':
	while (*p) {
	    for (q = p; *q != ',' && *q; ++q)
		;
	    c = *q;
	    *q = 0;
	    add_arg(ldargs, p);
	    *q = c;
	    p = q;
	    if (c == ',') ++p;
	}
	break;
    default:
	fprintf(stderr, "Illegal option to -W: %s\n", toolname, s);
	exit(1);
    }
}

process_def(s)
char *s;
{
    add_arg(cargs, "-def");
    add_arg(cargs, s);
}
process_idir(s)
char *s;
{
    add_arg(cargs, "-idir");
    add_arg(cargs, s);
}
process_undef(s)
char *s;
{
    add_arg(cargs, "-undef");
    add_arg(cargs, s);
}
process_lib(s)
char *s;
{
    /* we'll change these later */
    sprintf(fname, "-l%s", s);
    add_arg(ldfiles, fname);
}
process_yopt(s)
char *s;
{
    char *q, c;
    q = s;
    if (q[1] != ',' || q[2] == 0) {
	fprintf(stderr, "%s: Illegal option to -Y: %s\n", toolname, s);
	exit(1);
    }
    q += 2;
    switch (s[0]) {
    case '0':
	/* alternate compiler directory */
	compdir = strsave(q);
	break;
    case 'a':
	/* alternate assembler directory */
	asdir = strsave(q);
	break;
    case 'l':
	/* alternate linker directory */
	lddir = strsave(q);
	break;
    case 'S':	/* crt0 area */
	startupdir = strsave(q);
	break;
    case 'L':	/* linker library area */
	libdir = strsave(q);
    case 'U':	/* linker library area */
	strcpy(fname, "-Y");
	strcat(fname, s);
	add_arg(ldfiles, strsave(fname));
	break;
    case 'I':	/* include directory */
	incdir = strsave(q);
	break;
    default:
	fprintf(stderr, "%s: %s option to -Y ignored\n", toolname,
		s);
	break;
    }
}

process_file(s)
char *s;
{
    char *p;
    char *q, *r;

    p = suffix(s);
    if (p == 0) {
unk:
	fprintf(stderr,
	    "%s: file with unknown suffix passed to linker: %s\n",
	    toolname,
	    s);
	add_arg(ldfiles, s);
	return;
    }
    ++p;
    if (strcmp(p, fsuffix+1) == 0) {
	add_arg(cfiles, s);
	q = basename(s);
	p = suffix(q);
	mkname(q, p+1, ".o");
	add_arg(ldfiles, fname);
	++printprompt;
    }
    else if (strcmp(p, "s") == 0) {
	add_arg(cfiles, s);
	q = basename(s);
	p = suffix(q);
	mkname(q, p+1, ".o");
	add_arg(ldfiles, fname);
	++printprompt;
    }
    else if (strcmp(p, "o") == 0)
	add_arg(ldfiles, s);
    else if (strcmp(p, "a") == 0)
	add_arg(ldfiles, s);
    else
	goto unk;
}

add_linkopt(c)
int c;
{
    char buf[4];

    buf[0] = '-';
    buf[1] = c;
    buf[2] = 0;
    add_arg(ldargs, buf);
}

mkname(s, suf, newsuf)
char *s;
char *suf;
char *newsuf;
{
    int i;

    i = suf - s - 1;
    if (i > MAXFNAME) i = MAXFNAME;
    fname[MAXFNAME] = 0;
    strncpy(fname, s, i);
    fname[i] = 0;
    strcat(fname, newsuf);
}

char *
basename(s)
char *s;
{
    char *p;

    for (p = s + strlen(s); *p != DIRCHARC && p > s; --p)
	;
    if (*p == DIRCHARC)
	return p+1;
    return s;
}
#ifdef MSDOS
do_exec(options)
char **options;
{
	int len;
	char **p, *t, *s, *p1, *malloc();;

	for(p = options+1, len = 0; *p; p++)
		len += strlen(*p)+1;
	len += strlen("PGCARG=");
	if((s = malloc(len)) == NULL){
		perror("Can't malloc memory for arglist");
		return(-1);
	}
	strcpy(s, "PGCARG=");
	for(t = s; *t; t++)
		;
	for(p = options+1; *p; p++){
		for(p1 = *p; *p1; p1++)
			*t++ = *p1;
		*t++ = ' ';
	}
	*--t = '\0';
	if(putenv(s))
		fprintf(stderr, "Environment is too small(?)\n");
	return(spawnl(P_WAIT, RUN860, "run860", 0));
}
#else
#ifdef sun
#define VFORK() vfork()
#else
#define VFORK() fork()
#endif

do_exec(options)
char **options;
{
    int pid, x, i;

    if ((pid = VFORK()) == -1) {
	fprintf(stderr, "%s: can't fork\n", toolname);
	exit(127);
    }
    if (pid == 0) {
	execv(options[0], options);
	fprintf(stderr, "%s: Can't exec %s\n", toolname, options[0]);
	exit(127);
    }
    for (;;) {
	i = wait(&x);
	if (i == -1) {
	    fprintf(stderr, "%s: wait failed with -1\n", toolname);
	    exit(127);
	}
	if (i == pid)
	    break;
	fprintf(stderr, "%s: unknown child process\n", toolname);
	exit(127);
    }
    if ((x & 0xff) == 0x7f) {
	/* child stopped */
	fprintf(stderr, "%s: child %d stopped\n", toolname, pid);
	exit(127);
    }
    if ((x & 0xff) == 0) {
	/* child terminated due to exit call */
	if ((x & 0xff00) != 0)
	    return((x & 0xff00) >> 8);
    }
    else if ((x & 0xff00) == 0) {
	/* child terminated due to signal */
	fprintf(stderr, "%s: child %d caught signal\n", toolname, pid);
	exit(127);
    }
    return 0;
}
#endif
char *
mkdirname(suffix)
char *suffix;
{
    char *getenv(), *p;

    if (*suffix == DIRCHARC)
	return strsave(suffix);
    else if ((p = getenv("PGI")) != NULL) {
	strcpy(fname, p);
	strcat(fname, DIRCHAR);
	strcat(fname, suffix);
	return strsave(fname);

    }
    else {
	strcpy(fname, PGI);
	strcat(fname, DIRCHAR);
	strcat(fname, suffix);
	return strsave(fname);
    }
}

