
#include <stdio.h>
#include "vgalib/vga.h"

short xa[1300], ya[1030];

main(argc, argv)
char **argv;
{
	register int i, j, k, ns, dist, x, y, c, nl;

	ns = 100;
	nl = 106;
	while(--argc > 0){
		argv++;
		if(**argv != '-')
			break;
		switch((int)(argv[0][1])){
		case 'l':
			if(argc > 1){
				argv++;
				argc--;
				nl = atoi(*argv);
			}
			break;
		case 'n':
			if(argc > 1){
				argv++;
				argc--;
				ns = atoi(*argv);
			}
			break;

		default:
			fprintf(stderr, "Usage: sweep [-l lines] [-n nsweeps]\n");
			exit(1);
		}
	}


	if(nl > 1024 || nl < 0)
		nl = 16;

	dist = 1024/nl;
	for(i = 0, j = 0; j < 320; j += dist, i++){
		xa[i] = j;
		if(j < 200)
			ya[i] = j;
	}
	
	if(vga_init()){
		fprintf(stderr, "sweep: Standard input is not from a VGA\n");
		exit(2);
	}
	vga_clear_screen();

	/* i has number of x's, nl has number of y's */
	nl = 1024/dist;
	while(ns-- > 0){
		x = (rand() % 300) + 10;
		y = (rand() % 180) + 10;
		c = (rand()%252) + 2;
		vga_color(c);
		/* Do the x's */
		for(k = 0; k < i; k++){
			vga_move(x, y);
			vga_line(xa[k], 0);
		}
		for(k = 0; k < nl; k++){
			vga_move(x, y);
			vga_line(319, ya[k]);
		}
		for(k = i-1; k >= 0; k--){
			vga_move(x, y);
			vga_line(xa[k], 199);
		}
		for(k = nl-1; k >= 0; k--){
			vga_move(x, y);
			vga_line(0, ya[k]);
		}
	}
	vga_term();
	exit(0);
}
