@echo off
cls

for %%x IN ( DIAGS ATA EASYTERM ) DO if NOT EXIST %%x\install.bat goto bad_src

if "%1" == "" goto usage
if NOT "%3" == "" goto usage

for %%x IN ( DIAGS ATA EASYTERM PRODTEST ) DO if "%%x" == "%1" goto good_prod
for %%x IN ( diags ata easyterm prodtest ) DO if "%%x" == "%1" goto good_prod
goto bad_prod

:good_prod

if NOT EXIST \bin\itool.exe goto bad_src
if "%2" == "" goto default_case

\bin\itool -d %2\.
if errorlevel 1 md %2
\bin\itool -d %2\.
if errorlevel 1 goto bad_dir

\bin\itool -d %2\stallion
if errorlevel 1 md %2\stallion
\bin\itool -d %2\stallion
if errorlevel 1 goto bad_dir

cd \%1
install.bat %2\stallion
goto end

:default_case
\bin\itool -d c:\stallion
if errorlevel 1 md c:\stallion
\bin\itool -d c:\stallion
if errorlevel 1 goto bad_dir
cd \%1
install.bat c:\stallion

:usage
echo.
echo. Usage: INSTALL product [target]
echo.   where:
echo.    product = one of: DIAGS ATA EASYTERM or PRODTEST
echo.    target  = optional drive/path to install onto, the default is
echo.              C:\STALLION, (this is ignored by PRODTEST which will
echo.              be installed onto C:\STALLION ).
echo.
goto end

:bad_dir
echo.
echo.
echo. ERROR: The target "%2" is an invalid path, or an installation error
echo.        occurred.
echo.
goto end

:bad_prod
echo.
echo.
echo. ERROR: There is no "%1" product on this multiport diskette.
echo.
goto usage

:no_install
echo.
echo.
echo. ERROR: The "%1" product cannot be installed using INSTALL.
echo.        Refer to the %1 manual pages for more information.
echo.
goto end

:bad_src
echo.
echo.
echo. ERROR: Please ensure that the current drive is the drive containing
echo.      the installation floppy before executing INSTALL. Type A: or 
echo.      B: to select the appropriate floppy drive.
echo.
goto end

:end
