				REM TESTLIST.BAT
				
REM test list used at several stations

REM check station id
if .%STATION_ID% == . goto chkpod
    nutl /station %STATION_ID%
    if errorlevel 1 goto fail

REM check for POD errors
:chkpod
    nutl /chkpod
    if errorlevel 1 goto fail

REM make sure correct hardware is present
    REM build file with expected configuration
	del %OPT_STATION_NAME%.exp
	echo cib y		>> %OPT_STATION_NAME%.exp
	echo cpr y		>> %OPT_STATION_NAME%.exp
	echo fdu 1 y 1.44mb	>> %OPT_STATION_NAME%.exp
	echo fdu 2 n		>> %OPT_STATION_NAME%.exp
	echo ftu y 40mb		>> %OPT_STATION_NAME%.exp
	echo hdu 1 y 30 esdi	>> %OPT_STATION_NAME%.exp
	echo hdu 2 n		>> %OPT_STATION_NAME%.exp
	echo kbd y loopback	>> %OPT_STATION_NAME%.exp
	echo man y		>> %OPT_STATION_NAME%.exp
	echo mem y 4mb		>> %OPT_STATION_NAME%.exp
	echo mou n		>> %OPT_STATION_NAME%.exp
	echo par 1 y		>> %OPT_STATION_NAME%.exp
	echo par 2 n		>> %OPT_STATION_NAME%.exp
	echo par 3 n		>> %OPT_STATION_NAME%.exp
	echo ser 1 y		>> %OPT_STATION_NAME%.exp
	echo ser 2 n		>> %OPT_STATION_NAME%.exp
	echo vid y 		>> %OPT_STATION_NAME%.exp
	echo wei n 		>> %OPT_STATION_NAME%.exp
    REM build file with actual configuration
	del %OPT_STATION_NAME%.act
	cib_dia /c		>> %OPT_STATION_NAME%.act
	cpr_dia /c		>> %OPT_STATION_NAME%.act
	fdu_dia /c		>> %OPT_STATION_NAME%.act
	ftu_dia /c		>> %OPT_STATION_NAME%.act
	hdu_dia /c		>> %OPT_STATION_NAME%.act
	kbd_dia /c		>> %OPT_STATION_NAME%.act
	man_dia /c		>> %OPT_STATION_NAME%.act
	mem_dia /c		>> %OPT_STATION_NAME%.act
	mou_dia /c		>> %OPT_STATION_NAME%.act
	par_dia /c		>> %OPT_STATION_NAME%.act
	ser_dia /c		>> %OPT_STATION_NAME%.act
	vid_dia /c		>> %OPT_STATION_NAME%.act
	wei_dia /c		>> %OPT_STATION_NAME%.act
    REM compare expected configuration with actual configuration
	nutl /cfgcmp %OPT_STATION_NAME%.exp %OPT_STATION_NAME%.act
	if errorlevel 1 goto fail

:test_loop

REM test CPR
    REM select subtests
        set CPR_SUBTEST_FUNCTION=Y
        set CPR_SUBTEST_MATH=Y
        set CPR_SUBTEST_INTERRUPT=Y
    REM set test parameters
	set CPR_PARAM_TEST_CYCLES=1
    REM run test
	cpr_dia /n
	if errorlevel 1 goto fail
	
REM test MAN
    REM select subtests
	set MAN_SUBTEST_CPU=Y
	set MAN_SUBTEST_ROM=Y
	set MAN_SUBTEST_PIC=Y
	set MAN_SUBTEST_WATCHDOG=Y
	set MAN_SUBTEST_TIMER=Y
	set MAN_SUBTEST_DMA=Y
	set MAN_SUBTEST_REFRESH=Y
	set MAN_SUBTEST_CMOS=Y
	set MAN_SUBTEST_CLOCKCAL=Y
	set MAN_SUBTEST_CMOS=Y
	set MAN_SUBTEST_PORTS=Y
	set MAN_SUBTEST_SPEAKER=Y
	set MAN_SUBTEST_CACHE=Y
    REM set test parameters
	set MAN_PARAM_TEST_CYCLES=1
    REM run test
	man_dia /n
	if errorlevel 1 goto fail
	
REM test VID
    REM select subtests
	set VID_SUBTEST_DAC=Y
	set VID_SUBTEST_SEQ=Y
	set VID_SUBTEST_GRAPH_REG=Y
	set VID_SUBTEST_ATTR_REG=Y
	set VID_SUBTEST_GEN_REG=Y
	set VID_SUBTEST_CRT=Y
	set VID_SUBTEST_XREGS=Y
	set VID_SUBTEST_VRAM=Y
	set VID_SUBTEST_INTERRUPT=Y
	set VID_SUBTEST_MODE=N
	set VID_SUBTEST_FONT=N
	set VID_SUBTEST_ATTRIBUTE=N
	set VID_SUBTEST_COLOR=N
	set VID_SUBTEST_PATTERN=N
    REM set test parameters
	set VID_PARAM_TEST_CYCLES=1
    REM run test
	vid_dia /n
	if errorlevel 1 goto fail
	
REM all tests have passed
    REM checkpoint pass
        nutl /chkpt /p %CHECKPOINT_FILE%
    REM if count is not 0, then continue testing
        if errorlevel 1 goto test_loop
    REM display status
        nutl /status ALL PASS
        goto end
    
REM an error occurred
:fail
    REM checkpoint fail
    nutl /chkpt /f %CHECKPOINT_FILE%

REM all done
:end
