@ECHO OFF
REM
REM FIXWIN95.BAT -- Removes obsolete INF files from a Windows 9X installation
REM                 in order to ease installation of IBM Token-Ring ISA/PCMCIA
REM                 Token Ring adapters.
REM
REM Version: 1.2 (9/25/98 10:26:06)
REM
REM (c) 1995-1998 IBM Corporation. All rights reserved.
REM 
REM ==========================================================================

REM 
REM Print some prolog information
REM

ECHO.
ECHO This batch file will prepare your Windows 95 or Windows 98 system to 
ECHO receive the latest Token Ring drivers. It must be run before the
ECHO IBM Token Ring network adapter has been physically installed into
ECHO the computer.  
ECHO.
ECHO The IBM Token-Ring device drivers that ship with Windows 95 and Windows 98
ECHO are out of date, and will not allow you to take advantage of the 
ECHO latest features and fixes available in the latest drivers.
ECHO.
ECHO You may abort this batch file by pressing ^C (Control-C) now.
ECHO.
PAUSE
ECHO.

REM
REM Get the name of the WINDOWS directory
REM
ECHO Getting WINDIR environment variable...
IF "%WINDIR%"=="" GOTO NOWINDIR

REM 
REM Rename all NETIBM*.INF files to NETIBM*.ORG
REM

ECHO Looking for Microsoft Windows 95 IBM Token Ring INF files...

IF EXIST %WINDIR%\INF\NETIBMCC.ORG GOTO NEXT1
IF EXIST %WINDIR%\INF\NETIBMCC.INF GOTO DELCC

:NEXT1
IF EXIST %WINDIR%\INF\NETIBM.ORG   GOTO NEXT2
IF EXIST %WINDIR%\INF\NETIBM.INF   GOTO DELFS

ECHO.
ECHO Looking for any residual IBM-written INFs...

:NEXT2
IF EXIST %WINDIR%\INF\NETIBMC4.ORG GOTO NEXT3
IF EXIST %WINDIR%\INF\NETIBMC4.INF GOTO DELC4

:NEXT3
IF EXIST %WINDIR%\INF\NETIBM4.ORG GOTO NEXT4
IF EXIST %WINDIR%\INF\NETIBM4.INF GOTO DEL4

ECHO.
ECHO Looking for any backup copies of the INF in the "Other" directory...

:NEXT4
IF EXIST %WINDIR%\INF\OTHER\IBMNETIBM.INF GOTO DELOTHER

GOTO REMBIN

:REMBIN
REM
REM Remove adapter definition databases to force regeneration...
REM

ECHO.
ECHO Removing driver database (DRV*.BIN) from %WINDIR%\INF directory...
IF EXIST %WINDIR%\INF\DRVDATA.BIN DEL %WINDIR%\INF\DRVDATA.BIN
IF EXIST %WINDIR%\INF\DRVIDX.BIN  DEL %WINDIR%\INF\DRVIDX.BIN

GOTO OKEND

:NOWINDIR
ECHO Fatal error: The WINDIR environment variable could not be found.
ECHO Be sure to run this batch file using a Windows 95 command prompt.
GOTO ABEND

:DELCC
REN  %WINDIR%\INF\NETIBMCC.INF NETIBMCC.ORG
ECHO %WINDIR%\INF\NETIBMCC.INF renamed to %WINDIR%\INF\NETIBMCC.ORG...
GOTO NEXT1

:DELFS
REN  %WINDIR%\INF\NETIBM.INF NETIBM.ORG
ECHO %WINDIR%\INF\NETIBM.INF renamed to %WINDIR%\INF\NETIBM.ORG...
GOTO NEXT2

:DELC4
REN  %WINDIR%\INF\NETIBMC4.INF NETIBMC4.ORG
ECHO %WINDIR%\INF\NETIBMC4.INF renamed to %WINDIR%\INF\NETIBMC4.ORG...
GOTO NEXT3

:DEL4
REN  %WINDIR%\INF\NETIBM4.INF NETIBM4.ORG
ECHO %WINDIR%\INF\NETIBM4.INF renamed to %WINDIR%\INF\NETIBM4.ORG...
GOTO NEXT4

:DELOTHER
DEL %WINDIR%\INF\OTHER\IBMNET*.INF
ECHO Deleted IBMNETIBM.INF from the backup INF directory on Win98...
GOTO REMBIN


:ABEND
ECHO.
ECHO FIXWIN95 aborted.
ECHO.
GOTO END

:OKEND

ECHO.
ECHO FIXWIN95 completed.  
ECHO.
ECHO Your Windows system is now ready to accept the latest Token Ring 
ECHO device drivers.  

:END
