/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/**************************************************************************
**  Copyright (C) 1998-1999, Hewlett-Packard Co. All rights reserved.
**
**  File name:  acpi_cmd.h
**  Summary:    IMB ACPI Command Definitions
**
**************************************************************************/

#ifndef _ACPI_CMD_H_
#define _ACPI_CMD_H_

#include	"imb_std.h"	/* IMB OS-Dependent Standard Types */
#include	"imb_cmd.h"	/* IMB Common Command Definitions */

/* Application NetFn (IMB_NF_APP_) Global Commands */
#define ACPI_SET_ACPI_MODE			0x80
#define ACPI_SET_LEGACY_MODE			0x81
#define ACPI_GET_POWER_CONTROL_CONFIG_MODE	0x82
#define ACPI_ENTER_SLEEP_MODE			0x83
#define ACPI_EXIT_SLEEP_MODE			0x84

/* ACPI_SET_ACPI_MODE */
typedef void ACPI_Q_SET_ACPI_MODE;

typedef struct AcpiSSetAcpiMode {
    UINT8   completionCode;	/* IMB_CC_ */
} ACPI_S_SET_ACPI_MODE;


/* ACPI_SET_LEGACY_MODE */
typedef void ACPI_Q_SET_LEGACY_MODE;

typedef struct AcpiSSetLegacyMode {
    UINT8   completionCode;	/* IMB_CC_ */
} ACPI_S_SET_LEGACY_MODE;


/* ACPI_GET_POWER_CONTROL_CONFIG_MODE */
typedef void ACPI_Q_GET_POWER_CONTROL_CONFIG_MODE;

typedef struct AcpiSGetPowerControlConfigMode {
    UINT8   completionCode;	/* IMB_CC_ */
    UINT8   acpiMode:1;		/* vs. Legacy Mode */
    UINT8   reserved:7;
} ACPI_S_GET_POWER_CONTROL_CONFIG_MODE;


/* ACPI_ENTER_SLEEP_MODE */
typedef void ACPI_Q_ENTER_SLEEP_MODE;

typedef struct AcpiSEnterSleepMode {
    UINT8   completionCode;	/* IMB_CC_ */
} ACPI_S_ENTER_SLEEP_MODE;


/* ACPI_EXIT_SLEEP_MODE */
typedef void ACPI_Q_EXIT_SLEEP_MODE;

typedef struct AcpiSExitSleepMode {
    UINT8   completionCode;	/* IMB_CC_ */
} ACPI_S_EXIT_SLEEP_MODE;

#endif	/* _ACPI_CMD_H_ */
