/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/**************************************************************************
**  Copyright (C) 1997-1999, Hewlett-Packard Co. All rights reserved.
**
**  File name:  hs_cmd.h
**  Summary:    HS Command Definitions
**
**************************************************************************/

#ifndef _HS_CMD_H_
#define _HS_CMD_H_

#include	"imb_std.h"	/* IMB OS-Dependent Standard Types */
#include	"imb_cmd.h"	/* IMB Common Command Definitions */


/* HS Application NetFn (IMB_NF_APP_) Commands */
#define HS_CHECK_BACKPLANE_STATUS	0x10
#define HS_READ_SCSI_BUS_TYPE		0x11
#define HS_READ_DISK_CAGE_TEMP		0x12
#define HS_SET_WARNING_TEMP		0x13
#define HS_GET_WARNING_TEMP		0x14
#define HS_SET_ALERT_TEMP		0x15
#define HS_GET_ALERT_TEMP		0x16
#define HS_DRIVE_PRESENCE		0x1F
#define HS_GET_LEDS			0x23
#define HS_SET_LED			0x24
#define HS_GET_SCSI_ID			0x27
#define HS_SET_SCSI_ID			0x29
#define HS_CLEAR_DRIVE_ACTIVITY		0x2b
#define HS_GET_DRIVE_ACTIVITY		0x2d

/* HS Storage NetFn (IMB_NF_STORAGE_) FRU Commands */
#define HS_FRU_SELECT_FRU		0x13


/* HS_CHECK_BACKPLANE_STATUS */
/* HS_READ_SCSI_BUS_TYPE */
/* HS_READ_DISK_CAGE_TEMP */
/* HS_SET_WARNING_TEMP */
/* HS_GET_WARNING_TEMP */
/* HS_SET_ALERT_TEMP */
/* HS_GET_ALERT_TEMP */
/* HS_DRIVE_PRESENCE */

/* HS_SET_LED */
#define	HS_LED_OFF			0x00
#define	HS_LED_RED			0x01
#define	HS_LED_GREEN			0x02
#define	HS_LED_YELLOW			0x03
#define	HS_LED_RED_BLINK		0x11
#define	HS_LED_GREEN_BLINK		0x12
#define	HS_LED_YELLOW_BLINK		0x13
#define	HS_LED_PASSTHRU			0xFF

typedef struct HsQSetLed {
    UINT8   color;		/* HS_LED_ */
    UINT8   ledIndex;		/* 0..15 */
} HS_Q_SET_LED;

typedef struct HsSSetLed {
    UINT8   completionCode;	/* IMB_CC_ */
} HS_S_SET_LED;

/* HS_GET_LEDS */

typedef void HS_Q_GET_LEDS;

typedef struct HsSGetLeds {
    UINT8   completionCode;	/* IMB_CC_ */
    UINT8   color[16];
} HS_S_GET_LEDS;


/* HS_GET_SCSI_ID */
/* HS_SET_SCSI_ID */
/* HS_CLEAR_DRIVE_ACTIVITY */
/* HS_GET_DRIVE_ACTIVITY */

/* HS_FRU_SELECT_FRU */
#define	HS_FRU_MOTHERBOARD		0x00
#define	HS_FRU_BACKPLANE		0x01

typedef struct HsFruQSelectFru {
    UINT8   fru;
} HS_FRU_Q_SELECT_FRU;

typedef struct HsFruSSelectFru {
    UINT8   completionCode;	/* IMB_CC_ */
} HS_FRU_S_SELECT_FRU;

#endif  /* _HS_CMD_H_ */
