/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/**************************************************************************
**  Copyright (C) 1997-1999, Hewlett-Packard Co. All rights reserved.
**
**  File name:  sel_cmd.h
**  Summary:    IMB SEL Command Definitions
**
**  Description:
**
**************************************************************************/

#ifndef _SEL_CMD_H_
#define _SEL_CMD_H_

#include	"imb_std.h"	/* IMB OS-Dependent Standard Types */
#include	"imb_cmd.h"	/* IMB Common Command Definitions */

/* Storage NetFn (IMB_NF_STORAGE_) SEL Commands */
#define SEL_GET_SEL_INFO		0x40
#define SEL_GET_SEL_ALLOCATION_INFO	0x41
#define SEL_RESERVE_SEL			0x42
#define SEL_GET_SEL_ENTRY		0x43
#define SEL_ADD_SEL_ENTRY		0x44
#define SEL_PARTIAL_ADD_SEL_ENTRY	0x45
#define SEL_DELETE_SEL_ENTRY		0x46
#define SEL_CLEAR_SEL			0x47
#define SEL_GET_SEL_TIME		0x48
#define SEL_SET_SEL_TIME		0x49

/* common SEL data length */
#define SEL_DATA_LEN			16

/* special SEL (& SDR) recordId values (endian independent) */
#define RECORDID_FIRST 0x0000
#define RECORDID_LAST  0xFFFF

/* SEL_GET_SEL_INFO */
typedef void SEL_Q_GET_SEL_INFO;

/* SelSGetSelInfo.operationSupport bits */
#define	SEL_GSI_OS_OVERFLOW_FLAG		0x80	/* SEL full, events dropped */
						/* Commands supported: */
#define	SEL_GSI_OS_DELETE_CMD			0x08	/* SEL_DELETE_SEL_ENTRY	*/
#define SEL_GSI_OS_PARTIAL_ADD_CMD		0x04	/* SEL_PARTIAL_ADD_SEL_ENTRY */
#define SEL_GSI_OS_RESERVE_CMD			0x02	/* SEL_RESERVE_SEL */
#define SEL_GSI_OS_GET_ALLOCATION_INFO_CMD 	0x01	/* SEL_GET_SEL_ALLOCATION_INFO */

typedef struct SelSGetSelInfo {
    UINT8   completionCode;	/* IMB_CC_ */
    UINT8   selVersion;
    UINT16  recordCount;
    UINT16  freeSpace;
    UINT32  mostRecentAdditionTimestamp;
    UINT32  mostRecentEraseTimestamp;
    UINT8   operationSupport;
} SEL_S_GET_SEL_INFO;


/* SEL_GET_SEL_ALLOCATION_INFO */
typedef void SEL_Q_GET_SEL_ALLOCATION_INFO;

typedef struct SelSGetSelAllocationInfo {
    UINT8   completionCode;	/* IMB_CC_ */
    UINT16  possibleAllocationUnits;
    UINT16  allocationUnitSize;
    UINT16  freeAllocationUnits;
    UINT16  largestFreeBlock;	/* in allocation units */
    UINT8   maxRecordSize;	/* in allocation units */
} SEL_S_GET_SEL_ALLOCATION_INFO;


/* SEL_RESERVE_SEL */
typedef void SEL_Q_RESERVE_SEL;

typedef struct SelSReserveSel {
    UINT8   completionCode;	/* IMB_CC_ */
    UINT16  reservationId;
} SEL_S_RESERVE_SEL;


/* SEL_GET_SEL_ENTRY */
typedef struct SelQGetSelEntry {
    UINT16  reservationId;
    UINT16  recordId;
    UINT8   offset;		/* offset into record */
    UINT8   bytes;		/* bytes to read. 0xff == all */
} SEL_Q_GET_SEL_ENTRY;

typedef struct SelSGetSelEntry {
    UINT8   completionCode;	/* IMB_CC_ */
    UINT16  nextRecordId;
    UINT8   selData[SEL_DATA_LEN];
} SEL_S_GET_SEL_ENTRY;


/* SEL_ADD_SEL_ENTRY */
typedef struct SelQAddSelEntry {
    UINT8   selData[SEL_DATA_LEN];
} SEL_Q_ADD_SEL_ENTRY;

typedef struct SelSAddSelEntry {
    UINT8   completionCode;	/* IMB_CC_ */
    UINT16  addedRecordId;
} SEL_S_ADD_SEL_ENTRY;


/* SEL_PARTIAL_ADD_SEL_ENTRY */
typedef struct SelQPartialAddSelEntry {
    UINT16  reservationId;
    UINT16  recordId;
    UINT8   offset;
    UINT8   options;	/* IMSPAS_O_ */
    UINT8   selData[SEL_DATA_LEN];
} SEL_Q_PARTIAL_ADD_SEL_ENTRY;

typedef struct SelSPartialAddSelEntry {
    UINT8   completionCode;	/* IMB_CC_ */
    UINT16  addedRecordId;
} SEL_S_PARTIAL_ADD_SEL_ENTRY;


/* SEL_DELETE_SEL_ENTRY */
typedef struct SelQDeleteSelEntry {
    UINT16  reservationId;
    UINT16  recordId;
} SEL_Q_DELETE_SEL_ENTRY;

typedef struct SelSDeleteSelEntry {
    UINT8   completionCode;	/* IMB_CC_ */
    UINT16  deletedRecordId;
} SEL_S_DELETE_SEL_ENTRY;


/* SEL_CLEAR_SEL */
#define SEL_CS_A_INITIATE_ERASE		0xAA
#define SEL_CS_A_GET_ERASE_STATUS	0x00

typedef struct SelQClearSel {
    UINT16  reservationId;
    UINT8   password[3];	/* "CLR" */
    UINT8   action;		/* SEL_CS_A_ */
} SEL_Q_CLEAR_SEL;

#define SEL_CS_EP_ERASURE_IN_PROGRESS	0x00
#define SEL_CS_EP_ERASE_COMPLETED	0x01

typedef struct SelSClearSel {
    UINT8   completionCode;	/* IMB_CC_ */
    UINT8   erasureProgress;	/* SEL_CS_EP_ */
} SEL_S_CLEAR_SEL;


/* SEL_GET_SEL_TIME */
typedef void SEL_Q_GET_SEL_TIME;

typedef struct SelSGetSelTime {
    UINT8   completionCode;	/* IMB_CC_ */
    UINT32  time;
} SEL_S_GET_SEL_TIME;


/* SEL_SET_SEL_TIME */
typedef struct SelQSetSelTime {
    UINT32  time;
} SEL_Q_SET_SEL_TIME;

typedef struct SelSSetSelTime {
    UINT8   completionCode;	/* IMB_CC_ */
} SEL_S_SET_SEL_TIME;


/*----------------------------------------------------------------------
 * SEL Definition
 */

/* recordType */
#define	SEL_RT_STANDARD2		0x02	/* (the only valid value) */

/* generatorId [only odd IDs defined here] */
#define	SEL_GI_BIOS			0x01
#define	SEL_GI_SMI			0x11
#define	SEL_GI_NSA			0x21
#define	SEL_GI_FW_UPDATE		0x7D	/* FLASHxxx firmware update util */
#define	SEL_GI_ERA			0x7F	/* Integrated RA */

/* eventVersion */
#define	SEL_EV_STANDARD2		0x02	
#define SEL_EV_STANDARD3    		0x03    

/* sensorType */
#define	SEL_ST_RESERVED			0x00
#define SEL_ST_TEMPERATURE		0x01
#define SEL_ST_VOLTAGE			0x02
#define SEL_ST_CURRENT			0x03
#define SEL_ST_FAN			0x04
#define SEL_ST_PHYSICAL_SECURITY 	0x05	/* (Chassis Intrusion) */
#define SEL_ST_SECURE_MODE_VIOLATION_ATTEMPT 0x06 /* (LC II: not supported) */
#define SEL_ST_PROCESSOR		0x07
#define SEL_ST_POWER_SUPPLY		0x08
#define SEL_ST_POWER_UNIT		0x09
#define SEL_ST_COOLING_DEVICE		0x0A
#define SEL_ST_OTHER_UNITS_BASED 	0x0B
#define SEL_ST_MEMORY			0x0C
#define SEL_ST_DRIVE_SLOT		0x0D
#define SEL_ST_POST_MEMORY_RESIZE 	0x0E
#define SEL_ST_POST_ERROR		0x0F
#define SEL_ST_EVENT_LOGGING    	0x10
#define SEL_ST_WATCHDOG			0x11
#define SEL_ST_SYSTEM_EVENT		0x12
#define SEL_ST_CRITICAL_INTERRUPT 	0x13
#define SEL_ST_BUTTON			0x14
#define SEL_ST_MODULE			0x15
#define SEL_ST_MICROCONTROLLER		0x16
#define SEL_ST_ADD_IN_CARD		0x17
#define SEL_ST_CHASSIS			0x18
#define SEL_ST_CHIP_SET			0x19
#define SEL_ST_OTHER_FRU		0x1A

/* IPMI_VER_09 */
#define	SEL_ST_SYSTEM_CONFIG_INFO1 	0x20
#define	SEL_ST_SYSTEM_CONFIG_INFO2 	0x21
#define	SEL_ST_FIXED_DISK_INFO		0x22

/* IPMI_VER_10 */
#define SEL_ST_CABLE_INTERCONNECT       0x1B
#define SEL_ST_TERMINATOR               0x1C
#define SEL_ST_SYSTEM_BOOT              0x1D
#define SEL_ST_BOOT_ERROR               0x1E
#define SEL_ST_OS_BOOT                  0x1F
#define SEL_ST_OS_CRITICAL_STOP         0x20
#define SEL_ST_SLOT_CONNECTOR           0x21
#define SEL_ST_SYSTEM_ACPI_STATE        0x22
#define SEL_ST_WATCHDOG2                0x23
#define SEL_ST_PLATFORM_EVENT           0x24
#define SEL_ST_ENTITY_PRESENCE          0x25
#define SEL_ST_MONITOR_ASIC             0x26
#define SEL_ST_LAN                      0x27

#define	SEL_ST_REMORA			0xC7		/* 199 decimal */
#define SEL_ST_ADMIN			0xC8		/* 200 decimal */
#define SEL_ST_POWER			0xC9		/* 201 decimal */
#define	SEL_ST_RA_NOTIFICATION		0xCA		/* 202 decimal */
#define	SEL_ST_FIRMWARE_UPDATE		0xD1		/* 209 decimal */
#define	SEL_ST_VOLUME_CAPACITY		0xD2		/* 210 decimal */
#define	SEL_ST_SCSI_STATUS		0xD3		/* 211 decimal */
#define	SEL_ST_DISK_ARRAY		0xD4		/* 212 decimal */
#define	SEL_ST_NETWORK_CARD		0xD5		/* 213 decimal */
#define	SEL_ST_TAPE_ALERT		0xD6		/* 214 decimal */
#define	SEL_ST_UPS			0xD7		/* 215 decimal */


/* sensorNumber */
#define	SEL_SN_UNSPECIFIED		0x00

/* eventTrigger */
#define	SEL_ET_UNSPECIFIED		0x00
#define	SEL_ET_THRESHOLD		0x01
#define	SEL_ET_STATE_TRANSITION		0x02
#define	SEL_ET_STATE			0x03
#define	SEL_ET_PREDICTIVE_FAILURE 	0x04
#define	SEL_ET_LIMIT			0x05
#define	SEL_ET_PERFORMANCE		0x06
#define	SEL_ET_SEVERITY			0x07
#define	SEL_ET_DEVICE_INSERTION		0x08
#define	SEL_ET_DEVICE_ENABLE		0x09
#define	SEL_ET_DEVICE_AVAIL		0x0A
#define	SEL_ET_REDUNDANCY		0x0B

#define	SEL09_ET_SENSOR_ENUM		0xE7
#define	SEL10_ET_SENSOR_ENUM		0x6F
#define SEL10_ET_DEASSERTION		0x80
#define	SEL09_ET_NEGATED_SENSOR_ENUM 	0xE6
#define SEL10_ET_NEGATED_SENSOR_ENUM 	(SEL10_ET_SENSOR_ENUM | SEL10_ET_DEASSERTION)

/* IPMI ver 0.9  */
/* eventData1 flags [not all flags valid for all Event Trigger classes] */
#define	SEL09_ED1_TRIGGER_IN_ED2	0x80	/* eventData2 has trigger byte */
#define	SEL09_ED1_THRESHOLD_IN_ED3 	0x20	/* eventData3 has threshold byte */	     
#define	SEL09_ED1_SEVERITY_IN_ED2	0x80	/* eventData2 has severity field(s) */
#define SEL09_ED1_OEM_BYTE_IN_ED2   	0x20	/* eventData2 has OEM byte */
#define	SEL09_ED1_OEM_BYTE_IN_ED3	0x40	/* eventData3 has OEM byte */
#define	SEL09_ED1_OEM_BYTE_IN_ED2_ED3	0x60	/* eventData2&3 have OEM bytes */

/* IPMI ver 1.0 */
#define SEL10_ED1_SENSOR_DATA_IN_ED2  	0xC0	/* eventData2 has sensor specific data */
#define SEL10_ED1_OEM_BYTE_IN_ED2	0x80	/* eventData2 has OEM data */
#define SEL10_ED1_TRIGGER_IN_ED2        0x40	/* eventData2 has trigger value*/
#define SEL10_ED1_SEVERITY_IN_ED2       0x40	/* eventData2 has severity field(s) */
#define SEL10_ED1_UNSPECIFIED_ED2       0x00	/* eventData2 has unspecified data */
#define SEL10_ED1_SENSOR_DATA_IN_ED3  	0x30	/* eventData3 has sensor specific data */
#define SEL10_ED1_OEM_BYTE_IN_ED3       0x20	/* eventData3 has OEM data */
#define SEL10_ED1_THRESHOLD_IN_ED3      0x10	/* eventData3 has threshold value */
#define SEL10_ED1_UNSPECIFIED_ED3       0x00	/* eventData3 has unspecified data */

/* eventData1 "offset" fields */

/*   SEL_ET_THRESHOLD */
#define SEL_EDO_LOW_WARN_GOING_LOW      0x00
#define SEL_EDO_LOW_WARN_GOING_HIGH     0x01
#define SEL_EDO_LOW_ERROR_GOING_LOW     0x02
#define SEL_EDO_LOW_ERROR_GOING_HIGH    0x03
#define SEL_EDO_LOW_FATAL_GOING_LOW     0x04
#define SEL_EDO_LOW_FATAL_GOING_HIGH    0x05
#define SEL_EDO_UPPER_WARN_GOING_LOW    0x06
#define SEL_EDO_UPPER_WARN_GOING_HIGH   0x07
#define SEL_EDO_UPPER_ERROR_GOING_LOW   0x08
#define SEL_EDO_UPPER_ERROR_GOING_HIGH  0x09
#define SEL_EDO_UPPER_FATAL_GOING_LOW   0x0A
#define SEL_EDO_UPPER_FATAL_GOING_HIGH  0x0B

/*   SEL_ET_STATE_TRANSITION */
#define SEL_EDO_TO_IDLE         	0x00
#define SEL_EDO_TO_ACTIVE       	0x01
#define SEL_EDO_TO_BUSY         	0x02

/*   SEL_ET_STATE */
#define SEL_EDO_DEASSERTED      	0x00
#define SEL_EDO_ASSERTED        	0x01

/*   SEL_ET_PREDICTIVE_FAILURE */
#define SEL_ED0_PREDICTIVE_FAILURE_DEASSERTED   0x00
#define SEL_EDO_PREDICTIVE_FAILURE_ASSERTED     0x01

/*   SEL_ET_LIMIT */
#define SEL_EDO_LIMIT_NOT_EXCEEDED      0x00
#define SEL_EDO_LIMIT_EXCEEDED          0x01

/*   SEL_ET_PERFORMANCE */
#define SEL_EDO_PERFORMANCE_MET         0x00
#define SEL_EDO_PERFORMANCE_LAGS        0x01

/*   SEL_ET_SEVERITY */
#define SEL_EDO_TO_OK		0x00
#define SEL_EDO_UP_TO_WARN	0x01
#define SEL_EDO_UP_TO_ERROR	0x02
#define SEL_EDO_UP_TO_FATAL	0x03
#define SEL_EDO_DOWN_TO_WARN	0x04
#define SEL_EDO_DOWN_TO_ERROR	0x05
#define SEL_EDO_TO_FATAL	0x06
#define	SEL_EDO_MONITOR		0x07
#define	SEL_EDO_INFORMATIONAL	0x08

/*   SEL_ET_DEVICE_INSERTION */
#define SEL_EDO_DEVICE_REMOVED  0x00
#define SEL_EDO_DEVICE_INSERTED 0x01

/*   SEL_ET_DEVICE_ENABLE */
#define SEL_EDO_DEVICE_DISABLED 0x00
#define SEL_EDO_DEVICE_ENABLED  0x01

/*   SEL_ET_DEVICE_AVAIL */
#define SEL_EDO_TO_RUNNING	0x00
#define SEL_EDO_TO_IN_TEST	0x01
#define SEL_EDO_TO_POWER_OFF	0x02
#define SEL_EDO_TO_ON_LINE	0x03
#define SEL_EDO_TO_OFF_LINE	0x04
#define SEL_EDO_TO_OFF_DUTY	0x05
#define SEL_EDO_TO_DEGRADED	0x06
#define SEL_EDO_TO_POWER_SAVE	0x07
#define SEL_EDO_INSTALL_ERROR	0x08

/*   SEL_ET_REDUNDANCY */
#define SEL_EDO_REDUNDANCY_REGAINED 0x00
#define SEL_EDO_REDUNDANCY_LOST     0x01
#define SEL_EDO_REDUNDANCY_DEGRADED 0x02

/* IPMI_VER_10 */
/* SEL_ET_SENSOR_ENUM: SEL_ST_PHYSICAL_SECURITY */
#define SEL_EDO_GENERAL_CHASSIS_INTRUSION	0x00
#define SEL_EDO_DRIVE_BAY_INTRUSION  		0x01
#define SEL_EDO_IO_CARD_AREA_INTRUSION  	0x02
#define SEL_EDO_PROCESSOR_AREA_INTRUSION 	0x03
#define SEL_EDO_LAN_LEASH_LOST 			0x04

/* SEL_ET_SENSOR_ENUM: SEL_ST_SECURE_MODE_VIOLATION_ATTEMPT */
#define SEL_EDO_SECURE_MODE_VIOLATION_ATTEMPT  	0X00
#define SEL_EDO_USER_PASSWORD_VIOLATION  	0x01
#define SEL_EDO_SETUP_PASSWORD_VIOLATION  	0x02
#define SEL_EDO_NETWORK_PASSWORD_VIOLATION  	0x03
#define SEL_EDO_OTHER_PASSWORD_VIOLATION  	0x04
#define SEL_EDO_OOB_PASSWORD_VIOLATION  	0x05

/* SEL_ET_SENSOR_ENUM: SEL_ST_PROCESSOR */
#define SEL_EDO_IERR  				0x00
#define SEL_EDO_THERMAL_TRIP  			0x01
#define SEL_EDO_FRB1_BIST_FAILURE  		0x02
#define SEL_EDO_FRB2_POST_FAILURE  		0x03
#define SEL_EDO_FRB3_STARTUP_INIT_FAILURE  	0x04
#define SEL_EDO_CONFIGURATION_ERROR  		0x05
#define SEL_EDO_SM_BIOS_COMPLEX_ERROR  		0x06
#define SEL_EDO_PROCESSOR_PRESENCE_DETECTED  	0x07
#define SEL_EDO_PROCESSOR_DISABLED  		0x08
#define SEL_EDO_TERMINATOR_PRESENCE_DETECTED 	0x09

/* SEL_ET_SENSOR_ENUM: SEL_ST_SLOT_CONNECTOR */
#define SEL_EDO_FAULT_STATUS_ASSERTED  		0x00
#define SEL_EDO_IDENTIFY_STATUS_ASSERTED  	0x01
#define SEL_EDO_DEVICE_ATTACHED  		0x02
#define SEL_EDO_READY_FOR_INSERTION  		0x03
#define SEL_EDO_READY_FOR_REMOVAL  		0x04
#define SEL_EDO_SLOT_POWER_OFF  		0x05
#define SEL_EDO_REMOVAL_REQUEST  		0x06
#define SEL_EDO_INTERLOCK_ASSERTED  		0x07

/* SEL_ET_SENSOR_ENUM: SEL_ST_SYSTEM_ACPI_STATE */
#define SEL_EDO_ACPI_STATE_S0_G0  		0x00
#define SEL_EDO_ACPI_STATE_S1  			0x01
#define SEL_EDO_ACPI_STATE_S2  			0x02
#define SEL_EDO_ACPI_STATE_S3  			0x03
#define SEL_EDO_ACPI_STATE_S4  			0x04
#define SEL_EDO_ACPI_STATE_S5_G2  		0x05
#define SEL_EDO_ACPI_STATE_S4_S5  		0x06
#define SEL_EDO_ACPI_STATE_G3  			0x07
#define SEL_EDO_ACPI_SLEEPING  			0x08
#define SEL_EDO_ACPI_G1_SLEEPING  		0x09

/* SEL_ET_SENSOR_ENUM: SEL_ST_WATCHDOG2 */
#define SEL_EDO_WD2_TIMER_EXPIRED  		0x00
#define SEL_EDO_WD2_HARD_RESET     		0x01
#define SEL_EDO_WD2_POWER_DOWN     		0x02
#define SEL_EDO_WD2_POWER_CYCLE    		0x03
#define SEL_EDO_WD2_TIMER_INTERRUPT  		0x08


/*   SEL_ET_SENSOR_ENUM: SEL_ST_POWER_UNIT */
#define	SEL_EDO_POWER_DOWN			0x00	/* (Power Up when negated) */
#define	SEL_EDO_POWER_CYCLE			0x01
#define	SEL_EDO_240_POWER_DOWN			0x02	/* 240VA Power Down */
#define	SEL_EDO_INTERLOCK_POWER_DOWN 		0x03
#define	SEL_EDO_AC_LOST				0x04	/* A/C lost */
#define SEL_EDO_SOFT_POWER_CONTROL_FAILURE  	0x05
#define SEL_EDO_POWER_UNIT_FAILURE  		0x06

/*   SEL_ET_SENSOR_ENUM: SEL_ST_POWER_SUPPLY */
#define SEL_EDO_PRESENCE_DETECTED  		0x00
#define SEL_EDO_FAILURE_DETECTED   		0x01
#define SEL_EDO_FAILURE_PREDICTED  		0x02

/*   SEL_ET_SENSOR_ENUM: SEL_ST_EVENT_LOGGING */
#define SEL_EDO_LOGGING_DISABLED  		0x00
#define SEL_EDO_EVENT_TYPE_LOGGING_DISABLED  	0x01
#define SEL_EDO_LOG_AREA_CLEARED  		0x02
#define SEL_EDO_ALL_EVENT_LOGGING_DISABLED  	0x03

/*   SEL_ET_SENSOR_ENUM: SEL_ST_WATCHDOG */
#define	SEL_EDO_WD_HARD_RESET			0x01
#define	SEL_EDO_WD_POWER_DOWN			0x03
#define	SEL_EDO_WD_POWER_CYCLE			0x04
#define	SEL_EDO_WD_STATUS_ONLY			0x06

/*   SEL_ET_SENSOR_ENUM: SEL_ST_REMORA */
#define	SEL_EDO_REMORA_BOOT			0x00
#define SEL_EDO_REMORA_SDRR_CLEARED   		0x01
#define SEL_EDO_REMORA_FRU_IU_CLEARED 		0x02

/*   SEL_ET_SENSOR_ENUM: SEL_ST_ADMIN */
#define	SEL_EDO_ADMIN_ILLEGAL_LOGINS 		0x00
#define	SEL_EDO_ADMIN_LOGIN			0x01
#define	SEL_EDO_ADMIN_LOGOUT			0x02
#define	SEL_EDO_ADMIN_AUTOLOGOUT 		0x03
#define	SEL_EDO_ADMIN_DISCONNECT 		0x04
#define	SEL_EDO_ADMIN_NO_DIALBACK 		0x05
#define	SEL_EDO_CONFIG_LOST			0x06	/* e.g. due to checksum failure */

/*   SEL_ET_SENSOR_ENUM: SEL_ST_POWER */
#define	SEL_EDO_OOB_CTRL_ALT_DEL 		0x00
#define	SEL_EDO_OOB_HARD_RESET			0x01
#define	SEL_EDO_OOB_POWER_CYCLE			0x02
#define	SEL_EDO_OOB_POWER_DOWN			0x03
#define	SEL_EDO_OOB_POWER_UP			0x04
#define	SEL_EDO_AUTO_POWER_DOWN			0x05
#define	SEL_EDO_FRONT_PANEL_OFF			0x06
#define SEL_EDO_AUTO_GRACE_POWER_DOWN		0x07
#define SEL_EDO_OOB_GRACE_POWER_DOWN		0x08

/*   SEL_ET_SENSOR_ENUM: SEL_ST_RA_NOTIFICATION */
#define	SEL_EDO_MODEM_ERROR			0x01
#define	SEL_EDO_NO_CONNECTION			0x02
#define	SEL_EDO_TAP_NO_ID_PROMPT 		0x03
#define	SEL_EDO_TAP_NO_MSG_GO			0x04
#define	SEL_EDO_TAP_MSG_NAK			0x05

/* eventData2 "offset" fields (in low nibble of eventData2) */
#define	SEL_EDSO_UNSPECIFIED			0x0F

/* eventData2 "severity" fields (in high nibble of eventData2) */
#define SEL_EDSS_TO_OK		(SEL_EDO_TO_OK << 4)
#define SEL_EDSS_UP_TO_WARN	(SEL_EDO_UP_TO_WARN << 4)
#define SEL_EDSS_UP_TO_ERROR	(SEL_EDO_UP_TO_ERROR << 4)
#define SEL_EDSS_UP_TO_FATAL	(SEL_EDO_UP_TO_FATAL << 4)
#define SEL_EDSS_DOWN_TO_WARN	(SEL_EDO_DOWN_TO_WARN << 4)
#define SEL_EDSS_DOWN_TO_ERROR	(SEL_EDO_DOWN_TO_ERROR << 4)
#define SEL_EDSS_TO_FATAL	(SEL_EDO_TO_FATAL << 4)
#define	SEL_EDSS_MONITOR	(SEL_EDO_MONITOR << 4)
#define	SEL_EDSS_INFORMATIONAL	(SEL_EDO_INFORMATIONAL << 4)
#define	SEL_EDSS_UNSPECIFIED	(0x0F << 4)

typedef struct Sel {
    UINT16  recordId;
    UINT8   recordType;		/* SEL_RT_STANDARD2 */
    UINT32  timestamp;		/* time this record was written */
    UINT8   generatorId;
    UINT8   generatorLun;
    UINT8   eventVersion;	/* SEL_EV_STANDARD2 */
    UINT8   sensorType;		/* SEL_ST_... */
    UINT8   sensorNumber;
    UINT8   eventTrigger;	/* SEL_ET_... */
    UINT8   eventData1;
    UINT8   eventData2;
    UINT8   eventData3;
} SEL;

#endif	/* _SEL_CMD_H_ */
