/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/**************************************************************************
**  Copyright (C) 1998-1999, Hewlett-Packard Co. All rights reserved.
**
**  File name:  sf3_cmd.h
**  Summary:    Starfish III Command Definitions
**
**************************************************************************/
#ifndef _SF3_CMD_H_
#define _SF3_CMD_H_

#include	"imb_std.h"	/* IMB OS-Dependent Standard Types */

/* App NetFn (IMB_NF_APP) commands  */
#define	SF3_SET_SCSI_ID			0x29
#define	SF3_GET_SCSI_ID         0x27
#define SAF_TE_LED_CONTROL      0xDC

/* SF3_SET_SCSI_ID */
typedef struct SF3QsetSCSIid {
    UINT8  scsiID;          /* New SCSI ID */
} SF3_Q_SET_SCSI_ID;

typedef struct SF3SsetSCSIid {
    UINT8  completionCode;  /* IMB_CC_ */
} SF3_S_SET_SCSI_ID;


/* SF3_GET_SCSI_ID */
typedef void SF3_Q_GET_SCSI_ID;

typedef struct SF3SgetSCSIid {
    UINT8  completionCode;  /* IMB_CC_ */
    UINT8  scsiID;          /* Current SCSI ID */
} SF3_S_GET_SCSI_ID; 

#endif	/* _SF3_CMD_H_ */
