/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/***********************************************************
 Filename : aol2defs.h

 Description : Alert On Lan2 I2C and EEPROM register definitions

 Initial Version - Sekar Srinivasan

************************************************************/
#ifndef _AOL2DEFS_H_
#define _AOL2DEFS_H_


/* AOL-2 Cape Lookout I2C Address Definition
-------------------------------------------------------*/
#define AOL2_I2C_BUS_ID             0x04
#define AOL2_I2C_ADDRESS            0xCE
#define AOL2_CONFIG_REGISTER   	    0x0D
#define AOL2_APM_CONFIG_REGISTER    0x05
#define AOL2_EEP_ADDR_REGISTER      0x10
#define AOL2_EEP_DATA_REGISTER      0x11
#define AOL2_EEP_CNTRL_REGISTER     0x12

/* AOL2 EEPROM PROGRAMMING DEFINITIONS
-------------------------------------------*/
/* Mask Definitions can be used for "ANDing" with the register */

#define AOL2_EEP_BUSY_LOAD_MASK               0x90
#define AOL2_EEP_BUSY_MASK                    0x10
#define AOL2_EEP_ADDR_REG_WRITE_ENABLE_CMD    0xFF
#define AOL2_EEP_CNTRL_REG_WRITE_ENABLE_CMD   0x04
#define AOL2_EEP_CNTRL_REG_WRITE_CMD          0x05
#define AOL2_EEP_ADDR_REG_WRITE_DISABLE_CMD   0x00
#define AOL2_EEP_CNTRL_REG_WRITE_DISABLE_CMD  0x04


#endif // End _AOL2DEFS_H_