/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/**************************************************************************
**  Copyright (C) 1997-1999, Hewlett-Packard Co. All rights reserved.
**
**  File name:  fpc_cmd.h
**  Summary:    FPC Command Definitions
**
**************************************************************************/

#ifndef _FPC_CMD_H_
#define _FPC_CMD_H_

#include	"imb_std.h"	/* IMB OS-Dependent Standard Types */
#include	"imb_cmd.h"	/* IMB Common Command Definitions */

/* FPC NetFn (IMB_NF_APP_) Commands */
#define	FPC_WRITE_INFO_CELL		0xC8
#define	FPC_READ_INFO_CELL		0xC9
#define FPC_START_INTERACTIVE_TEST	0xD0
#define FPC_ABORT_INTERACTIVE_TEST	0xD1
#define FPC_INTERACTIVE_TEST_STATUS	0xD2
#define FPC_END_OF_BIOS_POST		0xD3 /* not implemented */
#define FPC_BEEP_SPEAKER		0xD4

/* FPC_INFO_CELL [common to WRITE & READ] */
/* cellNumber values/ranges */
#define	FPC_IC_USER_MENU		0x00
#define	FPC_IC_USER_MENU_MAX		0x6F
#define	FPC_IC_FW_REVISION		0x70
#define	FPC_IC_FW_REVISION_MAX		0x7F

/* maximum nesting for "enter" */
#define	FPC_IC_DEPTH			3	/* first level + two more */
/*
 * For LH3, circular left/right connections are not allowed.
 */
typedef struct FpcInfoCellHeader {
    UINT8   enter;		/* cell for "enter" key: self if none */
    UINT8   next;		/* next cell after this one: self if none */
 /* UINT8   ascii[n]; */	/* ASCII text immediately follows header */
} FPC_INFO_CELL_HEADER;


/* FPC_WRITE_INFO_CELL */
typedef struct FpcQWriteInfoCell {
    UINT8   cellNumber;		/* within FPC_IC_... ranges */
    UINT8   cellOffset;		/* zero erases all prior contents */
    /* FPC_INFO_CELL fragment */
    UINT8   cellData[IMB_MAX_DATA_LEN-2];
} FPC_Q_WRITE_INFO_CELL;


typedef struct FpcSWriteInfoCell {
    UINT8   completionCode;	/* IMB_CC_ */
} FPC_S_WRITE_INFO_CELL;


/* FPC_READ_INFO_CELL */
typedef struct FpcQReadInfoCell {
    UINT8   cellNumber;		/* within FPC_IC_... ranges */
    UINT8   cellOffset;
} FPC_Q_READ_INFO_CELL;


typedef struct FpcSReadInfoCell {
    UINT8   completionCode;	/* IMB_CC_ */
    /* FPC_INFO_CELL fragment */
    /* (don't read more than can write) */
    UINT8   cellData[IMB_MAX_DATA_LEN-2];
} FPC_S_READ_INFO_CELL;


/* FPC_START_INTERACTIVE_TEST */
#define	FPC_SIT_NO_SWITCHES		0x00
#define	FPC_SIT_NAV_SWITCHES		0x01
#define	FPC_SIT_ALL_SWITCHES		0x02	/* (except power) */
typedef struct FpcQStartInteractiveTest {
    UINT8   switchTestOption;
} FPC_Q_START_INTERACTIVE_TEST;

typedef struct FpcSStartInteractiveTest {
    UINT8   completionCode;	/* IMB_CC_ */
} FPC_S_START_INTERACTIVE_TEST;


/* FPC_ABORT_INTERACTIVE_TEST */
typedef void FPC_Q_ABORT_INTERACTIVE_TEST;

typedef struct FpcSAbortInteractiveTest {
    UINT8   completionCode;	/* IMB_CC_ */
} FPC_S_ABORT_INTERACTIVE_TEST;


/* FPC_INTERACTIVE_TEST_STATUS */
typedef void FPC_Q_INTERACTIVE_TEST_STATUS;

#define	FPC_IST_SUCCESS			0x00
#define	FPC_IST_NEVER_RUN		0x01
#define	FPC_IST_ABORTED			0x02

#define	FPC_IST_TIMEOUT_MASK		0x80

#define	FPC_IST_FILL_FAIL		0x10
#define	FPC_IST_CONTRAST_FAIL		0x11
#define	FPC_IST_SPEAKER_FAIL		0x12
#define	FPC_IST_LED5_FAIL		0x13
#define	FPC_IST_LED3G_FAIL		0x14
#define	FPC_IST_LED1Y_FAIL		0x15
#define	FPC_IST_LED1R_FAIL		0x16
#define	FPC_IST_POWER_BLINK_FAIL	0x17

#define	FPC_IST_SW_ESC_FAIL		0x20
#define	FPC_IST_SW_ENTER_FAIL		0x21
#define	FPC_IST_SW_LEFT_FAIL		0x22
#define	FPC_IST_SW_RIGHT_FAIL		0x23
#define	FPC_IST_SW_DOWN_FAIL		0x24
#define	FPC_IST_SW_UP_FAIL		0x25
#define	FPC_IST_SW_LOCK_FAIL		0x26
#define	FPC_IST_SW_RESET_FAIL		0x27


typedef struct FpcSInteractiveTestStatus {
    UINT8   completionCode;	/* IMB_CC_ */
    UINT8   testProgress;
    UINT8   results;
} FPC_S_INTERACTIVE_TEST_STATUS;


/* FPC_BEEP_SPEAKER */
typedef struct FpcQBeepSpeaker {
    UINT16  beepFrequency;   /* in Khz - normal range: 1Khz - 2Khz */
    UINT8   beepDuration;    /* in tenths of seconds */
    UINT8   numBeeps;	     /* 0 means continuous beeping until ESC switch is pressed */
} FPC_Q_BEEP_SPEAKER;

typedef struct FpcSBeepSpeaker {
    UINT8   completionCode;	/* IMB_CC_ */
} FPC_S_BEEP_SPEAKER;


/*
 * FPC FRU Internal Use Area
 */
#define	FPC_FRU_IU_FORMAT_VERSION	0x01

#define	FPC_FRU_IU_UP_KEY_CLICK		0x10	/* non-zero to enable click */
#define	FPC_FRU_IU_UP_USE_CONTRAST	0x08	/* non-zero to use value here */
#define	FPC_FRU_IU_UP_CONTRAST_MASK	0x07	/* 3-bit user contrast */

typedef struct FpcFruInternalUse {
    UINT8   formatVersion;		/* FPC_FRU_IU_FORMAT_VERSION */
    UINT8   length;			/* bytes / 8 (= 0x05) */

    /* Root Cell contents */
    UINT8   rootMenu[33];		/* not necessarily null terminated */

    UINT8   userPrefs;			/* FPC_FRU_IU_UP_ */

    UINT8   reserved[3];		/* set to zero */
    UINT8   checksum;			/* byte sum to zero */
} FPC_FRU_INTERNAL_USE;

#endif  /* _FPC_CMD_H_ */
