/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/**************************************************************************
**  Copyright (C) 1997-1999, Hewlett-Packard Co. All rights reserved.
**
**  File name:  imb_cmd.h
**  Summary:    IMB Common Command Definitions
**
**************************************************************************/

#ifndef _IMB_CMD_H_
#define _IMB_CMD_H_

#include	"imb_std.h"	/* IMB OS-Dependent Standard Types */

/* IMB NetFn - Network Function Codes */
#define IMB_NF_CHASSIS_REQ      0x00    /* Chassis Control Requests */
#define IMB_NF_CHASSIS_RESP     0x01    /* Chassis Control Responses */
#define IMB_NF_SENSOR_REQ	0x04	/* Sensor/Event Requests */
#define IMB_NF_SENSOR_RESP	0x05	/* Sensor/Event Responses */
#define IMB_NF_APP_REQ		0x06	/* Application Device Requests */
#define IMB_NF_APP_RESP		0x07	/* Application Device Responses */
#define IMB_NF_FIRMWARE_REQ	0x08	/* Firmware Transfer Requests */
#define IMB_NF_FIRMWARE_RESP	0x09	/* Firmware Transfer Responses */
#define IMB_NF_STORAGE_REQ	0x0A	/* Storage Device Requests */
#define IMB_NF_STORAGE_RESP	0x0B	/* Storage Device Responses */

/*   HP OEM Network Function Codes */
#define IMB_NF_ERA_REQ		0x30	/* ERA Requests */
#define IMB_NF_ERA_RESP		0x31	/* ERA Requests */

/* "Every IMB Device" Common LUNs */
#define IMB_LUN_CONTROL		0


/*----------------------------------------------------------------------
 *  Intellegent Management Bus (IMB) Completion Codes
 */
/*    Command completed normally */
#define IMB_CC_NO_ERROR			0x00
/*    Lost Arbitration */
#define IMB_CC_LOST_ARBITRATION		0x01
/*    Bus Error */
#define IMB_CC_BUS_ERROR		0x02
/*    NAK on Write */
#define IMB_CC_WRITE_NAK		0x03
/*    Truncated Read */
#define IMB_CC_TRUNCATED_READ		0x04
/*    NAK'd Slave Address */
#define IMB_CC_SLAVE_ADDRESS_NAK	0x05
/*    The I2C ISR did not respond in time */
#define IMB_CC_I2C_TIMEOUT		0x10
/*    Timeout acquiring semaphore */
#define IMB_CC_ACQUIRE_TIMEOUT		0x11
/*    The bus ID requested is illegal */
#define IMB_CC_ILLEGAL_BUS_ID		0x12
/*    The I2C interface does not support the requested action */
#define IMB_CC_I2C_NOT_IMPLEMENTED	0x20
/*    Data Validation Failed */
#define	IMB_CC_VALIDATION_FAILURE	0x7A
/*    Access to I2C bus disabled       */
#define IMB_CC_ACCESS_DENIED            0x7B
/*    SDR or SEL pointers initialized  */
#define IMB_CC_POINTERS_INITIALIZED     0x7C
/*    Command not supported: use IMB_CC_INVALID_COMMAND instead */
//#define IMB_CC_COMMAND_NOT_SUPPORTED  0x7D
/*    Command supported but not implemented in this build */
#define IMB_CC_COMMAND_NOT_IMPLEMENTED  0x7E
#if defined(IPMI_VER_10)
/*    Messaging queue is empty    */
#define IMB_CC_MESSAGE_QUEUE_EMPTY      0x80
#endif
/*    Node busy */
#define IMB_CC_NODE_BUSY		0xC0
/*    Invalid command */
#define IMB_CC_INVALID_COMMAND		0xC1
/*    Invalid command for given LUN */
#define IMB_CC_INVALID_COMMAND_FOR_LUN	0xC2
/*    Time-out while processing command */
#define IMB_CC_COMMAND_TIMEOUT		0xC3
/*    Out of space */
#define IMB_CC_OUT_OF_SPACE		0xC4
/*    Reservation canceled */
#define IMB_CC_RESERVATION_CANCELLED	0xC5
/*    Request data truncated */
#define IMB_CC_REQ_DATA_TRUNCATED	0xC6
/*    Request data length invalid */
#define IMB_CC_REQ_DATA_LEN_INVALID	0xC7
/*    Request data field length limit exceeded */
#define IMB_CC_REQ_DATA_LEN_EXCEEDED	0xC8
/*    Parameter out of range */
#define IMB_CC_PARM_OUT_OF_RANGE	0xC9
/*    Returned data (read) truncated */
#define IMB_CC_RESP_DATA_TRUNCATED	0xCA
/*    Requested sensor not found */
#define IMB_CC_SENSOR_NOT_FOUND		0xCB
/*    Invalid data field in request */
#define IMB_CC_INVALID_DATA_FIELD	0xCC
/*    Illegal command for sensor or record type */
#define IMB_CC_COMMAND_ILLEGAL_HERE	0xCD
/*    Command response could not be provided */
#define IMB_CC_NO_COMMAND_RESPONSE	0xCE
/*    Cannot execute duplicated request */
#define IMB_CC_DUPLICATED_REQUEST	0xCF
/*    Unspecified Error */
#define IMB_CC_UNSPECIFIED_ERROR	0xFF

/*----------------------------------------------------------------------
 *  Intellegent Management Bus (IMB) Command Forms
 */
#define IMB_MAX_DATA_LEN	32
#define IMB_MAX_I2C_CMD_LEN  (IMB_MAX_DATA_LEN+sizeof(IMB_I2C_REQUEST_HEADER)+1)
#define IMB_MAX_ISA_CMD_LEN  (IMB_MAX_DATA_LEN+sizeof(IMB_ISA_COMMAND_HEADER))
#define	IMB_CC_ONLY_DATA_LEN	1	/* data result that's just an IMB_CC_ */

/* command to/from I2C interface */
typedef struct ImbI2cRequest {
    UINT8   rsSA;	/* responder's (target) Slave Address */
    UINT8   rsLun:2;	/* responder's LUN */
    UINT8   netFn:6;
    UINT8   checksum1;	/* such that byte sum thru here is zero */
    UINT8   rqSA;	/* requester's (source) Slave Address (even) */
    UINT8   rqLun:2;	/* requester's LUN */
    UINT8   rqSeq:6;	/* requester's sequence number */
    UINT8   command;
    UINT8   cmdData[IMB_MAX_DATA_LEN+1];
	/* the last byte of cmdData is actually checksum2 */
} IMB_I2C_REQUEST;

typedef struct ImbI2cRequestHeader {
    UINT8   rsSA;	/* responder's (target) Slave Address */
    UINT8   rsLun:2;	/* responder's LUN */
    UINT8   netFn:6;
    UINT8   checksum1;	/* such that byte sum thru here is zero */
    UINT8   rqSA;	/* requester's (source) Slave Address (even) */
    UINT8   rqLun:2;	/* requester's LUN */
    UINT8   rqSeq:6;	/* requester's sequence number */
    UINT8   command;
} IMB_I2C_REQUEST_HEADER;

typedef struct ImbI2cResponse {
    UINT8   rqSA;	/* requester's (source) Slave Address (even) */
    UINT8   rqLun:2;	/* requester's LUN */
    UINT8   netFn:6;
    UINT8   checksum1;	/* such that byte sum thru here is zero */
    UINT8   rsSA;	/* responder's (target) Slave Address */
    UINT8   rsLun:2;	/* responder's LUN */
    UINT8   rqSeq:6;	/* requester's sequence number */
    UINT8   command;
    UINT8   cmdData[IMB_MAX_DATA_LEN+1];
	/* the last byte of cmdData is actually checksum2 */
} IMB_I2C_RESPONSE;

typedef struct ImbI2cResponseHeader {
    UINT8   rqSA;	/* requester's (source) Slave Address (even) */
    UINT8   rqLun:2;	/* requester's LUN */
    UINT8   netFn:6;
    UINT8   checksum1;	/* such that byte sum thru here is zero */
    UINT8   rsSA;	/* responder's (target) Slave Address */
    UINT8   rsLun:2;	/* responder's LUN */
    UINT8   rqSeq:6;	/* requester's sequence number */
    UINT8   command;
} IMB_I2C_RESPONSE_HEADER;

/* command over ISA interface */
typedef struct ImbIsaCommand {
    UINT8   lun:2;
    UINT8   netFn:6;
    UINT8   command;
    UINT8   cmdData[IMB_MAX_DATA_LEN];
} IMB_ISA_COMMAND;

/* command over ISA interface */
typedef struct ImbIsaCommandHeader {
    UINT8   lun:2;
    UINT8   netFn:6;
    UINT8   command;
} IMB_ISA_COMMAND_HEADER;


/*----------------------------------------------------------------------
 * "Every NetFn" Common Commands
 */
#define IMB_ERROR_REPORT	0xFF	/* common command to all NetFn/LUNs */

/* IMB_ERROR_REPORT */
/* There is no ImbQErrorReport, the command is only used as a response */

#define ISER_EC_UNKNOWN			0x00
#define ISER_EC_SUSPECT_CHECKSUM	0x01
#define ISER_EC_BAD_LENGTH		0x03
#define ISER_EC_UNRECOGNIZED_NETFN	0x05
#define ISER_EC_INVALID_LUN		0x06
#define ISER_EC_DUPLICATED_REQUEST	0x07
#define ISER_EC_NODE_BUSY		0x08
#define ISER_EC_RESPONSE_UNAVAILABLE	0x09

typedef struct ImbSErrorReport {
    UINT8   originalCommand;
    UINT8   errorCode;		/* ISER_EC_ */
} IMB_S_ERROR_REPORT;



#endif	/* _IMB_CMD_H_ */


