/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/**************************************************************************
**  Copyright (C) 1996, Hewlett-Packard Co. All rights reserved.
**
**  File name:  mmc_func.h
**  Summary:    Function prototypes for MMC functions
**  Product:    IMB driver, MMC API
**  Owner:      Elecia Engelman/Sonny Talag
**
**  START AUTOMATIC VERSION CONTROL INFORMATION
**  DO NOT MANUALLY EDIT THIS SECTION!
**  $Workfile$
**  $Revision: 1.2 $
**  $Date: 2001/04/24 13:22:06 $
**  $Author: hamilton $
**  END AUTOMATIC VERSION CONTROL INFORMATION
**
**  Description:
**      Contains all of the function prototypes for the MMC API
**      
**  Exports:
**     The prototypes
**     
**
***************************************************************************
**  START AUTOMATIC VERSION CONTROL LOG
**  DO NOT MANUALLY EDIT THIS SECTION!
**
**  $Log: mmc_func.h,v $
**  Revision 1.2  2001/04/24 13:22:06  hamilton
**  - Added copyright notice;
**  - Changed Makefile for compiling in rh70.
**
**  Revision 1.1.1.1  2000/08/21 18:45:46  hamilton
**  Initial import.
**
**  Revision 1.1.1.1  2000/08/21 12:49:15  hamilton
**  Initial import.
**
**
**  END AUTOMATIC VERSION CONTROL LOG
**************************************************************************/
#include "imb_cmd.h"
//#include "era_cmd.h"
#include "evnt_cmd.h"
#include "flsh_cmd.h"
#include "fru_cmd.h"
#include "mmc_cmd.h"
#include "sd_cmd.h"
#include "sdrr_cmd.h"
#include "sel_cmd.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Sleep Function Prototype */
void MMCSleep(int ms);

/* Retry Prototypes */
int RetryMMC_OpenDevice(void);
int RetryMMC_CloseDevice(void);
int RetryMMC_ReserveSEL(UINT16 *ReservationID);
int RetryMMC_ReserveSDRRepository(UINT16 *ReservationID);

/* Device Driver functions */
int MMC_OpenDevice(void);
int MMC_CloseDevice(void);
int MMC_GetDriverVersion(char* oem_name, char* version_letter, UINT8* version_major, 
    UINT8* version_minor);
int MMC_GetKernelDriverVersion(char* oem_name, char* version_letter, UINT8* version_major, 
    UINT8* version_minor);
int MMC_SendRcvMesg(UINT8 sNetFnLun, UINT8 scommand, UINT8* smesg, int slen, UINT8* rmesg, int* rlen);
int MMC_ReadPort( int nPort, UINT8 *pbData );
int MMC_WritePort( int nPort, UINT8 bData );

/* ASR functions */
int MMC_GetOSWatchdogTimer(UINT8 *Use, UINT8 *Actions, UINT8 *PreTimeOutInterval,
    UINT8 *UseExpirationBits, UINT16 *InitialCountdownValue,
    UINT16 *PresentCountdownValue);
int MMC_SetOSWatchdogTimer(UINT8 Use, UINT8 Actions, UINT8 PreTimeOutInterval,
    UINT8 UseExpirationBitsClear, UINT16 InitialCountdownValue);
int MMC_ResetOSWatchdogTimer();

/* SDR functions */
int MMC_AddSDR(SDR* RecData,UINT16* RecID);  
int MMC_PartialAddSDR(UINT16 Reservation, UINT16 RecID, UINT8 Offset, UINT8 Lenght, UINT8 Progress, SDR* Data, UINT16* RecIDout);
int MMC_ClearSDRRepository(UINT16 Reservation, UINT8 Flags, UINT8* Progress); 
int MMC_DeleteSDR(UINT16 Reservation, UINT16 RecID, UINT16* RecIDout); 
int MMC_ReserveDeviceSDRRepository(UINT16* Reservation);
int MMC_GetDeviceSDR(UINT16 ReservationID , UINT16 RecID, UINT8 Offset, 
          UINT8 Count, UINT16* NextNum, SDR* Data);    
int MMC_GetSDR(UINT16 Reservation, UINT16 RecID, UINT8 Offset, UINT8 ReadBytes, UINT16* NextID, SDR* Data);
int MMC_GetSDRRepositoryAllocInfo(UINT16* NumPossAlloc, UINT16* AllocUnitSize, UINT16* NumFreeAllocUnits, UINT16* LargestFreeBlock, UINT8* MaxRecordSize);
int MMC_GetSDRRepositoryInfo(UINT8* Version, UINT16* RecCount, UINT16* FreeSpace, UINT32* AddTime, UINT32* EraseTime,UINT8* OperationSupport); 
int MMC_ReserveSDRRepository(UINT16* Reservation);
int MMC_GetSensorEventEnable(UINT8 SensorNum, UINT8* Flags);
int MMC_GetSensorHysterisis(UINT8 SensorNum, UINT8 HysterisisMask, UINT8* Positive, UINT8* Negative);
int MMC_GetSensorReading(UINT8 SensorNum, UINT8* Reading);
int MMC_GetSensorThreshold(UINT8 SensorNum, UINT8 Threshold, UINT8* Value);
int MMC_SetSensorThreshold(UINT8 SensorNum, UINT8 Threshold, UINT8 Value);
int MMC_SetSensorHysterisis(UINT8 SensorNum, UINT8 HysterisisMask, UINT8 Positive, UINT8 Negative);
int MMC_SetSensorEventEnable(UINT8 SensorNum, UINT8 flags);
int MMC_RearmSensorEvents(UINT8 SensorNum, UINT8 flags);

/* Firmware functions */
int MMC_HPEnterFirmwareTransferMode(void);
int MMC_HPSetFirmwareTransferAddress(UINT8* Address);
int MMC_HPFirmwareProgram(UINT8 Length, UINT8* Data, UINT8* Count, UINT8* Status);
int MMC_HPFirmwareRead(UINT8 length, UINT8* Buffer, UINT8* Count);
int MMC_HPGetFirmwareChecksum(UINT8* StartAddress, UINT8* EndAddress, UINT8* Checksum,
    UINT8* Block1Status, UINT8* Block2Status);
int MMC_HPExitFirmwareTransferMode(void);

/* I2C Functions */
int MMC_MasterReadI2C(UINT8 busID, UINT8 addr, UINT8* data, int* len);
int MMC_MasterWriteI2C(UINT8 busID, UINT8 addr, UINT8* data, int len);
int MMC_MasterWriteReadI2C(UINT8 busID, UINT8 addr, UINT8* odata, int olen, UINT8* idata, int* ilen);

/* I2C Legacy functions */
int I2C_CloseDriver(void);
void I2C_GetDriverVersion(char* oem_name, char* version_letter,
        UINT8* version_major, UINT8* version_minor);
int I2C_GetKernelDriverVersion(char* oem_name, char* version_letter, 
        UINT8* version_major, UINT8* version_minor);
int I2C_OpenDriver(void);
int I2C_ReceiveMessage(UINT8 addr, UINT8* data, int len);
int I2C_RepeatStartMesg(UINT8 addr, UINT8 *odata, int olen, 
        UINT8 *idata, int ilen);
int I2C_Reset8584(UINT8 own_addr, UINT8 slc_clock);
int I2C_ResetBus(UINT8 own_addr, UINT8 slc_clock);
int I2C_SendMessage(UINT8 addr, UINT8* data, int len);

/*  MMC Core functions */
int MMC_ColdReset(void);
int MMC_GetDeviceID(UINT8* DevType, UINT8* DevRev, UINT8* FwRev1, UINT8* FwRev2, UINT8* SensorSpecRev, UINT8* DevSupport);
int MMC_WarmReset(void);
int MMC_GetIntelligentDeviceInfo(UINT8* DevSupport);
int MMC_GetSelfTestResults(UINT8* Result);
int MMC_MfgTestOn(void);

/*  MMC Application Device Functions  */
int MMC_ReadMMCRAM(UINT8 MemSpace, UINT16 RAMAddr, UINT8* RAMData);
int MMC_GetMMCGlobalEnables(UINT8* Flags);
int MMC_SetMMCGlobalEnables(UINT8 Flags);
int MMC_SetInterruptFlags(UINT8 Flags);
int MMC_GetInterruptFlags(UINT8* Flags);
int MMC_ReadSMMMessageBuffer(UINT8* Message, UINT8* Length);
int MMC_ReadSMSMessageBuffer(UINT8* Message, UINT8* Length);
int MMC_IsSMSDataAvailable( int *pnTrueFalse );

/* SEL functions */
int MMC_AddSELEntry(SEL* RecData,UINT16* RecID);
int MMC_PartialAddSELEntry(UINT16 Reservation, UINT16 RecID, UINT8 Offset, 
              UINT8 Length, UINT8 Progress, SEL* Data, UINT16* RecIDout);
int MMC_ClearSELRepository(UINT16 Reservation, UINT8 Flags, UINT8* Progress);
int MMC_DeleteSELEntry(UINT16 Reservation, UINT16 RecID, UINT16* RecIDout);
int MMC_GetSELEntry(UINT16 Reservation, UINT16 RecID, UINT8 Offset, 
          UINT8 ReadBytes, UINT16* NextID, SEL* Data);
int MMC_GetSELAllocInfo(UINT16* NumPossAlloc, 
        UINT16* AllocUnitSize, UINT16* NumFreeAllocUnits, 
        UINT16* LargestFreeBlock, UINT8* MaxRecordSize);
int MMC_GetSELInfo(UINT8* Version, UINT16* RecCount, 
        UINT16* FreeSpace, UINT32* AddTime, UINT32* EraseTime,
        UINT8* OperationSupport);
int MMC_ReserveSEL(UINT16* Reservation);
int MMC_GetSELTime(UINT32* Time);
int MMC_SetSELTime(UINT32 Time);

/* FRU functions */
int MMC_GetFRUInventoryAreaInfo(UINT16* AreaSize, UINT8* DevAccess);
int MMC_ReadFRUInventoryData(UINT16 Offset, UINT8 Count, 
                UINT8* CountReturned, UINT8* Data);
int MMC_WriteFRUInventoryData(UINT16 Offset, UINT8 Length,
        UINT8* Data, UINT8* CountWritten);

#ifdef __cplusplus
}
#endif /* for extern-ing the prototypes for C+++ */
