/**************************************************************************
**  Copyright (C) 1997, Hewlett-Packard Co. All rights reserved.
**
**  File name:  HPELint.h
**  Summary:    Event Log internal API prototypes
**  Product:    Event log internal API
**  Owner:      Mike Parrish
**
**  Description:
**       This file contains all of the internal Event Log API
**       prototype as specified in evtagt.doc and 
**       implemented in HPELapi.cpp
**
**  Exports:
** 
**
**  START AUTOMATIC VERSION CONTROL INFORMATION
**  DO NOT MANUALLY EDIT THIS SECTION!
**  $Workfile$
**  $Revision: 1.1 $
**  $Date: 2002/01/07 15:43:06 $
**  $Author: gustavo $
**  END AUTOMATIC VERSION CONTROL INFORMATION
**
***************************************************************************
**  START AUTOMATIC VERSION CONTROL LOG
**  DO NOT MANUALLY EDIT THIS SECTION!
**
**  $Log: hpelint.h,v $
**  Revision 1.1  2002/01/07 15:43:06  gustavo
**  *** empty log message ***
**
**  Revision 1.1  2001/12/27 20:29:37  gustavo
**  *** empty log message ***
**
**  Revision 1.3  2000/08/25 17:48:27  hamilton
**  - Changed LINUX_ROOT to /usr/hpserver/etc;
**  - Changed hpevttrapd configuration file to /usr/hpserver/etc.
**
**  Revision 1.2  2000/08/22 16:45:53  hamilton
**  - Changed GetSystemRoot() to /var/hpserver;
**  - Fix Makefile dependencies.
**
**  Revision 1.1.1.1  2000/08/21 18:46:53  hamilton
**  Initial import.
**
**  Revision 1.1.1.1  2000/08/21 16:04:29  hamilton
**  Initial import.
**
**
**  END AUTOMATIC VERSION CONTROL LOG
***************************************************************************/

#ifndef _HPELINT_H_
#define _HPELINT_H_
/////////////////////////////////////////////////////////////////////////////
// Includes

#include "hpelapi.h"

#pragma pack( 1 )

#ifdef __cplusplus
extern "C" {
#endif

/////////////////////////////////////////////////////////////////////////////
// defines 

// Errors
#define FIRST_RECORD                      0
#define LAST_RECORD                       0xFFFF

#define EVENT_READ_ALL                    0xFF
#define OFFSET_NONE                       0
                                          
#define MAIN_LOOP_SLEEP                   1000
#define NLM_TASK_SWITCH_SLEEP             1

#define CMD_LINE_NT_EVENT_LOG             "ntel"
#define CMD_LINE_SNMP                     "snmp"
#define CMD_LINE_DMI                      "dmi"
#define CMD_LINE_FILE                     "f"
#define CMD_LINE_DEBUG                    "d"

#define HPEL_SOFT_LOG_FILE_NAME           "evtlog.dat"
#define HPEL_BACKUP_SOFT_LOG_FILE_NAME    "evtlog.bak"
#define HPEL_EVENT_SPEC_FILE_NAME         "evtspec.cfg"
#define HPEL_OUTPUT_LOG_FILE_NAME         "outlog.txt"
#define HPEL_CONFIG_FILE_NAME             "hpevtlog.cfg"

#define HPEL_CONFIG_SECTION               "hpevtlog"
#define HPEL_LAST_ERASE_TIME              "LastEraseTime"
#define HPEL_LAST_ERASE_TIME_DEFAULT      0
                                          
#define HPEL_LAST_READ_EVENT              "LastReadEvent"
#define HPEL_LAST_READ_EVENT_DEFAULT      65535

#define HPU_FILE_READ_ONLY                    "r"
#define HPU_FILE_READ_WRITE                   "r+"
#define HPU_FILE_APPEND                       "a+"
#define HPU_FILE_DELETE                       "w"

#define MAX_VARBINDS                      8

#define DECIMAL_RADIX                     10
#define HEX_RADIX                         16

#define WINNT_ROOT      "\\..\\HPServer\\"
#define NLM_ROOT        "sys:\\HPServer\\"
#define SCO_UNIX_ROOT   "/usr/lib/hpnsa/hpevtlog/"
#define LINUX_ROOT		"/usr/hpserver/etc/"

#ifdef LINUX
	#define HPEL_SEMAPHORE_NAME   "eventlog.lck"
#else
	#define HPEL_SEMAPHORE_NAME   "Sem_AccessEventLog"
#endif

/////////////////////////////////////////////////////////////////////////////
// Export definitions.

#ifdef WINNT
#define PIPE_THREAD_STACK_SIZE   8192
#define PIPE_DEPTH               10
#define HPEL_PIPE_NAME           "\\\\.\\pipe\\HPEvtLog.pip"

typedef struct HPEL_PIPE_DATA
{
   HPEL_EVENT evt;
   char szTrapId[MAX_HPEL_BUFFER_SIZE];
} HPEL_PIPE_DATA;

#endif

#ifdef SCO_UNIX
char *itoa(int i, char *buf, int radix);
int stricmp( char *p1, char *p2 );
int strnicmp( char *p1, char *p2, int count );
#endif // SCO_UNIX

#ifdef __cplusplus
}
#endif

#endif // #ifndef _HPELAPI_H_




