#ifndef _MMC_FUNC_H_
#define _MMC_FUNC_H_

#include "sel_cmd.h"
#include "mmc_dev.h"
#include "mmc.h"

/** local constants **/
/*
   Define USE_SOFTWARE_ID if you want to use the
   software ID scheme that was
   discarded by Intel because they
   didn't code using it.
*/
//#define USE_SOFTWARE_ID             

#ifdef USE_SOFTWARE_ID
    #define INPUT_HEADER_SIZE       3
    #define OUTPUT_HEADER_SIZE      3
#else
    #define INPUT_HEADER_SIZE       2
    #define OUTPUT_HEADER_SIZE      2
#endif

#define MMC_MAXIMUM_NUMBER_OF_RETRIES     30
#define MMC_MILLISECONDS_BETWEEN_RETRIES  100

int  SendRcvMesg(UINT8 sNetFnLun, UINT8 scommand, UINT8* smesg, int slen, UINT8* rmesg, int* rlen);
int  MMCReserveSEL(UINT16* Reservation);
int  MMCGetSELEntry(UINT16 Reservation, UINT16 RecID, UINT8 Offset, UINT8 ReadBytes, UINT16* NextID, SEL* Data);


#define SDRR_RESERVE_SDR_REPOSITORY     0x22
#define SDR_NUM_THRESHOLDS			0x06
#define SDRR_GET_SDR				0x23

typedef struct SdrrSReserveSdrRepository {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT16  reservationId;
} SDRR_S_RESERVE_SDR_REPOSITORY;

typedef struct SdrrSGetSdr {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT16  nextRecordId;
    UINT8   sdrData[IMB_MAX_DATA_LEN-1];
} SDRR_S_GET_SDR;

typedef struct SdrrQGetSdr {
    UINT16  reservationId;
    UINT16  recordId;
    UINT8   offset;     /* offset into record */
    UINT8   bytes;      /* bytes to read. 0xff == all */
} SDRR_Q_GET_SDR;

typedef struct Sdr {          
    UINT16  recordId;         
    UINT8   sdrVersion;       
    UINT8   recordType;       
    UINT8   recordLength;     
    union {                   

        struct {
           UINT8   sensorOwnerId;
           UINT8   sensorOwnerLUN;
           UINT8   sensorNumber;
           UINT8   confirmationDeviceId;
           UINT8   confirmationMajorRevision;
           UINT8   sensorModuleFruInventoryDeviceOwnerId;
           UINT8   sensorInitialization;
           UINT8   sensorCapabilities;
           UINT8   sensorType;
           UINT8   eventReadingBaseType;
           UINT16  eventTriggerMask;
           UINT16  eventReadingMask;
           UINT8   sensorUnits1;
           UINT8   sensorUnits2;
           UINT8   sensorUnits3;
           UINT8   linearization;
           UINT8   mLSB;       
           UINT8   mTolerance; 
           UINT8   bLSB;       
           UINT8   bAccuracy;  
           UINT8   accuracy;   
           UINT8   exponents;  
           UINT8   analogCharacteristicFlags;
           UINT8   nominalReading;
           UINT8   normalMaximum;
           UINT8   normalMinimum;
           UINT8   sensorMaximumReading;
           UINT8   sensorMinimumReading;
           UINT8   readableThresholdMask;
           UINT8   settableThresholdMask;
           UINT8   threshold[SDR_NUM_THRESHOLDS];
           UINT8   positiveHysterisis;
           UINT8   negativeHysterisis;
           UINT8   oem;
           UINT8   entityId;
           UINT8   nameTypeLength;
           UINT8   name[16];   
        } t09_01;

        struct {
           UINT8   sensorOwnerId;
           UINT8   sensorOwnerLUN;
           UINT8   sensorNumber;
           UINT8   entityId;
           UINT8   entityInstance;
           UINT8   sensorInitialization;
           UINT8   sensorCapabilities;
           UINT8   sensorType;
           UINT8   eventReadingBaseType;
           UINT8   eventAssertionMask[2];
           UINT8   eventDeassertionMask[2];
           UINT8   settableReadableMask[2];
           UINT8   sensorUnits1;
           UINT8   sensorUnits2;
           UINT8   sensorUnits3;
           UINT8   linearization;
           UINT8   mLSB;       
           UINT8   mTolerance; 
           UINT8   bLSB;       
           UINT8   bAccuracy;  
           UINT8   accuracy;   
           UINT8   exponents;  
           UINT8   analogCharacteristicFlags;
           UINT8   nominalReading;
           UINT8   normalMaximum;
           UINT8   normalMinimum;
           UINT8   sensorMaximumReading;
           UINT8   sensorMinimumReading;
           UINT8   threshold[SDR_NUM_THRESHOLDS];
           UINT8   positiveHysterisis;
           UINT8   negativeHysterisis;
           UINT8   reserved1;
           UINT8   reserved2;
           UINT8   oem;
           UINT8   nameTypeLength;
           UINT8   name[16]; 
        } t10_01;


        struct {
           UINT8   sensorOwnerId;
           UINT8   sensorOwnerLUN;
           UINT8   sensorNumber;
           UINT8   confirmationDeviceId;
           UINT8   confirmationMajorRevision;
           UINT8   sensorModuleFruInventoryDeviceOwnerId;
           UINT8   sensorInitialization;
           UINT8   sensorCapabilities;
           UINT16  sensorRecordSharing;
           UINT8   sensorType;
           UINT8   eventReadingBaseType;
           UINT16  eventTriggerMask;
           UINT16  eventReadingMask;
           UINT8   sensorUnits1;
           UINT8   sensorUnits2;
           UINT8   sensorUnits3;
           UINT8   oem;
           UINT8   entityId;
           UINT8   nameTypeLength;
           UINT8   name[16];    
        } t09_02;

         struct {
          UINT8   sensorOwnerId;
          UINT8   sensorOwnerLUN;
          UINT8   sensorNumber;
          UINT8   entityId;
          UINT8   entityInstance;
          UINT8   sensorInitialization;
          UINT8   sensorCapabilities;
          UINT8   sensorType;
          UINT8   eventReadingBaseType;	
          UINT8   eventAssertionMask[2];  
          UINT8   eventDeassertionMask[2];
          UINT8   eventReadingMask[2];    
          UINT8   sensorUnits1;
          UINT8   sensorUnits2;       
          UINT8   sensorUnits3;       
          UINT8   sensorRecordSharing[2];
          UINT8   positiveHysterisis;
          UINT8   negativeHysterisis;
          UINT8   reserved1;
          UINT8   reserved2;
          UINT8   reserved3;
          UINT8   oem;
          UINT8   nameTypeLength;
          UINT8   name[16];           
        } t10_02;

        struct {
          UINT8   containerEntityId;
          UINT8   containerEntityInstance;
          UINT8   flags;
          UINT8   containedEntity1Range;
          UINT8   containedEntity1Instance;
          UINT8   containedEntity2Range;
          UINT8   containedEntity2Instance;
          UINT8   containedEntity3Range;
          UINT8   containedEntity3Instance;
          UINT8   containedEntity4Range;
          UINT8   containedEntity4Instance;
        } t10_08;

        struct {
          UINT8   deviceSlaveAddress;
          UINT8   imbBusId;
          UINT8   addressSpan;
          UINT8   confirmationDeviceId;
          UINT8   confirmationMajorRevision;
          UINT8   deviceType;
          UINT8   deviceTypeModifier;
          UINT8   deviceLocation;
          UINT8   optionalCommandSupport;
          UINT8   oem;
          UINT8   nameTypeLength;
          UINT8   name[16];
        } t09_10;

        struct {
          UINT8   deviceAccessAddress;
          UINT8   deviceSlaveAddress;
          UINT8   accessIdBusLun;
          UINT8   addressSpan;
          UINT8   reserved;
          UINT8   deviceType;
          UINT8   deviceTypeModifier;
          UINT8   entityId;
          UINT8   entityInstance;
          UINT8   oem;
          UINT8   nameTypeLength;
          UINT8   name[16];
        } t10_10;

        struct {
          UINT8   deviceAccessAddress;
          UINT8   fruDeviceIdSlaveAddress;
          UINT8   accessIdBusLun;
          UINT8   reserved1;
          UINT8   reserved2;
          UINT8   deviceType;
          UINT8   deviceTypeModifier;
          UINT8   fruEntityId;
          UINT8   fruEntityInstance;
          UINT8   oem;
          UINT8   nameTypeLength;
          UINT8   name[16];
        } t10_11;

        struct {
          UINT8   deviceSlaveAddress;
          UINT8   powerStateGlobalInit;
          UINT8   deviceCapabilities;
          UINT8   reserved1;
          UINT8   reserved2;
          UINT8   reserved3;
          UINT8   reserved4;
          UINT8   EntityId;
          UINT8   EntityInstance;
          UINT8   oem;
          UINT8   nameTypeLength;
          UINT8   name[16];
        } t10_12;

        struct {
          UINT8   deviceSlaveAddress;
          UINT8   deviceId;
          UINT8   deviceRevision;
          UINT8   firmwareRevision1;
          UINT8   firmwareRevision2;
          UINT8   IPMIversion;
          UINT8   mfgrId0; 
          UINT8   mfgrId1;
          UINT8   mfgrId2;
          UINT8   systemId;
          UINT8   oem;
          UINT8   deviceGuid[16];  
        } t10_13;

        struct {
          UINT8   messageChannel0Info;
          UINT8   messageChannel1Info;
          UINT8   messageChannel2Info;
          UINT8   messageChannel3Info;
          UINT8   messageChannel4Info;
          UINT8   messageChannel5Info;
          UINT8   messageChannel6Info;
          UINT8   messageChannel7Info;
          UINT8   messagingInterruptType;
          UINT8   eventMessageBufferInterruptType;
          UINT8   reserved;
        } t10_14;

        struct {
            UINT32  timestamp; 
            UINT8   systemModel[16];
            UINT8   romBiosVersion[8];
            UINT8   videoBiosVersion[8];
            UINT8   scsiBiosVersion[8];
            UINT8   pciIsaSlots;
            UINT8   securityFlags;
            UINT16  processorModel[4];
            UINT8   processorSpeed[4];
        } t09_20;

        struct {
            UINT32  timestamp; 
            UINT8   floppyDrive1;
            UINT8   floppyDrive2;
            UINT16  memorySizes[8];
            UINT8   reserved28;
        } t09_21;

        struct {
            UINT8   version[16];
        } t09_C0;

        struct {
            UINT8   manufacturerId[3];
            UINT8   version[56]; 
        } t10_C0;

    } body;
} SDR;

int MMC_ReserveSDRRepository( UINT16* Reservation );
int MMC_GetSDR( UINT16 Reservation, UINT16 RecID, UINT8 Offset, UINT8 ReadBytes, UINT16* NextID, SDR* Data);

#endif
