/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/**************************************************************************
**  Copyright (C) 1997-1999, Hewlett-Packard Co. All rights reserved.
**
**  File name:  mmc_cmd.h
**  Summary:    IPMI MMC Command Definitions
**  Owner:      Myron Tuttle
**
**************************************************************************/

#ifndef _MMC_CMD_H_
#define _MMC_CMD_H_

#include        "imb_std.h"     /* IMB OS-Dependent Standard Types */
#include        "imb_cmd.h"     /* IMB Common Command Definitions */

/* MMC-specific LUNs */
/* !!! should put under 0.9/1.0 paradigm */
#define MMC_LUN_SMM             1
#define MMC_LUN_SMS             2
#define MMC_LUN_EVENT           3       /* obsolete */

/* Application NetFn (IMB_NF_APP_) Global Commands */
#define MMC09_READ_MMC_MEMORY           0x1B    /* 0.9 */
#define MMC09_SET_MMC_GLOBAL_ENABLES    0x1C    /* 0.9 */
#define MMC09_GET_MMC_GLOBAL_ENABLES    0x1D    /* 0.9 */
#define MMC09_SET_SECURE_MODE_OPTIONS   0x1E    /* 0.9 */
#define MMC09_GET_SECURE_MODE_OPTIONS   0x1F    /* 0.9 */

#define MMC_RESET_WATCHDOG_TIMER        0x22    /* all */
#define MMC_SET_WATCHDOG_TIMER          0x24    /* all */
#define MMC_GET_WATCHDOG_TIMER          0x25    /* all */
#define MMC10_SET_MMC_GLOBAL_ENABLES    0x2E    /* 1.0 */
#define MMC10_GET_MMC_GLOBAL_ENABLES    0x2F    /* 1.0 */

#define MMC09_CLEAR_INTERRUPT_FLAGS     0x30    /* 0.9 */
#define MMC10_CLEAR_MESSAGE_FLAGS       0x30    /* 1.0 */
#define MMC09_GET_INTERRUPT_FLAGS       0x31    /* 0.9 */
#define MMC10_GET_MESSAGE_FLAGS         0x31    /* 1.0 */
#define MMC10_ENABLE_MSG_CHANNEL_REC    0x32    /* 1.0 */
#define MMC10_GET_MESSAGE               0x33    /* 1.0 */
#define MMC10_SEND_MESSAGE              0x34    /* 1.0 */
#define MMC_READ_EVENT_MESSAGE_BUFFER   0x35    /* all */
#define MMC09_READ_SMM_MESSAGE_BUFFER   0x36    /* 0.9 */
#define MMC09_READ_SMS_MESSAGE_BUFFER   0x37    /* 0.9 */

#define MMC09_MASTER_WRITE_I2C          0x50    /* 0.9 */
#define MMC09_MASTER_READ_I2C           0x51    /* 0.9 */
#define MMC_MASTER_WRITE_READ_I2C       0x52    /* all */

#if defined(IPMI_VER_09)
#define MMC_READ_MMC_MEMORY             MMC09_READ_MMC_MEMORY
#define MMC_SET_MMC_GLOBAL_ENABLES      MMC09_SET_MMC_GLOBAL_ENABLES
#define MMC_GET_MMC_GLOBAL_ENABLES      MMC09_GET_MMC_GLOBAL_ENABLES
#define MMC_SET_SECURE_MODE_OPTIONS     MMC09_SET_SECURE_MODE_OPTIONS
#define MMC_GET_SECURE_MODE_OPTIONS     MMC09_GET_SECURE_MODE_OPTIONS
#define MMC_CLEAR_INTERRUPT_FLAGS       MMC09_CLEAR_INTERRUPT_FLAGS
#define MMC_GET_INTERRUPT_FLAGS         MMC09_GET_INTERRUPT_FLAGS
#define MMC_READ_SMM_MESSAGE_BUFFER     MMC09_READ_SMM_MESSAGE_BUFFER
#define MMC_READ_SMS_MESSAGE_BUFFER     MMC09_READ_SMS_MESSAGE_BUFFER
#define MMC_MASTER_WRITE_I2C            MMC09_MASTER_WRITE_I2C
#define MMC_MASTER_READ_I2C             MMC09_MASTER_READ_I2C
#endif

#if defined(IPMI_VER_10)
#define MMC_SET_MMC_GLOBAL_ENABLES      MMC10_SET_MMC_GLOBAL_ENABLES
#define MMC_GET_MMC_GLOBAL_ENABLES      MMC10_GET_MMC_GLOBAL_ENABLES
#define MMC_CLEAR_MESSAGE_FLAGS         MMC10_CLEAR_MESSAGE_FLAGS
#define MMC_GET_MESSAGE_FLAGS           MMC10_GET_MESSAGE_FLAGS
#define MMC_ENABLE_MSG_CHANNEL_REC      MMC10_ENABLE_MSG_CHANNEL_REC
#define MMC_GET_MESSAGE                 MMC10_GET_MESSAGE
#define MMC_SEND_MESSAGE                MMC10_SEND_MESSAGE
#endif


/* SMM & SMS message buffers */
typedef struct MmcSmxMessage {
    UINT8   rsLun:2;    /* responder's LUN */
    UINT8   netFn:6;
    UINT8   checksum1;  /* such that byte sum thru here is -BMC slave address */
    UINT8   rqSA;       /* requester's (source) Slave Address (even) */
    UINT8   rqLun:2;    /* requester's LUN */
    UINT8   rqSeq:6;    /* requester's sequence number */
    UINT8   command;
    UINT8   cmdData[IMB_MAX_DATA_LEN-5];
        /* the last byte of cmdData is actually checksum2 */
} MMC_SMX_MESSAGE;


/* MMC_READ_MMC_MEMORY [0.9] */
#define MMC_MM_MS_INTERNAL_DATA         0x00
#define MMC_MM_MS_EXTERNAL_DATA         0x01
#define MMC_MM_MS_PROGRAM               0x02    /* only for Read MMC Memory */

typedef struct Mmc09QReadMmcMemory {
    UINT8   memorySpace;        /* MMC_MM_MS_ */
    UINT16  address;
} MMC09_Q_READ_MMC_MEMORY;

typedef struct Mmc09SReadMmcMemory {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   readData;
} MMC09_S_READ_MMC_MEMORY;

#if defined(IPMI_VER_09)
#define MmcQReadMmcMemory               MmcQ09ReadMmcMemory
#define MMC_Q_READ_MMC_MEMORY           MMC09_Q_READ_MMC_MEMORY
#define MmcSReadMmcMemory               MmcS09ReadMmcMemory
#define MMC_S_READ_MMC_MEMORY           MMC09_S_READ_MMC_MEMORY
#endif


/* MMC_..._MMC_GLOBAL_ENABLES [0.9/1.0] */
/* definition for the enables byte in the following commands */
/* bit definitions for IPMI 0.9  */
#define MMC_GE_ENABLE_SMI               0x80
#define MMC_GE_ROUTE_EVENTS             0x10
#define MMC_GE_DISABLE_FRB3             0x08
#define MMC_GE_DISABLE_LOGGING          0x02
#define MMC_GE_ENABLE_EM_SMI            0x01

/* bit definitions for IPMI 1.0  */
#define MMC_GE_ENABLE_OEM2              (0x01 << 7)
#define MMC_GE_ENABLE_OEM1              (0x01 << 6)
#define MMC_GE_ENABLE_OEM0              (0x01 << 5)
/* our OEM definitions for these bits */
#define MMC_GE_ENABLE_MMC_SMI           MMC_GE_ENABLE_OEM2
#define MMC_GE_ENABLE_BUSY_INTERRUPT    MMC_GE_ENABLE_OEM1
#define MMC_GE_ENABLE_SMM_BUFFER        MMC_GE_ENABLE_OEM0

#define MMC_GE_ENABLE_SYS_EVM           (0x01 << 3)
#define MMC_GE_ENABLE_EVM_BUFFER        (0x01 << 2)
#define MMC_GE_ENABLE_EVM_INTERRUPT     (0x01 << 1)
#define MMC_GE_ENABLE_REC_MSG_QUEUE_INT (0x01 << 0)

/* MMC_SET_MMC_GLOBAL_ENABLES [0.9/1.0] */
typedef struct MmcQSetMmcGlobalEnables {
    UINT8   enables;
} MMC_Q_SET_MMC_GLOBAL_ENABLES;

typedef struct MmcSSetMmcGlobalEnables {
    UINT8   completionCode;     /* IMB_CC_ */
} MMC_S_SET_MMC_GLOBAL_ENABLES;


/* MMC_GET_MMC_GLOBAL_ENABLES [0.9/1.0] */
typedef void MMC_Q_GET_MMC_GLOBAL_ENABLES;

typedef struct MmcSGetMmcGlobalEnables {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   enables;
} MMC_S_GET_MMC_GLOBAL_ENABLES;

/* for completeness with these commands whose command codes vary */
#define	Mmc09QSetMmcGlobalEnables       MmcQSetMmcGlobalEnables
#define	Mmc10QSetMmcGlobalEnables       MmcQSetMmcGlobalEnables
#define MMC09_Q_SET_MMC_GLOBAL_ENABLES  MMC_Q_SET_MMC_GLOBAL_ENABLES
#define MMC10_Q_SET_MMC_GLOBAL_ENABLES  MMC_Q_SET_MMC_GLOBAL_ENABLES
#define	Mmc09SSetMmcGlobalEnables       MmcQSetMmcGlobalEnables
#define	Mmc10SSetMmcGlobalEnables       MmcQSetMmcGlobalEnables
#define MMC09_S_SET_MMC_GLOBAL_ENABLES  MMC_Q_SET_MMC_GLOBAL_ENABLES
#define MMC10_S_SET_MMC_GLOBAL_ENABLES  MMC_Q_SET_MMC_GLOBAL_ENABLES
#define MMC09_Q_GET_MMC_GLOBAL_ENABLES  MMC_Q_SET_MMC_GLOBAL_ENABLES
#define MMC10_Q_GET_MMC_GLOBAL_ENABLES  MMC_Q_SET_MMC_GLOBAL_ENABLES
#define	Mmc09QGetMmcGlobalEnables       MmcQSetMmcGlobalEnables
#define	Mmc10QGetMmcGlobalEnables       MmcQSetMmcGlobalEnables
#define MMC09_S_GET_MMC_GLOBAL_ENABLES  MMC_Q_SET_MMC_GLOBAL_ENABLES
#define MMC10_S_GET_MMC_GLOBAL_ENABLES  MMC_Q_SET_MMC_GLOBAL_ENABLES


/* MMC_RESET_WATCHDOG_TIMER [all] */
typedef void MMC_Q_RESET_WATCHDOG_TIMER;

typedef struct MmcSResetWatchdogTimer {
    UINT8   completionCode;     /* IMB_CC_ */
} MMC_S_RESET_WATCHDOG_TIMER;


/* MMC_..._WATCHDOG_TIMER [all] */
/* definitions for the use bytes in the following commands */
#define MMC_WD_DONT_LOG         0x80
#define MMC_WD_TIMER_RUNNING    0x40
#define MMC_WD_USAGE_BIOS_FRB2  0x01
#define MMC_WD_USAGE_BIOS_POST  0x02
#define MMC_WD_USAGE_OS_LOAD    0x03
#define MMC_WD_USAGE_SMS_OS     0x04
#define MMC_WD_USAGE_OEM        0x05
#define MMC_WD_USAGE_MAX        MMC_WD_USAGE_OEM
#define MMC_WD_USAGE_MASK       0x07
#define MMC_WD_USEAGE_RESERVED  0x87  /* and with useage to zero out reserved bits */

/* definitions for the actions bytes in the following commands */
#define MMC_WD_PRE_TIMEOUT_NONE 0x00
#define MMC_WD_PRE_TIMEOUT_SMI  0x10
#define MMC_WD_PRE_TIMEOUT_SCI  0x20
#define MMC_WD_PRE_TIMEOUT_IRQ  0x30
#define MMC_WD_PRE_TIMEOUT_MAX  MMC_WD_PRE_TIMEOUT_SMI /* SCI nor IRQ allowed */
#define MMC_WD_PRE_TIMEOUT_MASK 0x70
#define MMC_WD_ACTION_NONE      0x00
#define MMC_WD_ACTION_HARD_RESET 0x01
#define MMC_WD_ACTION_POWER_OFF 0x02
#define MMC_WD_ACTION_POWER_CYCLE 0x03
#define MMC_WD_ACTION_MAX       MMC_WD_ACTION_POWER_CYCLE
#define MMC_WD_ACTION_MASK      0x07
/* definitions for the useExpirationBits bytes in the following commands */
#define MMC_WD_USE_BITS_BIOS_FRB2 0x02
#define MMC_WD_USE_BITS_BIOS_POST 0x04
#define MMC_WD_USE_BITS_OS_LOAD 0x08
#define MMC_WD_USE_BITS_SMS_OS  0x10
#define MMC_WD_USE_BITS_OEM     0x20
#define MMC_WD_USE_BITS_MASK    ( MMC_WD_USE_BITS_BIOS_FRB2 |     \
                                MMC_WD_USE_BITS_BIOS_POST |     \
                                MMC_WD_USE_BITS_OS_LOAD |       \
                                MMC_WD_USE_BITS_SMS_OS |        \
                                MMC_WD_USE_BITS_OEM )

/* MMC_SET_WATCHDOG_TIMER [all] */
typedef struct MmcQSetWatchdogTimer {
    UINT8   use;
    UINT8   actions;
    UINT8   preTimeoutInterval; /* 1 second/count */
    UINT8   useExpirationBitsClear;
    UINT16  initialCountdownValue; /* 100 milliseconds/count */
} MMC_Q_SET_WATCHDOG_TIMER;

typedef struct MmcSSetWatchdogTimer {
    UINT8   completionCode;     /* IMB_CC_ */
} MMC_S_SET_WATCHDOG_TIMER;


/* MMC_GET_WATCHDOG_TIMER [all] */
typedef void MMC_Q_GET_WATCHDOG_TIMER;

typedef struct MmcSGetWatchdogTimer {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   use;
    UINT8   actions;
    UINT8   preTimeoutInterval; /* 1 second/count */
    UINT8   useExpirationBits;
    UINT16  initialCountdownValue; /* 100 milliseconds/count */
    UINT16  presentCountdownValue; /* 100 milliseconds/count */
} MMC_S_GET_WATCHDOG_TIMER;


/* MMC_..._INTERRUPT_FLAGS [0.9] */
/* definition for the flags byte in the following commands */
#define MMC_IF_FP_NMI_FLAG      0x40
#define MMC_IF_SMM_MSG_FLAG     0x20
#define MMC_IF_WD_PRE_SMI_FLAG  0x08
#define MMC_IF_SMS_MSG_FLAG     0x04
#define MMC_IF_EVENT_MSG_FLAG   0x01

/* MMC_CLEAR_INTERRUPT_FLAGS [0.9] */
typedef struct Mmc09QClearInterruptFlags {
    UINT8   flags;
} MMC09_Q_CLEAR_INTERRUPT_FLAGS;

typedef struct Mmc09SClearInterruptFlags {
    UINT8   completionCode;     /* IMB_CC_ */
} MMC09_S_CLEAR_INTERRUPT_FLAGS;


/* MMC_GET_INTERRUPT_FLAGS [0.9] */
typedef void MMC09_Q_GET_INTERRUPT_FLAGS;

typedef struct Mmc09SGetInterruptFlags {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   flags;
} MMC09_S_GET_INTERRUPT_FLAGS;

#if defined(IPMI_VER_09)
#define MmcQClearInterruptFlags              Mmc09QClearInterruptFlags
#define MMC_Q_CLEAR_INTERRUPT_FLAGS          MMC09_Q_CLEAR_INTERRUPT_FLAGS
#define MmcSClearInterruptFlags              Mmc09SClearInterruptFlags
#define MMC_S_CLEAR_INTERRUPT_FLAGS          MMC09_S_CLEAR_INTERRUPT_FLAGS
#define MMC_Q_GET_INTERRUPT_FLAGS            MMC09_Q_GET_INTERRUPT_FLAGS
#define MMC_S_GET_INTERRUPT_FLAGS            MMC09_S_GET_INTERRUPT_FLAGS
#define MmcSGetInterruptFlags                Mmc09SGetInterruptFlags
#endif


/* MMC_..._MESSAGE_FLAGS [1.0] */
/* definition of message flags for the following commands */
#define MMC_MF_OEM2_FLAG          0x80
#define MMC_MF_OEM1_FLAG          0x40
#define MMC_MF_OEM0_FLAG          0x20
/* our definitions for OEM flags */
#define MMC_MF_SMM_BUFFER_FLAG    MMC_MF_OEM0_FLAG
//define reserved                 0x10
#define MMC_MF_PRETIMEOUT_INTERRUPT_FLAG 0x08
//define reserved                 0x04
#define MMC_MF_EVM_BUFFER_FLAG    0x02
#define MMC_MF_REC_MSG_QUEUE_FLAG 0x01

/* MMC_CLEAR_MESSAGE_FLAGS [1.0] */
typedef struct Mmc10QClearMessageFlags {
    UINT8   flags;
} MMC10_Q_CLEAR_MESSAGE_FLAGS;

typedef struct Mmc10SClearMessageFlags {
    UINT8   completionCode;     /* IMB_CC_ */
} MMC10_S_CLEAR_MESSAGE_FLAGS;


/* MMC_GET_MESSAGE_FLAGS [1.0] */
typedef void MMC10_Q_GET_MESSAGE_FLAGS;

typedef struct Mmc10SGetMessageFlags {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   flags;
} MMC10_S_GET_MESSAGE_FLAGS;

#if defined(IPMI_VER_10)
#define MmcQClearMessageFlags             Mmc09QClearInterruptFlags
#define MMC_Q_CLEAR_MESSAGE_FLAGS         MMC09_Q_CLEAR_INTERRUPT_FLAGS
#define MmcSClearMessageFlags             Mmc09SClearInterruptFlags
#define MMC_S_CLEAR_MESSAGE_FLAGS         MMC09_S_CLEAR_INTERRUPT_FLAGS
#define MmcQGetMessageFlags               Mmc09QGetInterruptFlags
#define MMC_Q_GET_MESSAGE_FLAGS           MMC09_Q_GET_INTERRUPT_FLAGS
#define MmcSGetMessageFlags               Mmc09SGetInterruptFlags
#define MMC_S_GET_MESSAGE_FLAGS           MMC09_S_GET_INTERRUPT_FLAGS
#endif


/* MMC_ENABLE_MSG_CHANNEL_REC [1.0] */
#define MMC_EMCR_DISABLE_CHANNEL        0x00
#define MMC_EMCR_ENABLE_CHANNEL         0x01
#define MMC_EMCR_GET_CHANNEL_STATUS     0x02
#define MMC_EMCR_CHANNEL_ENABLED        0x01

#define CHANNEL_ENABLE_BIT    0x01
#define CHANNEL_HAS_DATA_BIT  0x02

#define MMC_SMS_CHANNEL                 0x00
#define MAX_CHANNEL_DEFINED     MMC_SMS_CHANNEL
#define SLOTS_PER_CHANNEL               0x02
#define MESSAGE_SLOTS           (MAX_CHANNEL_DEFINED * SLOTS_PER_CHANNEL) + 2

/* MMC_ENABLE_MSG_CHANNEL_REC [1.0] */
typedef struct Mmc10QEnableMsgChannelRec {
    UINT8   channelNumber;
    UINT8   action;
} MMC10_Q_ENABLE_MSG_CHANNEL_REC;

typedef struct Mmc10SEnableMsgChannelRec {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   channelNumber;
    UINT8   channelState;
} MMC10_S_ENABLE_MSG_CHANNEL_REC;

#if defined(IPMI_VER_10)
#define MmcQEnableMsgChannelRec         Mmc10QEnableMsgChannelRec
#define MMC_Q_ENABLE_MSG_CHANNEL_REC    MMC10_Q_ENABLE_MSG_CHANNEL_REC
#define MmcSEnableMsgChannelRec         Mmc10SEnableMsgChannelRec
#define MMC_S_ENABLE_MSG_CHANNEL_REC    MMC10_S_ENABLE_MSG_CHANNEL_REC
#endif


/* MMC_..._MESSAGE [1.0] */
/* MMC_GET_MESSAGE */
typedef void MMC10_Q_GET_MESSAGE;

typedef struct Mmc10SGetMessaage {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   channelNumber;
    UINT8   messageBytes[34];                  /* !!!!! check this number for max length */
} MMC10_S_GET_MESSAGE;

/* MMC_SEND_MESSAGE */
typedef struct Mmc10QSendMessage {
    UINT8   channelNumber;
    UINT8   messageBytes[34];                  /* !!!!! check this number for max length */
} MMC10_Q_SEND_MESSAGE;

typedef struct Mmc10SSendMessage {
    UINT8   completionCode;     /* IMB_CC_ */
} MMC10_S_SEND_MESSAGE;

#if defined(IPMI_VER_10)
#define MMC_Q_GET_MESSAGE               MMC10_Q_GET_MESSAGE
#define MmcSGetMessage                  Mmc10SGetMessage
#define MMC_S_GET_MESSAGE               MMC10_S_GET_MESSAGE
#define MmcQSendMessage                 Mmc10QSendMessage
#define MMC_Q_SEND_MESSAGE              MMC10_Q_SEND_MESSAGE
#define MmcSSendMessage                 Mmc10SSendMessage
#define MMC_S_SEND_MESSAGE              MMC10_S_SEND_MESSAGE
#endif


/* MMC_READ_EVENT_MESSAGE_BUFFER [all] */
typedef void MMC_Q_READ_EVENT_MESSAGE_BUFFER;

typedef struct MmcSReadEventMessageBuffer {
    UINT8   completionCode;     /* IMB_CC_ */
    struct MmcSmxMessage eventMessage;
} MMC_S_READ_EVENT_MESSAGE_BUFFER;


/* MMC_READ_SMM_MESSAGE_BUFFER [0.9, 1.0(OEM)] */
typedef void MMC_Q_READ_SMM_MESSAGE_BUFFER;

typedef struct MmcSReadSmmMessageBuffer {
    UINT8   completionCode;     /* IMB_CC_ */
    struct MmcSmxMessage smmMessage;
} MMC_S_READ_SMM_MESSAGE_BUFFER;

/* MMC_READ_SMS_MESSAGE_BUFFER [0.9] */
typedef void MMC09_Q_READ_SMS_MESSAGE_BUFFER;

typedef struct Mmc09SReadSmsMessageBuffer {
    UINT8   completionCode;     /* IMB_CC_ */
    struct MmcSmxMessage smsMessage;
} MMC09_S_READ_SMS_MESSAGE_BUFFER;

#if defined(IPMI_VER_09)
#define MMC_Q_READ_SMS_MESSAGE_BUFFER   MMC09_Q_READ_SMS_MESSAGE_BUFFER
#define MmcSReadSmsMessageBuffer        Mmc09SReadSmsMessageBuffer
#define MMC_S_READ_SMS_MESSAGE_BUFFER   MMC09_S_READ_SMS_MESSAGE_BUFFER
#endif


/* MMC_MASTER_..._I2C */
#define MMC_I2C_BI_PUBLIC               0x00    /* IMB */
#define MMC_I2C_BI_PRIVATE              0x01

/* MMC_MASTER_WRITE_I2C [0.9] */
typedef struct Mmc09QMasterWriteI2C {
    UINT8   busId;              /* MMC_I2C_BI_ */
    UINT8   slaveAddress;
    UINT8   writeData[IMB_MAX_I2C_CMD_LEN-1];
} MMC09_Q_MASTER_WRITE_I2C;

typedef struct Mmc09SMasterWriteI2C {
    UINT8   completionCode;     /* IMB_CC_ */
} MMC09_S_MASTER_WRITE_I2C;


/* MMC_MASTER_READ_I2C [0.9] */
typedef struct Mmc09QMasterReadI2C {
    UINT8   busId;              /* MMC_I2C_BI_ */
    UINT8   slaveAddress;
    UINT8   numberOfBytesToRead;
} MMC09_Q_MASTER_READ_I2C;

typedef struct Mmc09SMasterReadI2C {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   readData[IMB_MAX_DATA_LEN-1];
} MMC09_S_MASTER_READ_I2C;

#if defined(IPMI_VER_09)
#define MmcQMasterWriteI2C              Mmc09QMasterWriteI2C
#define MMC_Q_MASTER_WRITE_I2C          MMC09_Q_MASTER_WRITE_I2C
#define MmcSMasterWriteI2C              Mmc09SMasterWriteI2C
#define MMC_S_MASTER_WRITE_I2C          MMC09_S_MASTER_WRITE_I2C
#define MmcQMasterReadI2C               Mmc09QMasterReadI2C
#define MMC_Q_MASTER_READ_I2C           MMC09_Q_MASTER_READ_I2C
#define MmcSMasterReadI2C               Mmc09SMasterReadI2C
#define MMC_S_MASTER_READ_I2C           MMC09_S_MASTER_READ_I2C
#endif


/* MMC_MASTER_WRITE_READ_I2C [all] */
typedef struct MmcQMasterWriteReadI2C
{
    UINT8   busId;              /* MMC_I2C_BI_ */
    UINT8   slaveAddress;
    UINT8   numberOfBytesToRead;
    UINT8   writeData[IMB_MAX_DATA_LEN+12];   /* IPMI 1.0 allows 34 bytes */
} MMC_Q_MASTER_WRITE_READ_I2C;

typedef struct MmcSMasterWriteReadI2C
{
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   readData[IMB_MAX_DATA_LEN+12];  /* IPMI 1.0 allows 33 bytes */
} MMC_S_MASTER_WRITE_READ_I2C;

#endif  /* _MMC_CMD_H_ */
