/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/**************************************************************************
**  Copyright (C) 1997-1999, Hewlett-Packard Co. All rights reserved.
**
**  File name:  oem_cmd.h
**  Summary:    OEM Command Definitions
**  Owner:      Myron Tuttle
**
**************************************************************************/

#ifndef _OEM_CMD_H_
#define _OEM_CMD_H_

#include    "imb_std.h" /* IMB OS-Dependent Standard Types */

/* App NetFn (IMB_NF_APP) commands  */
#define OEM_SET_I2C_ACCESS_CONTROL          0xC2
#define OEM_GET_I2C_ACCESS_CONTROL          0xC3

#define OEM_SET_I2C_BUS_ACTIVITY_CONTROL    0xC4
#define OEM_GET_I2C_BUS_ACTIVITY_CONTROL    0xC5

#define OEM_QUERY_POWER                     0xC6
#define OEM_GET_RPS_ID                      0xC7

#define OEM_SET_AOL2_ACTIVITY_CONTROL		0xC8
#define OEM_GET_AOL2_ACTIVITY_CONTROL		0xC9


#define MMC10_READ_SMM_MESSAGE_BUFFER       0xCA    /* 1.0 */
#define OEM_GET_BOOT_BLOCK_ID               0xCB

#define OEM_NOTIFY_INTRUSION_STATE          0xCC
#define OEM_SET_INTRUSION_ALARM_STATUS      0xCD
#define OEM_GET_INTRUSION_ALARM_STATUS      0xCE

#define OEM_GET_PRODUCT_ID                  0xCF

#define OEM_SET_LEDS						0xDE
#define OEM_GET_LEDS						0xDF

#if defined(IPMI_VER_10)
#define MMC_READ_SMM_MESSAGE_BUFFER         MMC10_READ_SMM_MESSAGE_BUFFER
#endif

/* Sensor/Event NetFn (IMB_NF_SENSOR_) Event Commands */
#define OEM_EVNT_LOG_ECC_ERROR              0xC2    /* OEM command */
#define OEM_EVNT_GET_QUEUE_POINTERS         0xC4    /* OEM debug command */
#define OEM_EVNT_GET_QUEUE_DATA             0xC5    /* OEM debug command */



/* OEM_xET_I2C_ACCESS_CONTROL */
/* defines to implement backwards compatability w/ old names */
#define OemQSetI2cControl       OemQSetI2cAccessControl
#define OEM_Q_SET_I2C_CONTROL       OEM_Q_SET_I2C_ACCESS_CONTROL
#define OemSSetI2cControl       OemSSetI2cAccessControl
#define OEM_S_SET_I2C_CONTROL       OEM_S_SET_I2C_ACCESS_CONTROL
#define OEM_Q_GET_I2C_CONTROL       OEM_Q_GET_I2C_ACCESS_CONTROL
#define OemSGetI2cControl       OemSGetI2cAccessControl
#define OEM_S_GET_I2C_CONTROL       OEM_S_GET_I2C_ACCESS_CONTROL

/* define the bit which controls I2C access */
#define OEM_I2C_ACCESS_ENABLE  0x01
#define OEM_I2C_ACCESS_DISABLE  0x00

/* OEM_SET_I2C_ACCESS_CONTROL */
typedef struct OemQSetI2cAccessControl {
    UINT8   control;        /* OEM_I2C_ACCESS_ */
} OEM_Q_SET_I2C_ACCESS_CONTROL;

typedef struct OemSSetI2cAccessControl {
    UINT8   completionCode; /* IMB_CC_ */
} OEM_S_SET_I2C_ACCESS_CONTROL;


/* OEM_SET_I2C_ACCESS_CONTROL */
typedef void OEM_Q_GET_I2C_CONTROL;

typedef struct OemSGetI2cControl {
    UINT8   completionCode; /* IMB_CC_ */
    UINT8   control;        /* OEM_I2C_ACCESS_ */
} OEM_S_GET_I2C_CONTROL;


/* OEM_SET_I2C_BUS_ACTIVITY_CONTROL */
typedef struct OemQSetI2cBusActivityControl {
    UINT8   control;
} OEM_Q_SET_I2C_BUS_ACTIVITY_CONTROL;

typedef struct OemSSetI2cBusActivityControl {
    UINT8   completionCode; /* IMB_CC_ */
} OEM_S_SET_I2C_BUS_ACTIVITY_CONTROL;


/* OEM_GET_I2C_BUS_ACTIVITY_CONTROL */
typedef void OEM_Q_GET_I2C_BUS_ACTIVITY_CONTROL;

typedef struct OemSGetI2cBusActivityControl {
    UINT8   completionCode; /* IMB_CC_ */
    UINT8   control;
} OEM_S_GET_I2C_BUS_ACTIVITY_CONTROL;


/* OEM_QUERY_POWER */
typedef void OEM_Q_QUERY_POWER;

#define OEM_QP_POWER_OFF    0x00
#define OEM_QP_POWER_ON     0x01

typedef struct OemSQueryPower {
    UINT8   completionCode; /* IMB_CC_ */
    UINT8   power;      /* OEM_QP_POWER_ */
} OEM_S_QUERY_POWER;


/* OEM_GET_RPS_ID */
typedef void OEM_Q_GET_RPS_ID;

typedef struct OemSGetRPSId {
    UINT8   completionCode; /* IMB_CC_ */
    UINT8   deviceType;     /* GLOB_GDI_DT_ */
    UINT8   deviceRevision;
    UINT8   firmwareRev1;
    UINT8   firmwareRev2;
    UINT8   sensorSpecRev;  /* GLOB_GDI_SSR_ */
    UINT8   ipmDeviceSupport;   /* GLOB_GDI_IDS_ */
} OEM_S_GET_RPS_ID;


/* OEM_EVNT_LOG_ECC_ERROR */
typedef struct OemEvntQLogEccError {
    UINT8   softwareId;
    UINT8   evmRev;
    UINT8   sensorType;
    UINT8   sensorNumber;
    UINT8   eventType;
    UINT8   eventData1;
    UINT8   eventData2;
    UINT8   eventData3;
    UINT8   timestampLow;
    UINT8   timestampHigh;
} OEM_EVNT_Q_LOG_ECC_ERROR;

typedef struct OemEvntSLogEccError {
    UINT8   completionCode; /* IMB_CC_ */
} OEM_EVNT_S_LOG_ECC_ERROR;


/* OEM_EVNT_GET_QUEUE_POINTERS */
#define EVENT_QUEUE     1

typedef struct OemEvntQGetQueuePointers {
    UINT8   whichQueue;     /* see above */
} OEM_EVNT_Q_GET_QUEUE_POINTERS;

typedef struct OemEvntSGetQueuePointers {
    UINT8   completionCode; /* IMB_CC_ */
    UINT16  queueStart;
    UINT16  queueEnd;
    UINT16  queueHead;
    UINT16  queueTail;
} OEM_EVNT_S_GET_QUEUE_POINTERS;


/* OEM_EVNT_GET_QUEUE_DATA */
typedef struct OemEvntQGetQueueData {
    UINT8  whichQueue;
    UINT8  numberBytes;
    UINT16 address;
} OEM_EVNT_Q_GET_QUEUE_DATA;

typedef struct OemEvntSGetQueueData {
    UINT8   completionCode; /* IMB_CC_ */
    UINT8  buffer[16];
} OEM_EVNT_S_GET_QUEUE_DATA;


/* OEM_GET_BOOT_BLOCK_ID */
typedef void OEM_Q_GET_BOOT_BLOCK_ID;

typedef struct OemSGetBootBlockId
{
    UINT8 completionCode;
    UINT8 DevRev;
    UINT8 FwRev1;
    UINT8 FwRev2;
} OEM_S_GET_BOOT_BLOCK_ID;

/* OEM_NOTIFY_INTRUSION_STATE */
typedef struct OemQNotifyIntrusionState
{
    UINT8   intrusionState;  /* 0, EVENT_ASSERTED, EVENT_DEASSERTED */
} OEM_Q_NOTIFY_INTRUSION_STATE;

typedef struct OemSNotifyIntrusionState
{
    UINT8   completionCode; /* IMB_CC_ */
} OEM_S_NOTIFY_INTRUSION_STATE;

/*  OEM_SET_INTRUSION_ALARM_STATUS  */
#define DISENABLE_INTRUSION_ALARM   0x00
#define ENABLE_INTRUSION_ALARM      0x01

typedef struct OemQSetIntrusionControlStatus
{
    UINT8 alarmStatus;
    UINT8 alarmDelay;
} OEM_Q_SET_INTRUSION_ALARM_STATUS;

typedef struct OemSSetIntrusionControlStatus
{
    UINT8   completionCode; /* IMB_CC_ */
} OEM_S_SET_INTRUSION_ALARM_STATUS;

/*  OEM_GET_INTRUSION_ALARM_STATUS  */
typedef void OEM_Q_GET_INTRUSION_ALARM_STATUS;

typedef struct OemSGetIntrusionControlStatus
{
    UINT8   completionCode; /* IMB_CC_ */
    UINT8 alarmStatus;
    UINT8 alarmDelay;
} OEM_S_GET_INTRUSION_ALARM_STATUS;

/*  OEM_GET_PRODUCT_ID  */
typedef void OEM_Q_GET_PRODUCT_ID;

typedef struct OemSGetProductId
{
    UINT8   completionCode; /* IMB_CC_ */
    UINT8   idStatus;       /* 0 if invalid, !0 if valid */
    UINT16  productId;
} OEM_S_GET_PRODUCT_ID;


/* AOL-2 Specific Structure Definitions
----------------------------------------*/

// SET Definitions
typedef struct
{
	UINT8 aolStatus ;

}OEM_Q_SET_AOL2_ACTIVITY_CONTROL ;

typedef struct
{
	UINT8 completionCode ; // IMB_CC_
}OEM_S_SET_AOL2_ACTIVITY_CONTROL ;


// GET Definitions

typedef void OEM_Q_GET_AOL2_ACTIVITY_CONTROL ;

typedef struct
{
	UINT8 completionCode ; // IMB_CC_
	UINT8 aolStatus ;
}OEM_S_GET_AOL2_ACTIVITY_CONTROL ;


#endif  /* _OEM_CMD_H_ */