/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/**************************************************************************
**  Copyright (C) 1997-1999, Hewlett-Packard Co. All rights reserved.
**
**  File name:  sdrr_cmd.h
**  Summary:    IMB SDR Repository Command Definitions
**
**************************************************************************/

#ifndef _SDRR_CMD_H_
#define _SDRR_CMD_H_

#include        "imb_std.h"     /* IMB OS-Dependent Standard Types */
#include        "imb_cmd.h"     /* IMB Common Command Definitions */

/* Storage NetFn (IMB_NF_STORAGE_) SDR Repository Commands */
#define SDRR_GET_SDR_REPOSITORY_INFO    0x20
#define SDRR_GET_SDR_REPOSITORY_ALLOCATION_INFO 0x21
#define SDRR_RESERVE_SDR_REPOSITORY     0x22
#define SDRR_GET_SDR                    0x23
#define SDRR_ADD_SDR                    0x24
#define SDRR_PARTIAL_ADD_SDR            0x25
#define SDRR_DELETE_SDR                 0x26
#define SDRR_CLEAR_SDR_REPOSITORY       0x27
#define SDRR_GET_SDR_REPOSITORY_TIME    0x28
#define SDRR_SET_SDR_REPOSITORY_TIME    0x29

#define SDRR10_ENTER_SDR_REPOSITORY_UPDATE_MODE 0x2A
#define SDRR10_EXIT_SDR_REPOSITORY_UPDATE_MODE 0x2B
#define SDRR10_RUN_INITIALIZATION_AGENT 0x2C

#if defined(IPMI_VER_10)
#define SDRR_ENTER_SDR_REPOSITORY_UPDATE_MODE \
                SDRR10_ENTER_SDR_REPOSITORY_UPDATE_MODE
#define SDRR_EXIT_SDR_REPOSITORY_UPDATE_MODE \
                SDRR10_EXIT_SDR_REPOSITORY_UPDATE_MODE
#define SDRR_RUN_INITIALIZATION_AGENT   SDRR10_RUN_INITIALIZATION_AGENT
#endif


/* SDRR_GET_SDR_REPOSITORY_INFO */
typedef void SDRR_Q_GET_SDR_REPOSITORY_INFO;

#define SDRR_GSRI_OS_OVERFLOW           0x80    /* out-of-space on last add */
#define SDRR_GSRI_OS_DELETE             0x08    /* _DELETE_ supported */
#define SDRR_GSRI_OS_PARTIAL_ADD        0x04    /* _PARTIAL_ADD_ supported */
#define SDRR_GSRI_OS_RESERVE            0x02    /* _RESERVE_ supported */
#define SDRR_GSRI_OS_GET_ALLOC_INFO     0x01    /* _GET_.._ALLOCATION_INFO_ " */

typedef struct SdrrSGetSdrRepositoryInfo {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   sdrVersion;
    UINT16  recordCount;
    UINT16  freeSpace;
    UINT32  mostRecentAdditionTimestamp;
    UINT32  mostRecentEraseTimestamp;
    UINT8   operationSupport;   /* SDRR_GSRI_OS_ */
} SDRR_S_GET_SDR_REPOSITORY_INFO;


/* SDRR_GET_SDR_REPOSITORY_ALLOCATION_INFO */
typedef void SDRR_Q_GET_SDR_REPOSITORY_ALLOCATION_INFO;

typedef struct SdrrSGetSdrRepositoryAllocationInfo {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT16  possibleAllocationUnits;
    UINT16  allocationUnitSize;
    UINT16  freeAllocationUnits;
    UINT16  largestFreeBlock;   /* in allocation units */
    UINT8   maxRecordSize;      /* in allocation units */
} SDRR_S_GET_SDR_REPOSITORY_ALLOCATION_INFO;


/* SDRR_RESERVE_SDR_REPOSITORY */
typedef void SDRR_Q_RESERVE_SDR_REPOSITORY;

typedef struct SdrrSReserveSdrRepository {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT16  reservationId;
} SDRR_S_RESERVE_SDR_REPOSITORY;


/* SDRR_GET_SDR */
typedef struct SdrrQGetSdr {
    UINT16  reservationId;
    UINT16  recordId;
    UINT8   offset;     /* offset into record */
    UINT8   bytes;      /* bytes to read. 0xff == all */
} SDRR_Q_GET_SDR;

typedef struct SdrrSGetSdr {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT16  nextRecordId;
    UINT8   sdrData[IMB_MAX_DATA_LEN-1];
} SDRR_S_GET_SDR;


/* SDRR_ADD_SDR */
typedef struct SdrrQAddSdr {
    UINT8   sdrData[IMB_MAX_DATA_LEN];
} SDRR_Q_ADD_SDR;

typedef struct SdrrSAddSdr {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT16  addedRecordId;
} SDRR_S_ADD_SDR;


/* SDRR_PARTIAL_ADD_SDR */
#define SDRR_PAS_O_LAST_RECORD  0x01    /* last record being transferred */

typedef struct SdrrQPartialAddSdr {
    UINT16  reservationId;
    UINT16  recordId;
    UINT8   offset;
    UINT8   options;    /* IMSPAS_O_ */
    UINT8   sdrData[IMB_MAX_DATA_LEN-6];
} SDRR_Q_PARTIAL_ADD_SDR;

typedef struct SdrrSPartialAddSdr {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT16  addedRecordId;
} SDRR_S_PARTIAL_ADD_SDR;


/* SDRR_DELETE_SDR */
typedef struct SdrrQDeleteSdr {
    UINT16  reservationId;
    UINT16  recordId;
} SDRR_Q_DELETE_SDR;

typedef struct SdrrSDeleteSdr {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT16  deletedRecordId;
} SDRR_S_DELETE_SDR;

#ifdef _DEBUG_SDRR_
typedef struct SdrrQGetSensorTable
{
    UINT8 sensorNumber;
}
SDRR_Q_GET_SENSOR_TABLE;

typedef struct SdrrSGetSensorTable
{
    UINT8 completionCode;
    UINT8 sensorData[32];
}
SDRR_S_GET_SENSOR_TABLE;
#endif

/* SDRR_CLEAR_SDR_REPOSITORY */
#define SDRR_CSR_A_INITIATE_ERASE       0xAA
#define SDRR_CSR_A_GET_ERASE_STATUS     0x00

typedef struct SdrrQClearSdrRepository {
    UINT16  reservationId;
    UINT8   password[3];        /* "CLR" */
    UINT8   action;             /* SDRR_CSR_A_ */
} SDRR_Q_CLEAR_SDR_REPOSITORY;

#define SDRR_CSR_EP_ERASURE_IN_PROGRESS 0x00
#define SDRR_CSR_EP_ERASE_COMPLETED     0x01

typedef struct SdrrSClearSdrRepository {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   erasureProgress;    /* SDRR_CSR_EP_ */
} SDRR_S_CLEAR_SDR_REPOSITORY;


/* SDRR_GET_SDR_REPOSITORY_TIME */
typedef void SDRR_Q_GET_SDR_REPOSITORY_TIME;

typedef struct SdrrSGetSdrRepositoryTime {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT32  time;
} SDRR_S_GET_SDR_REPOSITORY_TIME;


/* SDRR_SET_SDR_REPOSITORY_TIME */
typedef struct SdrrQSetSdrRepositoryTime {
    UINT32  time;
} SDRR_Q_SET_SDR_REPOSITORY_TIME;

typedef struct SdrrSSetSdrRepositoryTime {
    UINT8   completionCode;     /* IMB_CC_ */
} SDRR_S_SET_SDR_REPOSITORY_TIME;


/* SDRR_ENTER_UPDATE_MODE */
typedef void SDRR10_Q_ENTER_UPDATE_MODE;

typedef struct Sdrr10SEnterUpdateMode {
    UINT8   completionCode;     /* IMB_CC_ */
} SDRR10_S_ENTER_UPDATE_MODE;

#if defined(IPMI_VER_10)
#define SDRR_Q_ENTER_UPDATE_MODE        SDRR10_Q_ENTER_UPDATE_MODE
#define SdrrSEnterUpdateMode            Sdrr10SEnterUpdateMode
#define SDRR_S_ENTER_UPDATE_MODE        SDRR10_S_ENTER_UPDATE_MODE
#endif

/* SDRR_EXIT_UPDATE_MODE */
typedef void SDRR10_Q_EXIT_UPDATE_MODE;

typedef struct Sdrr10SExitUpdateMode {
    UINT8   completionCode;     /* IMB_CC_ */
} SDRR10_S_EXIT_UPDATE_MODE;

#if defined(IPMI_VER_10)
#define SDRR_Q_EXIT_UPDATE_MODE         SDRR10_Q_EXIT_UPDATE_MODE
#define SdrrSExitUpdateMode             Sdrr10SExitUpdateMode
#define SDRR_S_EXIT_UPDATE_MODE         SDRR10_S_EXIT_UPDATE_MODE
#endif

/* SDRR_RUN_INITIALIZATION_AGENT */
#define SDRR_RIA_RUN_AGENT              0x01
#define SDRR_RIA_GET_AGENT_PROGRESS     0x00
#define SDRR_RIA_INITIALIZATION_COMPLETE 0x01

typedef struct Sdrr10QRunInitializationAgent {
    UINT8   runOrGetProgress;
} SDRR10_Q_RUN_INITIALIZATION_AGENT;

typedef struct Sdrr10SQRunInitializationAgent {
    UINT8   completionCode;     /* IMB_CC_ */
    UINT8   initializationStatus;
} SDRR10_S_RUN_INITIALIZATION_AGENT;

#define SdrrQRunInitializationAgent     Sdrr10QRunInitializationAgent
#define SDRR_Q_RUN_INITIALIZATION_AGENT SDRR10_Q_RUN_INITIALIZATION_AGENT
#define SdrrSRunInitializationAgent     Sdrr10SRunInitializationAgent
#define SDRR_S_RUN_INITIALIZATION_AGENT SDRR10_S_RUN_INITIALIZATION_AGENT


/*----------------------------------------------------------------------
 * SDR Definition
 */


/***************** IPMI version 0.9 ***********************/
/*  Sensor Data Record -- Record Type */
/*      8-bit Analog/Digital/Discrete with Analog Thresholds */
#define SDR09_RT_8BIT_THRESHOLD         0x01
/*      Digital/Discrete with No Thresholds */
#define SDR09_RT_DIGITAL_DISCRETE       0x02
/*      IMB Device Locator */
#define SDR09_RT_DEVICE_LOCATOR         0x10
/*      BIOS Configuration 1 */
#define SDR09_RT_BIOS_CONFIG_1          0x20
/*      BIOS Configuration 2 */
#define SDR09_RT_BIOS_CONFIG_2          0x21
/*      BIOS Hard Disk Record */
#define SDR09_RT_HDD_INFO               0x22
/*      OEM Version Record */
#define SDR09_RT_OEM_VERSION            0xC0

#if defined(IPMI_VER_09)
#define SDR_RT_8BIT_THRESHOLD           SDR09_RT_8BIT_THRESHOLD
#define SDR_RT_DIGITAL_DISCRETE         SDR09_RT_DIGITAL_DISCRETE
#define SDR_RT_DEVICE_LOCATOR           SDR09_RT_DEVICE_LOCATOR
#define SDR_RT_BIOS_CONFIG_1            SDR09_RT_BIOS_CONFIG_1
#define SDR_RT_BIOS_CONFIG_2            SDR09_RT_BIOS_CONFIG_2
#define SDR_RT_HDD_INFO                 SDR09_RT_HDD_INFO
#define SDR_RT_OEM_VERSION              SDR09_RT_OEM_VERSION
#endif


/***************** IPMI version 1.0 ***********************/
/*  Sensor Data Record -- Record Type */
/*      8-bit Analog/Digital/Discrete with Analog Thresholds */
#define SDR10_RT_FULL_SENSOR_RECORD     0x01
/*      Compact sensor record - no analog reading supported  */
#define SDR10_RT_COMPACT_SENSOR_RECORD  0x02
/*      Associate entity with contents  */
#define SDR10_RT_ENTITY_ASSOCIATION_RECORD 0x08
/*      IMB Generic Device Locator */
#define SDR10_RT_GENERIC_DEVICE_LOCATOR 0x10
/*      Locate FRU devices  */
#define SDR10_RT_FRU_DEVICE_LOCATOR     0x11
/*      Locate management controller devices */
#define SDR10_RT_MANAGEMENT_CONTROLLER_LOCATOR 0x12
/*      Confirm controller still present */
#define SDR10_RT_MANAGEMENT_CONTROLLER_CONFIRMATION 0x13
/*      Define message channel information */
#define SDR10_RT_MMC_MESSAGE_CHANNEL_INFO 0x14
/*      OEM Version Record */
#define SDR10_RT_OEM_VERSION            0xC0

#if defined(IPMI_VER_10)
#define SDR_RT_FULL_SENSOR_RECORD       SDR10_RT_FULL_SENSOR_RECORD
#define SDR_RT_COMPACT_SENSOR_RECORD    SDR10_RT_COMPACT_SENSOR_RECORD
#define SDR_RT_ENTITY_ASSOCIATION_RECORD SDR10_RT_ENTITY_ASSOCIATION_RECORD
#define SDR_RT_GENERIC_DEVICE_LOCATOR   SDR10_RT_GENERIC_DEVICE_LOCATOR
#define SDR_RT_FRU_DEVICE_LOCATOR       SDR10_RT_FRU_DEVICE_LOCATOR
#define SDR_RT_MANAGEMENT_CONTROLLER_LOCATOR \
                SDR10_RT_MANAGEMENT_CONTROLLER_LOCATOR
#define SDR_RT_MANAGEMENT_CONTROLLER_CONFIRMATION \
                SDR10_RT_MANAGEMENT_CONTROLLER_CONFIRMATION
#define SDR_RT_MMC_MESSAGE_CHANNEL_INFO SDR10_RT_MMC_MESSAGE_CHANNEL_INFO
#define SDR_RT_OEM_VERSION              SDR10_RT_OEM_VERSION
#endif


/*  IMB/I2C Device Type Codes */
/*      IMB Device (microcontroller) */
#define SDR_DT_IMB_DEVICE               0x00

/*  IMB/I2C Device Type Modifiers */
/*    SDR_DT_IMB_DEVICE */
#define SDR_DTM_SEL_DEVICE              0x20
#define SDR_DTM_SDR_REPOSITORY_DEVICE   0x10
#define SDR_DTM_PRIMARY_EVENT_RECEIVER  0x08 /* (only one allowed) */
#define SDR_DTM_EVENT_RECEIVER          0x04
#define SDR_DTM_XIMB_BRIDGE             0x02
#define SDR_DTM_FIRMWARE_TRANSFER_SUPPORT 0x01

/*
 *  SDR Record
 *
 *  Platform Sensor and Event Interface EPS, V1.0 R0.83 S15
 */

#define SDR_NUM_THRESHOLDS     0x06    /* number of thresholds supported */
#define SDR_UPPER_NONRECOVER   0x00    /* indices into thresholds[]      */
#define SDR_UPPER_CRITICAL     0x01
#define SDR_UPPER_NONCRITICAL  0x02
#define SDR_LOWER_NONRECOVER   0x03
#define SDR_LOWER_CRITICAL     0x04
#define SDR_LOWER_NONCRITICAL  0x05

/* define bit (masks) for the Sensor Owner Id byte */
#define SDR_ADDRESS           0xFE
#define SDR_OWNER_ID          0x01    /* mask for system software owner */

/* definition of bits in the Sensor Initialization byte */
#define SDR_SENSOR_INIT      0x80
#define SDR_INIT_SCAN        0x40
#define SDR_INIT_EVM         0x20
#define SDR_INIT_THRESHOLDS  0x10

/* device type codes and modifiers used in locator records */
#define IMB_DT_IMB_DEVICE             0x00
#define IMB_DTM_SEL_DEVICE            0x20
#define IMB_DTM_SDRR_DEVICE           0x10
#define IMB_DTM_EVENT_RECEIVER        0x08
#define IMB_DTM_EVENT_GENERATOR       0x04
#define IMB_DTM_XIMB_BRIDGE           0x02
#define IMB_DTM_FIRMWARE_XFR_SUPPORT  0x01

#define IMB_DT_SMM_IMB_DEVICE         0x01

/* definitions for the fields in the SDRs */
/*****************************************************************************
**  These tables are used to interpret the byte and bit field in Sensor
**  Records.
*****************************************************************************/

#if defined(IPMI_VER_09)
#define SDR_VERSION                     0x90       /* version 0.9 */
#endif
#if defined(IPMI_VER_10)
#define SDR_VERSION                     0x01       /* version 1.0 */
#endif


/********* Management Controller Device Locater Record Table *****/  /* version 1.0 only */
#define MDLR_PSN_ACPI_SYS_STAT_NOTIF_REQ  (0x01 << 7)
#define MDLR_PSN_ACPI_DEV_STAT_NOTIF_REQ  (0x01 << 6)
#define MDLR_GI_CTLR_LOG_INIT_AGENT_ERRS  (0x01 << 3)
#define MDLR_GI_LOG_INIT_AGENT_ERRS_HERE  (0x01 << 2)
#define MDLR_GI_ENABLE_EVM                0x00
#define MDLR_GI_DISABLE_EVM               0x01
#define MDLR_GI_NO_INITIALIZE             0x10
#define MDLR_GI_INIT_MASK                 0x03

#define MDLR_DC_CHASSIS_DEVICE          (0x01 << 7)
#define MDLR_DC_BRIDGE                  (0x01 << 6)
#define MDLR_DC_EVENT_GENERATOR         (0x01 << 5)
#define MDLR_DC_EVENT_RECEIVER          (0x01 << 4)
#define MDLR_DC_FRU_DEVICE              (0x01 << 3)
#define MDLR_DC_SEL_DEVICE              (0x01 << 2)
#define MDLR_DC_SDRR_DEVICE             (0x01 << 1)
#define MDLR_DC_SENSOR_DEVICE           (0x01

/******** MMC Message Channel Info Table *******/
#define MCI_TRANSMIT_SUPPORTED          (0x01 << 7)
#define MCI_RECEIVE_LUN0                (0x00 << 4)
#define MCI_RECEIVE_LUN1                (0x01 << 4)
#define MCI_RECEIVE_LUN2                (0x02 << 4)
#define MCI_RECEIVE_LUN3                (0x03 << 4)
#define MCI_RECEIVE_NONE                (0x07 << 4)
#define MCI_RECEIVE_LUN_MASK            (0x07 << 4)
#define MCI_RECIEVE_LUN_SHIFT           0x04

#define MCI_CHANNEL_PROTOCOL_NONE       0x00
#define MCI_CHANNEL_PROTOCOL_IPMB       0x01
#define MCI_CHANNEL_PROTOCOL_ICMB_10    0x02
#define MCI_CHANNEL_PROTOCOL_ICMB_09    0x03
#define MCI_CHANNEL_PROTOCOL_SMBUS      0x04
#define MCI_CHANNEL_PROTOCOL_SYS_FMT    0x05
#define MCI_CHANNEL_PROTOCOL_OEM1       0x0C
#define MCI_CHANNEL_PROTOCOL_OEM2       0x0D
#define MCI_CHANNEL_PROTOCOL_OEM3       0x0E
#define MCI_CHANNEL_PROTOCOL_OEM4       0x0F
#define MCI_CHANNEL_PROTOCOL_MASK       0x0F

/*********  Sensor Initialization Table **********/
#define SI_INIT_SENSOR                  (0x01 << 7)   /* version 0.9 only */
#define SI_ENABLE_SCAN                  (0x01 << 6)
#define SI_ENABLE_EVM                   (0x01 << 5)
#define SI_THRESHOLD_INIT_REQD          (0x01 << 4)
#define SI_INIT_HYSTERISIS              (0x01 << 3)   /* version 1.0 only */
#define SI_INIT_SENSOR_TYPE             (0x01 << 2)   /* version 1.0 only */
#define SI_EVM_ENBLD_ON_PWR_UP          (0x01 << 1)
#define SI_SCAN_ENBLD_ON_PWR_UP         0x01

/*********  Sensor Capabilities Table **********/
#define SC_HYSTERISIS_SETABLE           (0x01 << 7)  /* version 0.9 only */
#define SC_IGNORE_BY_ENTITY             (0x01 << 7)  /* version 1.0 only */

#define SC_AUTO_REARM                   (0x01 << 6)

   /* present reading support -- choose one */    /* version 0.9 only */
#define SC_PRES_READING_NOT_SPECD       (0x01 << 4)
#define SC_DIGITAL_DESCRETE             (0x02 << 4)
#define SC_ANALOG                       (0x03 << 4)

   /* sensor hysterisis support -- choose one */   /* version 1.0 only */
#define SC_HS_NO_HYSTERISIS             0x00
#define SC_HS_READABLE                  (0x01 << 4)
#define SC_HS_READABLE_AND_SETTABLE     (0x02 << 4)
#define SC_HS_FIXED_UNREADABLE          (0x03 << 4)

   /* event message generation -- choose one */    /* version 0.9 only */
#define SC_EVM_TYPE_NOT_SPECD           (0x01 << 2)
#define SC_EVM_PER_BASE_AND_MASK        (0x02 << 2)

   /* sensor threshold access support -- choose one */ /* version 1.0 only */
#define SC_TAS_NO_THRESHOLDS            0x00
#define SC_TAS_READABLE                 (0x01 << 2)
#define SC_TAS_READABLE_AND_SETTABLE    (0x02 << 2)
#define SC_TAS_FIXED_UNREADABLE         (0x03 << 2)

   /* event message shutdown -- choose one */
#define SC_PER_THRESHOLD                0x00
#define SC_ENTIRE_SENSOR                0x01
#define SC_GLOBAL_ONLY                  0x02
#define SC_NO_EVENTS                    0x03

/*********  Event/Reading Base Types Table **********/
/* base type -- choose one */
#define ER_THRESHOLD                    0x01
#define    LNC_GL_BIT                   0x01
#define    LNC_GH_BIT                   (0x01 << 1)
#define    LC_GL_BIT                    (0x01 << 2)
#define    LC_GH_BIT                    (0x01 << 3)
#define    LNR_GL_BIT                   (0x01 << 4)
#define    LNR_GH_BIT                   (0x01 << 5)
#define    UNC_GL_BIT                   (0x01 << 6)
#define    UNC_GH_BIT                   (0x01 << 7)
#define    UC_GL_BIT                    (0x01 << 8)
#define    UC_GH_BIT                    (0x01 << 9)
#define    UNR_GL_BIT                   (0x01 << 10)
#define    UNR_GH_BIT                   (0x01 << 11)
#define ER_DESC_USAGE_STATE             0x02
#define    TR_IDLE_BIT                  0x01
#define    TR_ACTIVE_BIT                (0x01 << 1)
#define    TR_BUSY_BIT                  (0x01 << 2)
#define ER_DIGITAL_STATE                0x03
#define    ST_DEASSERTED_BIT            0x01
#define    ST_ASSERTED_BIT              (0x01 << 1)
#define ER_DIGITAL_PREDICTIVE_FAIL      0x04
#define    PF_DEASSERTED_BIT            0x01
#define    PF_ASSERTED_BIT              (0x01 << 1)
#define ER_DIGITAL_LIMIT                0x05
#define    LIMIT_NOT_EXCEEDED_BIT       0x01
#define    LIMIT_EXCEEDED_BIT           (0x01 << 1)
#define ER_DIGITAL_PERFORMANCE          0x06
#define    PERFORMANCE_MET_BIT          0x01
#define    PERFORMANCE_LAGS_BIT         (0x01 << 1)
#define ER_DESC_SEVERITY                0x07
#define    TR_TO_OK_BIT                 0x01
#define    TR_OK_TO_NC_BIT              (0x01 << 1)
#define    TR_LS_TO_C_BIT               (0x01 << 2)
#define    TR_LS_TO_NR_BIT              (0x01 << 3)
#define    TR_MS_TO_NC_BIT              (0x01 << 4)
#define    TR_NR_TO_C_BIT               (0x01 << 5)
#define    TR_TO_NR_BIT                 (0x01 << 6)
#define    MONITOR_BIT                  (0x01 << 7)
#define    INFORMATIONAL_BIT            (0x01 << 8)
#define ER_DIGITAL_REMOVAL              0x08
#define    DEV_REMOVED_BIT              0x01
#define    DEV_INSERTED_BIT             (0x01 << 1)
#define ER_DIGITAL_DISABLE              0x09
#define    DEV_DISABLED_BIT             0x01
#define    DEV_ENABLED_BIT              (0x01 << 1)
#define ER_DESC_AVAILABILITY            0x0A
#define    TR_TO_RUNNING_BIT            0x01
#define    TR_TO_TEST_BIT               (0x01 << 1)
#define    TR_TO_PWR_OFF_BIT            (0x01 << 2)
#define    TR_TO_ONLINE_BIT             (0x01 << 3)
#define    TR_TO_OFFLINE_BIT            (0x01 << 4)
#define    TR_TO_OFFDUTY_BIT            (0x01 << 5)
#define    TR_TO_DEGRADED_BIT           (0x01 << 6)
#define    TR_TO_POWER_SAVE_BIT         (0x01 << 7)
#define    INSTALL_ERROR_BIT            (0x01 << 8)
#define ER_DESC_REDUNDANCY              0x0B
#define    REDUN_REGAINED_BIT           0x01
#define    REDUN_LOST_BIT               (0x01 << 1)
#define    REDUN_DEGRADED_BIT           (0x01 << 2)

/*********  Sensor Units 1 Table **********/
/* raw data format -- choose one */
#define DF_UNSIGNED                     0x00h
#define DF_SIGNED_1S_COMP               (0x01 << 6)
#define DF_SIGNED_2S_COMP               (0x02 << 6)

/* rate units -- choose one */
#define RU_MICROSECONDS                 (0x01 << 3)
#define RU_MILLISECONDS                 (0x02 << 3)
#define RU_SECONDS                      (0x03 << 3)
#define RU_MINUTES                      (0x04 << 3)
#define RU_HOURS                        (0x05 << 3)
#define RU_DAYS                         (0x06 << 3)

/* modifier -- choose one */
#define SM_BASE_DIV_MOD                 (0x01 << 1)
#define SM_BASE_TIMES_MOD               (0x02 << 1)

/* percentage */
#define SU_PERCENTAGE                   0x01

/*********  Linearization Type Units Table **********/
#define LT_LINEAR                       0x00
#define LT_LN                           0x01
#define LT_LOG10                        0x02
#define LT_LOG2                         0x03
#define LT_EXP_E                        0x04
#define LT_EXP_10                       0x05
#define LT_EXP_2                        0x06
#define LT_ONE_OVER_X                   0x07
#define LT_SQUARE                       0x08
#define LT_CUBE                         0x09
#define LT_SQUARE_ROOT                  0x0A
#define LT_CUBE_ROOT                    0x0B

/*********  Threshold Table **********/
#define T_UPPER_NON_RECOVERABLE         (0x01 << 5)
#define T_UPPER_CRITICAL                (0x01 << 4)
#define T_UPPER_NON_CRITICAL            (0x01 << 3)
#define T_LOWER_NON_RECOVERABLE         (0x01 << 2)
#define T_LOWER_CRITICAL                (0x01 << 1)
#define T_LOWER_NON_CRITICAL            0x01

/*********  Assertion Mask Table *******/  /* version 1.0 only */
#define AM_LNR_COMPARISON_RETURNED      (0x01 << 14)
#define AM_LC_COMPARISON_RETURNED       (0x01 << 13)
#define AM_LNC_COMPARISON_RETURNED      (0x01 << 12)

#define AM_UNR_GH_SUPPORTED             (0x01 << 11)
#define AM_UNR_GL_SUPPORTED             (0x01 << 10)
#define AM_UC_GH_SUPPORTED              (0x01 << 9)
#define AM_UC_GL_SUPPORTED              (0x01 << 8)
#define AM_UNC_GH_SUPPORTED             (0x01 << 7)
#define AM_UNC_GL_SUPPORTED             (0x01 << 6)
#define AM_LNR_GH_SUPPORTED             (0x01 << 5)
#define AM_LNR_GL_SUPPORTED             (0x01 << 4)
#define AM_LC_GH_SUPPORTED              (0x01 << 3)
#define AM_LC_GL_SUPPORTED              (0x01 << 2)
#define AM_LNC_GH_SUPPORTED             (0x01 << 1)
#define AM_LNC_GL_SUPPORTED             0x01

/*********  Deassertion Mask Table *******/  /* version 1.0 only */
#define DM_UNR_COMPARISON_RETURNED      (0x01 << 14)
#define DM_UC_COMPARISON_RETURNED       (0x01 << 13)
#define DM_UNC_COMPARISON_RETURNED      (0x01 << 12)

#define DM_UNR_GH_SUPPORTED             (0x01 << 11)
#define DM_UNR_GL_SUPPORTED             (0x01 << 10)
#define DM_UC_GH_SUPPORTED              (0x01 << 9)
#define DM_UC_GL_SUPPORTED              (0x01 << 8)
#define DM_UNC_GH_SUPPORTED             (0x01 << 7)
#define DM_UNC_GL_SUPPORTED             (0x01 << 6)
#define DM_LNR_GH_SUPPORTED             (0x01 << 5)
#define DM_LNR_GL_SUPPORTED             (0x01 << 4)
#define DM_LC_GH_SUPPORTED              (0x01 << 3)
#define DM_LC_GL_SUPPORTED              (0x01 << 2)
#define DM_LNC_GH_SUPPORTED             (0x01 << 1)
#define DM_LNC_GL_SUPPORTED             0x01

/*********  Discrete/Settable/Readable Mask Table *******/  /* version 1.0 only */
#define DRM_STATE_14_READABLE           (0x01 << 14)
#define DRM_STATE_13_READABLE           (0x01 << 13)
#define DRM_STATE_12_READABLE           (0x01 << 12)
#define DRM_STATE_11_READABLE           (0x01 << 11)
#define DRM_STATE_10_READABLE           (0x01 << 10)
#define DRM_STATE_9_READABLE            (0x01 << 9)
#define DRM_STATE_8_READABLE            (0x01 << 8)
#define DRM_STATE_7_READABLE            (0x01 << 7)
#define DRM_STATE_6_READABLE            (0x01 << 6)
#define DRM_STATE_5_READABLE            (0x01 << 5)
#define DRM_STATE_4_READABLE            (0x01 << 4)
#define DRM_STATE_3_READABLE            (0x01 << 3)
#define DRM_STATE_2_READABLE            (0x01 << 2)
#define DRM_STATE_1_READABLE            (0x01 << 1)
#define DRM_STATE_0_READABLE            0x01

#define DRM_UNR_SETTABLE                (0x01 << 13)
#define DRM_UC_SETTABLE                 (0x01 << 12)
#define DRM_UNC_SETTABLE                (0x01 << 11)
#define DRM_LNR_SETTABLE                (0x01 << 10)
#define DRM_LC_SETTABLE                 (0x01 << 9)
#define DRM_LNC_SETTABLE                (0x01 << 8)

#define DRM_UNR_READABLE                (0x01 << 5)
#define DRM_UC_READABLE                 (0x01 << 4)
#define DRM_UNC_READABLE                (0x01 << 3)
#define DRM_LNR_READABLE                (0x01 << 2)
#define DRM_LC_READABLE                 (0x01 <<1)
#define DRM_LNC_READABLE                0x01

/********* Entity Association Record Flags Table *******/ /* version 1.0 */
#define EA_F_SPECIFIED_AS_RANGE         (0x01 << 7)
#define EA_F_LINKED                     (0x01 << 6)

/*********  String Type Table **********/
#define STR_UNICODE                     0x00
#define STR_BCD_PLUS                    (0x01 << 6)
#define STR_ASCII_6BIT                  (0x02 << 6)
#define STR_ASCII_8BIT                  (0x03 << 6)

/*********  Entity Id Code Type Table **********/  /* version 0.9 */
#define EI_UNSPECIFIED                  0x00
#define EI_MAIN_SYSTEM_BOARD            0x01
#define EI_SYSTEM_BOARD_2               0x02
#define EI_SYSTEM_BOARD_3               0x03
#define EI_SYSTEM_BOARD_4               0x04

#define EI_SYS_EXPANSION_BOARD_1        0x08
#define EI_SYS_EXPANSION_BOARD_2        0x09
#define EI_SYS_EXPANSION_BOARD_3        0x0A
#define EI_SYS_EXPANSION_BOARD_4        0x0B

#define EI_PROCESSOR_BOARD_1            0x10
#define EI_PROCESSOR_BOARD_2            0x11
#define EI_PROCESSOR_BOARD_3            0x12
#define EI_PROCESSOR_BOARD_4            0x13

#define EI_PROCESSOR_1                  0x18
#define EI_PROCESSOR_2                  0x19
#define EI_PROCESSOR_3                  0x1A
#define EI_PROCESSOR_4                  0x1B

#define EI_MEMORY_MODULE_1              0x20
#define EI_MEMORY_MODULE_2              0x21
#define EI_MEMORY_MODULE_3              0x22
#define EI_MEMORY_MODULE_4              0x23

#define EI_DISK_BACKPLANE_1             0x28
#define EI_DISK_BACKPLANE_2             0x29
#define EI_DISK_BACKPLANE_3             0x2A
#define EI_DISK_BACKPLANE_4             0x2B
#define EI_POWER_SUPPLY_1               0x2C
#define EI_POWER_SUPPLY_2               0x2D
#define EI_POWER_SUPPLY_3               0x2E
#define EI_POWER_SUPPLY_4               0x2F
#define EI_POWER_SUPPLY_5               0x30
#define EI_POWER_SUPPLY_6               0x31
#define EI_POWER_SUPPLY_7               0x32
#define EI_POWER_SUPPLY_8               0x33
#define EI_PWR_MGMT_BOARD_1             0x34
#define EI_PWR_MGMT_BOARD_2             0x35
#define EI_PWR_MGMT_BOARD_3             0x36
#define EI_PWR_MGMT_BOARD_4             0x37

#define EI_POWER_MODULE_1               0x3C
#define EI_POWER_MODULE_2               0x3D
#define EI_POWER_MODULE_3               0x3E
#define EI_POWER_MODULE_4               0x3F

#define EI_SYSTEM_MGMT_BOARD_1          0x44
#define EI_SYSTEM_MGMT_BOARD_2          0x45
#define EI_SYSTEM_MGMT_BOARD_3          0x46
#define EI_SYSTEM_MGMT_BOARD_4          0x47

#define EI_CHASSIS_BOARD_1              0x4C
#define EI_CHASSIS_BOARD_2              0x4D
#define EI_CHASSIS_BOARD_3              0x4E
#define EI_CHASSIS_BOARD_4              0x4F

#define EI_CHASSIS_FRONT_PANEL_1        0x54
#define EI_CHASSIS_FRONT_PANEL_2        0x55
#define EI_CHASSIS_FRONT_PANEL_3        0x56
#define EI_CHASSIS_FRONT_PANEL_4        0x57

#define EI_CHASSIS_BACK_PANEL_1         0x5C
#define EI_CHASSIS_BACK_PANEL_2         0x5D
#define EI_CHASSIS_BACK_PANEL_3         0x5E
#define EI_CHASSIS_BACK_PANEL_4         0x5F

#define EI_CHASSIS_MGMT_BOARD_1         0x64
#define EI_CHASSIS_MGMT_BOARD_2         0x65
#define EI_CHASSIS_MGMT_BOARD_3         0x66
#define EI_CHASSIS_MGMT_BOARD_4         0x67

#define EI_DISK_DRIVE_BAY_1             0x6C
#define EI_DISK_DRIVE_BAY_2             0x6D
#define EI_DISK_DRIVE_BAY_3             0x6E
#define EI_DISK_DRIVE_BAY_4             0x6F
#define EI_DISK_DRIVE_BAY_5             0x70
#define EI_DISK_DRIVE_BAY_6             0x71
#define EI_DISK_DRIVE_BAY_7             0x72
#define EI_DISK_DRIVE_BAY_8             0x73
#define EI_DISK_DRIVE_BAY_9             0x74
#define EI_DISK_DRIVE_BAY_10            0x75
#define EI_DISK_DRIVE_BAY_11            0x76
#define EI_DISK_DRIVE_BAY_12            0x77
#define EI_DISK_DRIVE_BAY_13            0x78
#define EI_DISK_DRIVE_BAY_14            0x79
#define EI_DISK_DRIVE_BAY_15            0x7A
#define EI_DISK_DRIVE_BAY_16            0x7B

#define EI_PERIPHERAL_BAY_1             0x7C
#define EI_PERIPHERAL_BAY_2             0x7D
#define EI_PERIPHERAL_BAY_3             0x7E
#define EI_PERIPHERAL_BAY_4             0x7F
#define EI_PERIPHERAL_BAY_5             0x80
#define EI_PERIPHERAL_BAY_6             0x81
#define EI_PERIPHERAL_BAY_7             0x82
#define EI_PERIPHERAL_BAY_8             0x83

/*********  Entity Id Code Type Table **********/  /* version 1.0 */
#define EID_UNSPECIFIED                 0x00
#define EID_OTHER                       0x01
#define EID_UNKNOWN                     0x02
#define EID_PROCESSOR                   0x03
#define EID_DISK_BAY                    0x04
#define EID_PERIPHERAL_BAY              0x05
#define EID_SYSTEM_MANAGEMENT_MODULE    0x06
#define EID_SYSTEM_BOARD                0x07
#define EID_MEMORY_MODULE               0x08
#define EID_PROCESSOR_MODULE            0x09
#define EID_POWER_SUPPLY                0x0A
#define EID_ADD_IN_CARD                 0x0B
#define EID_FRONT_PANEL_BOARD           0x0C
#define EID_BACK_PANEL_BOARD            0x0D
#define EID_POWER_SYSTEM_BOARD          0x0E
#define EID_DRIVE_BACKPLANE             0x0F
#define EID_INTERNAL_EXPANSION_BOARD    0x10
#define EID_OTHER_SYSTEM_BOARD          0x11
#define EID_PROCESSOR_BOARD             0x12
#define EID_POWER_UNIT                  0x13
#define EID_POWER_MODULE                0x14
#define EID_POWER_MANAGEMENT_BOARD      0x15
#define EID_CHASSIS_BACK_PANEL_BOARD    0x16
#define EID_SYSTEM_CHASSIS              0x17
#define EID_SUB_CHASSIS                 0x18
#define EID_OTHER_CHASSIS_BOARD         0x19
#define EID_DISK_DRIVE_BAY              0x1A
#define EID_PERIPH_BAY                  0x1B
#define EID_DEVICE_BAY                  0x1C
#define EID_FAN_COOLING_DEVICE          0x1D
#define EID_COOLING_UNIT                0x1E
#define EID_CABLE_INTERCONNECT          0x1F
#define EID_MEMORY_DEVICE               0x20
#define EID_SYSTEM_MANAGEMENT_SOFTWARE  0x21
#define EID_BIOS                        0x22
#define EID_OPERATING_SYSTEM            0x23
#define EID_SYSTEM_BUS                  0x24
#define EID_GROUP                       0x25

/*********  Device Location Code Table **********/
#define DL_OTHER                        0x01
#define DL_UNKNOWN                      0x02
#define DL_PROCESSOR                    0x03
#define DL_DISK_DRIVE_BAY               0x04
#define DL_PERIPHERAL_BAY               0x05
#define DL_SYS_MGMT_MODULE              0x06
#define DL_SYSTEM_BOARD                 0x07
#define DL_MEMORY_MODULE                0x08
#define DL_PROCESSOR_MODULE             0x09
#define DL_POWER_UNIT                   0x0A
#define DL_ADD_IN_CARD                  0x0B
#define DL_FRONT_PANEL_BOARD            0x0C
#define DL_BACK_PANEL_BOARD             0x0D
#define DL_PWR_SYSTEM_BOARD             0x0E
#define DL_DRIVE_BACKPLANE              0x0F

/*********  Sensor Unit Type Code Table **********/
#define SU_UNSPECIFIED                  0x00
#define SU_DEGREES_C                    0x01
#define SU_DEGREES_F                    0x02
#define SU_DEGREES_K                    0x03
#define SU_VOLTS                        0x04
#define SU_AMPS                         0x05
#define SU_WATTS                        0x06
#define SU_JOULES                       0x07
#define SU_COLOUMBS                     0x08
#define SU_VA                           0x09
#define SU_NITS                         0x0A
#define SU_LUMEN                        0x0B
#define SU_LUX                          0x0C
#define SU_CANDELA                      0x0D
#define SU_KPA                          0x0E
#define SU_PSI                          0x0F
#define SU_NEWTON                       0x10
#define SU_CFM                          0x11
#define SU_RPM                          0x12
#define SU_HZ                           0x13
#define SU_MICROSECOND                  0x14
#define SU_MILLISECOND                  0x15
#define SU_SECOND                       0x16
#define SU_MINUTE                       0x17
#define SU_HOUR                         0x18
#define SU_DAY                          0x19
#define SU_WEEK                         0x1A
#define SU_MIL                          0x1B
#define SU_INCH                         0x1C
#define SU_FEET                         0x1D
#define SU_CU_IN                        0x1E
#define SU_CU_FEET                      0x1F
#define SU_MILLIMETER                   0x20
#define SU_CENTIMETER                   0x21
#define SU_METER                        0x22
#define SU_CU_CM                        0x23
#define SU_CU_M                         0x24
#define SU_LITER                        0x25
#define SU_FLUID_OUNCE                  0x26
#define SU_RADIAN                       0x27
#define SU_STERADIAN                    0x28
#define SU_REVOLUTION                   0x29
#define SU_CYCLE                        0x2A
#define SU_GRAVITY                      0x2B
#define SU_OUNCE                        0x2C
#define SU_POUND                        0x2D
#define SU_FT_LB                        0x2E
#define SU_OZ_IN                        0x2F
#define SU_GAUSS                        0x30
#define SU_GILBERT                      0x31
#define SU_HENRY                        0x32
#define SU_MILLIHENRY                   0x33
#define SU_FARAD                        0x34
#define SU_MICROFARAD                   0x35
#define SU_OHMS                         0x36
#define SU_SIEMEN                       0x37
#define SU_MOLE                         0x38
#define SU_BECQUEREL                    0x39
#define SU_PPM                          0x3A
/* reserved                             0x3B  was a dup of 0x08 */
#define SU_DECIBEL                      0x3C
#define SU_DBA                          0x3D
#define SU_DBC                          0x3E
#define SU_GRAY                         0x3F
#define SU_SIEVERT                      0x40
#define SU_COLOR_TEMP_DEG_K             0x41
#define SU_BIT                          0x42
#define SU_KILOBIT                      0x43
#define SU_MEGABIT                      0x44
#define SU_GIGABIT                      0x45
#define SU_BYTE                         0x46
#define SU_KILOBYTE                     0x47
#define SU_MEGABYTE                     0x48
#define SU_GIGABYTE                     0x49
#define SU_WORD                         0x4A
#define SU_DWORD                        0x4B
#define SU_QWORD                        0x4C
#define SU_LINE                         0x4D
#define SU_HIT                          0x4E
#define SU_MISS                         0x4F
#define SU_RETRY                        0x50
#define SU_RESET                        0x51
#define SU_OVERRUN                      0x52
#define SU_OFERFLOW                     0x52
#define SU_UNDERRUN                     0x53
#define SU_COLLISION                    0x54
#define SU_PACKET                       0x55
#define SU_MESSAGE                      0x56
#define SU_CHARACTER                    0x57
#define SU_ERROR                        0x58
#define SU_CORRECTABLE_ERROR            0x59
#define SU_UNCORRECTABLE_ERROR          0x5A

/*********  Sensor Type Code Table **********/
#define ST_TEMPERATURE                  0x01
#define ST_VOLTAGE                      0x02
#define ST_CURRENT                      0x03
#define ST_FAN                          0x04
#define ST_PHYSICAL_SECURITY            0x05
#define ST_SECURE_MODE_VIOLATION        0x06
#define ST_PROCESSOR                    0x07
#define    PRO_IERR                     0x00
#define    PRO_THERMAL_TRIP             0x01
#define    PRO_FRB1_BIST_FAIL           0x02
#define    PRO_FRB2_POST_HANG           0x03
#define    PRO_FRB3_CPU_STARTUP_FAIL    0x04
#define    PRO_CONFIG_ERROR             0x05
#define    PRO_DM_BIOS_COMPLEX_ERROR    0x06
#define    PRO_PRESENCE_DETECTED        0x07
#define    PRO_PROCESSOR_DISABLED       0x08
#define ST_POWER_SUPPLY                 0x08
#define    PS_PRESENCE_DETECTED         0x00
#define    PS_FAILURE_DETECTED          0x01
#define    PS_PREDICTIVE_FAIL_ASSERTED  0x02
#define ST_POWER_UNIT                   0x09
#define ST_COOLING_DEVICE               0x0A
#define ST_OTHER_UNITS_BASED            0x0B
#define ST_MEMORY                       0x0C
#define    MEM_CORECTABLE_ECC           0x00
#define    MEM_UNCORECTABLE_ECC         0x01
#define    MEM_PARITY_ERROR             0x02
#define ST_DRIVE_SLOT                   0x0D
#define ST_POST_MEMORY_RESIZE           0x0E
#define ST_POST_ERROR                   0x0F
#define ST_EVENT_LOG_DISABLED           0x10
#define    EL_COR_MEM_ERR_LOG_DISABLED  0x00
#define    EL_EVENT_TYPE_LOG_DISABLED   0x01
#define    EL_LOG_AREA_CLEARED          0x02
#define    EL_ALL_EVENT_LOG_DISABLED    0x03
#define ST_WATCHDOG                     0x11
#define    WD_BIOS_WATCHDOG_RESET       0x00
#define    WD_OS_WATCHDOG_RESET         0x01
#define    WD_OS_WATCHDOG_SHUT_DOWN     0x02
#define    WD_OS_WATCHDOG_POWER_DOWN    0x03
#define    WD_OS_WATCHDOG_POWER_CYCLE   0x04
#define    WD_OS_WATCHDOG_POWER_OFF     0x05
#define    WD_OS_WATCHDOG_EXPIRED       0x06
#define ST_SYSTEM_EVENT                 0x12
#define    SE_SYSTEM_RECONFIGURED       0x00
#define    SE_SYSTEM_BOOT_EVENT         0x01
#define ST_CRITICAL_INTERRUPT           0x13
#define    CI_FRONT_PANEL_NMI           0x00
#define    CI_BUS_TIMEOUT               0x01
#define    CI_IO_CHANNEL_CHECK_NMI      0x02
#define    CI_SPROWARE_NMI              0x03
#define    CI_PCI_PERR                  0x04
#define    CI_PCI_SERR                  0x05
#define    CI_EISA_FAILSAFE_TIMEOUT     0x06
#define    CI_BUS_CORRRECTABLE_ERROR    0x07
#define    CI_BUS_UNCORRRECTABLE_ERROR  0x08
#define ST_BUTTON                       0x14
#define ST_MODULE                       0x15
#define ST_BOARD                        0x15
#define ST_MICROCONTROLLER              0x16
#define ST_COPROCESSOR                  0x16
#define ST_ADD_IN_CARD                  0x17
#define ST_CHASSIS                      0x18
#define ST_CHIPSET                      0x19
#define ST_OTHER_FRU                    0x1A
#define ST_SYS_CFG_INFO_REC_1           0x20
#define ST_SYS_CFG_INFO_REC_2           0x21
#define ST_FIXED_DISK_INFO_REC          0x22

/*********  Analog Flags Table **********/
#define AF_NORMAL_MIN_SPECD             0x04
#define AF_NORMAL_MAX_SPECD             0x02
#define AF_NOMINAL_SPECD                0x01


/*********  Device Type Codes and Device Type Modifier Table **********/
#define DT_DS1624_TEMP_SENSOR_EEPROM    0x02
#define DT_DS1621_TEMP_SENSOR           0x03
#define DT_LM75_TEMP_SENSOR             0x04
#define DT_HECETA_ASIC                  0x05
#define    DTM_LM78                     0x00
#define    DTM_LM79                     0x01
#define    DTM_LM80                     0x02
#define    DTM_HECETA3                  0x03
#define    DTM_HECETA4                  0x04
#define    DTM_HECETA5                  0x05
#define DT_EEPROM_24C01                 0x08
#define DT_EEPROM_24C02                 0x09
#define DT_EEPROM_24C04                 0x0A
#define DT_EEPROM_24C08                 0x0B
#define DT_EEPROM_24C16                 0x0C
#define DT_EEPROM_24C17                 0x0D
#define DT_EEPROM_24C32                 0x0E
#define DT_EEPROM_24C64                 0x0F
#define    DTM_EE_UNSPECIFIED           0x00
#define    DTM_EE_DIMM_SPD              0x01
#define    DTM_EE_FRU_DEVICE            0x02
#define    DTM_EE_PROC_CRTRDG           0x03
#define DT_PCF8570                      0x14
#define DT_PCF8573                      0x15
#define DT_PCF8574A                     0x16
#define DT_PCF8583                      0x17
#define DT_PCF8593                      0x18
#define DT_CLOCK_CALENDAR               0x19
#define DT_PCF8591                      0x1A
#define DT_IO_PORT                      0x1B
#define DT_A_TO_D                       0x1C
#define DT_D_TO_A                       0x1D
#define DT_A2D_D2A                      0x1E
#define DT_LCD_CONTROLLER               0x1F
#define DT_CORE_LOGIC                   0x20
#define DT_LMC6874                      0x21
#define DT_BATTERY_CONTROLLER           0x22
#define DT_MANAGEMENT_ASIC              0x23
#define DT_UNSPECIFIED                  0xBF

/*********  OEM Byte Table **********/
#define OEM_PLUS3_3V                    0
#define OEM_PLUS5V                      1
#define OEM_MINUS5V                     2
#define OEM_PLUS12V                     3
#define OEM_MINUS12V                    4
#define OEM_PLUS2_5V                    5
#define OEM_PROC_CORE_V                 6
#define OEM_SCSI_V                      7
/* 8 - 9  reserved */
#define OEM_SENSOR_CPU1                 10
#define OEM_SENSOR_CPU2                 11
#define OEM_SENSOR_CPU3                 12
#define OEM_SENSOR_CPU4                 13
#define OEM_SENSOR_CPU5                 14
#define OEM_SENSOR_CPU6                 15
#define OEM_SENSOR_CPU7                 16
#define OEM_SENSOR_CPU8                 17
/* 18 - 19  reserved */
#define OEM_SENSOR_SYS_BD1              20
#define OEM_SENSOR_SYS_BD2              21
#define OEM_SENSOR_SYS_BD3              22
#define OEM_SENSOR_RISER                23
#define OEM_SENSOR_CPU_BD1              24
#define OEM_SENSOR_CPU_BD2              25
#define OEM_SENSOR_CPU_BD3              26
#define OEM_SENSOR_CPU_BD4              27
/* 28 - 29  reserved */
#define OEM_SENSOR_CHASSIS              30
#define OEM_SENSOR_FRONT_PANEL          31
/* 32 - 39  reserved */
#define OEM_SENSOR_DISK_BACKPLANE       40
/* 41 - 49  reserved */
#define OEM_SENSOR_DISK_BAY1            50
#define OEM_SENSOR_DISK_BAY2            51
#define OEM_SENSOR_DISK_BAY3            52
#define OEM_SENSOR_DISK_BAY4            53
#define OEM_SENSOR_DISK_BAY5            54
#define OEM_SENSOR_DISK_BAY6            55
#define OEM_SENSOR_DISK_BAY7            56
#define OEM_SENSOR_DISK_BAY8            57
/* 58 - 59  reserved */
#define OEM_SYSTEM_MGMT_CARD            60
/* 61 - 99 reserved */


typedef struct sdrRecordHeader
{
    UINT16  recordId;           /* little-endian */
    UINT8   sdrVersion;         /* SDR_VERSION_1_0 (0x10) */
    UINT8   recordType;         /* <SDR_RT_> */
    UINT8   recordLength;       /* number of bytes that follow */
} SDR_RECORD_HEADER;

typedef struct Sdr {            /* Sensor Data Record (SDR) */
/* 1,2 */    UINT16  recordId;           /* little-endian */
/* 3   */    UINT8   sdrVersion;         /* SDR_VERSION_1_0 (0x10) */
/* 4   */    UINT8   recordType;         /* <SDR_RT_> */
/* 5   */    UINT8   recordLength;       /* number of bytes that follow */
    union {                     /* as per <SDR_RT_> */

/***************** IPMI version 0.9 ***********************/
        /* SDR_RT_8BIT_THRESHOLD */
        struct {
/* 6   */            UINT8   sensorOwnerId;
/* 7   */            UINT8   sensorOwnerLUN;
/* 8   */            UINT8   sensorNumber;
/* 9   */            UINT8   confirmationDeviceId;
/* 10  */            UINT8   confirmationMajorRevision;
/* 11  */            UINT8   sensorModuleFruInventoryDeviceOwnerId;
/* 12  */            UINT8   sensorInitialization;
/* 13  */            UINT8   sensorCapabilities;
/* 14  */            UINT8   sensorType;
/* 15  */            UINT8   eventReadingBaseType;
/* 16,17*/           UINT16  eventTriggerMask;
/* 18,19*/           UINT16  eventReadingMask;
/* 20  */            UINT8   sensorUnits1;
/* 21  */            UINT8   sensorUnits2;       /* base unit */
/* 22  */            UINT8   sensorUnits3;       /* modifier unit */
/* 23  */            UINT8   linearization;
/* 24  */            UINT8   mLSB;       // 7:0 LS 8 bits of 10-bit signed M
/* 25  */            UINT8   mTolerance; // 7:6 MS 2 bits of M
                                         // 5:0 6-bit unsigned tolerance
                                         //     in +/- 1/2 raw counts
/* 26  */            UINT8   bLSB;       // 7:0 LS 8 bits of 10-bit signed B
/* 27  */            UINT8   bAccuracy;  // 7:6 MS 2 bits of B
                                         // 5:0 LS 6 bits of unsigned accuracy in 1/100%
/* 28  */            UINT8   accuracy;   // 7:4 MS 4 bits of 10-bit accuracy
                                         // 3:2 2-bit unsigned accuracy exponent
                                         // 1:0 reserved
/* 29  */            UINT8   exponents;  // 7:4 4-bit signed R exponent
                                         // 3:0 4-bit signed B exponent
/* 30  */            UINT8   analogCharacteristicFlags;
/* 31  */            UINT8   nominalReading;
/* 32  */            UINT8   normalMaximum;
/* 33  */            UINT8   normalMinimum;
/* 34  */            UINT8   sensorMaximumReading;
/* 35  */            UINT8   sensorMinimumReading;
/* 36  */            UINT8   readableThresholdMask;
/* 37  */            UINT8   settableThresholdMask;
/* 38,43*/           UINT8   threshold[SDR_NUM_THRESHOLDS];
                     /*
                     ** thresholds accessed by index into array
   38                ** UINT8   upperNonRecoverable;  threshold[SDR_UPP_NONRECOVER]
   39                ** UINT8   upperCritical;        threshold[SDR_UPP_CRITICAL]
   40                ** UINT8   upperNonCritical;     threshold[SDR_UPP_NONCRITICAL]
   41                ** UINT8   lowerNonRecoverable;  threshold[SDR_LOW_NONRECOVER]
   42                ** UINT8   lowerCritical;        threshold[SDR_LOW_CRITICAL]
   43                ** UINT8   lowerNonCritical;     threshold[SDR_LOW_NONCRITICAL]
                     */
/* 44  */            UINT8   positiveHysterisis;
/* 45  */            UINT8   negativeHysterisis;
/* 46  */            UINT8   oem;
/* 47  */            UINT8   entityId;
/* 48  */            UINT8   nameTypeLength;
/* 49,64*/           UINT8   name[16];           /* actually as per nameTypeLength */

        } t09_01;

/***************** IPMI version 1.0 ***********************/
        /* SDR_RT_FULL_SENSOR_RECORD */
        struct {
/* 6   */            UINT8   sensorOwnerId;
/* 7   */            UINT8   sensorOwnerLUN;
/* 8   */            UINT8   sensorNumber;
/* 9   */            UINT8   entityId;
/* 10  */            UINT8   entityInstance;
/* 11  */            UINT8   sensorInitialization;
/* 12  */            UINT8   sensorCapabilities;
/* 13  */            UINT8   sensorType;
/* 14  */            UINT8   eventReadingBaseType;	/* bad name from 0.9 */
/* 15,16*/           UINT8   eventAssertionMask[2];     /* lsb first */
/* 17,18*/           UINT8   eventDeassertionMask[2];   /* lsb first */
/* 19,20*/           UINT8   settableReadableMask[2];   /* lsb first */
/* 21  */            UINT8   sensorUnits1;
/* 22  */            UINT8   sensorUnits2;       /* base unit */
/* 23  */            UINT8   sensorUnits3;       /* modifier unit */
/* 24  */            UINT8   linearization;
/* 25  */            UINT8   mLSB;       // 7:0 LS 8 bits of 10-bit signed M
/* 26  */            UINT8   mTolerance; // 7:6 MS 2 bits of M
                                         // 5:0 6-bit unsigned tolerance
                                         //     in +/- 1/2 raw counts
/* 27  */            UINT8   bLSB;       // 7:0 LS 8 bits of 10-bit signed B
/* 28  */            UINT8   bAccuracy;  // 7:6 MS 2 bits of B
                                         // 5:0 LS 6 bits of unsigned accuracy in 1/100%
/* 29  */            UINT8   accuracy;   // 7:4 MS 4 bits of 10-bit accuracy
                                         // 3:2 2-bit unsigned accuracy exponent
                                         // 1:0 reserved
/* 30  */            UINT8   exponents;  // 7:4 4-bit signed R exponent
                                         // 3:0 4-bit signed B exponent
/* 31  */            UINT8   analogCharacteristicFlags;
/* 32  */            UINT8   nominalReading;
/* 33  */            UINT8   normalMaximum;
/* 34  */            UINT8   normalMinimum;
/* 35  */            UINT8   sensorMaximumReading;
/* 36  */            UINT8   sensorMinimumReading;
/* 37,42*/           UINT8   threshold[SDR_NUM_THRESHOLDS];
                     /*
                     ** thresholds accessed by index into array
   37                ** UINT8   upperNonRecoverable;  threshold[SDR_UPP_NONRECOVER]
   38                ** UINT8   upperCritical;        threshold[SDR_UPP_CRITICAL]
   39                ** UINT8   upperNonCritical;     threshold[SDR_UPP_NONCRITICAL]
   40                ** UINT8   lowerNonRecoverable;  threshold[SDR_LOW_NONRECOVER]
   41                ** UINT8   lowerCritical;        threshold[SDR_LOW_CRITICAL]
   42                ** UINT8   lowerNonCritical;     threshold[SDR_LOW_NONCRITICAL]
                     */
/* 43  */            UINT8   positiveHysterisis;
/* 44  */            UINT8   negativeHysterisis;
/* 45  */            UINT8   reserved1;     /* write as 00h */
/* 46  */            UINT8   reserved2;     /* write as 00h */
/* 47  */            UINT8   oem;
/* 48  */            UINT8   nameTypeLength;
/* 49,64*/           UINT8   name[16];           /* actually as per nameTypeLength */
        } t10_01;

#if defined(IPMI_VER_09)
#define t01  t09_01
#endif
#if defined(IPMI_VER_10)
#define t01  t10_01
#endif


/***************** IPMI version 0.9 ***********************/
        /* SDR_RT_DIGITAL_DISCRETE */
        struct {
/* 6   */            UINT8   sensorOwnerId;
/* 7   */            UINT8   sensorOwnerLUN;
/* 8   */            UINT8   sensorNumber;
/* 9   */            UINT8   confirmationDeviceId;
/* 10  */            UINT8   confirmationMajorRevision;
/* 11  */            UINT8   sensorModuleFruInventoryDeviceOwnerId;
/* 12  */            UINT8   sensorInitialization;
/* 13  */            UINT8   sensorCapabilities;
/* 14,15*/           UINT16  sensorRecordSharing;
/* 16  */            UINT8   sensorType;
/* 17  */            UINT8   eventReadingBaseType;
/* 18,19*/           UINT16  eventTriggerMask;
/* 20,21*/           UINT16  eventReadingMask;
/* 22  */            UINT8   sensorUnits1;
/* 23  */            UINT8   sensorUnits2;       /* base unit */
/* 24  */            UINT8   sensorUnits3;       /* modifier unit */
/* 25  */            UINT8   oem;
/* 26  */            UINT8   entityId;
/* 27  */            UINT8   nameTypeLength;
/* 29,44*/           UINT8   name[16];           /* actually as per nameTypeLength */
        } t09_02;

/***************** IPMI version 1.0 ***********************/
         /* SDR_RT_COMPACT_SENSOR_RECORD */
         struct {
/* 6   */            UINT8   sensorOwnerId;
/* 7   */            UINT8   sensorOwnerLUN;
/* 8   */            UINT8   sensorNumber;
/* 9   */            UINT8   entityId;
/* 10  */            UINT8   entityInstance;
/* 11  */            UINT8   sensorInitialization;
/* 12  */            UINT8   sensorCapabilities;
/* 13  */            UINT8   sensorType;
/* 14  */            UINT8   eventReadingBaseType;	/* bad name from 0.9 */
/* 15,16*/           UINT8   eventAssertionMask[2];     /* lsb first */
/* 17,18*/           UINT8   eventDeassertionMask[2];   /* lsb first */
/* 19,20*/           UINT8   eventReadingMask[2];       /* lsb first */
/* 21  */            UINT8   sensorUnits1;
/* 22  */            UINT8   sensorUnits2;       /* base unit */
/* 23  */            UINT8   sensorUnits3;       /* modifier unit */
/* 24,25*/           UINT8   sensorRecordSharing[2];
/* 26  */            UINT8   positiveHysterisis;
/* 27  */            UINT8   negativeHysterisis;
/* 28  */            UINT8   reserved1;
/* 29  */            UINT8   reserved2;
/* 30  */            UINT8   reserved3;
/* 31  */            UINT8   oem;
/* 32  */            UINT8   nameTypeLength;
/* 33,48*/           UINT8   name[16];           /* actually as per nameTypeLength */
        } t10_02;

#if defined(IPMI_VER_09)
#define t02  t09_02
#endif
#if defined(IPMI_VER_10)
#define t02  t10_02
#endif


/***************** IPMI version 1.0 ***********************/
        /* SDR_RT_ENTITY_ASSOCIATION_RECORD */
        struct {
/* 6   */            UINT8   containerEntityId;
/* 7   */            UINT8   containerEntityInstance;
/* 8   */            UINT8   flags;
/* 9   */            UINT8   containedEntity1Range;
/* 10  */            UINT8   containedEntity1Instance;
/* 11  */            UINT8   containedEntity2Range;
/* 12  */            UINT8   containedEntity2Instance;
/* 13  */            UINT8   containedEntity3Range;
/* 14  */            UINT8   containedEntity3Instance;
/* 15  */            UINT8   containedEntity4Range;
/* 16  */            UINT8   containedEntity4Instance;
        } t10_08;

#if defined(IPMI_VER_10)
#define t08  t10_08
#endif


/***************** IPMI version 0.9 ***********************/
        /* SDR_RT_DEVICE_LOCATOR */
        struct {
/* 6   */            UINT8   deviceSlaveAddress;
/* 7   */            UINT8   imbBusId;
/* 8   */            UINT8   addressSpan;
/* 9   */            UINT8   confirmationDeviceId;
/* 10  */            UINT8   confirmationMajorRevision;
/* 11  */            UINT8   deviceType;
/* 12  */            UINT8   deviceTypeModifier;
/* 13  */            UINT8   deviceLocation;
/* 14  */            UINT8   optionalCommandSupport;
/* 15  */            UINT8   oem;
/* 16  */            UINT8   nameTypeLength;
/* 17,32*/           UINT8   name[16];           /* actually as per nameTypeLength */
        } t09_10;

/***************** IPMI version 1.0 ***********************/
        /* SDR_RT_GENERIC_DEVICE_LOCATOR */
        struct {
/* 6   */            UINT8   deviceAccessAddress;
/* 7   */            UINT8   deviceSlaveAddress;
/* 8   */            UINT8   accessIdBusLun;
/* 9   */            UINT8   addressSpan;
/* 10  */            UINT8   reserved;
/* 11  */            UINT8   deviceType;
/* 12  */            UINT8   deviceTypeModifier;
/* 13  */            UINT8   entityId;
/* 14  */            UINT8   entityInstance;
/* 15  */            UINT8   oem;
/* 16  */            UINT8   nameTypeLength;
/* 17,32*/           UINT8   name[16];           /* actually as per nameTypeLength */
        } t10_10;

#if defined(IPMI_VER_09)
#define t10  t09_10
#endif
#if defined(IPMI_VER_10)
#define t10  t10_10
#endif


/***************** IPMI version 1.0 ***********************/
        /* SDR_RT_FRU_DEVICE_LOCATOR */
        struct {
/* 6   */            UINT8   deviceAccessAddress;
/* 7   */            UINT8   fruDeviceIdSlaveAddress;
/* 8   */            UINT8   accessIdBusLun;
/* 9   */            UINT8   reserved1;
/* 10  */            UINT8   reserved2;
/* 11  */            UINT8   deviceType;
/* 12  */            UINT8   deviceTypeModifier;
/* 13  */            UINT8   fruEntityId;
/* 14  */            UINT8   fruEntityInstance;
/* 15  */            UINT8   oem;
/* 16  */            UINT8   nameTypeLength;
/* 17,32*/           UINT8   name[16];           /* actually as per nameTypeLength */
        } t10_11;

#if defined(IPMI_VER_10)
#define t11  t10_11
#endif


/***************** IPMI version 1.0 ***********************/
        /* SDR_RT_MANAGEMENT_CONTROLLER_LOCATOR */
        struct {
/* 6   */            UINT8   deviceSlaveAddress;
/* 7   */            UINT8   powerStateGlobalInit;
/* 8   */            UINT8   deviceCapabilities;
/* 9   */            UINT8   reserved1;
/* 10  */            UINT8   reserved2;
/* 11  */            UINT8   reserved3;
/* 12  */            UINT8   reserved4;
/* 13  */            UINT8   EntityId;
/* 14  */            UINT8   EntityInstance;
/* 15  */            UINT8   oem;
/* 16  */            UINT8   nameTypeLength;
/* 17,32*/           UINT8   name[16];           /* actually as per nameTypeLength */
        } t10_12;

#if defined(IPMI_VER_10)
#define t12  t10_12
#endif


/***************** IPMI version 1.0 ***********************/
        /* SDR_RT_MANAGEMENT_CONTROLLER_CONFIRMATION */
        struct {
/* 6   */            UINT8   deviceSlaveAddress;
/* 7   */            UINT8   deviceId;
/* 8   */            UINT8   deviceRevision;
/* 9   */            UINT8   firmwareRevision1;
/* 10  */            UINT8   firmwareRevision2;
/* 11  */            UINT8   IPMIversion;
/* 12  */            UINT8   mfgrId0;             /* LSB first */
/* 13  */            UINT8   mfgrId1;
/* 14  */            UINT8   mfgrId2;
/* 15  */            UINT8   systemId;
/* 16  */            UINT8   oem;
/* 17,32*/           UINT8   deviceGuid[16];           /* set to all 00h if GUID not supported */
        } t10_13;

#if defined(IPMI_VER_10)
#define t13  t10_13
#endif


/***************** IPMI version 1.0 ***********************/
        /* SDR_RT_MMC_MESSAGE_CHANNEL_INFO */
        struct {
/* 6   */            UINT8   messageChannel0Info;
/* 7   */            UINT8   messageChannel1Info;
/* 8   */            UINT8   messageChannel2Info;
/* 9   */            UINT8   messageChannel3Info;
/* 10  */            UINT8   messageChannel4Info;
/* 11  */            UINT8   messageChannel5Info;
/* 12  */            UINT8   messageChannel6Info;
/* 13  */            UINT8   messageChannel7Info;
/* 14  */            UINT8   messagingInterruptType;
/* 15  */            UINT8   eventMessageBufferInterruptType;
/* 16  */            UINT8   reserved;
        } t10_14;

#if defined(IPMI_VER_10)
#define t14  t10_14
#endif


/***************** IPMI version 0.9 ***********************/

        /* SDR_RT_BIOS_CONFIG_1 */
        struct {
            UINT32  timestamp;  /* time this record was written */
            UINT8   systemModel[16];
            UINT8   romBiosVersion[8];
            UINT8   videoBiosVersion[8];
            UINT8   scsiBiosVersion[8];
            UINT8   pciIsaSlots;
            UINT8   securityFlags;
            UINT16  processorModel[4];
            UINT8   processorSpeed[4];
        } t09_20;

        /* SDR_RT_BIOS_CONFIG_2 */
        struct {
            UINT32  timestamp;  /* time this record was written */
            UINT8   floppyDrive1;
            UINT8   floppyDrive2;
            UINT16  memorySizes[8];
            UINT8   reserved28;
        } t09_21;

#if defined(IPMI_VER_09)
#define t20  t09_20
#define t21  t09_21
#endif


/***************** IPMI version 0.9 ***********************/
        /* SDR09_RT_OEM_VERSION */
        struct {
            UINT8   version[16];        /* actually as per recordLength */
        } t09_C0;

/***************** IPMI version 1.0 ***********************/
        /* SDR10_RT_OEM_VERSION */
        struct {
            UINT8   manufacturerId[3];
            UINT8   version[56];        /* actually as per recordLength */
        } t10_C0;

#if defined(IPMI_VER_09)
#define tC0  t09_C0
#endif
#if defined(IPMI_VER_10)
#define tC0  t10_C0
#endif


    } body;
} SDR;

#endif  /* _SDRR_CMD_H_ */
