/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/**************************************************************************
**  Copyright (C) 1997, Hewlett-Packard Co. All rights reserved.
**
**  File name:  linuxtunnl.h
**  Summary:    Linux specific tunnel and driver header info
**  Product:    MMC driver
**  Owner:      
**
**  Description:
**              Provides structures and #defines for the Linux MMC driver and 
**              and Tunnel portion of the API
**
**  Exports:
**      
**
**  START AUTOMATIC VERSION CONTROL INFORMATION
**  DO NOT MANUALLY EDIT THIS SECTION!
**  $Workfile:   NT_TUNNL.H  $
**  $Revision: 1.2 $
**  $Date: 2001/04/24 13:22:06 $
**  $Author: hamilton $
**  END AUTOMATIC VERSION CONTROL INFORMATION
**
***************************************************************************
**  START AUTOMATIC VERSION CONTROL LOG
**  DO NOT MANUALLY EDIT THIS SECTION!                                                                  
**
**  $Log:
**
**************************************************************************/

#define IOCTL_MMC_SEND_RCV                0x01
#define IOCTL_MMC_GET_KERNEL_VERSION      0x02
#define IOCTL_MMC_PORT_READ_DATA          0x03
#define IOCTL_MMC_PORT_READ_STATUS        0x04
#define IOCTL_MMC_PORT_READ_FLAG          0x05
#define IOCTL_MMC_PORT_WRITE_DATA         0x06
#define IOCTL_MMC_PORT_WRITE_STATUS       0x07
#define IOCTL_MMC_PORT_WRITE_FLAG         0x08

struct _KERNEL_VERSION
{
    UINT16      retcode; 
    char        oem_name[OEM_NAME_LENGTH];    // 8 character ascii name
    char        version_letter; // 1 ascii character
    UINT8       version_major;  // 1 byte major version number (0-99)
    UINT8       version_minor;  // 1 byte minor version number (0-99)
} __attribute__ ((packed));

typedef struct _KERNEL_VERSION KERNEL_VERSION;
typedef struct _KERNEL_VERSION *PKERNEL_VERSION;

struct _SEND_RCV    
{
   UINT16       retcode; 
   UINT8*       input;
   UINT8        ilen;
   UINT8*       output;
   UINT8        olen;
} __attribute__ ((packed));

typedef struct _SEND_RCV SEND_RCV;
typedef struct _SEND_RCV *PSEND_RCV;

