/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/**************************************************************************

MMC API header file

This file is used to 

**************************************************************************/
/* [ NSA_SYMBOLS effort - Added by Kumaresan to avoid the warning for
using pragma pack (1) 8/8/2000 */
#ifdef WINNT
#pragma warning (disable : 4103)
#endif
/* end of changes ] */

/* Pack all structures for ALL NOS's */
#pragma pack(1)

/* MMCRetry_ Function constants */
#ifdef LINUX
#define MAX_DEVICE_OPEN_RETRIES           1000
#define DEVICE_RETRY_SLEEP_TICK           150
#else
#define MAX_DEVICE_OPEN_RETRIES           5
#define DEVICE_RETRY_SLEEP_TICK           500
#endif

/* MMC defines in case stuff changes */
#define NETFNLUN_MMCSE         0x10
#define NETFNLUN_MMCAPP        0x18
#define NETFNLUN_MMCFW         0x20
#define NETFNLUN_MMCSTORAGE    0x28

#define SYSTEMSOFTWAREID       0x20

/* Device driver errors: */
#define MMC_SUCCESS             0
#define EDEVDRV                 0x100   /* Device Driver failure -- */
                    /* ISA-BMC level error */
#define ETIMEOUT                0x101   /* Driver unable to get response before timing out */
#define EINUSE                  0x102   /* Driver was already opened */
#define ENOHARDWARE             0x103   /* No hardware was found during "Open" */
#define EMEMORY                 0x104   /* Indicates low memory -- unable to allocate space for buffers */
#define EPARAMS                 0x105   /* Parameter(s) incorrectly loaded -- possibly out of range */
#define EBADDATA                0x106   /* Driver returned data of incorrect size or some return */
                    /* parameters were wrong -- the data may be invalid */
#define EBUFFER                 0x107   /* the output buffer size was inadequate to hold all the returned */
                    /* data */
#define EINFWXFERMODE           0x108   /* The MMC was already in firmware transfer mode */
                    
#define ENOTINFWXFERMODE        0x109   /* The MMC hasn't been set to firmware transfer mode */
#define EABORTED                0x110   /* The BIOS (?) aborted this function -- can retry without a problem */

/* Definitions required for legacy I2C functions: */
#define LEGACYBB    0x01        /* ~bus busy */
                /* 0 = busy     1 = free */
#define LEGACYLAB   0x02        /* lost arbitration */
                /* 0 = false    1 = true */
#define LEGACYAAS   0x04        /* addressed as slave */
                /* 0 = false    1 = true */
#define LEGACYLRB   0x08        /* last received bit */
                /* 0 = acknwl   1 = not ack */
#define LEGACYAD0   0x08        /* recv genrl call addr */
                /* 0 = false    1 = true */
#define LEGACYBER   0x10        /* bus error */
                /* 0 = false    1 = true */
#define LEGACYSTS   0x20        /* external stop recv */
                /* 0 = false    1 = true */
#define LEGACYINIT  0x40        /* ~initialized 8584 */
                /* 0 = true     1 = false */
#define LEGACYPIN   0x80        /* pending interrupt not */
                /* 0 = servce   1 = normal */

/* I2C API function error return values NOT to be confused with 8584 status */
/* bits although some are the same and with inverted meanings. */

#define LEGACYEBB         LEGACYBB      /* bus busy */
                    /* 0 = free     1 = busy */
#define LEGACYELAB        LEGACYLAB     /* lost arbitration */
                    /* 0 = false    1 = true */
#define LEGACYEIN_USE     0x04          /* 8584 device in use */
                    /* 0 = false    1 = true */
#define LEGACYELRB        LEGACYLRB     /* last received bit */
                    /* 0 = acknwl   1 = no ack */
#define LEGACYEBER        LEGACYBER     /* bus error */
                    /* 0 = false    1 = true */
#define LEGACYEDEVDRV     0x20          /* err open/close driver */
                    /* 0 = ok       1 = error */
#define LEGACYEINIT       LEGACYINIT    /* ~initialized 8584 */
                    /* 0 = true     1 = false */
#define LEGACYEPIN        LEGACYPIN     /* txfer complete */
                    /* 0 = true     1 = false */
            
#define I2C_SUCCESS 0x0000  /* always ZERO for success, don't change !!! */
#define I2C_FAILURE 0x0001  /* error used in i2cdrv.c only */

#define MAX_SLAVE_ADDR      0x80        /* max number of slave addresses */

#ifdef _DOS
    #define MS_DOS          _DOS
#endif /* _DOS */


#define MAX_BUFFER_SIZE     35

#define MMC_CLEAR_PASSWORD  "CLR"
#define MMC_CLEAR_PASSWORD_LEN 3

#define OEM_NAME                "HP NSD"
#define OEM_NAME_LENGTH         7
#define API_VERSION_LETTER      'Q'
#define API_VERSION_MAJOR       0
#define API_VERSION_MINOR       3
#define KERNEL_VERSION_LETTER   'Q'
#define KERNEL_VERSION_MAJOR    0
#define KERNEL_VERSION_MINOR    1

#define MMC_DRIVER_NAME "MMCDev"

#ifndef __min
    #define __min(a,b) (((a) < (b)) ? (a) : (b))
#endif

/* Port Definitions */
#define MMC_PORT_DATA   1
#define MMC_PORT_STATUS 2
#define MMC_PORT_FLAG   3


