/**************************************************************************
**  Copyright (C) 1997, Hewlett-Packard Co. All rights reserved.
**
**  File name:  HPELapi.h
**  Summary:    Event Log API prototypes
**  Product:    Event log agent and API
**  Owner:      Mike Parrish
**
**  Description:
**       This file contains all of the exposed Event Log API
**       prototypes as specified in evtagt.doc and 
**       implemented in HPELapi.cpp
**
**  Exports:
**       HPEL_Write
**       HPELENG_EntryPoint
**       HPELENG_Stop
**
**  START AUTOMATIC VERSION CONTROL INFORMATION
**  DO NOT MANUALLY EDIT THIS SECTION!
**  $Workfile$
**  $Revision: 1.1 $
**  $Date: 2002/01/07 15:43:06 $
**  $Author: gustavo $
**  END AUTOMATIC VERSION CONTROL INFORMATION
**
***************************************************************************
**  START AUTOMATIC VERSION CONTROL LOG
**  DO NOT MANUALLY EDIT THIS SECTION!
**
**  $Log: hpelapi.h,v $
**  Revision 1.1  2002/01/07 15:43:06  gustavo
**  *** empty log message ***
**
**  Revision 1.1  2001/12/27 20:29:37  gustavo
**  *** empty log message ***
**
**  Revision 1.1.1.1  2000/08/21 18:46:53  hamilton
**  Initial import.
**
**  Revision 1.1.1.1  2000/08/21 16:04:29  hamilton
**  Initial import.
**
**
**  END AUTOMATIC VERSION CONTROL LOG
***************************************************************************/

// HPELapi.h : main header file for the HPELapi Module
//

// This needs to be here, especially for SCO
#pragma pack( 1 )

#ifndef _HPELAPI_H_
#define _HPELAPI_H_
/////////////////////////////////////////////////////////////////////////////
// Includes
#include "sel_cmd.h"

#ifdef __cplusplus
extern "C" {
#endif

/////////////////////////////////////////////////////////////////////////////
// OS Selection, specialization.

#ifdef WINNT

/////////////////////////////////////////////////////////////////////////////
// Windows Dll access defines.
#ifdef MIKE_STYLE

#define DllImport    __declspec( dllimport )
#define DllExport    __declspec( dllexport )

#ifdef _USRDLL
#define EXPORTED DllExport 
#else
#define EXPORTED DllImport 
#endif

#else
#define EXPORTED

#endif // MIKE_STYLE

#endif         // #ifdef WINNT

#if defined( NLM ) || defined( SCO_UNIX )
   #if defined ( __cplusplus )
      #define EXPORTED extern "C"
   #else
      #define EXPORTED
   #endif         
#endif         

#ifdef LINUX

#define EXPORTED extern "C"

#endif // LINUX

/////////////////////////////////////////////////////////////////////////////
// defines 

// Errors
#define HPEL_SUCCESS                         0
#define SEL_TYPE                             1
#define NO_NEW_REC                           2
                                             
#define HPEL_SELBUSY                         1001
                                             
#define HPEL_NO_NEW_RECORD                   NO_NEW_REC
                                             
#define HPEL_GENERAL_ERROR                   10000
#define HPEL_ILLEGAL_PARAMETER               10001
#define HPEL_MMC_OPEN_FAILED                 10002
#define HPEL_MMC_RESERVESEL_FAILED           10003
#define HPEL_ADDSELENTRY_FAILED              10004
#define HPEL_MMC_CLOSE_FAILED                10005
#define HPEL_MMC_GETSELENTRY_FAILED          10006
#define HPEL_MAKESELFROMSTRING_FAILED        10007
#define HPEL_RECORD_NOT_FOUND                10008
#define HPEL_MMC_GETSELINFO_FAILED           10009
#define HPEL_MMC_CLEARSELREPOSITORY_FAILED   10010
#define HPEL_FILE_OPEN_FAILED                10011
#define HPEL_FUNCTION_SEMAPHORE_LOCKED       10012

// Sizes 
#define MAX_KEY_LENGTH                    256
#define MAX_HPEL_BUFFER_SIZE              256

/////////////////////////////////////////////////////////////////////////////
// Type definitions.
typedef struct HpelSnmp 
{
   int snmpId;
} HPEL_SNMP;

typedef struct HpelDmi 
{
   int dmiId;
} HPEL_DMI;

typedef struct HpelNtel 
{
   int hpelId;
} HPEL_NTEL;

typedef struct ReportingStruct 
{
   HPEL_SNMP   snmpInfo;
   HPEL_DMI    dmiInfo;
   HPEL_NTEL   ntelInfo;
} REPORTING;

typedef struct EvtStruct 
{
   SEL         selEntry;

   int         convertedReading;
   int         convertedThreshold;

   char        szAddString[MAX_HPEL_BUFFER_SIZE];       // Possibly passed in during the HPEL_WriteEvent call.
   char        szEventString[MAX_HPEL_BUFFER_SIZE];     // filled during translation using evtspec.cfg
   REPORTING   reportingInfo;
} HPEL_EVENT;


/////////////////////////////////////////////////////////////////////////////
// Export definitions.

#ifdef __cplusplus
}
#endif

#endif // #ifndef _HPELAPI_H_

