#ifndef _MMC_DEV_H_
#define _MMC_DEV_H_

#include "sel_cmd.h"

#define IOCTL_MMC_SEND_RCV                0x01
#define IOCTL_MMC_GET_KERNEL_VERSION      0x02
#define IOCTL_MMC_PORT_READ_DATA          0x03
#define IOCTL_MMC_PORT_READ_STATUS        0x04
#define IOCTL_MMC_PORT_READ_FLAG          0x05
#define IOCTL_MMC_PORT_WRITE_DATA         0x06
#define IOCTL_MMC_PORT_WRITE_STATUS       0x07
#define IOCTL_MMC_PORT_WRITE_FLAG         0x08

struct _SEND_RCV {
	UINT16       retcode;
	UINT8*       input;
	UINT8        ilen;
	UINT8*       output;
	UINT8        olen;
} __attribute__ ((packed));

typedef struct _SEND_RCV SEND_RCV;

int  MMC_LoadFunctions();
void MMC_UnloadFunctions();
int  MMC_OpenDevice();
int  MMC_CloseDevice();
int  MMC_SendRcvMesg(UINT8 *input, int ilen, UINT8 *output, UINT8 *olen);
void MMC_Sleep(unsigned long ms);

#endif
