/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/***************************************************************************
*** Filename: ermc_if.h
***
***
*** Description: Defines the IPMI command specific definitions
***              used in ERMC on and up
***
*** Notes: This is the header file that will be available in Rx/era/include
***        directory. This is the file that will be common for era and other
***        utilities to use, whenever a new OEM command is added. There
***        should be #ifdef's that will cause a conditional compilation
***        between eRMC and era/other utilities. The default should be
***        era/other utilities. ERMC can define the condition for #ifdef
***        in its makefile
***
*** Revision History:
***
*** Sekar Srinivasan - Initial Version
***
***
***
***
***************************************************************************/
#ifndef _ERMC_IF_H_
#define _ERMC_IF_H_




//-----------------------------------------------------------------

/* App NetFn (IMB_NF_APP) commands - From oem_cmd.h
------------------------------------------------------*/
#if defined(ERMC_COMMAND_DEFINITIONS)

#define IPMM_NSD_OEM_SET_I2C_ACTIVITY_CONTROL 0xC4
#define IPMM_NSD_OEM_GET_I2C_ACTIVITY_CONTROL 0xC5

#endif




/* Locator LED command handling definitions
--------------------------------------------------------*/

#if defined(ERMC_COMMAND_DEFINITIONS)


/**********************************************************
Set and Get Locator LED definitions for T11/T12/ST2
***********************************************************/

/* SET Command Definitions */
#define IPMM_NSD_OEM_SET_LOCATOR_LED      0xD0
#define IPMM_NSD_OEM_GET_LOCATOR_LED      0xD1

typedef __packed struct{

	 /* 0 - Activate Locator, 1- De-Activate Locator */
	 UINT8 locatorState;

}CMD_OEM_Q_SET_LOCATOR_LED_t ;


typedef __packed struct{

	UINT8  completionCode;

}CMD_OEM_S_SET_LOCATOR_LED_t ;

/* Get Command Definitions */

typedef void CMD_OEM_Q_GET_LOCATOR_LED_t; //0 bytes

typedef __packed struct{

	UINT8 completionCode;
	UINT8 locatorState;

}CMD_OEM_S_GET_LOCATOR_LED_t;



/************************************************
Set and Get Led Definitions for T11/T12/ST2
*************************************************/

#define IPMM_NSD_OEM_SET_LEDS		0xDE
#define IPMM_NSD_OEM_GET_LEDS		0xDF

/* Set LED Definitions */
typedef __packed struct{

	UINT8 statusLedState;
	UINT8 diagLedState;
}CMD_OEM_Q_SET_LED_STATE_t;

typedef __packed struct{

	UINT8 completionCode;

}CMD_OEM_S_SET_LED_STATE_t;

/* Get LED Definitions */
typedef void CMD_OEM_Q_GET_LED_STATE_t;

typedef __packed struct{

	UINT8 completionCode;
	UINT8 pwrSplyLedState;
	UINT8 statusLedState;
	UINT8 locatorLedState;
	UINT8 diagLedState;

}CMD_OEM_S_GET_LED_STATE_t;



#else

/***********************************************************************
Set and Get Locator LED definitions for T11/T12/ST2 - OTHER LIBRARIES USE
*************************************************************************/

#define OEM_SET_LOCATOR_LED  0xD0
#define OEM_GET_LOCATOR_LED  0xD1

/* Set locator Led definitions */
typedef struct{

    /* 0 - Activate Locator, 1- De-Activate Locator */
    UINT8 locatorState;

}OEM_Q_SET_LOCATOR_LED ;


typedef struct{

	UINT8 completionCode;

}OEM_S_SET_LOCATOR_LED ;

/* Get Locator LED definitions */

typedef void OEM_Q_GET_LOCATOR_LED ;

typedef struct{

	UINT8 completionCode;
	UINT8 locatorState; /* 0 - Locator ON, 1 - Locator OFF */

}OEM_S_GET_LOCATOR_LED ;




/*****************************************************************
Set and Get Led Definitions for T11/T12/ST2 - OTHER LIBRARIES USE
******************************************************************/
/* Set LED Definitions */
typedef struct{

	UINT8 statusLedState;
	UINT8 diagLedState;
}OEM_Q_SET_LED_STATE;

typedef struct{

	UINT8 completionCode;

}OEM_S_SET_LED_STATE;

/* Get LED Definitions */
typedef void OEM_Q_GET_LED_STATE;

typedef struct{

	UINT8 completionCode;
	UINT8 pwrSplyLedState;
	UINT8 statusLedState;
	UINT8 locatorLedState;
	UINT8 diagLedState;

}OEM_S_GET_LED_STATE;


#endif




#endif // End _ERMC_IF_H_
