/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/**************************************************************************
**  Copyright (C) 1997-1999, Hewlett-Packard Co. All rights reserved.
**
**  File name:  evnt_cmd.h
**  Summary:    IMB Event Command Definitions
**
**************************************************************************/

#ifndef _EVNT_CMD_H_
#define _EVNT_CMD_H_

#include	"imb_std.h"	/* IMB OS-Dependent Standard Types */

/* Sensor/Event NetFn (IMB_NF_SENSOR_) Event Commands */
#define EVNT_SET_EVENT_RECEIVER		0x00	/* Not Implemented */
#define EVNT_GET_EVENT_RECEIVER		0x01	/* Not Implemented */
#define EVNT_EVENT_MESSAGE		0x02
	/* 03..1F */
/* OEM commands moved to OEM_CMD.H  */

/* Value for eventRecieverLUN when no event generation is disabled. */
#define EVNT_NO_EVENT_RECEIVER		0xFF

/* EVNT_SET_EVENT_RECEIVER */
typedef struct EvntQSetEventReceiver {
    UINT8   eventReceiverSlaveAddress;
    UINT8   eventReceiverLUN;
} EVNT_Q_SET_EVENT_RECEIVER;

typedef struct EvntSSetEventReceiver {
    UINT8   completionCode;	/* IMB_CC_ */
} EVNT_S_SET_EVENT_RECEIVER;


/* EVNT_GET_EVENT_RECEIVER */
typedef void EVNT_Q_GET_EVENT_RECEIVER;

typedef struct EvntSGetEventReceiver {
    UINT8   completionCode;	/* IMB_CC_ */
    UINT8   eventReceiverSlaveAddress;
    UINT8   eventReceiverLUN;
} EVNT_S_GET_EVENT_RECEIVER;


/* EVNT_EVENT_MESSAGE */
/*   As a special case, the I2C form takes the softwareId from RqSA */
typedef struct EvntQI2CEventMessage {
    UINT8   evmRev;
    UINT8   sensorType;
    UINT8   sensorNumber;
    UINT8   eventType;
    UINT8   eventData1;
    UINT8   eventData2;
    UINT8   eventData3;
} EVNT_Q_I2C_EVENT_MESSAGE;

typedef struct EvntQEventMessage {
    UINT8   softwareId;
    UINT8   evmRev;
    UINT8   sensorType;
    UINT8   sensorNumber;
    UINT8   eventType;
    UINT8   eventData1;
    UINT8   eventData2;
    UINT8   eventData3;
} EVNT_Q_EVENT_MESSAGE;

typedef struct EvntSEventMessage {
    UINT8   completionCode;	/* IMB_CC_ */
} EVNT_S_EVENT_MESSAGE;

#endif	/* _EVNT_CMD_H_ */
