/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/**************************************************************************
**  Copyright (C) 1997-1999, Hewlett-Packard Co. All rights reserved.
**
**  File name:  imb_isa.h
**  Summary:    IMB SMIC Definitions
**
**************************************************************************/

#ifndef _IMB_ISA_H_
#define _IMB_ISA_H_

/***********************************************************************
 *  SMIC Interface
 */
/*  SMIC Flags Register Bits */
#define	IF_BUSY			0x01
#define	IF_SMS_DATA_AVAIL	0x04
#define	IF_EVM_DATA_AVAIL	0x08
#define	IF_SMI			0x10
#define	IF_TX_DATA_READY	0x40
#define	IF_RX_DATA_READY	0x80

/*  SMIC Error Codes */
#define	EC_NO_ERROR		0x00
#define	EC_ABORTED		0x01
#define	EC_ILLEGAL_CONTROL	0x02
#define	EC_NO_RESPONSE		0x03
#define	EC_ILLEGAL_COMMAND	0x04
#define	EC_BUFFER_FULL		0x05

/*  SMIC Control/Status Code Components */
#define	CS_GET_STATUS		0x00	/* Control form's name */
#define	CS_READY		0x00	/* Status  form's name */
#define	CS_WR_START		0x01	/* Unified Control/Status names... */
#define	CS_WR_NEXT		0x02
#define	CS_WR_END		0x03
#define	CS_RD_START		0x04
#define	CS_RD_NEXT		0x05
#define	CS_RD_END		0x06
#define	CS_CODE_MASK		0x0f

#define	CS_CONTROL		0x00
#define	CS_STATUS		0x80
#define	CS_CONTROL_STATUS_MASK	0x80

#define	CS_SMS			0x40
#define	CS_SMM			0x60
#define	CS_STREAM_MASK		0x60

/*	use of data under mask 0x10 is undefined */

/*  SMIC Control Codes */
#define	CC_SMS_GET_STATUS	(CS_CONTROL|CS_SMS|CS_READY)
#define	CC_SMS_WR_START		(CS_CONTROL|CS_SMS|CS_WR_START)
#define	CC_SMS_WR_NEXT		(CS_CONTROL|CS_SMS|CS_WR_NEXT)
#define	CC_SMS_WR_END		(CS_CONTROL|CS_SMS|CS_WR_END)
#define	CC_SMS_RD_START		(CS_CONTROL|CS_SMS|CS_RD_START)
#define	CC_SMS_RD_NEXT		(CS_CONTROL|CS_SMS|CS_RD_NEXT)
#define	CC_SMS_RD_END		(CS_CONTROL|CS_SMS|CS_RD_END)

#define	CC_SMM_GET_STATUS	(CS_CONTROL|CS_SMM|CS_READY)
#define	CC_SMM_WR_START		(CS_CONTROL|CS_SMM|CS_WR_START)
#define	CC_SMM_WR_NEXT		(CS_CONTROL|CS_SMM|CS_WR_NEXT)
#define	CC_SMM_WR_END		(CS_CONTROL|CS_SMM|CS_WR_END)
#define	CC_SMM_RD_START		(CS_CONTROL|CS_SMM|CS_RD_START)
#define	CC_SMM_RD_NEXT		(CS_CONTROL|CS_SMM|CS_RD_NEXT)
#define	CC_SMM_RD_END		(CS_CONTROL|CS_SMM|CS_RD_END)

/*  SMIC Status Codes */
#define	SC_SMS_READY		(CS_STATUS|CS_SMS|CS_READY)
#define	SC_SMS_WR_START		(CS_STATUS|CS_SMS|CS_WR_START)
#define	SC_SMS_WR_NEXT		(CS_STATUS|CS_SMS|CS_WR_NEXT)
#define	SC_SMS_WR_END		(CS_STATUS|CS_SMS|CS_WR_END)
#define	SC_SMS_RD_START		(CS_STATUS|CS_SMS|CS_RD_START)
#define	SC_SMS_RD_NEXT		(CS_STATUS|CS_SMS|CS_RD_NEXT)
#define	SC_SMS_RD_END		(CS_STATUS|CS_SMS|CS_RD_END)

#define	SC_SMM_READY		(CS_STATUS|CS_SMM|CS_READY)
#define	SC_SMM_WR_START		(CS_STATUS|CS_SMM|CS_WR_START)
#define	SC_SMM_WR_NEXT		(CS_STATUS|CS_SMM|CS_WR_NEXT)
#define	SC_SMM_WR_END		(CS_STATUS|CS_SMM|CS_WR_END)
#define	SC_SMM_RD_START		(CS_STATUS|CS_SMM|CS_RD_START)
#define	SC_SMM_RD_NEXT		(CS_STATUS|CS_SMM|CS_RD_NEXT)
#define	SC_SMM_RD_END		(CS_STATUS|CS_SMM|CS_RD_END)

#endif  /* _IMB_ISA_H_ */
