/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/**************************************************************************
**  Copyright (C) 1997-1999, Hewlett-Packard Co. All rights reserved.
**
**  File name:  imb_std.h
**  Summary:    IMB OS-Dependent Standard Types
**
**************************************************************************/

#ifndef _IMB_STD_H_
#define _IMB_STD_H_

/** compilation pragmas **/
#ifdef	_MSC_VER
/*
 *  Microsoft C compiler:
 *  all structures are fully packed, and don't warn me to say they are
 */
#pragma warning (disable : 4103)
#endif	/* _MSC_VER */

#pragma pack(1)

/** global defines **/
#ifndef _H2INC
#ifndef TRUE
#define TRUE  1
#endif
#ifndef FALSE
#define FALSE 0
#endif
#endif

/** typedefs **/

typedef char            INT8;
typedef unsigned char   UINT8;
typedef short           INT16;
typedef unsigned short  UINT16;
//typedef long            INT32;

/*
**  UINT32 is turned off for those project that also depends on
**  basetsd.h, Basetsd.h also defined UINT32, so to avoid compiler
**  warnings , it guarded here.
**
**  Part of the NSA_SYMBOLS effort
*/

#ifndef _BASETSD_H_
typedef unsigned long   UINT32;
#endif

typedef union
    {
        UINT16  W16;
        struct
            {
                UINT8  Msb;
                UINT8  Lsb;
            } B8;
    } UINT16OR8;

/** macros **/
#ifndef OFFSETOF
   #define OFFSETOF(type,field)	((unsigned) (&(((type *) 0)->field)))
#endif	/* OFFSETOF */

#ifndef	SIZEOF
#ifndef	_H2INC			/* hide SIZEOF from .h to .inc conversion */
#define SIZEOF(type,field)	(sizeof((((type *) 0)->field)))
#endif	/* _H2INC */
#endif	/* SIZEOF */

#endif  /* _IMB_STD_H_ */
