/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/**************************************************************************
**  Copyright (C) 1997-1999, Hewlett-Packard Co. All rights reserved.
**
**  File name:  sens_def.h
**  Summary:    file contains definitions for sensor names
**  Owner:      Myron Tuttle
**
**************************************************************************/

#ifndef _SENS_DEF_H_
#define _SENS_DEF_H_

/* this is a table of the sensors and their sensor number.  This should
** be used in both the sensorTable definitions and the SDR definitions.
*/

/* sensors common to LC2 LC3, LH3, & LPr */
#define SENSOR_PLUS_5V         0x01     /* threshold  LM78   */
#define SENSOR_MINUS_5V        0x02     /* threshold  LM78   */
#define SENSOR_PLUS_12V        0x03     /* threshold  LM78   */
#define SENSOR_MINUS_12V       0x04     /* threshold  LM78   */
#define SENSOR_PLUS_33V        0x05     /* threshold  LM78   */
#define SENSOR_PROCA_CORE_V    0x06     /* threshold  LM78   */
#define SENSOR_PROCB_CORE_V    0x07     /* threshold  LM78   */
#define SENSOR_PROCA_TEMP      0x08     /* threshold  87C751 */
#define SENSOR_PROCB_TEMP      0x09     /* threshold  87C751 */
#define SENSOR_INTERNAL_TEMP   0x0A     /* threshold  LM78   */

/* sensors specific to LC2/LC3 */
#if	(defined(LC2) || defined(LC3))
#define SENSOR_REAR_PANEL_FAN  0x0B     /* threshold  LM78   */
#define SENSOR_PROCESSOR_FAN   0x0C     /* threshold  LM78   */
#define SENSOR_INTRUSION       0x0D     /* digital    LM78   */
#define SENSOR_SCSI_TERM       0x0E     /* digital    87C751 */
#endif /* LC2 */

/* sensors specific to LH3 */
#ifdef LH3
#define SENSOR_PROCESSOR_FAN    0x0B     /* threshold  LM78   */
#define SENSOR_INTRUSION        0x0C     /* digital    LM78   */
#define SENSOR_FAN_0_IO_AREA    0x0D     /* threshold  87C751 */
#define SENSOR_FAN_1_IO_AREA    0x0E     /* threshold  87C751 */
#define SENSOR_FAN_2_REAR_PANEL 0x0F     /* threshold  87C751 */
#define SENSOR_FAN_3_REAR_PANEL 0x10     /* threshold  87C751 */
#define SENSOR_FAN_4_REAR_PAIR  0x11     /* threshold  87C751 */
#define SENSOR_FAN_5_REAR_PAIR  0x12     /* threshold  87C751 */
#define SENSOR_FAN_6_FRONT_PAIR 0x13     /* threshold  87C751 */
#define SENSOR_FAN_7_FRONT_PAIR 0x14     /* threshold  87C751 */
#endif /* LH3 */

#endif  /*  _SENS_DEF_H_ */
