/*
 * (c) Copyright 2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/**************************************************************************
**  Copyright (C) 1997-1999, Hewlett-Packard Co. All rights reserved.
**
**  File name:  ver_info.h
**  Summary:    binary image system/firmware version information 
**
**  Description:
**      This module is lays out the information about the system and its
**  firmware at the very end of the binary file.  The code is placed in 
**  the last bank, starting at an address that will put the very end of
**  the versionInfo at the very end of the FLASH.
**
**  The information is written to the hex as follows:
**     NULL,TextVersionString,NULL,TextDateTime,NULL,TextSystemDescription,
**     hardware revision, firmware revision
**     checksum start address (0x2000h), end address (0x1ffffh),
**     checksum bytes 1 and 2 
**
***************************************************************************/

#include <imb_std.h>

/*
 * Preceding the structure are two NULL surrounded strings.  The first is
 * a timestamp and the second is a string describing the hardware.
 */

typedef struct { 
   UINT8 DevRev;
   UINT8 FwRev1;
   UINT8 FwRev2;
   UINT8 StartLo;
   UINT8 StartMid;
   UINT8 StartHi;
   UINT8 EndLo;
   UINT8 EndMid;
   UINT8 EndHi;
   UINT16 Checksum;
} versionInfoType;

